<?php

namespace PHPMaker2024\fibre;

// Page object
$HelpEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fhelpedit" id="fhelpedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { help: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fhelpedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fhelpedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["level", [fields.level.visible && fields.level.required ? ew.Validators.required(fields.level.caption) : null], fields.level.isInvalid],
            ["menu_group", [fields.menu_group.visible && fields.menu_group.required ? ew.Validators.required(fields.menu_group.caption) : null], fields.menu_group.isInvalid],
            ["menu_description", [fields.menu_description.visible && fields.menu_description.required ? ew.Validators.required(fields.menu_description.caption) : null], fields.menu_description.isInvalid],
            ["table_name", [fields.table_name.visible && fields.table_name.required ? ew.Validators.required(fields.table_name.caption) : null], fields.table_name.isInvalid],
            ["table_caption", [fields.table_caption.visible && fields.table_caption.required ? ew.Validators.required(fields.table_caption.caption) : null], fields.table_caption.isInvalid],
            ["field_name", [fields.field_name.visible && fields.field_name.required ? ew.Validators.required(fields.field_name.caption) : null], fields.field_name.isInvalid],
            ["field_caption", [fields.field_caption.visible && fields.field_caption.required ? ew.Validators.required(fields.field_caption.caption) : null], fields.field_caption.isInvalid],
            ["field_description", [fields.field_description.visible && fields.field_description.required ? ew.Validators.required(fields.field_description.caption) : null], fields.field_description.isInvalid],
            ["table_description", [fields.table_description.visible && fields.table_description.required ? ew.Validators.required(fields.table_description.caption) : null], fields.table_description.isInvalid],
            ["portal_notes", [fields.portal_notes.visible && fields.portal_notes.required ? ew.Validators.required(fields.portal_notes.caption) : null], fields.portal_notes.isInvalid],
            ["_visible", [fields._visible.visible && fields._visible.required ? ew.Validators.required(fields._visible.caption) : null], fields._visible.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "_visible": <?= $Page->_visible->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="help">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_help_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_help_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level"<?= $Page->level->rowAttributes() ?>>
        <label id="elh_help_level" for="x_level" class="<?= $Page->LeftColumnClass ?>"><?= $Page->level->caption() ?><?= $Page->level->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->level->cellAttributes() ?>>
<span id="el_help_level">
<span<?= $Page->level->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->level->getDisplayValue($Page->level->EditValue) ?></span></span>
<input type="hidden" data-table="help" data-field="x_level" data-hidden="1" name="x_level" id="x_level" value="<?= HtmlEncode($Page->level->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->menu_group->Visible) { // menu_group ?>
    <div id="r_menu_group"<?= $Page->menu_group->rowAttributes() ?>>
        <label id="elh_help_menu_group" for="x_menu_group" class="<?= $Page->LeftColumnClass ?>"><?= $Page->menu_group->caption() ?><?= $Page->menu_group->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->menu_group->cellAttributes() ?>>
<span id="el_help_menu_group">
<input type="<?= $Page->menu_group->getInputTextType() ?>" name="x_menu_group" id="x_menu_group" data-table="help" data-field="x_menu_group" value="<?= $Page->menu_group->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->menu_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->menu_group->formatPattern()) ?>"<?= $Page->menu_group->editAttributes() ?> aria-describedby="x_menu_group_help">
<?= $Page->menu_group->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->menu_group->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->menu_description->Visible) { // menu_description ?>
    <div id="r_menu_description"<?= $Page->menu_description->rowAttributes() ?>>
        <label id="elh_help_menu_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->menu_description->caption() ?><?= $Page->menu_description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->menu_description->cellAttributes() ?>>
<span id="el_help_menu_description">
<?php $Page->menu_description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_menu_description" name="x_menu_description" id="x_menu_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->menu_description->getPlaceHolder()) ?>"<?= $Page->menu_description->editAttributes() ?> aria-describedby="x_menu_description_help"><?= $Page->menu_description->EditValue ?></textarea>
<?= $Page->menu_description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->menu_description->getErrorMessage() ?></div>
<script>
loadjs.ready(["fhelpedit", "editor"], function() {
    ew.createEditor("fhelpedit", "x_menu_description", 0, 0, <?= $Page->menu_description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->table_name->Visible) { // table_name ?>
    <div id="r_table_name"<?= $Page->table_name->rowAttributes() ?>>
        <label id="elh_help_table_name" for="x_table_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->table_name->caption() ?><?= $Page->table_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->table_name->cellAttributes() ?>>
<span id="el_help_table_name">
<span<?= $Page->table_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->table_name->getDisplayValue($Page->table_name->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_table_name" data-hidden="1" name="x_table_name" id="x_table_name" value="<?= HtmlEncode($Page->table_name->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->table_caption->Visible) { // table_caption ?>
    <div id="r_table_caption"<?= $Page->table_caption->rowAttributes() ?>>
        <label id="elh_help_table_caption" for="x_table_caption" class="<?= $Page->LeftColumnClass ?>"><?= $Page->table_caption->caption() ?><?= $Page->table_caption->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->table_caption->cellAttributes() ?>>
<span id="el_help_table_caption">
<span<?= $Page->table_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->table_caption->getDisplayValue($Page->table_caption->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_table_caption" data-hidden="1" name="x_table_caption" id="x_table_caption" value="<?= HtmlEncode($Page->table_caption->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->field_name->Visible) { // field_name ?>
    <div id="r_field_name"<?= $Page->field_name->rowAttributes() ?>>
        <label id="elh_help_field_name" for="x_field_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->field_name->caption() ?><?= $Page->field_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->field_name->cellAttributes() ?>>
<span id="el_help_field_name">
<span<?= $Page->field_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->field_name->getDisplayValue($Page->field_name->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_field_name" data-hidden="1" name="x_field_name" id="x_field_name" value="<?= HtmlEncode($Page->field_name->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->field_caption->Visible) { // field_caption ?>
    <div id="r_field_caption"<?= $Page->field_caption->rowAttributes() ?>>
        <label id="elh_help_field_caption" for="x_field_caption" class="<?= $Page->LeftColumnClass ?>"><?= $Page->field_caption->caption() ?><?= $Page->field_caption->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->field_caption->cellAttributes() ?>>
<span id="el_help_field_caption">
<span<?= $Page->field_caption->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->field_caption->getDisplayValue($Page->field_caption->EditValue))) ?>"></span>
<input type="hidden" data-table="help" data-field="x_field_caption" data-hidden="1" name="x_field_caption" id="x_field_caption" value="<?= HtmlEncode($Page->field_caption->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->field_description->Visible) { // field_description ?>
    <div id="r_field_description"<?= $Page->field_description->rowAttributes() ?>>
        <label id="elh_help_field_description" for="x_field_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->field_description->caption() ?><?= $Page->field_description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->field_description->cellAttributes() ?>>
<span id="el_help_field_description">
<textarea data-table="help" data-field="x_field_description" name="x_field_description" id="x_field_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->field_description->getPlaceHolder()) ?>"<?= $Page->field_description->editAttributes() ?> aria-describedby="x_field_description_help"><?= $Page->field_description->EditValue ?></textarea>
<?= $Page->field_description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->field_description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->table_description->Visible) { // table_description ?>
    <div id="r_table_description"<?= $Page->table_description->rowAttributes() ?>>
        <label id="elh_help_table_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->table_description->caption() ?><?= $Page->table_description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->table_description->cellAttributes() ?>>
<span id="el_help_table_description">
<?php $Page->table_description->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_table_description" name="x_table_description" id="x_table_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->table_description->getPlaceHolder()) ?>"<?= $Page->table_description->editAttributes() ?> aria-describedby="x_table_description_help"><?= $Page->table_description->EditValue ?></textarea>
<?= $Page->table_description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->table_description->getErrorMessage() ?></div>
<script>
loadjs.ready(["fhelpedit", "editor"], function() {
    ew.createEditor("fhelpedit", "x_table_description", 35, 4, <?= $Page->table_description->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->portal_notes->Visible) { // portal_notes ?>
    <div id="r_portal_notes"<?= $Page->portal_notes->rowAttributes() ?>>
        <label id="elh_help_portal_notes" class="<?= $Page->LeftColumnClass ?>"><?= $Page->portal_notes->caption() ?><?= $Page->portal_notes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->portal_notes->cellAttributes() ?>>
<span id="el_help_portal_notes">
<?php $Page->portal_notes->EditAttrs->appendClass("editor"); ?>
<textarea data-table="help" data-field="x_portal_notes" name="x_portal_notes" id="x_portal_notes" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->portal_notes->getPlaceHolder()) ?>"<?= $Page->portal_notes->editAttributes() ?> aria-describedby="x_portal_notes_help"><?= $Page->portal_notes->EditValue ?></textarea>
<?= $Page->portal_notes->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->portal_notes->getErrorMessage() ?></div>
<script>
loadjs.ready(["fhelpedit", "editor"], function() {
    ew.createEditor("fhelpedit", "x_portal_notes", 35, 4, <?= $Page->portal_notes->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_visible->Visible) { // visible ?>
    <div id="r__visible"<?= $Page->_visible->rowAttributes() ?>>
        <label id="elh_help__visible" for="x__visible" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_visible->caption() ?><?= $Page->_visible->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_visible->cellAttributes() ?>>
<span id="el_help__visible">
    <select
        id="x__visible"
        name="x__visible"
        class="form-select ew-select<?= $Page->_visible->isInvalidClass() ?>"
        <?php if (!$Page->_visible->IsNativeSelect) { ?>
        data-select2-id="fhelpedit_x__visible"
        <?php } ?>
        data-table="help"
        data-field="x__visible"
        data-value-separator="<?= $Page->_visible->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_visible->getPlaceHolder()) ?>"
        <?= $Page->_visible->editAttributes() ?>>
        <?= $Page->_visible->selectOptionListHtml("x__visible") ?>
    </select>
    <?= $Page->_visible->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->_visible->getErrorMessage() ?></div>
<?php if (!$Page->_visible->IsNativeSelect) { ?>
<script>
loadjs.ready("fhelpedit", function() {
    var options = { name: "x__visible", selectId: "fhelpedit_x__visible" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fhelpedit.lists._visible?.lookupOptions.length) {
        options.data = { id: "x__visible", form: "fhelpedit" };
    } else {
        options.ajax = { id: "x__visible", form: "fhelpedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.help.fields._visible.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fhelpedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fhelpedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("help");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    var level = $("#x_level").val();
    		if (level == 3)
    		{
    			$("#r_menu_group").hide();
    			$("#r_menu_description").hide();
    			$("#r_table_name").show();
    			$("#r_table_caption").hide();
    			$("#r_table_description").hide();
    			$("#r_field_name").show();
    			$("#r_field_caption").show();
    			$("#r_field_description").show();		
    			$("#r_system_notes").hide();
    			$("#r_portal_notes").hide();
    			$("#r_admin_notes").hide();
    			$("#r__visible").show();		
    		}
    		else if (level == 2)
    		{
    			$("#r_menu_group").show();
    			$("#r_menu_description").show();
    			$("#r_table_name").show();
    			$("#r_table_caption").show();
    			$("#r_table_description").show();		
    			$("#r_field_name").hide();
    			$("#r_field_caption").hide();
    			$("#r_field_description").hide();		
    			$("#r_system_notes").show();
    			$("#r_portal_notes").hide();
    			$("#r_admin_notes").hide();
    			$("#r__visible").hide();		
    		}
});
</script>
