<?php

namespace PHPMaker2024\fibre;

// Page object
$GodownTransferTableSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { godown_transfer_table: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fgodown_transfer_tablesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgodown_transfer_tablesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["ref", [ew.Validators.integer], fields.ref.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["quantity_avg_act", [], fields.quantity_avg_act.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["next_issue_yn", [], fields.next_issue_yn.isInvalid],
            ["next_process", [], fields.next_process.isInvalid],
            ["next_godown", [], fields.next_godown.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["remarks", [], fields.remarks.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "quantity_avg_act": <?= $Page->quantity_avg_act->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "next_issue_yn": <?= $Page->next_issue_yn->toClientList($Page) ?>,
            "next_process": <?= $Page->next_process->toClientList($Page) ?>,
            "next_godown": <?= $Page->next_godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgodown_transfer_tablesearch" id="fgodown_transfer_tablesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_table">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="godown_transfer_table" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tablesearch_x_grp"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tablesearch", function() {
    var options = { name: "x_grp", selectId: "fgodown_transfer_tablesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tablesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fgodown_transfer_tablesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fgodown_transfer_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ref" id="z_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="godown_transfer_table" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="godown_transfer_table" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fgodown_transfer_tablesearch", function() {
    fgodown_transfer_tablesearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.godown_transfer_table.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="godown_transfer_table" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity_avg_act->Visible) { // quantity_avg_act ?>
    <div id="r_quantity_avg_act" class="row"<?= $Page->quantity_avg_act->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_quantity_avg_act"><?= $Page->quantity_avg_act->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity_avg_act->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_quantity_avg_act" class="ew-search-field ew-search-field-single">
<template id="tp_x_quantity_avg_act">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="godown_transfer_table" data-field="x_quantity_avg_act" name="x_quantity_avg_act" id="x_quantity_avg_act"<?= $Page->quantity_avg_act->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_quantity_avg_act" class="ew-item-list"></div>
<selection-list hidden
    id="x_quantity_avg_act"
    name="x_quantity_avg_act"
    value="<?= HtmlEncode($Page->quantity_avg_act->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_quantity_avg_act"
    data-target="dsl_x_quantity_avg_act"
    data-repeatcolumn="5"
    class="form-control<?= $Page->quantity_avg_act->isInvalidClass() ?>"
    data-table="godown_transfer_table"
    data-field="x_quantity_avg_act"
    data-value-separator="<?= $Page->quantity_avg_act->displayValueSeparatorAttribute() ?>"
    <?= $Page->quantity_avg_act->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->quantity_avg_act->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="godown_transfer_table" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tablesearch_x_packing_type"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tablesearch", function() {
    var options = { name: "x_packing_type", selectId: "fgodown_transfer_tablesearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tablesearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fgodown_transfer_tablesearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fgodown_transfer_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tablesearch_x_godown"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tablesearch", function() {
    var options = { name: "x_godown", selectId: "fgodown_transfer_tablesearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tablesearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fgodown_transfer_tablesearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fgodown_transfer_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="godown_transfer_table" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgodown_transfer_tablesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgodown_transfer_tablesearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label for="x_employee_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_employee_id"><?= $Page->employee_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_employee_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->employee_id->getInputTextType() ?>" name="x_employee_id" id="x_employee_id" data-table="godown_transfer_table" data-field="x_employee_id" value="<?= $Page->employee_id->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->next_issue_yn->Visible) { // next_issue_yn ?>
    <div id="r_next_issue_yn" class="row"<?= $Page->next_issue_yn->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_next_issue_yn"><?= $Page->next_issue_yn->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_next_issue_yn" id="z_next_issue_yn" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->next_issue_yn->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_next_issue_yn" class="ew-search-field ew-search-field-single">
<template id="tp_x_next_issue_yn">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="godown_transfer_table" data-field="x_next_issue_yn" name="x_next_issue_yn" id="x_next_issue_yn"<?= $Page->next_issue_yn->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_next_issue_yn" class="ew-item-list"></div>
<selection-list hidden
    id="x_next_issue_yn"
    name="x_next_issue_yn"
    value="<?= HtmlEncode($Page->next_issue_yn->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_next_issue_yn"
    data-target="dsl_x_next_issue_yn"
    data-repeatcolumn="5"
    class="form-control<?= $Page->next_issue_yn->isInvalidClass() ?>"
    data-table="godown_transfer_table"
    data-field="x_next_issue_yn"
    data-value-separator="<?= $Page->next_issue_yn->displayValueSeparatorAttribute() ?>"
    <?= $Page->next_issue_yn->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->next_issue_yn->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->next_process->Visible) { // next_process ?>
    <div id="r_next_process" class="row"<?= $Page->next_process->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_next_process"><?= $Page->next_process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_next_process" id="z_next_process" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->next_process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_next_process" class="ew-search-field ew-search-field-single">
<template id="tp_x_next_process">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="godown_transfer_table" data-field="x_next_process" name="x_next_process" id="x_next_process"<?= $Page->next_process->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_next_process" class="ew-item-list"></div>
<selection-list hidden
    id="x_next_process"
    name="x_next_process"
    value="<?= HtmlEncode($Page->next_process->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_next_process"
    data-target="dsl_x_next_process"
    data-repeatcolumn="5"
    class="form-control<?= $Page->next_process->isInvalidClass() ?>"
    data-table="godown_transfer_table"
    data-field="x_next_process"
    data-value-separator="<?= $Page->next_process->displayValueSeparatorAttribute() ?>"
    <?= $Page->next_process->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->next_process->getErrorMessage(false) ?></div>
<?= $Page->next_process->Lookup->getParamTag($Page, "p_x_next_process") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->next_godown->Visible) { // next_godown ?>
    <div id="r_next_godown" class="row"<?= $Page->next_godown->rowAttributes() ?>>
        <label for="x_next_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_next_godown"><?= $Page->next_godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_next_godown" id="z_next_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->next_godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_next_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_next_godown"
        name="x_next_godown"
        class="form-select ew-select<?= $Page->next_godown->isInvalidClass() ?>"
        <?php if (!$Page->next_godown->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tablesearch_x_next_godown"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_next_godown"
        data-value-separator="<?= $Page->next_godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->next_godown->getPlaceHolder()) ?>"
        <?= $Page->next_godown->editAttributes() ?>>
        <?= $Page->next_godown->selectOptionListHtml("x_next_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->next_godown->getErrorMessage(false) ?></div>
<?= $Page->next_godown->Lookup->getParamTag($Page, "p_x_next_godown") ?>
<?php if (!$Page->next_godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tablesearch", function() {
    var options = { name: "x_next_godown", selectId: "fgodown_transfer_tablesearch_x_next_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tablesearch.lists.next_godown?.lookupOptions.length) {
        options.data = { id: "x_next_godown", form: "fgodown_transfer_tablesearch" };
    } else {
        options.ajax = { id: "x_next_godown", form: "fgodown_transfer_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.next_godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="godown_transfer_table" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fgodown_transfer_tablesearch", function() {
    fgodown_transfer_tablesearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.godown_transfer_table.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="godown_transfer_table" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_godown_transfer_table_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_godown_transfer_table_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="godown_transfer_table" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="31" maxlength="40" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgodown_transfer_tablesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgodown_transfer_tablesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fgodown_transfer_tablesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("godown_transfer_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
