<?php

namespace PHPMaker2024\fibre;

// Page object
$GodownTransferTableAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { godown_transfer_table: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fgodown_transfer_tableadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgodown_transfer_tableadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null, ew.Validators.integer], fields.product.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null, ew.Validators.integer], fields.ref.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null, ew.Validators.integer], fields.rid.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.float], fields.packets.isInvalid],
            ["quantity_avg_act", [fields.quantity_avg_act.visible && fields.quantity_avg_act.required ? ew.Validators.required(fields.quantity_avg_act.caption) : null], fields.quantity_avg_act.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["employee_id", [fields.employee_id.visible && fields.employee_id.required ? ew.Validators.required(fields.employee_id.caption) : null], fields.employee_id.isInvalid],
            ["next_issue_yn", [fields.next_issue_yn.visible && fields.next_issue_yn.required ? ew.Validators.required(fields.next_issue_yn.caption) : null], fields.next_issue_yn.isInvalid],
            ["next_process", [fields.next_process.visible && fields.next_process.required ? ew.Validators.required(fields.next_process.caption) : null], fields.next_process.isInvalid],
            ["next_godown", [fields.next_godown.visible && fields.next_godown.required ? ew.Validators.required(fields.next_godown.caption) : null], fields.next_godown.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "quantity_avg_act": <?= $Page->quantity_avg_act->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "next_issue_yn": <?= $Page->next_issue_yn->toClientList($Page) ?>,
            "next_process": <?= $Page->next_process->toClientList($Page) ?>,
            "next_godown": <?= $Page->next_godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgodown_transfer_tableadd" id="fgodown_transfer_tableadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_table">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_godown_transfer_table_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tableadd_x_grp"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tableadd", function() {
    var options = { name: "x_grp", selectId: "fgodown_transfer_tableadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tableadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fgodown_transfer_tableadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fgodown_transfer_tableadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_godown_transfer_table_product">
<input type="<?= $Page->product->getInputTextType() ?>" name="x_product" id="x_product" data-table="godown_transfer_table" data-field="x_product" value="<?= $Page->product->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product->formatPattern()) ?>"<?= $Page->product->editAttributes() ?> aria-describedby="x_product_help">
<?= $Page->product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_ref" for="x_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ref->caption() ?><?= $Page->ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ref->cellAttributes() ?>>
<span id="el_godown_transfer_table_ref">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="godown_transfer_table" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?> aria-describedby="x_ref_help">
<?= $Page->ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_godown_transfer_table_rid">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?> aria-describedby="x_rid_help">
</span>
<selection-list hidden class="form-control" data-table="godown_transfer_table" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>"></selection-list>
<?= $Page->rid->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<script>
loadjs.ready("fgodown_transfer_tableadd", function() {
    fgodown_transfer_tableadd.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.godown_transfer_table.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets"<?= $Page->packets->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_packets" for="x_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packets->caption() ?><?= $Page->packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packets->cellAttributes() ?>>
<span id="el_godown_transfer_table_packets">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="godown_transfer_table" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?> aria-describedby="x_packets_help">
<?= $Page->packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity_avg_act->Visible) { // quantity_avg_act ?>
    <div id="r_quantity_avg_act"<?= $Page->quantity_avg_act->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_quantity_avg_act" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity_avg_act->caption() ?><?= $Page->quantity_avg_act->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity_avg_act->cellAttributes() ?>>
<span id="el_godown_transfer_table_quantity_avg_act">
<template id="tp_x_quantity_avg_act">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="godown_transfer_table" data-field="x_quantity_avg_act" name="x_quantity_avg_act" id="x_quantity_avg_act"<?= $Page->quantity_avg_act->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_quantity_avg_act" class="ew-item-list"></div>
<selection-list hidden
    id="x_quantity_avg_act"
    name="x_quantity_avg_act"
    value="<?= HtmlEncode($Page->quantity_avg_act->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_quantity_avg_act"
    data-target="dsl_x_quantity_avg_act"
    data-repeatcolumn="5"
    class="form-control<?= $Page->quantity_avg_act->isInvalidClass() ?>"
    data-table="godown_transfer_table"
    data-field="x_quantity_avg_act"
    data-value-separator="<?= $Page->quantity_avg_act->displayValueSeparatorAttribute() ?>"
    <?= $Page->quantity_avg_act->editAttributes() ?>></selection-list>
<?= $Page->quantity_avg_act->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity_avg_act->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_godown_transfer_table_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="godown_transfer_table" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_godown_transfer_table_packing_type">
<div class="input-group flex-nowrap">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tableadd_x_packing_type"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$Page->packing_type->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->packing_type->caption() ?>" data-title="<?= $Page->packing_type->caption() ?>" data-ew-action="add-option" data-el="x_packing_type" data-url="<?= GetUrl("packingtypeaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->packing_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tableadd", function() {
    var options = { name: "x_packing_type", selectId: "fgodown_transfer_tableadd_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tableadd.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fgodown_transfer_tableadd" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fgodown_transfer_tableadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown"<?= $Page->godown->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_godown" for="x_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown->caption() ?><?= $Page->godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown->cellAttributes() ?>>
<span id="el_godown_transfer_table_godown">
<div class="input-group flex-nowrap">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tableadd_x_godown"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$Page->godown->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->godown->caption() ?>" data-title="<?= $Page->godown->caption() ?>" data-ew-action="add-option" data-el="x_godown" data-url="<?= GetUrl("godowntableaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->godown->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage() ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tableadd", function() {
    var options = { name: "x_godown", selectId: "fgodown_transfer_tableadd_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tableadd.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fgodown_transfer_tableadd" };
    } else {
        options.ajax = { id: "x_godown", form: "fgodown_transfer_tableadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_godown_transfer_table_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="godown_transfer_table" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgodown_transfer_tableadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgodown_transfer_tableadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id"<?= $Page->employee_id->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_employee_id" for="x_employee_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_id->caption() ?><?= $Page->employee_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_id->cellAttributes() ?>>
<span id="el_godown_transfer_table_employee_id">
<input type="<?= $Page->employee_id->getInputTextType() ?>" name="x_employee_id" id="x_employee_id" data-table="godown_transfer_table" data-field="x_employee_id" value="<?= $Page->employee_id->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_id->formatPattern()) ?>"<?= $Page->employee_id->editAttributes() ?> aria-describedby="x_employee_id_help">
<?= $Page->employee_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->next_issue_yn->Visible) { // next_issue_yn ?>
    <div id="r_next_issue_yn"<?= $Page->next_issue_yn->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_next_issue_yn" class="<?= $Page->LeftColumnClass ?>"><?= $Page->next_issue_yn->caption() ?><?= $Page->next_issue_yn->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->next_issue_yn->cellAttributes() ?>>
<span id="el_godown_transfer_table_next_issue_yn">
<template id="tp_x_next_issue_yn">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="godown_transfer_table" data-field="x_next_issue_yn" name="x_next_issue_yn" id="x_next_issue_yn"<?= $Page->next_issue_yn->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_next_issue_yn" class="ew-item-list"></div>
<selection-list hidden
    id="x_next_issue_yn"
    name="x_next_issue_yn"
    value="<?= HtmlEncode($Page->next_issue_yn->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_next_issue_yn"
    data-target="dsl_x_next_issue_yn"
    data-repeatcolumn="5"
    class="form-control<?= $Page->next_issue_yn->isInvalidClass() ?>"
    data-table="godown_transfer_table"
    data-field="x_next_issue_yn"
    data-value-separator="<?= $Page->next_issue_yn->displayValueSeparatorAttribute() ?>"
    <?= $Page->next_issue_yn->editAttributes() ?>></selection-list>
<?= $Page->next_issue_yn->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->next_issue_yn->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->next_process->Visible) { // next_process ?>
    <div id="r_next_process"<?= $Page->next_process->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_next_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->next_process->caption() ?><?= $Page->next_process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->next_process->cellAttributes() ?>>
<span id="el_godown_transfer_table_next_process">
<template id="tp_x_next_process">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="godown_transfer_table" data-field="x_next_process" name="x_next_process" id="x_next_process"<?= $Page->next_process->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_next_process" class="ew-item-list"></div>
<selection-list hidden
    id="x_next_process"
    name="x_next_process"
    value="<?= HtmlEncode($Page->next_process->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_next_process"
    data-target="dsl_x_next_process"
    data-repeatcolumn="5"
    class="form-control<?= $Page->next_process->isInvalidClass() ?>"
    data-table="godown_transfer_table"
    data-field="x_next_process"
    data-value-separator="<?= $Page->next_process->displayValueSeparatorAttribute() ?>"
    <?= $Page->next_process->editAttributes() ?>></selection-list>
<?= $Page->next_process->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->next_process->getErrorMessage() ?></div>
<?= $Page->next_process->Lookup->getParamTag($Page, "p_x_next_process") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->next_godown->Visible) { // next_godown ?>
    <div id="r_next_godown"<?= $Page->next_godown->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_next_godown" for="x_next_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->next_godown->caption() ?><?= $Page->next_godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->next_godown->cellAttributes() ?>>
<span id="el_godown_transfer_table_next_godown">
    <select
        id="x_next_godown"
        name="x_next_godown"
        class="form-select ew-select<?= $Page->next_godown->isInvalidClass() ?>"
        <?php if (!$Page->next_godown->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_tableadd_x_next_godown"
        <?php } ?>
        data-table="godown_transfer_table"
        data-field="x_next_godown"
        data-value-separator="<?= $Page->next_godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->next_godown->getPlaceHolder()) ?>"
        <?= $Page->next_godown->editAttributes() ?>>
        <?= $Page->next_godown->selectOptionListHtml("x_next_godown") ?>
    </select>
    <?= $Page->next_godown->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->next_godown->getErrorMessage() ?></div>
<?= $Page->next_godown->Lookup->getParamTag($Page, "p_x_next_godown") ?>
<?php if (!$Page->next_godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_tableadd", function() {
    var options = { name: "x_next_godown", selectId: "fgodown_transfer_tableadd_x_next_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_tableadd.lists.next_godown?.lookupOptions.length) {
        options.data = { id: "x_next_godown", form: "fgodown_transfer_tableadd" };
    } else {
        options.ajax = { id: "x_next_godown", form: "fgodown_transfer_tableadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_table.fields.next_godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_godown_transfer_table_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_godown_transfer_table_remarks">
<textarea data-table="godown_transfer_table" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="31" rows="5" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgodown_transfer_tableadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgodown_transfer_tableadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("godown_transfer_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#r_next_process").addClass('hide');
    $("#r_next_godown").addClass('hide');
});
</script>
