<?php

namespace PHPMaker2024\fibre;

// Page object
$GodownTransferNewAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { godown_transfer_new: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fgodown_transfer_newadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgodown_transfer_newadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["gp_no", [fields.gp_no.visible && fields.gp_no.required ? ew.Validators.required(fields.gp_no.caption) : null, ew.Validators.integer], fields.gp_no.isInvalid],
            ["_from", [fields._from.visible && fields._from.required ? ew.Validators.required(fields._from.caption) : null], fields._from.isInvalid],
            ["to", [fields.to.visible && fields.to.required ? ew.Validators.required(fields.to.caption) : null], fields.to.isInvalid],
            ["attention", [fields.attention.visible && fields.attention.required ? ew.Validators.required(fields.attention.caption) : null], fields.attention.isInvalid],
            ["transfer_nature", [fields.transfer_nature.visible && fields.transfer_nature.required ? ew.Validators.required(fields.transfer_nature.caption) : null], fields.transfer_nature.isInvalid],
            ["due_date", [fields.due_date.visible && fields.due_date.required ? ew.Validators.required(fields.due_date.caption) : null, ew.Validators.datetime(fields.due_date.clientFormatPattern)], fields.due_date.isInvalid],
            ["group", [fields.group.visible && fields.group.required ? ew.Validators.required(fields.group.caption) : null], fields.group.isInvalid],
            ["item", [fields.item.visible && fields.item.required ? ew.Validators.required(fields.item.caption) : null], fields.item.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["despatchdetails", [fields.despatchdetails.visible && fields.despatchdetails.required ? ew.Validators.required(fields.despatchdetails.caption) : null], fields.despatchdetails.isInvalid],
            ["sender_comments", [fields.sender_comments.visible && fields.sender_comments.required ? ew.Validators.required(fields.sender_comments.caption) : null], fields.sender_comments.isInvalid],
            ["t_mode", [fields.t_mode.visible && fields.t_mode.required ? ew.Validators.required(fields.t_mode.caption) : null], fields.t_mode.isInvalid],
            ["t_distance", [fields.t_distance.visible && fields.t_distance.required ? ew.Validators.required(fields.t_distance.caption) : null, ew.Validators.integer], fields.t_distance.isInvalid],
            ["t_v_no", [fields.t_v_no.visible && fields.t_v_no.required ? ew.Validators.required(fields.t_v_no.caption) : null], fields.t_v_no.isInvalid],
            ["purpose", [fields.purpose.visible && fields.purpose.required ? ew.Validators.required(fields.purpose.caption) : null], fields.purpose.isInvalid],
            ["user_id", [fields.user_id.visible && fields.user_id.required ? ew.Validators.required(fields.user_id.caption) : null], fields.user_id.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["e_user_id", [fields.e_user_id.visible && fields.e_user_id.required ? ew.Validators.required(fields.e_user_id.caption) : null, ew.Validators.integer], fields.e_user_id.isInvalid],
            ["e_datetime", [fields.e_datetime.visible && fields.e_datetime.required ? ew.Validators.required(fields.e_datetime.caption) : null, ew.Validators.datetime(fields.e_datetime.clientFormatPattern)], fields.e_datetime.isInvalid],
            ["receiving_condition", [fields.receiving_condition.visible && fields.receiving_condition.required ? ew.Validators.required(fields.receiving_condition.caption) : null, ew.Validators.integer], fields.receiving_condition.isInvalid],
            ["receiver_comments", [fields.receiver_comments.visible && fields.receiver_comments.required ? ew.Validators.required(fields.receiver_comments.caption) : null, ew.Validators.integer], fields.receiver_comments.isInvalid],
            ["r_user_id", [fields.r_user_id.visible && fields.r_user_id.required ? ew.Validators.required(fields.r_user_id.caption) : null, ew.Validators.integer], fields.r_user_id.isInvalid],
            ["r_datetime", [fields.r_datetime.visible && fields.r_datetime.required ? ew.Validators.required(fields.r_datetime.caption) : null, ew.Validators.datetime(fields.r_datetime.clientFormatPattern)], fields.r_datetime.isInvalid],
            ["updated", [fields.updated.visible && fields.updated.required ? ew.Validators.required(fields.updated.caption) : null, ew.Validators.integer], fields.updated.isInvalid],
            ["r_e_user_id", [fields.r_e_user_id.visible && fields.r_e_user_id.required ? ew.Validators.required(fields.r_e_user_id.caption) : null, ew.Validators.integer], fields.r_e_user_id.isInvalid],
            ["r_e_datetime", [fields.r_e_datetime.visible && fields.r_e_datetime.required ? ew.Validators.required(fields.r_e_datetime.caption) : null, ew.Validators.datetime(fields.r_e_datetime.clientFormatPattern)], fields.r_e_datetime.isInvalid],
            ["jc_no", [fields.jc_no.visible && fields.jc_no.required ? ew.Validators.required(fields.jc_no.caption) : null, ew.Validators.integer], fields.jc_no.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null, ew.Validators.integer], fields.product.isInvalid],
            ["count_received", [fields.count_received.visible && fields.count_received.required ? ew.Validators.required(fields.count_received.caption) : null], fields.count_received.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "_from": <?= $Page->_from->toClientList($Page) ?>,
            "to": <?= $Page->to->toClientList($Page) ?>,
            "attention": <?= $Page->attention->toClientList($Page) ?>,
            "transfer_nature": <?= $Page->transfer_nature->toClientList($Page) ?>,
            "group": <?= $Page->group->toClientList($Page) ?>,
            "t_mode": <?= $Page->t_mode->toClientList($Page) ?>,
            "purpose": <?= $Page->purpose->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgodown_transfer_newadd" id="fgodown_transfer_newadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_new">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->gp_no->Visible) { // gp_no ?>
    <div id="r_gp_no"<?= $Page->gp_no->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_gp_no" for="x_gp_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gp_no->caption() ?><?= $Page->gp_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gp_no->cellAttributes() ?>>
<span id="el_godown_transfer_new_gp_no">
<input type="<?= $Page->gp_no->getInputTextType() ?>" name="x_gp_no" id="x_gp_no" data-table="godown_transfer_new" data-field="x_gp_no" value="<?= $Page->gp_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gp_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gp_no->formatPattern()) ?>"<?= $Page->gp_no->editAttributes() ?> aria-describedby="x_gp_no_help">
<?= $Page->gp_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gp_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_from->Visible) { // from ?>
    <div id="r__from"<?= $Page->_from->rowAttributes() ?>>
        <label id="elh_godown_transfer_new__from" for="x__from" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_from->caption() ?><?= $Page->_from->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_from->cellAttributes() ?>>
<span id="el_godown_transfer_new__from">
    <select
        id="x__from"
        name="x__from"
        class="form-select ew-select<?= $Page->_from->isInvalidClass() ?>"
        <?php if (!$Page->_from->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x__from"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x__from"
        data-value-separator="<?= $Page->_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_from->getPlaceHolder()) ?>"
        <?= $Page->_from->editAttributes() ?>>
        <?= $Page->_from->selectOptionListHtml("x__from") ?>
    </select>
    <?= $Page->_from->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->_from->getErrorMessage() ?></div>
<?= $Page->_from->Lookup->getParamTag($Page, "p_x__from") ?>
<?php if (!$Page->_from->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x__from", selectId: "fgodown_transfer_newadd_x__from" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists._from?.lookupOptions.length) {
        options.data = { id: "x__from", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x__from", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields._from.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->to->Visible) { // to ?>
    <div id="r_to"<?= $Page->to->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_to" for="x_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->to->caption() ?><?= $Page->to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->to->cellAttributes() ?>>
<span id="el_godown_transfer_new_to">
    <select
        id="x_to"
        name="x_to"
        class="form-select ew-select<?= $Page->to->isInvalidClass() ?>"
        <?php if (!$Page->to->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x_to"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x_to"
        data-value-separator="<?= $Page->to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->to->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->to->editAttributes() ?>>
        <?= $Page->to->selectOptionListHtml("x_to") ?>
    </select>
    <?= $Page->to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->to->getErrorMessage() ?></div>
<?= $Page->to->Lookup->getParamTag($Page, "p_x_to") ?>
<?php if (!$Page->to->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x_to", selectId: "fgodown_transfer_newadd_x_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists.to?.lookupOptions.length) {
        options.data = { id: "x_to", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x_to", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields.to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->attention->Visible) { // attention ?>
    <div id="r_attention"<?= $Page->attention->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_attention" for="x_attention" class="<?= $Page->LeftColumnClass ?>"><?= $Page->attention->caption() ?><?= $Page->attention->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->attention->cellAttributes() ?>>
<span id="el_godown_transfer_new_attention">
    <select
        id="x_attention"
        name="x_attention"
        class="form-select ew-select<?= $Page->attention->isInvalidClass() ?>"
        <?php if (!$Page->attention->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x_attention"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x_attention"
        data-value-separator="<?= $Page->attention->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->attention->getPlaceHolder()) ?>"
        <?= $Page->attention->editAttributes() ?>>
        <?= $Page->attention->selectOptionListHtml("x_attention") ?>
    </select>
    <?= $Page->attention->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->attention->getErrorMessage() ?></div>
<?= $Page->attention->Lookup->getParamTag($Page, "p_x_attention") ?>
<?php if (!$Page->attention->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x_attention", selectId: "fgodown_transfer_newadd_x_attention" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists.attention?.lookupOptions.length) {
        options.data = { id: "x_attention", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x_attention", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields.attention.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->transfer_nature->Visible) { // transfer_nature ?>
    <div id="r_transfer_nature"<?= $Page->transfer_nature->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_transfer_nature" for="x_transfer_nature" class="<?= $Page->LeftColumnClass ?>"><?= $Page->transfer_nature->caption() ?><?= $Page->transfer_nature->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->transfer_nature->cellAttributes() ?>>
<span id="el_godown_transfer_new_transfer_nature">
    <select
        id="x_transfer_nature"
        name="x_transfer_nature"
        class="form-select ew-select<?= $Page->transfer_nature->isInvalidClass() ?>"
        <?php if (!$Page->transfer_nature->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x_transfer_nature"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x_transfer_nature"
        data-value-separator="<?= $Page->transfer_nature->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->transfer_nature->getPlaceHolder()) ?>"
        <?= $Page->transfer_nature->editAttributes() ?>>
        <?= $Page->transfer_nature->selectOptionListHtml("x_transfer_nature") ?>
    </select>
    <?= $Page->transfer_nature->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->transfer_nature->getErrorMessage() ?></div>
<?php if (!$Page->transfer_nature->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x_transfer_nature", selectId: "fgodown_transfer_newadd_x_transfer_nature" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists.transfer_nature?.lookupOptions.length) {
        options.data = { id: "x_transfer_nature", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x_transfer_nature", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields.transfer_nature.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->due_date->Visible) { // due_date ?>
    <div id="r_due_date"<?= $Page->due_date->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_due_date" for="x_due_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->due_date->caption() ?><?= $Page->due_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->due_date->cellAttributes() ?>>
<span id="el_godown_transfer_new_due_date">
<input type="<?= $Page->due_date->getInputTextType() ?>" name="x_due_date" id="x_due_date" data-table="godown_transfer_new" data-field="x_due_date" value="<?= $Page->due_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->due_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->due_date->formatPattern()) ?>"<?= $Page->due_date->editAttributes() ?> aria-describedby="x_due_date_help">
<?= $Page->due_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->due_date->getErrorMessage() ?></div>
<?php if (!$Page->due_date->ReadOnly && !$Page->due_date->Disabled && !isset($Page->due_date->EditAttrs["readonly"]) && !isset($Page->due_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgodown_transfer_newadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgodown_transfer_newadd", "x_due_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->group->Visible) { // group ?>
    <div id="r_group"<?= $Page->group->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_group" for="x_group" class="<?= $Page->LeftColumnClass ?>"><?= $Page->group->caption() ?><?= $Page->group->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->group->cellAttributes() ?>>
<span id="el_godown_transfer_new_group">
    <select
        id="x_group"
        name="x_group"
        class="form-select ew-select<?= $Page->group->isInvalidClass() ?>"
        <?php if (!$Page->group->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x_group"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x_group"
        data-value-separator="<?= $Page->group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->group->getPlaceHolder()) ?>"
        <?= $Page->group->editAttributes() ?>>
        <?= $Page->group->selectOptionListHtml("x_group") ?>
    </select>
    <?= $Page->group->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->group->getErrorMessage() ?></div>
<?php if (!$Page->group->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x_group", selectId: "fgodown_transfer_newadd_x_group" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists.group?.lookupOptions.length) {
        options.data = { id: "x_group", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x_group", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields.group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item"<?= $Page->item->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_item" for="x_item" class="<?= $Page->LeftColumnClass ?>"><?= $Page->item->caption() ?><?= $Page->item->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->item->cellAttributes() ?>>
<span id="el_godown_transfer_new_item">
<input type="<?= $Page->item->getInputTextType() ?>" name="x_item" id="x_item" data-table="godown_transfer_new" data-field="x_item" value="<?= $Page->item->EditValue ?>" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?> aria-describedby="x_item_help">
<?= $Page->item->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_godown_transfer_new_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="godown_transfer_new" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->despatchdetails->Visible) { // despatch details ?>
    <div id="r_despatchdetails"<?= $Page->despatchdetails->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_despatchdetails" for="x_despatchdetails" class="<?= $Page->LeftColumnClass ?>"><?= $Page->despatchdetails->caption() ?><?= $Page->despatchdetails->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->despatchdetails->cellAttributes() ?>>
<span id="el_godown_transfer_new_despatchdetails">
<input type="<?= $Page->despatchdetails->getInputTextType() ?>" name="x_despatchdetails" id="x_despatchdetails" data-table="godown_transfer_new" data-field="x_despatchdetails" value="<?= $Page->despatchdetails->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->despatchdetails->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatchdetails->formatPattern()) ?>"<?= $Page->despatchdetails->editAttributes() ?> aria-describedby="x_despatchdetails_help">
<?= $Page->despatchdetails->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->despatchdetails->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sender_comments->Visible) { // sender_comments ?>
    <div id="r_sender_comments"<?= $Page->sender_comments->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_sender_comments" for="x_sender_comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sender_comments->caption() ?><?= $Page->sender_comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sender_comments->cellAttributes() ?>>
<span id="el_godown_transfer_new_sender_comments">
<input type="<?= $Page->sender_comments->getInputTextType() ?>" name="x_sender_comments" id="x_sender_comments" data-table="godown_transfer_new" data-field="x_sender_comments" value="<?= $Page->sender_comments->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->sender_comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sender_comments->formatPattern()) ?>"<?= $Page->sender_comments->editAttributes() ?> aria-describedby="x_sender_comments_help">
<?= $Page->sender_comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sender_comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_mode->Visible) { // t_mode ?>
    <div id="r_t_mode"<?= $Page->t_mode->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_t_mode" for="x_t_mode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_mode->caption() ?><?= $Page->t_mode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_mode->cellAttributes() ?>>
<span id="el_godown_transfer_new_t_mode">
    <select
        id="x_t_mode"
        name="x_t_mode"
        class="form-select ew-select<?= $Page->t_mode->isInvalidClass() ?>"
        <?php if (!$Page->t_mode->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x_t_mode"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x_t_mode"
        data-value-separator="<?= $Page->t_mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->t_mode->getPlaceHolder()) ?>"
        <?= $Page->t_mode->editAttributes() ?>>
        <?= $Page->t_mode->selectOptionListHtml("x_t_mode") ?>
    </select>
    <?= $Page->t_mode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->t_mode->getErrorMessage() ?></div>
<?php if (!$Page->t_mode->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x_t_mode", selectId: "fgodown_transfer_newadd_x_t_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists.t_mode?.lookupOptions.length) {
        options.data = { id: "x_t_mode", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x_t_mode", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields.t_mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_distance->Visible) { // t_distance ?>
    <div id="r_t_distance"<?= $Page->t_distance->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_t_distance" for="x_t_distance" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_distance->caption() ?><?= $Page->t_distance->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_distance->cellAttributes() ?>>
<span id="el_godown_transfer_new_t_distance">
<input type="<?= $Page->t_distance->getInputTextType() ?>" name="x_t_distance" id="x_t_distance" data-table="godown_transfer_new" data-field="x_t_distance" value="<?= $Page->t_distance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->t_distance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_distance->formatPattern()) ?>"<?= $Page->t_distance->editAttributes() ?> aria-describedby="x_t_distance_help">
<?= $Page->t_distance->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->t_distance->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->t_v_no->Visible) { // t_v_no ?>
    <div id="r_t_v_no"<?= $Page->t_v_no->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_t_v_no" for="x_t_v_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->t_v_no->caption() ?><?= $Page->t_v_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->t_v_no->cellAttributes() ?>>
<span id="el_godown_transfer_new_t_v_no">
<input type="<?= $Page->t_v_no->getInputTextType() ?>" name="x_t_v_no" id="x_t_v_no" data-table="godown_transfer_new" data-field="x_t_v_no" value="<?= $Page->t_v_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->t_v_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_v_no->formatPattern()) ?>"<?= $Page->t_v_no->editAttributes() ?> aria-describedby="x_t_v_no_help">
<?= $Page->t_v_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->t_v_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->purpose->Visible) { // purpose ?>
    <div id="r_purpose"<?= $Page->purpose->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_purpose" for="x_purpose" class="<?= $Page->LeftColumnClass ?>"><?= $Page->purpose->caption() ?><?= $Page->purpose->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->purpose->cellAttributes() ?>>
<span id="el_godown_transfer_new_purpose">
    <select
        id="x_purpose"
        name="x_purpose"
        class="form-select ew-select<?= $Page->purpose->isInvalidClass() ?>"
        <?php if (!$Page->purpose->IsNativeSelect) { ?>
        data-select2-id="fgodown_transfer_newadd_x_purpose"
        <?php } ?>
        data-table="godown_transfer_new"
        data-field="x_purpose"
        data-value-separator="<?= $Page->purpose->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->purpose->getPlaceHolder()) ?>"
        <?= $Page->purpose->editAttributes() ?>>
        <?= $Page->purpose->selectOptionListHtml("x_purpose") ?>
    </select>
    <?= $Page->purpose->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->purpose->getErrorMessage() ?></div>
<?php if (!$Page->purpose->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_transfer_newadd", function() {
    var options = { name: "x_purpose", selectId: "fgodown_transfer_newadd_x_purpose" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_transfer_newadd.lists.purpose?.lookupOptions.length) {
        options.data = { id: "x_purpose", form: "fgodown_transfer_newadd" };
    } else {
        options.ajax = { id: "x_purpose", form: "fgodown_transfer_newadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_transfer_new.fields.purpose.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->e_user_id->Visible) { // e_user_id ?>
    <div id="r_e_user_id"<?= $Page->e_user_id->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_e_user_id" for="x_e_user_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->e_user_id->caption() ?><?= $Page->e_user_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->e_user_id->cellAttributes() ?>>
<span id="el_godown_transfer_new_e_user_id">
<input type="<?= $Page->e_user_id->getInputTextType() ?>" name="x_e_user_id" id="x_e_user_id" data-table="godown_transfer_new" data-field="x_e_user_id" value="<?= $Page->e_user_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->e_user_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_user_id->formatPattern()) ?>"<?= $Page->e_user_id->editAttributes() ?> aria-describedby="x_e_user_id_help">
<?= $Page->e_user_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->e_user_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->e_datetime->Visible) { // e_datetime ?>
    <div id="r_e_datetime"<?= $Page->e_datetime->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_e_datetime" for="x_e_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->e_datetime->caption() ?><?= $Page->e_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->e_datetime->cellAttributes() ?>>
<span id="el_godown_transfer_new_e_datetime">
<input type="<?= $Page->e_datetime->getInputTextType() ?>" name="x_e_datetime" id="x_e_datetime" data-table="godown_transfer_new" data-field="x_e_datetime" value="<?= $Page->e_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_datetime->formatPattern()) ?>"<?= $Page->e_datetime->editAttributes() ?> aria-describedby="x_e_datetime_help">
<?= $Page->e_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->e_datetime->getErrorMessage() ?></div>
<?php if (!$Page->e_datetime->ReadOnly && !$Page->e_datetime->Disabled && !isset($Page->e_datetime->EditAttrs["readonly"]) && !isset($Page->e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgodown_transfer_newadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgodown_transfer_newadd", "x_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->receiving_condition->Visible) { // receiving_condition ?>
    <div id="r_receiving_condition"<?= $Page->receiving_condition->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_receiving_condition" for="x_receiving_condition" class="<?= $Page->LeftColumnClass ?>"><?= $Page->receiving_condition->caption() ?><?= $Page->receiving_condition->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->receiving_condition->cellAttributes() ?>>
<span id="el_godown_transfer_new_receiving_condition">
<input type="<?= $Page->receiving_condition->getInputTextType() ?>" name="x_receiving_condition" id="x_receiving_condition" data-table="godown_transfer_new" data-field="x_receiving_condition" value="<?= $Page->receiving_condition->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->receiving_condition->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receiving_condition->formatPattern()) ?>"<?= $Page->receiving_condition->editAttributes() ?> aria-describedby="x_receiving_condition_help">
<?= $Page->receiving_condition->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->receiving_condition->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->receiver_comments->Visible) { // receiver_comments ?>
    <div id="r_receiver_comments"<?= $Page->receiver_comments->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_receiver_comments" for="x_receiver_comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->receiver_comments->caption() ?><?= $Page->receiver_comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->receiver_comments->cellAttributes() ?>>
<span id="el_godown_transfer_new_receiver_comments">
<input type="<?= $Page->receiver_comments->getInputTextType() ?>" name="x_receiver_comments" id="x_receiver_comments" data-table="godown_transfer_new" data-field="x_receiver_comments" value="<?= $Page->receiver_comments->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->receiver_comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receiver_comments->formatPattern()) ?>"<?= $Page->receiver_comments->editAttributes() ?> aria-describedby="x_receiver_comments_help">
<?= $Page->receiver_comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->receiver_comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_user_id->Visible) { // r_user_id ?>
    <div id="r_r_user_id"<?= $Page->r_user_id->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_r_user_id" for="x_r_user_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_user_id->caption() ?><?= $Page->r_user_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_user_id->cellAttributes() ?>>
<span id="el_godown_transfer_new_r_user_id">
<input type="<?= $Page->r_user_id->getInputTextType() ?>" name="x_r_user_id" id="x_r_user_id" data-table="godown_transfer_new" data-field="x_r_user_id" value="<?= $Page->r_user_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->r_user_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_user_id->formatPattern()) ?>"<?= $Page->r_user_id->editAttributes() ?> aria-describedby="x_r_user_id_help">
<?= $Page->r_user_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_user_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_datetime->Visible) { // r_datetime ?>
    <div id="r_r_datetime"<?= $Page->r_datetime->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_r_datetime" for="x_r_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_datetime->caption() ?><?= $Page->r_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_datetime->cellAttributes() ?>>
<span id="el_godown_transfer_new_r_datetime">
<input type="<?= $Page->r_datetime->getInputTextType() ?>" name="x_r_datetime" id="x_r_datetime" data-table="godown_transfer_new" data-field="x_r_datetime" value="<?= $Page->r_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->r_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_datetime->formatPattern()) ?>"<?= $Page->r_datetime->editAttributes() ?> aria-describedby="x_r_datetime_help">
<?= $Page->r_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_datetime->getErrorMessage() ?></div>
<?php if (!$Page->r_datetime->ReadOnly && !$Page->r_datetime->Disabled && !isset($Page->r_datetime->EditAttrs["readonly"]) && !isset($Page->r_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgodown_transfer_newadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgodown_transfer_newadd", "x_r_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated"<?= $Page->updated->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_updated" for="x_updated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->updated->caption() ?><?= $Page->updated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->updated->cellAttributes() ?>>
<span id="el_godown_transfer_new_updated">
<input type="<?= $Page->updated->getInputTextType() ?>" name="x_updated" id="x_updated" data-table="godown_transfer_new" data-field="x_updated" value="<?= $Page->updated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updated->formatPattern()) ?>"<?= $Page->updated->editAttributes() ?> aria-describedby="x_updated_help">
<?= $Page->updated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->updated->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_e_user_id->Visible) { // r_e_user_id ?>
    <div id="r_r_e_user_id"<?= $Page->r_e_user_id->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_r_e_user_id" for="x_r_e_user_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_e_user_id->caption() ?><?= $Page->r_e_user_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_e_user_id->cellAttributes() ?>>
<span id="el_godown_transfer_new_r_e_user_id">
<input type="<?= $Page->r_e_user_id->getInputTextType() ?>" name="x_r_e_user_id" id="x_r_e_user_id" data-table="godown_transfer_new" data-field="x_r_e_user_id" value="<?= $Page->r_e_user_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->r_e_user_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_e_user_id->formatPattern()) ?>"<?= $Page->r_e_user_id->editAttributes() ?> aria-describedby="x_r_e_user_id_help">
<?= $Page->r_e_user_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_e_user_id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_e_datetime->Visible) { // r_e_datetime ?>
    <div id="r_r_e_datetime"<?= $Page->r_e_datetime->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_r_e_datetime" for="x_r_e_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_e_datetime->caption() ?><?= $Page->r_e_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_e_datetime->cellAttributes() ?>>
<span id="el_godown_transfer_new_r_e_datetime">
<input type="<?= $Page->r_e_datetime->getInputTextType() ?>" name="x_r_e_datetime" id="x_r_e_datetime" data-table="godown_transfer_new" data-field="x_r_e_datetime" value="<?= $Page->r_e_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->r_e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_e_datetime->formatPattern()) ?>"<?= $Page->r_e_datetime->editAttributes() ?> aria-describedby="x_r_e_datetime_help">
<?= $Page->r_e_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_e_datetime->getErrorMessage() ?></div>
<?php if (!$Page->r_e_datetime->ReadOnly && !$Page->r_e_datetime->Disabled && !isset($Page->r_e_datetime->EditAttrs["readonly"]) && !isset($Page->r_e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgodown_transfer_newadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgodown_transfer_newadd", "x_r_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no"<?= $Page->jc_no->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_jc_no" for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->jc_no->caption() ?><?= $Page->jc_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->jc_no->cellAttributes() ?>>
<span id="el_godown_transfer_new_jc_no">
<input type="<?= $Page->jc_no->getInputTextType() ?>" name="x_jc_no" id="x_jc_no" data-table="godown_transfer_new" data-field="x_jc_no" value="<?= $Page->jc_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->jc_no->formatPattern()) ?>"<?= $Page->jc_no->editAttributes() ?> aria-describedby="x_jc_no_help">
<?= $Page->jc_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_godown_transfer_new_product">
<input type="<?= $Page->product->getInputTextType() ?>" name="x_product" id="x_product" data-table="godown_transfer_new" data-field="x_product" value="<?= $Page->product->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product->formatPattern()) ?>"<?= $Page->product->editAttributes() ?> aria-describedby="x_product_help">
<?= $Page->product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->count_received->Visible) { // count_received ?>
    <div id="r_count_received"<?= $Page->count_received->rowAttributes() ?>>
        <label id="elh_godown_transfer_new_count_received" for="x_count_received" class="<?= $Page->LeftColumnClass ?>"><?= $Page->count_received->caption() ?><?= $Page->count_received->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->count_received->cellAttributes() ?>>
<span id="el_godown_transfer_new_count_received">
<input type="<?= $Page->count_received->getInputTextType() ?>" name="x_count_received" id="x_count_received" data-table="godown_transfer_new" data-field="x_count_received" value="<?= $Page->count_received->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->count_received->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count_received->formatPattern()) ?>"<?= $Page->count_received->editAttributes() ?> aria-describedby="x_count_received_help">
<?= $Page->count_received->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->count_received->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgodown_transfer_newadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgodown_transfer_newadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("godown_transfer_new");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
