<?php

namespace PHPMaker2024\fibre;

// Page object
$GodownTableAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { godown_table: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fgodown_tableaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgodown_tableaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["incharge", [fields.incharge.visible && fields.incharge.required ? ew.Validators.required(fields.incharge.caption) : null], fields.incharge.isInvalid],
            ["capacity", [fields.capacity.visible && fields.capacity.required ? ew.Validators.required(fields.capacity.caption) : null, ew.Validators.integer], fields.capacity.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["r_text", [fields.r_text.visible && fields.r_text.required ? ew.Validators.required(fields.r_text.caption) : null], fields.r_text.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "incharge": <?= $Page->incharge->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fgodown_tableaddopt" id="fgodown_tableaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="godown_table">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->company_id->cellAttributes() ?>>
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?> aria-describedby="x_company_id_help">
</span>
<selection-list hidden class="form-control" data-table="godown_table" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->CurrentValue) ?>"></selection-list>
<?= $Page->company_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fgodown_tableaddopt", function() {
    fgodown_tableaddopt.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.godown_table.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->grp->cellAttributes() ?>>
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="godown_table" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="godown_table"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<?= $Page->grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->type->cellAttributes() ?>>
<template id="tp_x_type">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="godown_table" data-field="x_type" name="x_type" id="x_type"<?= $Page->type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_type[]"
    name="x_type[]"
    value="<?= HtmlEncode($Page->type->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_type"
    data-target="dsl_x_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->type->isInvalidClass() ?>"
    data-table="godown_table"
    data-field="x_type"
    data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
    <?= $Page->type->editAttributes() ?>></selection-list>
<?= $Page->type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_name"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->name->cellAttributes() ?>>
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="godown_table" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_location"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->location->cellAttributes() ?>>
<textarea data-table="godown_table" data-field="x_location" name="x_location" id="x_location" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"<?= $Page->location->editAttributes() ?> aria-describedby="x_location_help"><?= $Page->location->EditValue ?></textarea>
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_code"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->code->cellAttributes() ?>>
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="godown_table" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->incharge->Visible) { // incharge ?>
    <div id="r_incharge"<?= $Page->incharge->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_incharge"><?= $Page->incharge->caption() ?><?= $Page->incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->incharge->cellAttributes() ?>>
    <select
        id="x_incharge"
        name="x_incharge"
        class="form-select ew-select<?= $Page->incharge->isInvalidClass() ?>"
        <?php if (!$Page->incharge->IsNativeSelect) { ?>
        data-select2-id="fgodown_tableaddopt_x_incharge"
        <?php } ?>
        data-table="godown_table"
        data-field="x_incharge"
        data-value-separator="<?= $Page->incharge->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->incharge->getPlaceHolder()) ?>"
        <?= $Page->incharge->editAttributes() ?>>
        <?= $Page->incharge->selectOptionListHtml("x_incharge") ?>
    </select>
    <?= $Page->incharge->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->incharge->getErrorMessage() ?></div>
<?= $Page->incharge->Lookup->getParamTag($Page, "p_x_incharge") ?>
<?php if (!$Page->incharge->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_tableaddopt", function() {
    var options = { name: "x_incharge", selectId: "fgodown_tableaddopt_x_incharge" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_tableaddopt.lists.incharge?.lookupOptions.length) {
        options.data = { id: "x_incharge", form: "fgodown_tableaddopt" };
    } else {
        options.ajax = { id: "x_incharge", form: "fgodown_tableaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_table.fields.incharge.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->capacity->Visible) { // capacity ?>
    <div id="r_capacity"<?= $Page->capacity->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_capacity"><?= $Page->capacity->caption() ?><?= $Page->capacity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->capacity->cellAttributes() ?>>
<input type="<?= $Page->capacity->getInputTextType() ?>" name="x_capacity" id="x_capacity" data-table="godown_table" data-field="x_capacity" value="<?= $Page->capacity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->capacity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->capacity->formatPattern()) ?>"<?= $Page->capacity->editAttributes() ?> aria-describedby="x_capacity_help">
<?= $Page->capacity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->capacity->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fgodown_tableaddopt_x_status"
        <?php } ?>
        data-table="godown_table"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_tableaddopt", function() {
    var options = { name: "x_status", selectId: "fgodown_tableaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_tableaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fgodown_tableaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "fgodown_tableaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_table.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="godown_table" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="godown_table" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->r_text->Visible) { // r_text ?>
    <div id="r_r_text"<?= $Page->r_text->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_r_text"><?= $Page->r_text->caption() ?><?= $Page->r_text->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->r_text->cellAttributes() ?>>
<textarea data-table="godown_table" data-field="x_r_text" name="x_r_text" id="x_r_text" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->r_text->getPlaceHolder()) ?>"<?= $Page->r_text->editAttributes() ?> aria-describedby="x_r_text_help"><?= $Page->r_text->EditValue ?></textarea>
<?= $Page->r_text->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_text->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("godown_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
