<?php

namespace PHPMaker2024\fibre;

// Page object
$GodownTableAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { godown_table: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fgodown_tableadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fgodown_tableadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["incharge", [fields.incharge.visible && fields.incharge.required ? ew.Validators.required(fields.incharge.caption) : null], fields.incharge.isInvalid],
            ["capacity", [fields.capacity.visible && fields.capacity.required ? ew.Validators.required(fields.capacity.caption) : null, ew.Validators.integer], fields.capacity.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "incharge": <?= $Page->incharge->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgodown_tableadd" id="fgodown_tableadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="godown_table">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_godown_table_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_godown_table_company_id">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?> aria-describedby="x_company_id_help">
</span>
<selection-list hidden class="form-control" data-table="godown_table" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->CurrentValue) ?>"></selection-list>
<?= $Page->company_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fgodown_tableadd", function() {
    fgodown_tableadd.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.godown_table.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_godown_table_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_godown_table_grp">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="godown_table" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="godown_table"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<?= $Page->grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_godown_table_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_godown_table_type">
<template id="tp_x_type">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="godown_table" data-field="x_type" name="x_type" id="x_type"<?= $Page->type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_type[]"
    name="x_type[]"
    value="<?= HtmlEncode($Page->type->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_type"
    data-target="dsl_x_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->type->isInvalidClass() ?>"
    data-table="godown_table"
    data-field="x_type"
    data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
    <?= $Page->type->editAttributes() ?>></selection-list>
<?= $Page->type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_godown_table_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_godown_table_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="godown_table" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_godown_table_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_godown_table_location">
<textarea data-table="godown_table" data-field="x_location" name="x_location" id="x_location" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"<?= $Page->location->editAttributes() ?> aria-describedby="x_location_help"><?= $Page->location->EditValue ?></textarea>
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label id="elh_godown_table_code" for="x_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->code->cellAttributes() ?>>
<span id="el_godown_table_code">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="godown_table" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->incharge->Visible) { // incharge ?>
    <div id="r_incharge"<?= $Page->incharge->rowAttributes() ?>>
        <label id="elh_godown_table_incharge" for="x_incharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->incharge->caption() ?><?= $Page->incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->incharge->cellAttributes() ?>>
<span id="el_godown_table_incharge">
    <select
        id="x_incharge"
        name="x_incharge"
        class="form-select ew-select<?= $Page->incharge->isInvalidClass() ?>"
        <?php if (!$Page->incharge->IsNativeSelect) { ?>
        data-select2-id="fgodown_tableadd_x_incharge"
        <?php } ?>
        data-table="godown_table"
        data-field="x_incharge"
        data-value-separator="<?= $Page->incharge->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->incharge->getPlaceHolder()) ?>"
        <?= $Page->incharge->editAttributes() ?>>
        <?= $Page->incharge->selectOptionListHtml("x_incharge") ?>
    </select>
    <?= $Page->incharge->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->incharge->getErrorMessage() ?></div>
<?= $Page->incharge->Lookup->getParamTag($Page, "p_x_incharge") ?>
<?php if (!$Page->incharge->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_tableadd", function() {
    var options = { name: "x_incharge", selectId: "fgodown_tableadd_x_incharge" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_tableadd.lists.incharge?.lookupOptions.length) {
        options.data = { id: "x_incharge", form: "fgodown_tableadd" };
    } else {
        options.ajax = { id: "x_incharge", form: "fgodown_tableadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_table.fields.incharge.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->capacity->Visible) { // capacity ?>
    <div id="r_capacity"<?= $Page->capacity->rowAttributes() ?>>
        <label id="elh_godown_table_capacity" for="x_capacity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->capacity->caption() ?><?= $Page->capacity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->capacity->cellAttributes() ?>>
<span id="el_godown_table_capacity">
<input type="<?= $Page->capacity->getInputTextType() ?>" name="x_capacity" id="x_capacity" data-table="godown_table" data-field="x_capacity" value="<?= $Page->capacity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->capacity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->capacity->formatPattern()) ?>"<?= $Page->capacity->editAttributes() ?> aria-describedby="x_capacity_help">
<?= $Page->capacity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->capacity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_godown_table_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_godown_table_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fgodown_tableadd_x_status"
        <?php } ?>
        data-table="godown_table"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fgodown_tableadd", function() {
    var options = { name: "x_status", selectId: "fgodown_tableadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgodown_tableadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fgodown_tableadd" };
    } else {
        options.ajax = { id: "x_status", form: "fgodown_tableadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.godown_table.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgodown_tableadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgodown_tableadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("godown_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
