<?php

namespace PHPMaker2024\fibre;

// Page object
$GatePassReceivedSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { gate_pass_received: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fgate_pass_receivedsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgate_pass_receivedsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["gp_no", [ew.Validators.integer], fields.gp_no.isInvalid],
            ["_from", [ew.Validators.integer], fields._from.isInvalid],
            ["to", [], fields.to.isInvalid],
            ["attention", [], fields.attention.isInvalid],
            ["transfer_nature", [], fields.transfer_nature.isInvalid],
            ["due_date", [ew.Validators.datetime(fields.due_date.clientFormatPattern)], fields.due_date.isInvalid],
            ["group", [], fields.group.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["count_received", [], fields.count_received.isInvalid],
            ["item", [], fields.item.isInvalid],
            ["gt_id", [], fields.gt_id.isInvalid],
            ["despatchdetails", [], fields.despatchdetails.isInvalid],
            ["sender_comments", [], fields.sender_comments.isInvalid],
            ["t_mode", [], fields.t_mode.isInvalid],
            ["t_distance", [ew.Validators.integer], fields.t_distance.isInvalid],
            ["t_v_no", [], fields.t_v_no.isInvalid],
            ["purpose", [], fields.purpose.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["e_operator", [ew.Validators.integer], fields.e_operator.isInvalid],
            ["e_datetime", [ew.Validators.datetime(fields.e_datetime.clientFormatPattern)], fields.e_datetime.isInvalid],
            ["receiving_condition", [], fields.receiving_condition.isInvalid],
            ["receiver_comments", [], fields.receiver_comments.isInvalid],
            ["r_operator", [], fields.r_operator.isInvalid],
            ["r_datetime", [ew.Validators.datetime(fields.r_datetime.clientFormatPattern)], fields.r_datetime.isInvalid],
            ["updated", [ew.Validators.integer], fields.updated.isInvalid],
            ["r_e_user_id", [ew.Validators.integer], fields.r_e_user_id.isInvalid],
            ["r_e_datetime", [ew.Validators.datetime(fields.r_e_datetime.clientFormatPattern)], fields.r_e_datetime.isInvalid],
            ["jc_no", [], fields.jc_no.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "_from": <?= $Page->_from->toClientList($Page) ?>,
            "to": <?= $Page->to->toClientList($Page) ?>,
            "attention": <?= $Page->attention->toClientList($Page) ?>,
            "transfer_nature": <?= $Page->transfer_nature->toClientList($Page) ?>,
            "group": <?= $Page->group->toClientList($Page) ?>,
            "t_mode": <?= $Page->t_mode->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "receiving_condition": <?= $Page->receiving_condition->toClientList($Page) ?>,
            "r_operator": <?= $Page->r_operator->toClientList($Page) ?>,
            "jc_no": <?= $Page->jc_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fgate_pass_receivedsearch" id="fgate_pass_receivedsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="gate_pass_received">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->gp_no->Visible) { // gp_no ?>
    <div id="r_gp_no" class="row"<?= $Page->gp_no->rowAttributes() ?>>
        <label for="x_gp_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_gp_no"><?= $Page->gp_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gp_no" id="z_gp_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gp_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_gp_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gp_no->getInputTextType() ?>" name="x_gp_no" id="x_gp_no" data-table="gate_pass_received" data-field="x_gp_no" value="<?= $Page->gp_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gp_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gp_no->formatPattern()) ?>"<?= $Page->gp_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gp_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_from->Visible) { // from ?>
    <div id="r__from" class="row"<?= $Page->_from->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received__from"><?= $Page->_from->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__from" id="z__from" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_from->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received__from" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->_from->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x__from" class="ew-auto-suggest">
    <input type="<?= $Page->_from->getInputTextType() ?>" class="form-control" name="sv_x__from" id="sv_x__from" value="<?= RemoveHtml($Page->_from->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->_from->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->_from->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_from->formatPattern()) ?>"<?= $Page->_from->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="gate_pass_received" data-field="x__from" data-input="sv_x__from" data-value-separator="<?= $Page->_from->displayValueSeparatorAttribute() ?>" name="x__from" id="x__from" value="<?= HtmlEncode($Page->_from->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->_from->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    fgate_pass_receivedsearch.createAutoSuggest(Object.assign({"id":"x__from","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->_from->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.gate_pass_received.fields._from.autoSuggestOptions));
});
</script>
<?= $Page->_from->Lookup->getParamTag($Page, "p_x__from") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->to->Visible) { // to ?>
    <div id="r_to" class="row"<?= $Page->to->rowAttributes() ?>>
        <label for="x_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_to"><?= $Page->to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_to" id="z_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_to"
        name="x_to"
        class="form-select ew-select<?= $Page->to->isInvalidClass() ?>"
        <?php if (!$Page->to->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_to"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_to"
        data-value-separator="<?= $Page->to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->to->getPlaceHolder()) ?>"
        <?= $Page->to->editAttributes() ?>>
        <?= $Page->to->selectOptionListHtml("x_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->to->getErrorMessage(false) ?></div>
<?= $Page->to->Lookup->getParamTag($Page, "p_x_to") ?>
<?php if (!$Page->to->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_to", selectId: "fgate_pass_receivedsearch_x_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.to?.lookupOptions.length) {
        options.data = { id: "x_to", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_to", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->attention->Visible) { // attention ?>
    <div id="r_attention" class="row"<?= $Page->attention->rowAttributes() ?>>
        <label for="x_attention" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_attention"><?= $Page->attention->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_attention" id="z_attention" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->attention->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_attention" class="ew-search-field ew-search-field-single">
    <select
        id="x_attention"
        name="x_attention"
        class="form-select ew-select<?= $Page->attention->isInvalidClass() ?>"
        <?php if (!$Page->attention->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_attention"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_attention"
        data-value-separator="<?= $Page->attention->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->attention->getPlaceHolder()) ?>"
        <?= $Page->attention->editAttributes() ?>>
        <?= $Page->attention->selectOptionListHtml("x_attention") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->attention->getErrorMessage(false) ?></div>
<?= $Page->attention->Lookup->getParamTag($Page, "p_x_attention") ?>
<?php if (!$Page->attention->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_attention", selectId: "fgate_pass_receivedsearch_x_attention" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.attention?.lookupOptions.length) {
        options.data = { id: "x_attention", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_attention", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.attention.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transfer_nature->Visible) { // transfer_nature ?>
    <div id="r_transfer_nature" class="row"<?= $Page->transfer_nature->rowAttributes() ?>>
        <label for="x_transfer_nature" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_transfer_nature"><?= $Page->transfer_nature->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_transfer_nature" id="z_transfer_nature" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transfer_nature->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_transfer_nature" class="ew-search-field ew-search-field-single">
    <select
        id="x_transfer_nature"
        name="x_transfer_nature"
        class="form-select ew-select<?= $Page->transfer_nature->isInvalidClass() ?>"
        <?php if (!$Page->transfer_nature->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_transfer_nature"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_transfer_nature"
        data-value-separator="<?= $Page->transfer_nature->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->transfer_nature->getPlaceHolder()) ?>"
        <?= $Page->transfer_nature->editAttributes() ?>>
        <?= $Page->transfer_nature->selectOptionListHtml("x_transfer_nature") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->transfer_nature->getErrorMessage(false) ?></div>
<?php if (!$Page->transfer_nature->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_transfer_nature", selectId: "fgate_pass_receivedsearch_x_transfer_nature" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.transfer_nature?.lookupOptions.length) {
        options.data = { id: "x_transfer_nature", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_transfer_nature", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.transfer_nature.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->due_date->Visible) { // due_date ?>
    <div id="r_due_date" class="row"<?= $Page->due_date->rowAttributes() ?>>
        <label for="x_due_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_due_date"><?= $Page->due_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_due_date" id="z_due_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->due_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_due_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->due_date->getInputTextType() ?>" name="x_due_date" id="x_due_date" data-table="gate_pass_received" data-field="x_due_date" value="<?= $Page->due_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->due_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->due_date->formatPattern()) ?>"<?= $Page->due_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->due_date->getErrorMessage(false) ?></div>
<?php if (!$Page->due_date->ReadOnly && !$Page->due_date->Disabled && !isset($Page->due_date->EditAttrs["readonly"]) && !isset($Page->due_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgate_pass_receivedsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgate_pass_receivedsearch", "x_due_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->group->Visible) { // group ?>
    <div id="r_group" class="row"<?= $Page->group->rowAttributes() ?>>
        <label for="x_group" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_group"><?= $Page->group->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_group" id="z_group" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->group->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_group" class="ew-search-field ew-search-field-single">
    <select
        id="x_group"
        name="x_group"
        class="form-select ew-select<?= $Page->group->isInvalidClass() ?>"
        <?php if (!$Page->group->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_group"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_group"
        data-value-separator="<?= $Page->group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->group->getPlaceHolder()) ?>"
        <?= $Page->group->editAttributes() ?>>
        <?= $Page->group->selectOptionListHtml("x_group") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->group->getErrorMessage(false) ?></div>
<?php if (!$Page->group->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_group", selectId: "fgate_pass_receivedsearch_x_group" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.group?.lookupOptions.length) {
        options.data = { id: "x_group", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_group", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_product"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_product", selectId: "fgate_pass_receivedsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->count_received->Visible) { // count_received ?>
    <div id="r_count_received" class="row"<?= $Page->count_received->rowAttributes() ?>>
        <label for="x_count_received" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_count_received"><?= $Page->count_received->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_count_received" id="z_count_received" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->count_received->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_count_received" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->count_received->getInputTextType() ?>" name="x_count_received" id="x_count_received" data-table="gate_pass_received" data-field="x_count_received" value="<?= $Page->count_received->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->count_received->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count_received->formatPattern()) ?>"<?= $Page->count_received->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count_received->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item" class="row"<?= $Page->item->rowAttributes() ?>>
        <label for="x_item" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_item"><?= $Page->item->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_item" id="z_item" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->item->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_item" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->item->getInputTextType() ?>" name="x_item" id="x_item" data-table="gate_pass_received" data-field="x_item" value="<?= $Page->item->EditValue ?>" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gt_id->Visible) { // gt_id ?>
    <div id="r_gt_id" class="row"<?= $Page->gt_id->rowAttributes() ?>>
        <label for="x_gt_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_gt_id"><?= $Page->gt_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gt_id" id="z_gt_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gt_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_gt_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gt_id->getInputTextType() ?>" name="x_gt_id" id="x_gt_id" data-table="gate_pass_received" data-field="x_gt_id" value="<?= $Page->gt_id->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Page->gt_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gt_id->formatPattern()) ?>"<?= $Page->gt_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gt_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatchdetails->Visible) { // despatch details ?>
    <div id="r_despatchdetails" class="row"<?= $Page->despatchdetails->rowAttributes() ?>>
        <label for="x_despatchdetails" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_despatchdetails"><?= $Page->despatchdetails->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_despatchdetails" id="z_despatchdetails" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatchdetails->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_despatchdetails" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->despatchdetails->getInputTextType() ?>" name="x_despatchdetails" id="x_despatchdetails" data-table="gate_pass_received" data-field="x_despatchdetails" value="<?= $Page->despatchdetails->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->despatchdetails->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->despatchdetails->formatPattern()) ?>"<?= $Page->despatchdetails->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->despatchdetails->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sender_comments->Visible) { // sender_comments ?>
    <div id="r_sender_comments" class="row"<?= $Page->sender_comments->rowAttributes() ?>>
        <label for="x_sender_comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_sender_comments"><?= $Page->sender_comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sender_comments" id="z_sender_comments" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sender_comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_sender_comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sender_comments->getInputTextType() ?>" name="x_sender_comments" id="x_sender_comments" data-table="gate_pass_received" data-field="x_sender_comments" value="<?= $Page->sender_comments->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->sender_comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sender_comments->formatPattern()) ?>"<?= $Page->sender_comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sender_comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_mode->Visible) { // t_mode ?>
    <div id="r_t_mode" class="row"<?= $Page->t_mode->rowAttributes() ?>>
        <label for="x_t_mode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_t_mode"><?= $Page->t_mode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_t_mode" id="z_t_mode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_mode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_t_mode" class="ew-search-field ew-search-field-single">
    <select
        id="x_t_mode"
        name="x_t_mode"
        class="form-select ew-select<?= $Page->t_mode->isInvalidClass() ?>"
        <?php if (!$Page->t_mode->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_t_mode"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_t_mode"
        data-value-separator="<?= $Page->t_mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->t_mode->getPlaceHolder()) ?>"
        <?= $Page->t_mode->editAttributes() ?>>
        <?= $Page->t_mode->selectOptionListHtml("x_t_mode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->t_mode->getErrorMessage(false) ?></div>
<?php if (!$Page->t_mode->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_t_mode", selectId: "fgate_pass_receivedsearch_x_t_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.t_mode?.lookupOptions.length) {
        options.data = { id: "x_t_mode", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_t_mode", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.t_mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_distance->Visible) { // t_distance ?>
    <div id="r_t_distance" class="row"<?= $Page->t_distance->rowAttributes() ?>>
        <label for="x_t_distance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_t_distance"><?= $Page->t_distance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_t_distance" id="z_t_distance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_distance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_t_distance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_distance->getInputTextType() ?>" name="x_t_distance" id="x_t_distance" data-table="gate_pass_received" data-field="x_t_distance" value="<?= $Page->t_distance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->t_distance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_distance->formatPattern()) ?>"<?= $Page->t_distance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_distance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_v_no->Visible) { // t_v_no ?>
    <div id="r_t_v_no" class="row"<?= $Page->t_v_no->rowAttributes() ?>>
        <label for="x_t_v_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_t_v_no"><?= $Page->t_v_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_v_no" id="z_t_v_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_v_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_t_v_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_v_no->getInputTextType() ?>" name="x_t_v_no" id="x_t_v_no" data-table="gate_pass_received" data-field="x_t_v_no" value="<?= $Page->t_v_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->t_v_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_v_no->formatPattern()) ?>"<?= $Page->t_v_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_v_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->purpose->Visible) { // purpose ?>
    <div id="r_purpose" class="row"<?= $Page->purpose->rowAttributes() ?>>
        <label for="x_purpose" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_purpose"><?= $Page->purpose->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_purpose" id="z_purpose" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->purpose->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_purpose" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->purpose->getInputTextType() ?>" name="x_purpose" id="x_purpose" data-table="gate_pass_received" data-field="x_purpose" value="<?= $Page->purpose->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->purpose->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->purpose->formatPattern()) ?>"<?= $Page->purpose->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->purpose->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_operator"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_operator", selectId: "fgate_pass_receivedsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="gate_pass_received" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgate_pass_receivedsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgate_pass_receivedsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->e_operator->Visible) { // e_operator ?>
    <div id="r_e_operator" class="row"<?= $Page->e_operator->rowAttributes() ?>>
        <label for="x_e_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_e_operator"><?= $Page->e_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_e_operator" id="z_e_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->e_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_e_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->e_operator->getInputTextType() ?>" name="x_e_operator" id="x_e_operator" data-table="gate_pass_received" data-field="x_e_operator" value="<?= $Page->e_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->e_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_operator->formatPattern()) ?>"<?= $Page->e_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->e_datetime->Visible) { // e_datetime ?>
    <div id="r_e_datetime" class="row"<?= $Page->e_datetime->rowAttributes() ?>>
        <label for="x_e_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_e_datetime"><?= $Page->e_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_e_datetime" id="z_e_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->e_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_e_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->e_datetime->getInputTextType() ?>" name="x_e_datetime" id="x_e_datetime" data-table="gate_pass_received" data-field="x_e_datetime" value="<?= $Page->e_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_datetime->formatPattern()) ?>"<?= $Page->e_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->e_datetime->ReadOnly && !$Page->e_datetime->Disabled && !isset($Page->e_datetime->EditAttrs["readonly"]) && !isset($Page->e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgate_pass_receivedsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgate_pass_receivedsearch", "x_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->receiving_condition->Visible) { // receiving_condition ?>
    <div id="r_receiving_condition" class="row"<?= $Page->receiving_condition->rowAttributes() ?>>
        <label for="x_receiving_condition" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_receiving_condition"><?= $Page->receiving_condition->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_receiving_condition" id="z_receiving_condition" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->receiving_condition->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_receiving_condition" class="ew-search-field ew-search-field-single">
    <select
        id="x_receiving_condition"
        name="x_receiving_condition"
        class="form-select ew-select<?= $Page->receiving_condition->isInvalidClass() ?>"
        <?php if (!$Page->receiving_condition->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_receiving_condition"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_receiving_condition"
        data-value-separator="<?= $Page->receiving_condition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->receiving_condition->getPlaceHolder()) ?>"
        <?= $Page->receiving_condition->editAttributes() ?>>
        <?= $Page->receiving_condition->selectOptionListHtml("x_receiving_condition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->receiving_condition->getErrorMessage(false) ?></div>
<?php if (!$Page->receiving_condition->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_receiving_condition", selectId: "fgate_pass_receivedsearch_x_receiving_condition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.receiving_condition?.lookupOptions.length) {
        options.data = { id: "x_receiving_condition", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_receiving_condition", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.receiving_condition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->receiver_comments->Visible) { // receiver_comments ?>
    <div id="r_receiver_comments" class="row"<?= $Page->receiver_comments->rowAttributes() ?>>
        <label for="x_receiver_comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_receiver_comments"><?= $Page->receiver_comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_receiver_comments" id="z_receiver_comments" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->receiver_comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_receiver_comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->receiver_comments->getInputTextType() ?>" name="x_receiver_comments" id="x_receiver_comments" data-table="gate_pass_received" data-field="x_receiver_comments" value="<?= $Page->receiver_comments->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->receiver_comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->receiver_comments->formatPattern()) ?>"<?= $Page->receiver_comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->receiver_comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_operator->Visible) { // r_operator ?>
    <div id="r_r_operator" class="row"<?= $Page->r_operator->rowAttributes() ?>>
        <label for="x_r_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_operator"><?= $Page->r_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_r_operator" id="z_r_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_r_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_r_operator"
        name="x_r_operator"
        class="form-select ew-select<?= $Page->r_operator->isInvalidClass() ?>"
        <?php if (!$Page->r_operator->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_r_operator"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_r_operator"
        data-value-separator="<?= $Page->r_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->r_operator->getPlaceHolder()) ?>"
        <?= $Page->r_operator->editAttributes() ?>>
        <?= $Page->r_operator->selectOptionListHtml("x_r_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->r_operator->getErrorMessage(false) ?></div>
<?= $Page->r_operator->Lookup->getParamTag($Page, "p_x_r_operator") ?>
<?php if (!$Page->r_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_r_operator", selectId: "fgate_pass_receivedsearch_x_r_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.r_operator?.lookupOptions.length) {
        options.data = { id: "x_r_operator", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_r_operator", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.r_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_datetime->Visible) { // r_datetime ?>
    <div id="r_r_datetime" class="row"<?= $Page->r_datetime->rowAttributes() ?>>
        <label for="x_r_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_datetime"><?= $Page->r_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_r_datetime" id="z_r_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_r_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_datetime->getInputTextType() ?>" name="x_r_datetime" id="x_r_datetime" data-table="gate_pass_received" data-field="x_r_datetime" value="<?= $Page->r_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->r_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_datetime->formatPattern()) ?>"<?= $Page->r_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->r_datetime->ReadOnly && !$Page->r_datetime->Disabled && !isset($Page->r_datetime->EditAttrs["readonly"]) && !isset($Page->r_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgate_pass_receivedsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgate_pass_receivedsearch", "x_r_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated" class="row"<?= $Page->updated->rowAttributes() ?>>
        <label for="x_updated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_updated"><?= $Page->updated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_updated" id="z_updated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->updated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_updated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->updated->getInputTextType() ?>" name="x_updated" id="x_updated" data-table="gate_pass_received" data-field="x_updated" value="<?= $Page->updated->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updated->formatPattern()) ?>"<?= $Page->updated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->updated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_e_user_id->Visible) { // r_e_user_id ?>
    <div id="r_r_e_user_id" class="row"<?= $Page->r_e_user_id->rowAttributes() ?>>
        <label for="x_r_e_user_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_e_user_id"><?= $Page->r_e_user_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_r_e_user_id" id="z_r_e_user_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_e_user_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_r_e_user_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_e_user_id->getInputTextType() ?>" name="x_r_e_user_id" id="x_r_e_user_id" data-table="gate_pass_received" data-field="x_r_e_user_id" value="<?= $Page->r_e_user_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->r_e_user_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_e_user_id->formatPattern()) ?>"<?= $Page->r_e_user_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_e_user_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_e_datetime->Visible) { // r_e_datetime ?>
    <div id="r_r_e_datetime" class="row"<?= $Page->r_e_datetime->rowAttributes() ?>>
        <label for="x_r_e_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_e_datetime"><?= $Page->r_e_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_r_e_datetime" id="z_r_e_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_e_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_r_e_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_e_datetime->getInputTextType() ?>" name="x_r_e_datetime" id="x_r_e_datetime" data-table="gate_pass_received" data-field="x_r_e_datetime" value="<?= $Page->r_e_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->r_e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_e_datetime->formatPattern()) ?>"<?= $Page->r_e_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_e_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->r_e_datetime->ReadOnly && !$Page->r_e_datetime->Disabled && !isset($Page->r_e_datetime->EditAttrs["readonly"]) && !isset($Page->r_e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fgate_pass_receivedsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fgate_pass_receivedsearch", "x_r_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
    <div id="r_jc_no" class="row"<?= $Page->jc_no->rowAttributes() ?>>
        <label for="x_jc_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_gate_pass_received_jc_no"><?= $Page->jc_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_jc_no" id="z_jc_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->jc_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_gate_pass_received_jc_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_jc_no"
        name="x_jc_no"
        class="form-select ew-select<?= $Page->jc_no->isInvalidClass() ?>"
        <?php if (!$Page->jc_no->IsNativeSelect) { ?>
        data-select2-id="fgate_pass_receivedsearch_x_jc_no"
        <?php } ?>
        data-table="gate_pass_received"
        data-field="x_jc_no"
        data-value-separator="<?= $Page->jc_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->jc_no->getPlaceHolder()) ?>"
        <?= $Page->jc_no->editAttributes() ?>>
        <?= $Page->jc_no->selectOptionListHtml("x_jc_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->jc_no->getErrorMessage(false) ?></div>
<?= $Page->jc_no->Lookup->getParamTag($Page, "p_x_jc_no") ?>
<?php if (!$Page->jc_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_pass_receivedsearch", function() {
    var options = { name: "x_jc_no", selectId: "fgate_pass_receivedsearch_x_jc_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_pass_receivedsearch.lists.jc_no?.lookupOptions.length) {
        options.data = { id: "x_jc_no", form: "fgate_pass_receivedsearch" };
    } else {
        options.ajax = { id: "x_jc_no", form: "fgate_pass_receivedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass_received.fields.jc_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fgate_pass_receivedsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fgate_pass_receivedsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fgate_pass_receivedsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("gate_pass_received");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
