<?php

namespace PHPMaker2024\fibre;

// Page object
$GatePassList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { gate_pass: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fgate_passsrch" id="fgate_passsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fgate_passsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { gate_pass: currentTable } });
var currentForm;
var fgate_passsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fgate_passsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["gp_no", [ew.Validators.integer], fields.gp_no.isInvalid],
            ["_from", [], fields._from.isInvalid],
            ["to", [], fields.to.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "_from": <?= $Page->_from->toClientList($Page) ?>,
            "to": <?= $Page->to->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->gp_no->Visible) { // gp_no ?>
<?php
if (!$Page->gp_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_gp_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->gp_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_gp_no" class="ew-search-caption ew-label"><?= $Page->gp_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gp_no" id="z_gp_no" value="=">
</div>
        </div>
        <div id="el_gate_pass_gp_no" class="ew-search-field">
<input type="<?= $Page->gp_no->getInputTextType() ?>" name="x_gp_no" id="x_gp_no" data-table="gate_pass" data-field="x_gp_no" value="<?= $Page->gp_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gp_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gp_no->formatPattern()) ?>"<?= $Page->gp_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gp_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_from->Visible) { // from ?>
<?php
if (!$Page->_from->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__from" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_from->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__from" class="ew-search-caption ew-label"><?= $Page->_from->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__from" id="z__from" value="=">
</div>
        </div>
        <div id="el_gate_pass__from" class="ew-search-field">
    <select
        id="x__from"
        name="x__from"
        class="form-select ew-select<?= $Page->_from->isInvalidClass() ?>"
        <?php if (!$Page->_from->IsNativeSelect) { ?>
        data-select2-id="fgate_passsrch_x__from"
        <?php } ?>
        data-table="gate_pass"
        data-field="x__from"
        data-value-separator="<?= $Page->_from->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_from->getPlaceHolder()) ?>"
        <?= $Page->_from->editAttributes() ?>>
        <?= $Page->_from->selectOptionListHtml("x__from") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->_from->getErrorMessage(false) ?></div>
<?= $Page->_from->Lookup->getParamTag($Page, "p_x__from") ?>
<?php if (!$Page->_from->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_passsrch", function() {
    var options = { name: "x__from", selectId: "fgate_passsrch_x__from" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_passsrch.lists._from?.lookupOptions.length) {
        options.data = { id: "x__from", form: "fgate_passsrch" };
    } else {
        options.ajax = { id: "x__from", form: "fgate_passsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass.fields._from.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->to->Visible) { // to ?>
<?php
if (!$Page->to->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_to" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->to->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_to" class="ew-search-caption ew-label"><?= $Page->to->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_to" id="z_to" value="=">
</div>
        </div>
        <div id="el_gate_pass_to" class="ew-search-field">
    <select
        id="x_to"
        name="x_to"
        class="form-select ew-select<?= $Page->to->isInvalidClass() ?>"
        <?php if (!$Page->to->IsNativeSelect) { ?>
        data-select2-id="fgate_passsrch_x_to"
        <?php } ?>
        data-table="gate_pass"
        data-field="x_to"
        data-value-separator="<?= $Page->to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->to->getPlaceHolder()) ?>"
        <?= $Page->to->editAttributes() ?>>
        <?= $Page->to->selectOptionListHtml("x_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->to->getErrorMessage(false) ?></div>
<?= $Page->to->Lookup->getParamTag($Page, "p_x_to") ?>
<?php if (!$Page->to->IsNativeSelect) { ?>
<script>
loadjs.ready("fgate_passsrch", function() {
    var options = { name: "x_to", selectId: "fgate_passsrch_x_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fgate_passsrch.lists.to?.lookupOptions.length) {
        options.data = { id: "x_to", form: "fgate_passsrch" };
    } else {
        options.ajax = { id: "x_to", form: "fgate_passsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.gate_pass.fields.to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fgate_passsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fgate_passsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fgate_passsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fgate_passsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fgate_passsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fgate_passsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fgate_passsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="gate_pass">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_gate_pass" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_gate_passlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->gp_no->Visible) { // gp_no ?>
        <th data-name="gp_no" class="<?= $Page->gp_no->headerCellClass() ?>"><div id="elh_gate_pass_gp_no" class="gate_pass_gp_no"><?= $Page->renderFieldHeader($Page->gp_no) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_gate_pass_company_id" class="gate_pass_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->_from->Visible) { // from ?>
        <th data-name="_from" class="<?= $Page->_from->headerCellClass() ?>"><div id="elh_gate_pass__from" class="gate_pass__from"><?= $Page->renderFieldHeader($Page->_from) ?></div></th>
<?php } ?>
<?php if ($Page->from_po->Visible) { // from_po ?>
        <th data-name="from_po" class="<?= $Page->from_po->headerCellClass() ?>"><div id="elh_gate_pass_from_po" class="gate_pass_from_po"><?= $Page->renderFieldHeader($Page->from_po) ?></div></th>
<?php } ?>
<?php if ($Page->to->Visible) { // to ?>
        <th data-name="to" class="<?= $Page->to->headerCellClass() ?>"><div id="elh_gate_pass_to" class="gate_pass_to"><?= $Page->renderFieldHeader($Page->to) ?></div></th>
<?php } ?>
<?php if ($Page->attention->Visible) { // attention ?>
        <th data-name="attention" class="<?= $Page->attention->headerCellClass() ?>"><div id="elh_gate_pass_attention" class="gate_pass_attention"><?= $Page->renderFieldHeader($Page->attention) ?></div></th>
<?php } ?>
<?php if ($Page->transfer_nature->Visible) { // transfer_nature ?>
        <th data-name="transfer_nature" class="<?= $Page->transfer_nature->headerCellClass() ?>"><div id="elh_gate_pass_transfer_nature" class="gate_pass_transfer_nature"><?= $Page->renderFieldHeader($Page->transfer_nature) ?></div></th>
<?php } ?>
<?php if ($Page->due_date->Visible) { // due_date ?>
        <th data-name="due_date" class="<?= $Page->due_date->headerCellClass() ?>"><div id="elh_gate_pass_due_date" class="gate_pass_due_date"><?= $Page->renderFieldHeader($Page->due_date) ?></div></th>
<?php } ?>
<?php if ($Page->jc_no->Visible) { // jc_no ?>
        <th data-name="jc_no" class="<?= $Page->jc_no->headerCellClass() ?>"><div id="elh_gate_pass_jc_no" class="gate_pass_jc_no"><?= $Page->renderFieldHeader($Page->jc_no) ?></div></th>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
        <th data-name="item" class="<?= $Page->item->headerCellClass() ?>"><div id="elh_gate_pass_item" class="gate_pass_item"><?= $Page->renderFieldHeader($Page->item) ?></div></th>
<?php } ?>
<?php if ($Page->sender_comments->Visible) { // sender_comments ?>
        <th data-name="sender_comments" class="<?= $Page->sender_comments->headerCellClass() ?>"><div id="elh_gate_pass_sender_comments" class="gate_pass_sender_comments"><?= $Page->renderFieldHeader($Page->sender_comments) ?></div></th>
<?php } ?>
<?php if ($Page->despatchdetails->Visible) { // despatch details ?>
        <th data-name="despatchdetails" class="<?= $Page->despatchdetails->headerCellClass() ?>"><div id="elh_gate_pass_despatchdetails" class="gate_pass_despatchdetails"><?= $Page->renderFieldHeader($Page->despatchdetails) ?></div></th>
<?php } ?>
<?php if ($Page->t_mode->Visible) { // t_mode ?>
        <th data-name="t_mode" class="<?= $Page->t_mode->headerCellClass() ?>"><div id="elh_gate_pass_t_mode" class="gate_pass_t_mode"><?= $Page->renderFieldHeader($Page->t_mode) ?></div></th>
<?php } ?>
<?php if ($Page->t_distance->Visible) { // t_distance ?>
        <th data-name="t_distance" class="<?= $Page->t_distance->headerCellClass() ?>"><div id="elh_gate_pass_t_distance" class="gate_pass_t_distance"><?= $Page->renderFieldHeader($Page->t_distance) ?></div></th>
<?php } ?>
<?php if ($Page->t_v_no->Visible) { // t_v_no ?>
        <th data-name="t_v_no" class="<?= $Page->t_v_no->headerCellClass() ?>"><div id="elh_gate_pass_t_v_no" class="gate_pass_t_v_no"><?= $Page->renderFieldHeader($Page->t_v_no) ?></div></th>
<?php } ?>
<?php if ($Page->purpose->Visible) { // purpose ?>
        <th data-name="purpose" class="<?= $Page->purpose->headerCellClass() ?>"><div id="elh_gate_pass_purpose" class="gate_pass_purpose"><?= $Page->renderFieldHeader($Page->purpose) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_gate_pass_operator" class="gate_pass_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_gate_pass_datetime" class="gate_pass_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->e_operator->Visible) { // e_operator ?>
        <th data-name="e_operator" class="<?= $Page->e_operator->headerCellClass() ?>"><div id="elh_gate_pass_e_operator" class="gate_pass_e_operator"><?= $Page->renderFieldHeader($Page->e_operator) ?></div></th>
<?php } ?>
<?php if ($Page->e_datetime->Visible) { // e_datetime ?>
        <th data-name="e_datetime" class="<?= $Page->e_datetime->headerCellClass() ?>"><div id="elh_gate_pass_e_datetime" class="gate_pass_e_datetime"><?= $Page->renderFieldHeader($Page->e_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->receiving_condition->Visible) { // receiving_condition ?>
        <th data-name="receiving_condition" class="<?= $Page->receiving_condition->headerCellClass() ?>"><div id="elh_gate_pass_receiving_condition" class="gate_pass_receiving_condition"><?= $Page->renderFieldHeader($Page->receiving_condition) ?></div></th>
<?php } ?>
<?php if ($Page->receiver_comments->Visible) { // receiver_comments ?>
        <th data-name="receiver_comments" class="<?= $Page->receiver_comments->headerCellClass() ?>"><div id="elh_gate_pass_receiver_comments" class="gate_pass_receiver_comments"><?= $Page->renderFieldHeader($Page->receiver_comments) ?></div></th>
<?php } ?>
<?php if ($Page->r_operator->Visible) { // r_operator ?>
        <th data-name="r_operator" class="<?= $Page->r_operator->headerCellClass() ?>"><div id="elh_gate_pass_r_operator" class="gate_pass_r_operator"><?= $Page->renderFieldHeader($Page->r_operator) ?></div></th>
<?php } ?>
<?php if ($Page->r_datetime->Visible) { // r_datetime ?>
        <th data-name="r_datetime" class="<?= $Page->r_datetime->headerCellClass() ?>"><div id="elh_gate_pass_r_datetime" class="gate_pass_r_datetime"><?= $Page->renderFieldHeader($Page->r_datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->gp_no->Visible) { // gp_no ?>
        <td data-name="gp_no"<?= $Page->gp_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_gp_no" class="el_gate_pass_gp_no">
<span<?= $Page->gp_no->viewAttributes() ?>>
<?= $Page->gp_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_company_id" class="el_gate_pass_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_from->Visible) { // from ?>
        <td data-name="_from"<?= $Page->_from->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass__from" class="el_gate_pass__from">
<span<?= $Page->_from->viewAttributes() ?>>
<?php if (!EmptyString($Page->_from->getViewValue()) && $Page->_from->linkAttributes() != "") { ?>
<a<?= $Page->_from->linkAttributes() ?>><?= $Page->_from->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->_from->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->from_po->Visible) { // from_po ?>
        <td data-name="from_po"<?= $Page->from_po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_from_po" class="el_gate_pass_from_po">
<span<?= $Page->from_po->viewAttributes() ?>>
<?= $Page->from_po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->to->Visible) { // to ?>
        <td data-name="to"<?= $Page->to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_to" class="el_gate_pass_to">
<span<?= $Page->to->viewAttributes() ?>>
<?php if (!EmptyString($Page->to->getViewValue()) && $Page->to->linkAttributes() != "") { ?>
<a<?= $Page->to->linkAttributes() ?>><?= $Page->to->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->attention->Visible) { // attention ?>
        <td data-name="attention"<?= $Page->attention->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_attention" class="el_gate_pass_attention">
<span<?= $Page->attention->viewAttributes() ?>>
<?php if (!EmptyString($Page->attention->getViewValue()) && $Page->attention->linkAttributes() != "") { ?>
<a<?= $Page->attention->linkAttributes() ?>><?= $Page->attention->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->attention->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->transfer_nature->Visible) { // transfer_nature ?>
        <td data-name="transfer_nature"<?= $Page->transfer_nature->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_transfer_nature" class="el_gate_pass_transfer_nature">
<span<?= $Page->transfer_nature->viewAttributes() ?>>
<?php if (!EmptyString($Page->transfer_nature->getViewValue()) && $Page->transfer_nature->linkAttributes() != "") { ?>
<a<?= $Page->transfer_nature->linkAttributes() ?>><?= $Page->transfer_nature->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->transfer_nature->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->due_date->Visible) { // due_date ?>
        <td data-name="due_date"<?= $Page->due_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_due_date" class="el_gate_pass_due_date">
<span<?= $Page->due_date->viewAttributes() ?>>
<?php if (!EmptyString($Page->due_date->getViewValue()) && $Page->due_date->linkAttributes() != "") { ?>
<a<?= $Page->due_date->linkAttributes() ?>><?= $Page->due_date->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->due_date->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_no->Visible) { // jc_no ?>
        <td data-name="jc_no"<?= $Page->jc_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_jc_no" class="el_gate_pass_jc_no">
<span<?= $Page->jc_no->viewAttributes() ?>>
<?= $Page->jc_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->item->Visible) { // item ?>
        <td data-name="item"<?= $Page->item->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_item" class="el_gate_pass_item">
<span<?= $Page->item->viewAttributes() ?>>
<?php if (!EmptyString($Page->item->getViewValue()) && $Page->item->linkAttributes() != "") { ?>
<a<?= $Page->item->linkAttributes() ?>><?= $Page->item->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->item->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sender_comments->Visible) { // sender_comments ?>
        <td data-name="sender_comments"<?= $Page->sender_comments->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_sender_comments" class="el_gate_pass_sender_comments">
<span<?= $Page->sender_comments->viewAttributes() ?>>
<?= $Page->sender_comments->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->despatchdetails->Visible) { // despatch details ?>
        <td data-name="despatchdetails"<?= $Page->despatchdetails->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_despatchdetails" class="el_gate_pass_despatchdetails">
<span<?= $Page->despatchdetails->viewAttributes() ?>>
<?= $Page->despatchdetails->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_mode->Visible) { // t_mode ?>
        <td data-name="t_mode"<?= $Page->t_mode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_t_mode" class="el_gate_pass_t_mode">
<span<?= $Page->t_mode->viewAttributes() ?>>
<?php if (!EmptyString($Page->t_mode->getViewValue()) && $Page->t_mode->linkAttributes() != "") { ?>
<a<?= $Page->t_mode->linkAttributes() ?>><?= $Page->t_mode->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->t_mode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_distance->Visible) { // t_distance ?>
        <td data-name="t_distance"<?= $Page->t_distance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_t_distance" class="el_gate_pass_t_distance">
<span<?= $Page->t_distance->viewAttributes() ?>>
<?php if (!EmptyString($Page->t_distance->getViewValue()) && $Page->t_distance->linkAttributes() != "") { ?>
<a<?= $Page->t_distance->linkAttributes() ?>><?= $Page->t_distance->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->t_distance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_v_no->Visible) { // t_v_no ?>
        <td data-name="t_v_no"<?= $Page->t_v_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_t_v_no" class="el_gate_pass_t_v_no">
<span<?= $Page->t_v_no->viewAttributes() ?>>
<?= $Page->t_v_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->purpose->Visible) { // purpose ?>
        <td data-name="purpose"<?= $Page->purpose->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_purpose" class="el_gate_pass_purpose">
<span<?= $Page->purpose->viewAttributes() ?>>
<?= $Page->purpose->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_operator" class="el_gate_pass_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?php if (!EmptyString($Page->operator->getViewValue()) && $Page->operator->linkAttributes() != "") { ?>
<a<?= $Page->operator->linkAttributes() ?>><?= $Page->operator->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_datetime" class="el_gate_pass_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->e_operator->Visible) { // e_operator ?>
        <td data-name="e_operator"<?= $Page->e_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_e_operator" class="el_gate_pass_e_operator">
<span<?= $Page->e_operator->viewAttributes() ?>>
<?= $Page->e_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->e_datetime->Visible) { // e_datetime ?>
        <td data-name="e_datetime"<?= $Page->e_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_e_datetime" class="el_gate_pass_e_datetime">
<span<?= $Page->e_datetime->viewAttributes() ?>>
<?= $Page->e_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->receiving_condition->Visible) { // receiving_condition ?>
        <td data-name="receiving_condition"<?= $Page->receiving_condition->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_receiving_condition" class="el_gate_pass_receiving_condition">
<span<?= $Page->receiving_condition->viewAttributes() ?>>
<?php if (!EmptyString($Page->receiving_condition->getViewValue()) && $Page->receiving_condition->linkAttributes() != "") { ?>
<a<?= $Page->receiving_condition->linkAttributes() ?>><?= $Page->receiving_condition->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->receiving_condition->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->receiver_comments->Visible) { // receiver_comments ?>
        <td data-name="receiver_comments"<?= $Page->receiver_comments->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_receiver_comments" class="el_gate_pass_receiver_comments">
<span<?= $Page->receiver_comments->viewAttributes() ?>>
<?= $Page->receiver_comments->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->r_operator->Visible) { // r_operator ?>
        <td data-name="r_operator"<?= $Page->r_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_r_operator" class="el_gate_pass_r_operator">
<span<?= $Page->r_operator->viewAttributes() ?>>
<?= $Page->r_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->r_datetime->Visible) { // r_datetime ?>
        <td data-name="r_datetime"<?= $Page->r_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_gate_pass_r_datetime" class="el_gate_pass_r_datetime">
<span<?= $Page->r_datetime->viewAttributes() ?>>
<?= $Page->r_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("gate_pass");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
