<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoView2Update = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info_view2: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var ffamily_info_view2update;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffamily_info_view2update")
        .setPageId("update")

        // Add fields
        .setFields([
            ["family_personal", [fields.family_personal.visible && fields.family_personal.required ? ew.Validators.required(fields.family_personal.caption) : null], fields.family_personal.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["event", [fields.event.visible && fields.event.required ? ew.Validators.required(fields.event.caption) : null], fields.event.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_info_view2update" id="ffamily_info_view2update" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info_view2">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_family_info_view2update" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->family_personal->Visible && (!$Page->isConfirm() || $Page->family_personal->multiUpdateSelected())) { // family_personal ?>
    <div id="r_family_personal"<?= $Page->family_personal->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_family_personal" id="u_family_personal" class="form-check-input ew-multi-select" value="1"<?= $Page->family_personal->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_family_personal"><?= $Page->family_personal->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_family_personal" id="u_family_personal" value="<?= $Page->family_personal->MultiUpdate ?>">
            <?= $Page->family_personal->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->family_personal->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_view2_family_personal">
                <template id="tp_x_family_personal">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" data-table="family_info_view2" data-field="x_family_personal" name="x_family_personal" id="x_family_personal"<?= $Page->family_personal->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_family_personal" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_family_personal"
                    name="x_family_personal"
                    value="<?= HtmlEncode($Page->family_personal->CurrentValue) ?>"
                    data-type="select-one"
                    data-template="tp_x_family_personal"
                    data-target="dsl_x_family_personal"
                    data-repeatcolumn="1"
                    class="form-control<?= $Page->family_personal->isInvalidClass() ?>"
                    data-table="family_info_view2"
                    data-field="x_family_personal"
                    data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
                    <?= $Page->family_personal->editAttributes() ?>></selection-list>
                <?= $Page->family_personal->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_view2_family_personal">
                <span<?= $Page->family_personal->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->family_personal->getDisplayValue($Page->family_personal->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info_view2" data-field="x_family_personal" data-hidden="1" name="x_family_personal" id="x_family_personal" value="<?= HtmlEncode($Page->family_personal->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible && (!$Page->isConfirm() || $Page->city_name->multiUpdateSelected())) { // city_name ?>
    <div id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <label for="x_city_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_city_name" id="u_city_name" class="form-check-input ew-multi-select" value="1"<?= $Page->city_name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_city_name"><?= $Page->city_name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_city_name" id="u_city_name" value="<?= $Page->city_name->MultiUpdate ?>">
            <?= $Page->city_name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_view2_city_name">
                <input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="family_info_view2" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?> aria-describedby="x_city_name_help">
                <?= $Page->city_name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->city_name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_view2_city_name">
                <span<?= $Page->city_name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->city_name->getDisplayValue($Page->city_name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="family_info_view2" data-field="x_city_name" data-hidden="1" name="x_city_name" id="x_city_name" value="<?= HtmlEncode($Page->city_name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible && (!$Page->isConfirm() || $Page->category->multiUpdateSelected())) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_category" id="u_category" class="form-check-input ew-multi-select" value="1"<?= $Page->category->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_category"><?= $Page->category->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_category" id="u_category" value="<?= $Page->category->MultiUpdate ?>">
            <?= $Page->category->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_view2_category">
                <template id="tp_x_category">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" data-table="family_info_view2" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_category" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_category[]"
                    name="x_category[]"
                    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
                    data-type="select-multiple"
                    data-template="tp_x_category"
                    data-target="dsl_x_category"
                    data-repeatcolumn="3"
                    class="form-control<?= $Page->category->isInvalidClass() ?>"
                    data-table="family_info_view2"
                    data-field="x_category"
                    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
                    <?= $Page->category->editAttributes() ?>></selection-list>
                <?= $Page->category->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
                <?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_view2_category">
                <span<?= $Page->category->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->category->getDisplayValue($Page->category->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info_view2" data-field="x_category" data-hidden="1" name="x_category" id="x_category" value="<?= HtmlEncode($Page->category->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event->Visible && (!$Page->isConfirm() || $Page->event->multiUpdateSelected())) { // event ?>
    <div id="r_event"<?= $Page->event->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_event" id="u_event" class="form-check-input ew-multi-select" value="1"<?= $Page->event->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_event"><?= $Page->event->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_event" id="u_event" value="<?= $Page->event->MultiUpdate ?>">
            <?= $Page->event->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_view2_event">
                <template id="tp_x_event">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" data-table="family_info_view2" data-field="x_event" name="x_event" id="x_event"<?= $Page->event->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_event" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_event[]"
                    name="x_event[]"
                    value="<?= HtmlEncode($Page->event->CurrentValue) ?>"
                    data-type="select-multiple"
                    data-template="tp_x_event"
                    data-target="dsl_x_event"
                    data-repeatcolumn="3"
                    class="form-control<?= $Page->event->isInvalidClass() ?>"
                    data-table="family_info_view2"
                    data-field="x_event"
                    data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
                    <?= $Page->event->editAttributes() ?>></selection-list>
                <?= $Page->event->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->event->getErrorMessage() ?></div>
                <?= $Page->event->Lookup->getParamTag($Page, "p_x_event") ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_view2_event">
                <span<?= $Page->event->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->event->getDisplayValue($Page->event->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info_view2" data-field="x_event" data-hidden="1" name="x_event" id="x_event" value="<?= HtmlEncode($Page->event->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_info_view2update" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_info_view2update" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_info_view2update"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="ffamily_info_view2update" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info_view2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
