<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoView2Add = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info_view2: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ffamily_info_view2add;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffamily_info_view2add")
        .setPageId("add")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["family_personal", [fields.family_personal.visible && fields.family_personal.required ? ew.Validators.required(fields.family_personal.caption) : null], fields.family_personal.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["event", [fields.event.visible && fields.event.required ? ew.Validators.required(fields.event.caption) : null], fields.event.isInvalid],
            ["work_details", [fields.work_details.visible && fields.work_details.required ? ew.Validators.required(fields.work_details.caption) : null], fields.work_details.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [fields.dom.visible && fields.dom.required ? ew.Validators.required(fields.dom.caption) : null, ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_info_view2add" id="ffamily_info_view2add" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info_view2">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_family_info_view2_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>></div></div>
    </div>
<?php } ?>
<?php if ($Page->family_personal->Visible) { // family_personal ?>
    <div id="r_family_personal"<?= $Page->family_personal->rowAttributes() ?>>
        <label id="elh_family_info_view2_family_personal" class="<?= $Page->LeftColumnClass ?>"><?= $Page->family_personal->caption() ?><?= $Page->family_personal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->family_personal->cellAttributes() ?>>
<span id="el_family_info_view2_family_personal">
<template id="tp_x_family_personal">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info_view2" data-field="x_family_personal" name="x_family_personal" id="x_family_personal"<?= $Page->family_personal->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_family_personal" class="ew-item-list"></div>
<selection-list hidden
    id="x_family_personal"
    name="x_family_personal"
    value="<?= HtmlEncode($Page->family_personal->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_family_personal"
    data-target="dsl_x_family_personal"
    data-repeatcolumn="1"
    class="form-control<?= $Page->family_personal->isInvalidClass() ?>"
    data-table="family_info_view2"
    data-field="x_family_personal"
    data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
    <?= $Page->family_personal->editAttributes() ?>></selection-list>
<?= $Page->family_personal->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_family_info_view2_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_family_info_view2_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="family_info_view2" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_family_info_view2_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_family_info_view2_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="family_info_view2" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_family_info_view2_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_family_info_view2_address">
<textarea data-table="family_info_view2" data-field="x_address" name="x_address" id="x_address" cols="35" rows="3" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <label id="elh_family_info_view2_city_name" for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city_name->caption() ?><?= $Page->city_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city_name->cellAttributes() ?>>
<span id="el_family_info_view2_city_name">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="family_info_view2" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?> aria-describedby="x_city_name_help">
<?= $Page->city_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_family_info_view2_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_family_info_view2_category">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info_view2" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="family_info_view2"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "family_misc") && !$Page->category->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->category->caption() ?>" data-title="<?= $Page->category->caption() ?>" data-ew-action="add-option" data-el="x_category[]" data-url="<?= GetUrl("familymiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->event->Visible) { // event ?>
    <div id="r_event"<?= $Page->event->rowAttributes() ?>>
        <label id="elh_family_info_view2_event" class="<?= $Page->LeftColumnClass ?>"><?= $Page->event->caption() ?><?= $Page->event->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->event->cellAttributes() ?>>
<span id="el_family_info_view2_event">
<template id="tp_x_event">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info_view2" data-field="x_event" name="x_event" id="x_event"<?= $Page->event->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_event" class="ew-item-list"></div>
<selection-list hidden
    id="x_event[]"
    name="x_event[]"
    value="<?= HtmlEncode($Page->event->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_event"
    data-target="dsl_x_event"
    data-repeatcolumn="3"
    class="form-control<?= $Page->event->isInvalidClass() ?>"
    data-table="family_info_view2"
    data-field="x_event"
    data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
    <?= $Page->event->editAttributes() ?>></selection-list>
<?= $Page->event->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->event->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "family_event_list") && !$Page->event->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_event" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->event->caption() ?>" data-title="<?= $Page->event->caption() ?>" data-ew-action="add-option" data-el="x_event[]" data-url="<?= GetUrl("familyeventlistaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->event->Lookup->getParamTag($Page, "p_x_event") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
    <div id="r_work_details"<?= $Page->work_details->rowAttributes() ?>>
        <label id="elh_family_info_view2_work_details" for="x_work_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->work_details->caption() ?><?= $Page->work_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->work_details->cellAttributes() ?>>
<span id="el_family_info_view2_work_details">
<textarea data-table="family_info_view2" data-field="x_work_details" name="x_work_details" id="x_work_details" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>"<?= $Page->work_details->editAttributes() ?> aria-describedby="x_work_details_help"><?= $Page->work_details->EditValue ?></textarea>
<?= $Page->work_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->work_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label id="elh_family_info_view2_dob" for="x_dob" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dob->caption() ?><?= $Page->dob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dob->cellAttributes() ?>>
<span id="el_family_info_view2_dob">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="family_info_view2" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
<?= $Page->dob->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_info_view2add", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_info_view2add", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <label id="elh_family_info_view2_dom" for="x_dom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dom->caption() ?><?= $Page->dom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dom->cellAttributes() ?>>
<span id="el_family_info_view2_dom">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="family_info_view2" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?> aria-describedby="x_dom_help">
<?= $Page->dom->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage() ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_info_view2add", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_info_view2add", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_info_view2add"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_info_view2add" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info_view2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
