<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var ffamily_infoupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffamily_infoupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["family_personal", [fields.family_personal.visible && fields.family_personal.required ? ew.Validators.required(fields.family_personal.caption) : null], fields.family_personal.isInvalid],
            ["lifecycle", [fields.lifecycle.visible && fields.lifecycle.required ? ew.Validators.required(fields.lifecycle.caption) : null], fields.lifecycle.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["_title", [fields._title.visible && fields._title.required ? ew.Validators.required(fields._title.caption) : null], fields._title.isInvalid],
            ["marital_status", [fields.marital_status.visible && fields.marital_status.required ? ew.Validators.required(fields.marital_status.caption) : null], fields.marital_status.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["mobile_spouse", [fields.mobile_spouse.visible && fields.mobile_spouse.required ? ew.Validators.required(fields.mobile_spouse.caption) : null], fields.mobile_spouse.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["event", [fields.event.visible && fields.event.required ? ew.Validators.required(fields.event.caption) : null], fields.event.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.country.isInvalid],
            ["state", [fields.state.visible && fields.state.required ? ew.Validators.required(fields.state.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.state.isInvalid],
            ["city_india", [fields.city_india.visible && fields.city_india.required ? ew.Validators.required(fields.city_india.caption) : null], fields.city_india.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["sort_order", [fields.sort_order.visible && fields.sort_order.required ? ew.Validators.required(fields.sort_order.caption) : null, ew.Validators.float, ew.Validators.selected], fields.sort_order.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "lifecycle": <?= $Page->lifecycle->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "_title": <?= $Page->_title->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "city_india": <?= $Page->city_india->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_infoupdate" id="ffamily_infoupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_family_infoupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->family_personal->Visible && (!$Page->isConfirm() || $Page->family_personal->multiUpdateSelected())) { // family_personal ?>
    <div id="r_family_personal"<?= $Page->family_personal->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_family_personal" id="u_family_personal" class="form-check-input ew-multi-select" value="1"<?= $Page->family_personal->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_family_personal"><?= $Page->family_personal->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_family_personal" id="u_family_personal" value="<?= $Page->family_personal->MultiUpdate ?>">
            <?= $Page->family_personal->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->family_personal->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_family_personal">
                <template id="tp_x_family_personal">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_family_personal" name="x_family_personal" id="x_family_personal"<?= $Page->family_personal->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_family_personal" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_family_personal"
                    name="x_family_personal"
                    value="<?= HtmlEncode($Page->family_personal->CurrentValue) ?>"
                    data-type="select-one"
                    data-template="tp_x_family_personal"
                    data-target="dsl_x_family_personal"
                    data-repeatcolumn="1"
                    class="form-control<?= $Page->family_personal->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x_family_personal"
                    data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
                    <?= $Page->family_personal->editAttributes() ?>></selection-list>
                <?= $Page->family_personal->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_family_personal">
                <span<?= $Page->family_personal->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->family_personal->getDisplayValue($Page->family_personal->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_family_personal" data-hidden="1" name="x_family_personal" id="x_family_personal" value="<?= HtmlEncode($Page->family_personal->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lifecycle->Visible && (!$Page->isConfirm() || $Page->lifecycle->multiUpdateSelected())) { // lifecycle ?>
    <div id="r_lifecycle"<?= $Page->lifecycle->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_lifecycle" id="u_lifecycle" class="form-check-input ew-multi-select" value="1"<?= $Page->lifecycle->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_lifecycle"><?= $Page->lifecycle->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_lifecycle" id="u_lifecycle" value="<?= $Page->lifecycle->MultiUpdate ?>">
            <?= $Page->lifecycle->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lifecycle->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_lifecycle">
                <template id="tp_x_lifecycle">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_lifecycle" name="x_lifecycle" id="x_lifecycle"<?= $Page->lifecycle->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_lifecycle" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_lifecycle"
                    name="x_lifecycle"
                    value="<?= HtmlEncode($Page->lifecycle->CurrentValue) ?>"
                    data-type="select-one"
                    data-template="tp_x_lifecycle"
                    data-target="dsl_x_lifecycle"
                    data-repeatcolumn="5"
                    class="form-control<?= $Page->lifecycle->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x_lifecycle"
                    data-value-separator="<?= $Page->lifecycle->displayValueSeparatorAttribute() ?>"
                    <?= $Page->lifecycle->editAttributes() ?>></selection-list>
                <?= $Page->lifecycle->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->lifecycle->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_lifecycle">
                <span<?= $Page->lifecycle->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->lifecycle->getDisplayValue($Page->lifecycle->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_lifecycle" data-hidden="1" name="x_lifecycle" id="x_lifecycle" value="<?= HtmlEncode($Page->lifecycle->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible && (!$Page->isConfirm() || $Page->gender->multiUpdateSelected())) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_gender" id="u_gender" class="form-check-input ew-multi-select" value="1"<?= $Page->gender->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_gender"><?= $Page->gender->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_gender" id="u_gender" value="<?= $Page->gender->MultiUpdate ?>">
            <?= $Page->gender->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_gender">
                <template id="tp_x_gender">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_gender" name="x_gender" id="x_gender"<?= $Page->gender->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_gender" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_gender"
                    name="x_gender"
                    value="<?= HtmlEncode($Page->gender->CurrentValue) ?>"
                    data-type="select-one"
                    data-template="tp_x_gender"
                    data-target="dsl_x_gender"
                    data-repeatcolumn="5"
                    class="form-control<?= $Page->gender->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x_gender"
                    data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
                    <?= $Page->gender->editAttributes() ?>></selection-list>
                <?= $Page->gender->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_gender">
                <span<?= $Page->gender->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->gender->getDisplayValue($Page->gender->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_gender" data-hidden="1" name="x_gender" id="x_gender" value="<?= HtmlEncode($Page->gender->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_title->Visible && (!$Page->isConfirm() || $Page->_title->multiUpdateSelected())) { // title ?>
    <div id="r__title"<?= $Page->_title->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u__title" id="u__title" class="form-check-input ew-multi-select" value="1"<?= $Page->_title->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u__title"><?= $Page->_title->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u__title" id="u__title" value="<?= $Page->_title->MultiUpdate ?>">
            <?= $Page->_title->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_title->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info__title">
                <template id="tp_x__title">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" data-table="family_info" data-field="x__title" name="x__title" id="x__title"<?= $Page->_title->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x__title" class="ew-item-list"></div>
                <selection-list hidden
                    id="x__title"
                    name="x__title"
                    value="<?= HtmlEncode($Page->_title->CurrentValue) ?>"
                    data-type="select-one"
                    data-template="tp_x__title"
                    data-target="dsl_x__title"
                    data-repeatcolumn="5"
                    class="form-control<?= $Page->_title->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x__title"
                    data-value-separator="<?= $Page->_title->displayValueSeparatorAttribute() ?>"
                    <?= $Page->_title->editAttributes() ?>></selection-list>
                <?= $Page->_title->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->_title->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info__title">
                <span<?= $Page->_title->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->_title->getDisplayValue($Page->_title->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x__title" data-hidden="1" name="x__title" id="x__title" value="<?= HtmlEncode($Page->_title->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible && (!$Page->isConfirm() || $Page->marital_status->multiUpdateSelected())) { // marital_status ?>
    <div id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_marital_status" id="u_marital_status" class="form-check-input ew-multi-select" value="1"<?= $Page->marital_status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_marital_status"><?= $Page->marital_status->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_marital_status" id="u_marital_status" value="<?= $Page->marital_status->MultiUpdate ?>">
            <?= $Page->marital_status->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->marital_status->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_marital_status">
                <template id="tp_x_marital_status">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_marital_status" name="x_marital_status" id="x_marital_status"<?= $Page->marital_status->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_marital_status" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_marital_status"
                    name="x_marital_status"
                    value="<?= HtmlEncode($Page->marital_status->CurrentValue) ?>"
                    data-type="select-one"
                    data-template="tp_x_marital_status"
                    data-target="dsl_x_marital_status"
                    data-repeatcolumn="5"
                    class="form-control<?= $Page->marital_status->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x_marital_status"
                    data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
                    <?= $Page->marital_status->editAttributes() ?>></selection-list>
                <?= $Page->marital_status->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_marital_status">
                <span<?= $Page->marital_status->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->marital_status->getDisplayValue($Page->marital_status->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_marital_status" data-hidden="1" name="x_marital_status" id="x_marital_status" value="<?= HtmlEncode($Page->marital_status->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible && (!$Page->isConfirm() || $Page->name->multiUpdateSelected())) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_name" id="u_name" class="form-check-input ew-multi-select" value="1"<?= $Page->name->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_name"><?= $Page->name->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_name" id="u_name" value="<?= $Page->name->MultiUpdate ?>">
            <?= $Page->name->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_name">
                <input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="family_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
                <?= $Page->name->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_name">
                <span<?= $Page->name->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->name->getDisplayValue($Page->name->ViewValue))) ?>"></span>
                <input type="hidden" data-table="family_info" data-field="x_name" data-hidden="1" name="x_name" id="x_name" value="<?= HtmlEncode($Page->name->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_spouse->Visible && (!$Page->isConfirm() || $Page->mobile_spouse->multiUpdateSelected())) { // mobile_spouse ?>
    <div id="r_mobile_spouse"<?= $Page->mobile_spouse->rowAttributes() ?>>
        <label for="x_mobile_spouse" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_mobile_spouse" id="u_mobile_spouse" class="form-check-input ew-multi-select" value="1"<?= $Page->mobile_spouse->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_mobile_spouse"><?= $Page->mobile_spouse->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_mobile_spouse" id="u_mobile_spouse" value="<?= $Page->mobile_spouse->MultiUpdate ?>">
            <?= $Page->mobile_spouse->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_spouse->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_mobile_spouse">
                <input type="<?= $Page->mobile_spouse->getInputTextType() ?>" name="x_mobile_spouse" id="x_mobile_spouse" data-table="family_info" data-field="x_mobile_spouse" value="<?= $Page->mobile_spouse->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->mobile_spouse->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_spouse->formatPattern()) ?>"<?= $Page->mobile_spouse->editAttributes() ?> aria-describedby="x_mobile_spouse_help">
                <?= $Page->mobile_spouse->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->mobile_spouse->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_mobile_spouse">
                <span<?= $Page->mobile_spouse->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->mobile_spouse->getDisplayValue($Page->mobile_spouse->ViewValue))) ?>"></span>
                <input type="hidden" data-table="family_info" data-field="x_mobile_spouse" data-hidden="1" name="x_mobile_spouse" id="x_mobile_spouse" value="<?= HtmlEncode($Page->mobile_spouse->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible && (!$Page->isConfirm() || $Page->category->multiUpdateSelected())) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_category" id="u_category" class="form-check-input ew-multi-select" value="1"<?= $Page->category->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_category"><?= $Page->category->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_category" id="u_category" value="<?= $Page->category->MultiUpdate ?>">
            <?= $Page->category->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_category">
                <template id="tp_x_category">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_category" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_category[]"
                    name="x_category[]"
                    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
                    data-type="select-multiple"
                    data-template="tp_x_category"
                    data-target="dsl_x_category"
                    data-repeatcolumn="3"
                    class="form-control<?= $Page->category->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x_category"
                    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
                    <?= $Page->category->editAttributes() ?>></selection-list>
                <?= $Page->category->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
                <?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_category">
                <span<?= $Page->category->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->category->getDisplayValue($Page->category->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_category" data-hidden="1" name="x_category" id="x_category" value="<?= HtmlEncode($Page->category->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event->Visible && (!$Page->isConfirm() || $Page->event->multiUpdateSelected())) { // event ?>
    <div id="r_event"<?= $Page->event->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_event" id="u_event" class="form-check-input ew-multi-select" value="1"<?= $Page->event->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_event"><?= $Page->event->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_event" id="u_event" value="<?= $Page->event->MultiUpdate ?>">
            <?= $Page->event->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_event">
                <template id="tp_x_event">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_event" name="x_event" id="x_event"<?= $Page->event->editAttributes() ?>>
                        <label class="form-check-label"></label>
                    </div>
                </template>
                <div id="dsl_x_event" class="ew-item-list"></div>
                <selection-list hidden
                    id="x_event[]"
                    name="x_event[]"
                    value="<?= HtmlEncode($Page->event->CurrentValue) ?>"
                    data-type="select-multiple"
                    data-template="tp_x_event"
                    data-target="dsl_x_event"
                    data-repeatcolumn="3"
                    class="form-control<?= $Page->event->isInvalidClass() ?>"
                    data-table="family_info"
                    data-field="x_event"
                    data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
                    <?= $Page->event->editAttributes() ?>></selection-list>
                <?= $Page->event->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->event->getErrorMessage() ?></div>
                <?= $Page->event->Lookup->getParamTag($Page, "p_x_event") ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_event">
                <span<?= $Page->event->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->event->getDisplayValue($Page->event->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_event" data-hidden="1" name="x_event" id="x_event" value="<?= HtmlEncode($Page->event->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible && (!$Page->isConfirm() || $Page->country->multiUpdateSelected())) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_country" id="u_country" class="form-check-input ew-multi-select" value="1"<?= $Page->country->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_country"><?= $Page->country->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_country" id="u_country" value="<?= $Page->country->MultiUpdate ?>">
            <?= $Page->country->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->country->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_country">
                <?php
                if (IsRTL()) {
                    $Page->country->EditAttrs["dir"] = "rtl";
                }
                ?>
                <span id="as_x_country" class="ew-auto-suggest">
                    <input type="<?= $Page->country->getInputTextType() ?>" class="form-control" name="sv_x_country" id="sv_x_country" value="<?= RemoveHtml($Page->country->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->country->formatPattern()) ?>"<?= $Page->country->editAttributes() ?> aria-describedby="x_country_help">
                </span>
                <selection-list hidden class="form-control" data-table="family_info" data-field="x_country" data-input="sv_x_country" data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>" name="x_country" id="x_country" value="<?= HtmlEncode($Page->country->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
                <?= $Page->country->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
                <script>
                loadjs.ready("ffamily_infoupdate", function() {
                    ffamily_infoupdate.createAutoSuggest(Object.assign({"id":"x_country","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->country->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.country.autoSuggestOptions));
                });
                </script>
                <?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_country">
                <span<?= $Page->country->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->country->getDisplayValue($Page->country->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_country" data-hidden="1" name="x_country" id="x_country" value="<?= HtmlEncode($Page->country->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->state->Visible && (!$Page->isConfirm() || $Page->state->multiUpdateSelected())) { // state ?>
    <div id="r_state"<?= $Page->state->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_state" id="u_state" class="form-check-input ew-multi-select" value="1"<?= $Page->state->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_state"><?= $Page->state->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_state" id="u_state" value="<?= $Page->state->MultiUpdate ?>">
            <?= $Page->state->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->state->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_state">
                <?php
                if (IsRTL()) {
                    $Page->state->EditAttrs["dir"] = "rtl";
                }
                ?>
                <span id="as_x_state" class="ew-auto-suggest">
                    <input type="<?= $Page->state->getInputTextType() ?>" class="form-control" name="sv_x_state" id="sv_x_state" value="<?= RemoveHtml($Page->state->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->state->formatPattern()) ?>"<?= $Page->state->editAttributes() ?> aria-describedby="x_state_help">
                </span>
                <selection-list hidden class="form-control" data-table="family_info" data-field="x_state" data-input="sv_x_state" data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>" name="x_state" id="x_state" value="<?= HtmlEncode($Page->state->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
                <?= $Page->state->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->state->getErrorMessage() ?></div>
                <script>
                loadjs.ready("ffamily_infoupdate", function() {
                    ffamily_infoupdate.createAutoSuggest(Object.assign({"id":"x_state","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->state->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.state.autoSuggestOptions));
                });
                </script>
                <?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_state">
                <span<?= $Page->state->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->state->getDisplayValue($Page->state->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_state" data-hidden="1" name="x_state" id="x_state" value="<?= HtmlEncode($Page->state->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_india->Visible && (!$Page->isConfirm() || $Page->city_india->multiUpdateSelected())) { // city_india ?>
    <div id="r_city_india"<?= $Page->city_india->rowAttributes() ?>>
        <label for="x_city_india" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_city_india" id="u_city_india" class="form-check-input ew-multi-select" value="1"<?= $Page->city_india->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_city_india"><?= $Page->city_india->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_city_india" id="u_city_india" value="<?= $Page->city_india->MultiUpdate ?>">
            <?= $Page->city_india->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_india->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_city_india">
                    <select
                        id="x_city_india"
                        name="x_city_india"
                        class="form-control ew-select<?= $Page->city_india->isInvalidClass() ?>"
                        data-select2-id="ffamily_infoupdate_x_city_india"
                        data-table="family_info"
                        data-field="x_city_india"
                        data-caption="<?= HtmlEncode(RemoveHtml($Page->city_india->caption())) ?>"
                        data-modal-lookup="true"
                        data-value-separator="<?= $Page->city_india->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->city_india->getPlaceHolder()) ?>"
                        <?= $Page->city_india->editAttributes() ?>>
                        <?= $Page->city_india->selectOptionListHtml("x_city_india") ?>
                    </select>
                    <?= $Page->city_india->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->city_india->getErrorMessage() ?></div>
                <?= $Page->city_india->Lookup->getParamTag($Page, "p_x_city_india") ?>
                <script>
                loadjs.ready("ffamily_infoupdate", function() {
                    var options = { name: "x_city_india", selectId: "ffamily_infoupdate_x_city_india" };
                    if (ffamily_infoupdate.lists.city_india?.lookupOptions.length) {
                        options.data = { id: "x_city_india", form: "ffamily_infoupdate" };
                    } else {
                        options.ajax = { id: "x_city_india", form: "ffamily_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.city_india.modalLookupOptions);
                    ew.createModalLookup(options);
                });
                </script>
                </span>
                <?php } else { ?>
                <span id="el_family_info_city_india">
                <span<?= $Page->city_india->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->city_india->getDisplayValue($Page->city_india->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_city_india" data-hidden="1" name="x_city_india" id="x_city_india" value="<?= HtmlEncode($Page->city_india->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible && (!$Page->isConfirm() || $Page->city->multiUpdateSelected())) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label for="x_city" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_city" id="u_city" class="form-check-input ew-multi-select" value="1"<?= $Page->city->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_city"><?= $Page->city->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_city" id="u_city" value="<?= $Page->city->MultiUpdate ?>">
            <?= $Page->city->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_city">
                    <select
                        id="x_city"
                        name="x_city"
                        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
                        data-select2-id="ffamily_infoupdate_x_city"
                        data-table="family_info"
                        data-field="x_city"
                        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
                        data-modal-lookup="true"
                        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
                        <?= $Page->city->editAttributes() ?>>
                        <?= $Page->city->selectOptionListHtml("x_city") ?>
                    </select>
                    <?= $Page->city->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
                <?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
                <script>
                loadjs.ready("ffamily_infoupdate", function() {
                    var options = { name: "x_city", selectId: "ffamily_infoupdate_x_city" };
                    if (ffamily_infoupdate.lists.city?.lookupOptions.length) {
                        options.data = { id: "x_city", form: "ffamily_infoupdate" };
                    } else {
                        options.ajax = { id: "x_city", form: "ffamily_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.city.modalLookupOptions);
                    ew.createModalLookup(options);
                });
                </script>
                </span>
                <?php } else { ?>
                <span id="el_family_info_city">
                <span<?= $Page->city->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->city->getDisplayValue($Page->city->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_city" data-hidden="1" name="x_city" id="x_city" value="<?= HtmlEncode($Page->city->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible && (!$Page->isConfirm() || $Page->status->multiUpdateSelected())) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?= $Page->status->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_status"><?= $Page->status->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_status" id="u_status" value="<?= $Page->status->MultiUpdate ?>">
            <?= $Page->status->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_status">
                    <select
                        id="x_status"
                        name="x_status"
                        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
                        <?php if (!$Page->status->IsNativeSelect) { ?>
                        data-select2-id="ffamily_infoupdate_x_status"
                        <?php } ?>
                        data-table="family_info"
                        data-field="x_status"
                        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
                        <?= $Page->status->editAttributes() ?>>
                        <?= $Page->status->selectOptionListHtml("x_status") ?>
                    </select>
                    <?= $Page->status->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
                <?php if (!$Page->status->IsNativeSelect) { ?>
                <script>
                loadjs.ready("ffamily_infoupdate", function() {
                    var options = { name: "x_status", selectId: "ffamily_infoupdate_x_status" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (ffamily_infoupdate.lists.status?.lookupOptions.length) {
                        options.data = { id: "x_status", form: "ffamily_infoupdate" };
                    } else {
                        options.ajax = { id: "x_status", form: "ffamily_infoupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_info.fields.status.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_family_info_status">
                <span<?= $Page->status->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->status->getDisplayValue($Page->status->ViewValue) ?></span></span>
                <input type="hidden" data-table="family_info" data-field="x_status" data-hidden="1" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sort_order->Visible && (!$Page->isConfirm() || $Page->sort_order->multiUpdateSelected())) { // sort_order ?>
    <div id="r_sort_order"<?= $Page->sort_order->rowAttributes() ?>>
        <label for="x_sort_order" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_sort_order" id="u_sort_order" class="form-check-input ew-multi-select" value="1"<?= $Page->sort_order->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_sort_order"><?= $Page->sort_order->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_sort_order" id="u_sort_order" value="<?= $Page->sort_order->MultiUpdate ?>">
            <?= $Page->sort_order->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sort_order->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_family_info_sort_order">
                <input type="<?= $Page->sort_order->getInputTextType() ?>" name="x_sort_order" id="x_sort_order" data-table="family_info" data-field="x_sort_order" value="<?= $Page->sort_order->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sort_order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sort_order->formatPattern()) ?>"<?= $Page->sort_order->editAttributes() ?> aria-describedby="x_sort_order_help">
                <?= $Page->sort_order->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->sort_order->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_family_info_sort_order">
                <span<?= $Page->sort_order->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->sort_order->getDisplayValue($Page->sort_order->ViewValue))) ?>"></span>
                <input type="hidden" data-table="family_info" data-field="x_sort_order" data-hidden="1" name="x_sort_order" id="x_sort_order" value="<?= HtmlEncode($Page->sort_order->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_infoupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_infoupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_infoupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="ffamily_infoupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
