<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffamily_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffamily_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["family_personal", [], fields.family_personal.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["lifecycle", [], fields.lifecycle.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["_title", [], fields._title.isInvalid],
            ["marital_status", [], fields.marital_status.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["mobile", [ew.Validators.integer], fields.mobile.isInvalid],
            ["spouse_name", [], fields.spouse_name.isInvalid],
            ["mobile_spouse", [], fields.mobile_spouse.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["event", [], fields.event.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["country", [ew.Validators.integer], fields.country.isInvalid],
            ["state", [ew.Validators.integer], fields.state.isInvalid],
            ["city_india", [], fields.city_india.isInvalid],
            ["city", [], fields.city.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["work_details", [], fields.work_details.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["sort_order", [ew.Validators.float], fields.sort_order.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "lifecycle": <?= $Page->lifecycle->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "_title": <?= $Page->_title->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "city_india": <?= $Page->city_india->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_infosearch" id="ffamily_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->family_personal->Visible) { // family_personal ?>
    <div id="r_family_personal" class="row"<?= $Page->family_personal->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_family_personal"><?= $Page->family_personal->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_family_personal" id="z_family_personal" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->family_personal->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_family_personal" class="ew-search-field ew-search-field-single">
<template id="tp_x_family_personal">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_family_personal" name="x_family_personal" id="x_family_personal"<?= $Page->family_personal->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_family_personal" class="ew-item-list"></div>
<selection-list hidden
    id="x_family_personal"
    name="x_family_personal"
    value="<?= HtmlEncode($Page->family_personal->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_family_personal"
    data-target="dsl_x_family_personal"
    data-repeatcolumn="1"
    class="form-control<?= $Page->family_personal->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_family_personal"
    data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
    <?= $Page->family_personal->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name" class="row"<?= $Page->father_name->rowAttributes() ?>>
        <label for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_father_name"><?= $Page->father_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_father_name" id="z_father_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->father_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="family_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lifecycle->Visible) { // lifecycle ?>
    <div id="r_lifecycle" class="row"<?= $Page->lifecycle->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_lifecycle"><?= $Page->lifecycle->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lifecycle" id="z_lifecycle" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lifecycle->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_lifecycle" class="ew-search-field ew-search-field-single">
<template id="tp_x_lifecycle">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_lifecycle" name="x_lifecycle" id="x_lifecycle"<?= $Page->lifecycle->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_lifecycle" class="ew-item-list"></div>
<selection-list hidden
    id="x_lifecycle"
    name="x_lifecycle"
    value="<?= HtmlEncode($Page->lifecycle->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_lifecycle"
    data-target="dsl_x_lifecycle"
    data-repeatcolumn="5"
    class="form-control<?= $Page->lifecycle->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_lifecycle"
    data-value-separator="<?= $Page->lifecycle->displayValueSeparatorAttribute() ?>"
    <?= $Page->lifecycle->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->lifecycle->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender" class="row"<?= $Page->gender->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_gender"><?= $Page->gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gender" id="z_gender" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_gender" class="ew-search-field ew-search-field-single">
<template id="tp_x_gender">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_gender" name="x_gender" id="x_gender"<?= $Page->gender->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_gender" class="ew-item-list"></div>
<selection-list hidden
    id="x_gender"
    name="x_gender"
    value="<?= HtmlEncode($Page->gender->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_gender"
    data-target="dsl_x_gender"
    data-repeatcolumn="5"
    class="form-control<?= $Page->gender->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_gender"
    data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
    <?= $Page->gender->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_title->Visible) { // title ?>
    <div id="r__title" class="row"<?= $Page->_title->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info__title"><?= $Page->_title->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__title" id="z__title" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_title->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info__title" class="ew-search-field ew-search-field-single">
<template id="tp_x__title">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x__title" name="x__title" id="x__title"<?= $Page->_title->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x__title" class="ew-item-list"></div>
<selection-list hidden
    id="x__title"
    name="x__title"
    value="<?= HtmlEncode($Page->_title->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x__title"
    data-target="dsl_x__title"
    data-repeatcolumn="5"
    class="form-control<?= $Page->_title->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x__title"
    data-value-separator="<?= $Page->_title->displayValueSeparatorAttribute() ?>"
    <?= $Page->_title->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->_title->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status" class="row"<?= $Page->marital_status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_marital_status"><?= $Page->marital_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_marital_status" id="z_marital_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->marital_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_marital_status" class="ew-search-field ew-search-field-single">
<template id="tp_x_marital_status">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_marital_status" name="x_marital_status" id="x_marital_status"<?= $Page->marital_status->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_marital_status" class="ew-item-list"></div>
<selection-list hidden
    id="x_marital_status"
    name="x_marital_status"
    value="<?= HtmlEncode($Page->marital_status->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_marital_status"
    data-target="dsl_x_marital_status"
    data-repeatcolumn="5"
    class="form-control<?= $Page->marital_status->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_marital_status"
    data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
    <?= $Page->marital_status->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="family_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="family_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->spouse_name->Visible) { // spouse_name ?>
    <div id="r_spouse_name" class="row"<?= $Page->spouse_name->rowAttributes() ?>>
        <label for="x_spouse_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_spouse_name"><?= $Page->spouse_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_spouse_name" id="z_spouse_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->spouse_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_spouse_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->spouse_name->getInputTextType() ?>" name="x_spouse_name" id="x_spouse_name" data-table="family_info" data-field="x_spouse_name" value="<?= $Page->spouse_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_name->formatPattern()) ?>"<?= $Page->spouse_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->spouse_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_spouse->Visible) { // mobile_spouse ?>
    <div id="r_mobile_spouse" class="row"<?= $Page->mobile_spouse->rowAttributes() ?>>
        <label for="x_mobile_spouse" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_mobile_spouse"><?= $Page->mobile_spouse->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_spouse" id="z_mobile_spouse" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_spouse->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_mobile_spouse" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_spouse->getInputTextType() ?>" name="x_mobile_spouse" id="x_mobile_spouse" data-table="family_info" data-field="x_mobile_spouse" value="<?= $Page->mobile_spouse->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->mobile_spouse->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_spouse->formatPattern()) ?>"<?= $Page->mobile_spouse->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_spouse->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="family_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_category" class="ew-search-field ew-search-field-single">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event->Visible) { // event ?>
    <div id="r_event" class="row"<?= $Page->event->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_event"><?= $Page->event->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event" id="z_event" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_event" class="ew-search-field ew-search-field-single">
<template id="tp_x_event">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_event" name="x_event" id="x_event"<?= $Page->event->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_event" class="ew-item-list"></div>
<selection-list hidden
    id="x_event[]"
    name="x_event[]"
    value="<?= HtmlEncode($Page->event->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_event"
    data-target="dsl_x_event"
    data-repeatcolumn="3"
    class="form-control<?= $Page->event->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_event"
    data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
    <?= $Page->event->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->event->getErrorMessage(false) ?></div>
<?= $Page->event->Lookup->getParamTag($Page, "p_x_event") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob" class="row"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_dob"><?= $Page->dob->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dob" id="z_dob" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="family_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infosearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom" class="row"<?= $Page->dom->rowAttributes() ?>>
        <label for="x_dom" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_dom"><?= $Page->dom->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dom" id="z_dom" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dom->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_dom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="family_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage(false) ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infosearch", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="family_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country" class="row"<?= $Page->country->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_country"><?= $Page->country->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_country" id="z_country" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->country->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_country" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->country->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_country" class="ew-auto-suggest">
    <input type="<?= $Page->country->getInputTextType() ?>" class="form-control" name="sv_x_country" id="sv_x_country" value="<?= RemoveHtml($Page->country->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->country->formatPattern()) ?>"<?= $Page->country->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="family_info" data-field="x_country" data-input="sv_x_country" data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>" name="x_country" id="x_country" value="<?= HtmlEncode($Page->country->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->country->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffamily_infosearch", function() {
    ffamily_infosearch.createAutoSuggest(Object.assign({"id":"x_country","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->country->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.country.autoSuggestOptions));
});
</script>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->state->Visible) { // state ?>
    <div id="r_state" class="row"<?= $Page->state->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_state"><?= $Page->state->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_state" id="z_state" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->state->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_state" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->state->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_state" class="ew-auto-suggest">
    <input type="<?= $Page->state->getInputTextType() ?>" class="form-control" name="sv_x_state" id="sv_x_state" value="<?= RemoveHtml($Page->state->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->state->formatPattern()) ?>"<?= $Page->state->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="family_info" data-field="x_state" data-input="sv_x_state" data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>" name="x_state" id="x_state" value="<?= HtmlEncode($Page->state->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->state->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffamily_infosearch", function() {
    ffamily_infosearch.createAutoSuggest(Object.assign({"id":"x_state","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->state->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.state.autoSuggestOptions));
});
</script>
<?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_india->Visible) { // city_india ?>
    <div id="r_city_india" class="row"<?= $Page->city_india->rowAttributes() ?>>
        <label for="x_city_india" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_city_india"><?= $Page->city_india->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_city_india" id="z_city_india" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_india->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_city_india" class="ew-search-field ew-search-field-single">
    <select
        id="x_city_india"
        name="x_city_india"
        class="form-control ew-select<?= $Page->city_india->isInvalidClass() ?>"
        data-select2-id="ffamily_infosearch_x_city_india"
        data-table="family_info"
        data-field="x_city_india"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city_india->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city_india->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city_india->getPlaceHolder()) ?>"
        <?= $Page->city_india->editAttributes() ?>>
        <?= $Page->city_india->selectOptionListHtml("x_city_india") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city_india->getErrorMessage(false) ?></div>
<?= $Page->city_india->Lookup->getParamTag($Page, "p_x_city_india") ?>
<script>
loadjs.ready("ffamily_infosearch", function() {
    var options = { name: "x_city_india", selectId: "ffamily_infosearch_x_city_india" };
    if (ffamily_infosearch.lists.city_india?.lookupOptions.length) {
        options.data = { id: "x_city_india", form: "ffamily_infosearch" };
    } else {
        options.ajax = { id: "x_city_india", form: "ffamily_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.city_india.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city" class="row"<?= $Page->city->rowAttributes() ?>>
        <label for="x_city" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_city"><?= $Page->city->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_city" id="z_city" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_city" class="ew-search-field ew-search-field-single">
    <select
        id="x_city"
        name="x_city"
        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
        data-select2-id="ffamily_infosearch_x_city"
        data-table="family_info"
        data-field="x_city"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<script>
loadjs.ready("ffamily_infosearch", function() {
    var options = { name: "x_city", selectId: "ffamily_infosearch_x_city" };
    if (ffamily_infosearch.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "ffamily_infosearch" };
    } else {
        options.ajax = { id: "x_city", form: "ffamily_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.city.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name" class="row"<?= $Page->city_name->rowAttributes() ?>>
        <label for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_city_name"><?= $Page->city_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_city_name" id="z_city_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_city_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="family_info" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="family_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
    <div id="r_work_details" class="row"<?= $Page->work_details->rowAttributes() ?>>
        <label for="x_work_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_work_details"><?= $Page->work_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_work_details" id="z_work_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->work_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_work_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->work_details->getInputTextType() ?>" name="x_work_details" id="x_work_details" data-table="family_info" data-field="x_work_details" value="<?= $Page->work_details->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->work_details->formatPattern()) ?>"<?= $Page->work_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->work_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="family_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="family_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ffamily_infosearch_x_status"
        <?php } ?>
        data-table="family_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_infosearch", function() {
    var options = { name: "x_status", selectId: "ffamily_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ffamily_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "ffamily_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sort_order->Visible) { // sort_order ?>
    <div id="r_sort_order" class="row"<?= $Page->sort_order->rowAttributes() ?>>
        <label for="x_sort_order" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_info_sort_order"><?= $Page->sort_order->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sort_order" id="z_sort_order" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sort_order->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_info_sort_order" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sort_order->getInputTextType() ?>" name="x_sort_order" id="x_sort_order" data-table="family_info" data-field="x_sort_order" value="<?= $Page->sort_order->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sort_order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sort_order->formatPattern()) ?>"<?= $Page->sort_order->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sort_order->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ffamily_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
