<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffamily_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffamily_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["family_personal", [], fields.family_personal.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["lifecycle", [], fields.lifecycle.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["_title", [], fields._title.isInvalid],
            ["marital_status", [], fields.marital_status.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["mobile", [ew.Validators.integer], fields.mobile.isInvalid],
            ["spouse_name", [], fields.spouse_name.isInvalid],
            ["mobile_spouse", [], fields.mobile_spouse.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["event", [], fields.event.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["country", [ew.Validators.integer], fields.country.isInvalid],
            ["state", [ew.Validators.integer], fields.state.isInvalid],
            ["city_india", [], fields.city_india.isInvalid],
            ["city", [], fields.city.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["work_details", [], fields.work_details.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["sort_order", [ew.Validators.float], fields.sort_order.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "lifecycle": <?= $Page->lifecycle->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "_title": <?= $Page->_title->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "city_india": <?= $Page->city_india->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_infosearch" id="ffamily_infosearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("familyinfolist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_family_info_family_personal" class="family_infosearch"><span id="el_family_info_family_personal" class="ew-search-field ew-search-field-single">
<template id="tp_x_family_personal">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_family_personal" name="x_family_personal" id="x_family_personal"<?= $Page->family_personal->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_family_personal" class="ew-item-list"></div>
<selection-list hidden
    id="x_family_personal"
    name="x_family_personal"
    value="<?= HtmlEncode($Page->family_personal->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_family_personal"
    data-target="dsl_x_family_personal"
    data-repeatcolumn="1"
    class="form-control<?= $Page->family_personal->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_family_personal"
    data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
    <?= $Page->family_personal->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_father_name" class="family_infosearch"><span id="el_family_info_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="family_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_lifecycle" class="family_infosearch"><span id="el_family_info_lifecycle" class="ew-search-field ew-search-field-single">
<template id="tp_x_lifecycle">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_lifecycle" name="x_lifecycle" id="x_lifecycle"<?= $Page->lifecycle->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_lifecycle" class="ew-item-list"></div>
<selection-list hidden
    id="x_lifecycle"
    name="x_lifecycle"
    value="<?= HtmlEncode($Page->lifecycle->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_lifecycle"
    data-target="dsl_x_lifecycle"
    data-repeatcolumn="5"
    class="form-control<?= $Page->lifecycle->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_lifecycle"
    data-value-separator="<?= $Page->lifecycle->displayValueSeparatorAttribute() ?>"
    <?= $Page->lifecycle->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->lifecycle->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_gender" class="family_infosearch"><span id="el_family_info_gender" class="ew-search-field ew-search-field-single">
<template id="tp_x_gender">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_gender" name="x_gender" id="x_gender"<?= $Page->gender->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_gender" class="ew-item-list"></div>
<selection-list hidden
    id="x_gender"
    name="x_gender"
    value="<?= HtmlEncode($Page->gender->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_gender"
    data-target="dsl_x_gender"
    data-repeatcolumn="5"
    class="form-control<?= $Page->gender->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_gender"
    data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
    <?= $Page->gender->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info__title" class="family_infosearch"><span id="el_family_info__title" class="ew-search-field ew-search-field-single">
<template id="tp_x__title">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x__title" name="x__title" id="x__title"<?= $Page->_title->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x__title" class="ew-item-list"></div>
<selection-list hidden
    id="x__title"
    name="x__title"
    value="<?= HtmlEncode($Page->_title->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x__title"
    data-target="dsl_x__title"
    data-repeatcolumn="5"
    class="form-control<?= $Page->_title->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x__title"
    data-value-separator="<?= $Page->_title->displayValueSeparatorAttribute() ?>"
    <?= $Page->_title->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->_title->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_marital_status" class="family_infosearch"><span id="el_family_info_marital_status" class="ew-search-field ew-search-field-single">
<template id="tp_x_marital_status">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_marital_status" name="x_marital_status" id="x_marital_status"<?= $Page->marital_status->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_marital_status" class="ew-item-list"></div>
<selection-list hidden
    id="x_marital_status"
    name="x_marital_status"
    value="<?= HtmlEncode($Page->marital_status->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_marital_status"
    data-target="dsl_x_marital_status"
    data-repeatcolumn="5"
    class="form-control<?= $Page->marital_status->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_marital_status"
    data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
    <?= $Page->marital_status->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_name" class="family_infosearch"><span id="el_family_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="family_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_mobile" class="family_infosearch"><span id="el_family_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="family_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_spouse_name" class="family_infosearch"><span id="el_family_info_spouse_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->spouse_name->getInputTextType() ?>" name="x_spouse_name" id="x_spouse_name" data-table="family_info" data-field="x_spouse_name" value="<?= $Page->spouse_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_name->formatPattern()) ?>"<?= $Page->spouse_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->spouse_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_mobile_spouse" class="family_infosearch"><span id="el_family_info_mobile_spouse" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_spouse->getInputTextType() ?>" name="x_mobile_spouse" id="x_mobile_spouse" data-table="family_info" data-field="x_mobile_spouse" value="<?= $Page->mobile_spouse->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->mobile_spouse->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_spouse->formatPattern()) ?>"<?= $Page->mobile_spouse->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_spouse->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info__email" class="family_infosearch"><span id="el_family_info__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="family_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_category" class="family_infosearch"><span id="el_family_info_category" class="ew-search-field ew-search-field-single">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span></template>
<template id="tpx_family_info_event" class="family_infosearch"><span id="el_family_info_event" class="ew-search-field ew-search-field-single">
<template id="tp_x_event">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_event" name="x_event" id="x_event"<?= $Page->event->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_event" class="ew-item-list"></div>
<selection-list hidden
    id="x_event[]"
    name="x_event[]"
    value="<?= HtmlEncode($Page->event->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_event"
    data-target="dsl_x_event"
    data-repeatcolumn="3"
    class="form-control<?= $Page->event->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_event"
    data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
    <?= $Page->event->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->event->getErrorMessage(false) ?></div>
<?= $Page->event->Lookup->getParamTag($Page, "p_x_event") ?>
</span></template>
<template id="tpx_family_info_dob" class="family_infosearch"><span id="el_family_info_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="family_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infosearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_family_info_dom" class="family_infosearch"><span id="el_family_info_dom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="family_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage(false) ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infosearch", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_family_info_address" class="family_infosearch"><span id="el_family_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="family_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_country" class="family_infosearch"><span id="el_family_info_country" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->country->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_country" class="ew-auto-suggest">
    <input type="<?= $Page->country->getInputTextType() ?>" class="form-control" name="sv_x_country" id="sv_x_country" value="<?= RemoveHtml($Page->country->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->country->formatPattern()) ?>"<?= $Page->country->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="family_info" data-field="x_country" data-input="sv_x_country" data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>" name="x_country" id="x_country" value="<?= HtmlEncode($Page->country->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->country->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffamily_infosearch", function() {
    ffamily_infosearch.createAutoSuggest(Object.assign({"id":"x_country","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->country->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.country.autoSuggestOptions));
});
</script>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
</span></template>
<template id="tpx_family_info_state" class="family_infosearch"><span id="el_family_info_state" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->state->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_state" class="ew-auto-suggest">
    <input type="<?= $Page->state->getInputTextType() ?>" class="form-control" name="sv_x_state" id="sv_x_state" value="<?= RemoveHtml($Page->state->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->state->formatPattern()) ?>"<?= $Page->state->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="family_info" data-field="x_state" data-input="sv_x_state" data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>" name="x_state" id="x_state" value="<?= HtmlEncode($Page->state->AdvancedSearch->SearchValue) ?>" data-ew-action="update-options"></selection-list>
<div class="invalid-feedback"><?= $Page->state->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffamily_infosearch", function() {
    ffamily_infosearch.createAutoSuggest(Object.assign({"id":"x_state","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->state->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.state.autoSuggestOptions));
});
</script>
<?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
</span></template>
<template id="tpx_family_info_city_india" class="family_infosearch"><span id="el_family_info_city_india" class="ew-search-field ew-search-field-single">
    <select
        id="x_city_india"
        name="x_city_india"
        class="form-control ew-select<?= $Page->city_india->isInvalidClass() ?>"
        data-select2-id="ffamily_infosearch_x_city_india"
        data-table="family_info"
        data-field="x_city_india"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city_india->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city_india->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city_india->getPlaceHolder()) ?>"
        <?= $Page->city_india->editAttributes() ?>>
        <?= $Page->city_india->selectOptionListHtml("x_city_india") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city_india->getErrorMessage(false) ?></div>
<?= $Page->city_india->Lookup->getParamTag($Page, "p_x_city_india") ?>
<script>
loadjs.ready("ffamily_infosearch", function() {
    var options = { name: "x_city_india", selectId: "ffamily_infosearch_x_city_india" };
    if (ffamily_infosearch.lists.city_india?.lookupOptions.length) {
        options.data = { id: "x_city_india", form: "ffamily_infosearch" };
    } else {
        options.ajax = { id: "x_city_india", form: "ffamily_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.city_india.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_family_info_city" class="family_infosearch"><span id="el_family_info_city" class="ew-search-field ew-search-field-single">
    <select
        id="x_city"
        name="x_city"
        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
        data-select2-id="ffamily_infosearch_x_city"
        data-table="family_info"
        data-field="x_city"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<script>
loadjs.ready("ffamily_infosearch", function() {
    var options = { name: "x_city", selectId: "ffamily_infosearch_x_city" };
    if (ffamily_infosearch.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "ffamily_infosearch" };
    } else {
        options.ajax = { id: "x_city", form: "ffamily_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.city.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_family_info_city_name" class="family_infosearch"><span id="el_family_info_city_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="family_info" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_image" class="family_infosearch"><span id="el_family_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="family_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_work_details" class="family_infosearch"><span id="el_family_info_work_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->work_details->getInputTextType() ?>" name="x_work_details" id="x_work_details" data-table="family_info" data-field="x_work_details" value="<?= $Page->work_details->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->work_details->formatPattern()) ?>"<?= $Page->work_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->work_details->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_operator" class="family_infosearch"><span id="el_family_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="family_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_info_datetime" class="family_infosearch"><span id="el_family_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="family_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_family_info_status" class="family_infosearch"><span id="el_family_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ffamily_infosearch_x_status"
        <?php } ?>
        data-table="family_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_infosearch", function() {
    var options = { name: "x_status", selectId: "ffamily_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ffamily_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "ffamily_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_family_info_sort_order" class="family_infosearch"><span id="el_family_info_sort_order" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sort_order->getInputTextType() ?>" name="x_sort_order" id="x_sort_order" data-table="family_info" data-field="x_sort_order" value="<?= $Page->sort_order->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sort_order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sort_order->formatPattern()) ?>"<?= $Page->sort_order->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sort_order->getErrorMessage(false) ?></div>
</span></template>
<div id="family_info_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "family_personal",
                type: "integer",
                label: currentTable.fields.family_personal.caption,
                operators: currentTable.fields.family_personal.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.family_personal.validators),
                data: {
                    format: currentTable.fields.family_personal.clientFormatPattern
                }
            },
            {
                id: "father_name",
                type: "string",
                label: currentTable.fields.father_name.caption,
                operators: currentTable.fields.father_name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.father_name.validators),
                data: {
                    format: currentTable.fields.father_name.clientFormatPattern
                }
            },
            {
                id: "lifecycle",
                type: "string",
                label: currentTable.fields.lifecycle.caption,
                operators: currentTable.fields.lifecycle.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.lifecycle.validators),
                data: {
                    format: currentTable.fields.lifecycle.clientFormatPattern
                }
            },
            {
                id: "gender",
                type: "string",
                label: currentTable.fields.gender.caption,
                operators: currentTable.fields.gender.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.gender.validators),
                data: {
                    format: currentTable.fields.gender.clientFormatPattern
                }
            },
            {
                id: "_title",
                type: "string",
                label: currentTable.fields._title.caption,
                operators: currentTable.fields._title.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields._title.validators),
                data: {
                    format: currentTable.fields._title.clientFormatPattern
                }
            },
            {
                id: "marital_status",
                type: "string",
                label: currentTable.fields.marital_status.caption,
                operators: currentTable.fields.marital_status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.marital_status.validators),
                data: {
                    format: currentTable.fields.marital_status.clientFormatPattern
                }
            },
            {
                id: "name",
                type: "string",
                label: currentTable.fields.name.caption,
                operators: currentTable.fields.name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.name.validators),
                data: {
                    format: currentTable.fields.name.clientFormatPattern
                }
            },
            {
                id: "mobile",
                type: "integer",
                label: currentTable.fields.mobile.caption,
                operators: currentTable.fields.mobile.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.mobile.validators),
                data: {
                    format: currentTable.fields.mobile.clientFormatPattern
                }
            },
            {
                id: "spouse_name",
                type: "string",
                label: currentTable.fields.spouse_name.caption,
                operators: currentTable.fields.spouse_name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.spouse_name.validators),
                data: {
                    format: currentTable.fields.spouse_name.clientFormatPattern
                }
            },
            {
                id: "mobile_spouse",
                type: "string",
                label: currentTable.fields.mobile_spouse.caption,
                operators: currentTable.fields.mobile_spouse.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.mobile_spouse.validators),
                data: {
                    format: currentTable.fields.mobile_spouse.clientFormatPattern
                }
            },
            {
                id: "_email",
                type: "string",
                label: currentTable.fields._email.caption,
                operators: currentTable.fields._email.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields._email.validators),
                data: {
                    format: currentTable.fields._email.clientFormatPattern
                }
            },
            {
                id: "category",
                type: "string",
                label: currentTable.fields.category.caption,
                operators: currentTable.fields.category.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.category.validators),
                data: {
                    format: currentTable.fields.category.clientFormatPattern
                }
            },
            {
                id: "event",
                type: "string",
                label: currentTable.fields.event.caption,
                operators: currentTable.fields.event.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.event.validators),
                data: {
                    format: currentTable.fields.event.clientFormatPattern
                }
            },
            {
                id: "dob",
                type: "datetime",
                label: currentTable.fields.dob.caption,
                operators: currentTable.fields.dob.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.dob.validators),
                data: {
                    format: currentTable.fields.dob.clientFormatPattern
                }
            },
            {
                id: "dom",
                type: "datetime",
                label: currentTable.fields.dom.caption,
                operators: currentTable.fields.dom.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.dom.validators),
                data: {
                    format: currentTable.fields.dom.clientFormatPattern
                }
            },
            {
                id: "address",
                type: "string",
                label: currentTable.fields.address.caption,
                operators: currentTable.fields.address.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.address.validators),
                data: {
                    format: currentTable.fields.address.clientFormatPattern
                }
            },
            {
                id: "country",
                type: "integer",
                label: currentTable.fields.country.caption,
                operators: currentTable.fields.country.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.country.validators),
                data: {
                    format: currentTable.fields.country.clientFormatPattern
                }
            },
            {
                id: "state",
                type: "integer",
                label: currentTable.fields.state.caption,
                operators: currentTable.fields.state.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.state.validators),
                data: {
                    format: currentTable.fields.state.clientFormatPattern
                }
            },
            {
                id: "city_india",
                type: "integer",
                label: currentTable.fields.city_india.caption,
                operators: currentTable.fields.city_india.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.city_india.validators),
                data: {
                    format: currentTable.fields.city_india.clientFormatPattern
                }
            },
            {
                id: "city",
                type: "integer",
                label: currentTable.fields.city.caption,
                operators: currentTable.fields.city.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.city.validators),
                data: {
                    format: currentTable.fields.city.clientFormatPattern
                }
            },
            {
                id: "city_name",
                type: "string",
                label: currentTable.fields.city_name.caption,
                operators: currentTable.fields.city_name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.city_name.validators),
                data: {
                    format: currentTable.fields.city_name.clientFormatPattern
                }
            },
            {
                id: "image",
                type: "string",
                label: currentTable.fields.image.caption,
                operators: currentTable.fields.image.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.image.validators),
                data: {
                    format: currentTable.fields.image.clientFormatPattern
                }
            },
            {
                id: "work_details",
                type: "string",
                label: currentTable.fields.work_details.caption,
                operators: currentTable.fields.work_details.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.work_details.validators),
                data: {
                    format: currentTable.fields.work_details.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "sort_order",
                type: "double",
                label: currentTable.fields.sort_order.caption,
                operators: currentTable.fields.sort_order.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_infosearch.fields.sort_order.validators),
                data: {
                    format: currentTable.fields.sort_order.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#family_info_query_builder"),
        args = {},
        rules = ew.parseJson($("#ffamily_infosearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#ffamily_infosearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="ffamily_infosearch" formaction="<?= HtmlEncode(GetUrl("familyinfolist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="ffamily_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
