<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "father_name": <?= $Page->father_name->toClientList($Page) ?>,
            "lifecycle": <?= $Page->lifecycle->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "_title": <?= $Page->_title->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "spouse_name": <?= $Page->spouse_name->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
            "city_name": <?= $Page->city_name->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffamily_infosrch" id="ffamily_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ffamily_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info: currentTable } });
var currentForm;
var ffamily_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffamily_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "father_name": <?= $Page->father_name->toClientList($Page) ?>,
            "lifecycle": <?= $Page->lifecycle->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "_title": <?= $Page->_title->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "spouse_name": <?= $Page->spouse_name->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
            "city_name": <?= $Page->city_name->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->family_personal->Visible) { // family_personal ?>
<?php
if (!$Page->family_personal->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_family_personal" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->family_personal->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_family_personal"
            name="x_family_personal[]"
            class="form-control ew-select<?= $Page->family_personal->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_family_personal"
            data-table="family_info"
            data-field="x_family_personal"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->family_personal->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->family_personal->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->family_personal->editAttributes() ?>>
            <?= $Page->family_personal->selectOptionListHtml("x_family_personal", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_family_personal",
                selectId: "ffamily_infosrch_x_family_personal",
                ajax: { id: "x_family_personal", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.family_personal.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
<?php
if (!$Page->father_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_father_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->father_name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_father_name"
            name="x_father_name[]"
            class="form-control ew-select<?= $Page->father_name->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_father_name"
            data-table="family_info"
            data-field="x_father_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->father_name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->father_name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->father_name->editAttributes() ?>>
            <?= $Page->father_name->selectOptionListHtml("x_father_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_father_name",
                selectId: "ffamily_infosrch_x_father_name",
                ajax: { id: "x_father_name", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.father_name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->lifecycle->Visible) { // lifecycle ?>
<?php
if (!$Page->lifecycle->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_lifecycle" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->lifecycle->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_lifecycle"
            name="x_lifecycle[]"
            class="form-control ew-select<?= $Page->lifecycle->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_lifecycle"
            data-table="family_info"
            data-field="x_lifecycle"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->lifecycle->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->lifecycle->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->lifecycle->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->lifecycle->editAttributes() ?>>
            <?= $Page->lifecycle->selectOptionListHtml("x_lifecycle", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->lifecycle->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_lifecycle",
                selectId: "ffamily_infosrch_x_lifecycle",
                ajax: { id: "x_lifecycle", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.lifecycle.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
<?php
if (!$Page->gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_gender"
            name="x_gender[]"
            class="form-control ew-select<?= $Page->gender->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_gender"
            data-table="family_info"
            data-field="x_gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->gender->editAttributes() ?>>
            <?= $Page->gender->selectOptionListHtml("x_gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_gender",
                selectId: "ffamily_infosrch_x_gender",
                ajax: { id: "x_gender", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_title->Visible) { // title ?>
<?php
if (!$Page->_title->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__title" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_title->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x__title"
            name="x__title[]"
            class="form-control ew-select<?= $Page->_title->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x__title"
            data-table="family_info"
            data-field="x__title"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->_title->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->_title->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->_title->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->_title->editAttributes() ?>>
            <?= $Page->_title->selectOptionListHtml("x__title", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->_title->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x__title",
                selectId: "ffamily_infosrch_x__title",
                ajax: { id: "x__title", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields._title.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
<?php
if (!$Page->name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_name"
            name="x_name[]"
            class="form-control ew-select<?= $Page->name->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_name"
            data-table="family_info"
            data-field="x_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->name->editAttributes() ?>>
            <?= $Page->name->selectOptionListHtml("x_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_name",
                selectId: "ffamily_infosrch_x_name",
                ajax: { id: "x_name", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
<?php
if (!$Page->mobile->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_mobile" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->mobile->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_mobile"
            name="x_mobile[]"
            class="form-control ew-select<?= $Page->mobile->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_mobile"
            data-table="family_info"
            data-field="x_mobile"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->mobile->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->mobile->editAttributes() ?>>
            <?= $Page->mobile->selectOptionListHtml("x_mobile", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_mobile",
                selectId: "ffamily_infosrch_x_mobile",
                ajax: { id: "x_mobile", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.mobile.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->spouse_name->Visible) { // spouse_name ?>
<?php
if (!$Page->spouse_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_spouse_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->spouse_name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_spouse_name"
            name="x_spouse_name[]"
            class="form-control ew-select<?= $Page->spouse_name->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_spouse_name"
            data-table="family_info"
            data-field="x_spouse_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->spouse_name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->spouse_name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->spouse_name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->spouse_name->editAttributes() ?>>
            <?= $Page->spouse_name->selectOptionListHtml("x_spouse_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->spouse_name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_spouse_name",
                selectId: "ffamily_infosrch_x_spouse_name",
                ajax: { id: "x_spouse_name", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.spouse_name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
<?php
if (!$Page->category->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_category" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->category->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_category"
            name="x_category[]"
            class="form-control ew-select<?= $Page->category->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_category"
            data-table="family_info"
            data-field="x_category"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->category->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->category->editAttributes() ?>>
            <?= $Page->category->selectOptionListHtml("x_category", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_category",
                selectId: "ffamily_infosrch_x_category",
                ajax: { id: "x_category", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.category.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->event->Visible) { // event ?>
<?php
if (!$Page->event->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_event" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->event->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_event"
            name="x_event[]"
            class="form-control ew-select<?= $Page->event->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_event"
            data-table="family_info"
            data-field="x_event"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->event->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->event->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->event->editAttributes() ?>>
            <?= $Page->event->selectOptionListHtml("x_event", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->event->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_event",
                selectId: "ffamily_infosrch_x_event",
                ajax: { id: "x_event", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.event.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
<?php
if (!$Page->city_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_city_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->city_name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_city_name"
            name="x_city_name[]"
            class="form-control ew-select<?= $Page->city_name->isInvalidClass() ?>"
            data-select2-id="ffamily_infosrch_x_city_name"
            data-table="family_info"
            data-field="x_city_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->city_name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->city_name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->city_name->editAttributes() ?>>
            <?= $Page->city_name->selectOptionListHtml("x_city_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("ffamily_infosrch", function() {
            var options = {
                name: "x_city_name",
                selectId: "ffamily_infosrch_x_city_name",
                ajax: { id: "x_city_name", form: "ffamily_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_info.fields.city_name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ffamily_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ffamily_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ffamily_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffamily_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffamily_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffamily_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffamily_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_family_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_family_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_family_info_id" class="family_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
        <th data-name="father_name" class="<?= $Page->father_name->headerCellClass() ?>"><div id="elh_family_info_father_name" class="family_info_father_name"><?= $Page->renderFieldHeader($Page->father_name) ?></div></th>
<?php } ?>
<?php if ($Page->lifecycle->Visible) { // lifecycle ?>
        <th data-name="lifecycle" class="<?= $Page->lifecycle->headerCellClass() ?>"><div id="elh_family_info_lifecycle" class="family_info_lifecycle"><?= $Page->renderFieldHeader($Page->lifecycle) ?></div></th>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
        <th data-name="gender" class="<?= $Page->gender->headerCellClass() ?>"><div id="elh_family_info_gender" class="family_info_gender"><?= $Page->renderFieldHeader($Page->gender) ?></div></th>
<?php } ?>
<?php if ($Page->_title->Visible) { // title ?>
        <th data-name="_title" class="<?= $Page->_title->headerCellClass() ?>"><div id="elh_family_info__title" class="family_info__title"><?= $Page->renderFieldHeader($Page->_title) ?></div></th>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Page->name->headerCellClass() ?>"><div id="elh_family_info_name" class="family_info_name"><?= $Page->renderFieldHeader($Page->name) ?></div></th>
<?php } ?>
<?php if ($Page->spouse_name->Visible) { // spouse_name ?>
        <th data-name="spouse_name" class="<?= $Page->spouse_name->headerCellClass() ?>"><div id="elh_family_info_spouse_name" class="family_info_spouse_name"><?= $Page->renderFieldHeader($Page->spouse_name) ?></div></th>
<?php } ?>
<?php if ($Page->mobile_spouse->Visible) { // mobile_spouse ?>
        <th data-name="mobile_spouse" class="<?= $Page->mobile_spouse->headerCellClass() ?>"><div id="elh_family_info_mobile_spouse" class="family_info_mobile_spouse"><?= $Page->renderFieldHeader($Page->mobile_spouse) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_family_info_category" class="family_info_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->event->Visible) { // event ?>
        <th data-name="event" class="<?= $Page->event->headerCellClass() ?>"><div id="elh_family_info_event" class="family_info_event"><?= $Page->renderFieldHeader($Page->event) ?></div></th>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
        <th data-name="city_name" class="<?= $Page->city_name->headerCellClass() ?>"><div id="elh_family_info_city_name" class="family_info_city_name"><?= $Page->renderFieldHeader($Page->city_name) ?></div></th>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
        <th data-name="work_details" class="<?= $Page->work_details->headerCellClass() ?>"><div id="elh_family_info_work_details" class="family_info_work_details"><?= $Page->renderFieldHeader($Page->work_details) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_family_info_status" class="family_info_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->sort_order->Visible) { // sort_order ?>
        <th data-name="sort_order" class="<?= $Page->sort_order->headerCellClass() ?>"><div id="elh_family_info_sort_order" class="family_info_sort_order"><?= $Page->renderFieldHeader($Page->sort_order) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_id" class="el_family_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->father_name->Visible) { // father_name ?>
        <td data-name="father_name"<?= $Page->father_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_father_name" class="el_family_info_father_name">
<span<?= $Page->father_name->viewAttributes() ?>>
<?= $Page->father_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lifecycle->Visible) { // lifecycle ?>
        <td data-name="lifecycle"<?= $Page->lifecycle->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_lifecycle" class="el_family_info_lifecycle">
<span<?= $Page->lifecycle->viewAttributes() ?>>
<?= $Page->lifecycle->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gender->Visible) { // gender ?>
        <td data-name="gender"<?= $Page->gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_gender" class="el_family_info_gender">
<span<?= $Page->gender->viewAttributes() ?>>
<?= $Page->gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_title->Visible) { // title ?>
        <td data-name="_title"<?= $Page->_title->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info__title" class="el_family_info__title">
<span<?= $Page->_title->viewAttributes() ?>>
<?= $Page->_title->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name"<?= $Page->name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_name" class="el_family_info_name">
<span<?= $Page->name->viewAttributes() ?>>
<?= $Page->name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->spouse_name->Visible) { // spouse_name ?>
        <td data-name="spouse_name"<?= $Page->spouse_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_spouse_name" class="el_family_info_spouse_name">
<span<?= $Page->spouse_name->viewAttributes() ?>>
<?= $Page->spouse_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile_spouse->Visible) { // mobile_spouse ?>
        <td data-name="mobile_spouse"<?= $Page->mobile_spouse->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_mobile_spouse" class="el_family_info_mobile_spouse">
<span<?= $Page->mobile_spouse->viewAttributes() ?>>
<?= $Page->mobile_spouse->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_category" class="el_family_info_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event->Visible) { // event ?>
        <td data-name="event"<?= $Page->event->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_event" class="el_family_info_event">
<span<?= $Page->event->viewAttributes() ?>>
<?= $Page->event->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city_name->Visible) { // city_name ?>
        <td data-name="city_name"<?= $Page->city_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_city_name" class="el_family_info_city_name">
<span<?= $Page->city_name->viewAttributes() ?>>
<?= $Page->city_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->work_details->Visible) { // work_details ?>
        <td data-name="work_details"<?= $Page->work_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_work_details" class="el_family_info_work_details">
<span<?= $Page->work_details->viewAttributes() ?>>
<?= $Page->work_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_status" class="el_family_info_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sort_order->Visible) { // sort_order ?>
        <td data-name="sort_order"<?= $Page->sort_order->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_info_sort_order" class="el_family_info_sort_order">
<span<?= $Page->sort_order->viewAttributes() ?>>
<?= $Page->sort_order->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
