<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyInfoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_info: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ffamily_infoadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffamily_infoadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["family_personal", [fields.family_personal.visible && fields.family_personal.required ? ew.Validators.required(fields.family_personal.caption) : null], fields.family_personal.isInvalid],
            ["family_id", [fields.family_id.visible && fields.family_id.required ? ew.Validators.required(fields.family_id.caption) : null], fields.family_id.isInvalid],
            ["lifecycle", [fields.lifecycle.visible && fields.lifecycle.required ? ew.Validators.required(fields.lifecycle.caption) : null], fields.lifecycle.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["_title", [fields._title.visible && fields._title.required ? ew.Validators.required(fields._title.caption) : null], fields._title.isInvalid],
            ["marital_status", [fields.marital_status.visible && fields.marital_status.required ? ew.Validators.required(fields.marital_status.caption) : null], fields.marital_status.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["spouse_name", [fields.spouse_name.visible && fields.spouse_name.required ? ew.Validators.required(fields.spouse_name.caption) : null], fields.spouse_name.isInvalid],
            ["mobile_spouse", [fields.mobile_spouse.visible && fields.mobile_spouse.required ? ew.Validators.required(fields.mobile_spouse.caption) : null], fields.mobile_spouse.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email], fields._email.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["event", [fields.event.visible && fields.event.required ? ew.Validators.required(fields.event.caption) : null], fields.event.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [fields.dom.visible && fields.dom.required ? ew.Validators.required(fields.dom.caption) : null, ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null, ew.Validators.integer], fields.country.isInvalid],
            ["state", [fields.state.visible && fields.state.required ? ew.Validators.required(fields.state.caption) : null, ew.Validators.integer], fields.state.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["work_details", [fields.work_details.visible && fields.work_details.required ? ew.Validators.required(fields.work_details.caption) : null], fields.work_details.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_personal": <?= $Page->family_personal->toClientList($Page) ?>,
            "family_id": <?= $Page->family_id->toClientList($Page) ?>,
            "lifecycle": <?= $Page->lifecycle->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "_title": <?= $Page->_title->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "event": <?= $Page->event->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "state": <?= $Page->state->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_infoadd" id="ffamily_infoadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_family_info_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>></div></div>
    </div>
<?php } ?>
<?php if ($Page->family_personal->Visible) { // family_personal ?>
    <div id="r_family_personal"<?= $Page->family_personal->rowAttributes() ?>>
        <label id="elh_family_info_family_personal" class="<?= $Page->LeftColumnClass ?>"><?= $Page->family_personal->caption() ?><?= $Page->family_personal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->family_personal->cellAttributes() ?>>
<span id="el_family_info_family_personal">
<template id="tp_x_family_personal">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_family_personal" name="x_family_personal" id="x_family_personal"<?= $Page->family_personal->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_family_personal" class="ew-item-list"></div>
<selection-list hidden
    id="x_family_personal"
    name="x_family_personal"
    value="<?= HtmlEncode($Page->family_personal->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_family_personal"
    data-target="dsl_x_family_personal"
    data-repeatcolumn="1"
    class="form-control<?= $Page->family_personal->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_family_personal"
    data-value-separator="<?= $Page->family_personal->displayValueSeparatorAttribute() ?>"
    <?= $Page->family_personal->editAttributes() ?>></selection-list>
<?= $Page->family_personal->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->family_personal->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->family_id->Visible) { // family_id ?>
    <div id="r_family_id"<?= $Page->family_id->rowAttributes() ?>>
        <label id="elh_family_info_family_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->family_id->caption() ?><?= $Page->family_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->family_id->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$Page->userIDAllow("add")) { // Non system admin ?>
<span id="el_family_info_family_id">
    <select
        id="x_family_id"
        name="x_family_id"
        class="form-control ew-select<?= $Page->family_id->isInvalidClass() ?>"
        data-select2-id="ffamily_infoadd_x_family_id"
        data-table="family_info"
        data-field="x_family_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->family_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->family_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->family_id->getPlaceHolder()) ?>"
        <?= $Page->family_id->editAttributes() ?>>
        <?= $Page->family_id->selectOptionListHtml("x_family_id") ?>
    </select>
    <?= $Page->family_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->family_id->getErrorMessage() ?></div>
<?= $Page->family_id->Lookup->getParamTag($Page, "p_x_family_id") ?>
<script>
loadjs.ready("ffamily_infoadd", function() {
    var options = { name: "x_family_id", selectId: "ffamily_infoadd_x_family_id" };
    if (ffamily_infoadd.lists.family_id?.lookupOptions.length) {
        options.data = { id: "x_family_id", form: "ffamily_infoadd" };
    } else {
        options.ajax = { id: "x_family_id", form: "ffamily_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.family_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } else { ?>
<span id="el_family_info_family_id">
    <select
        id="x_family_id"
        name="x_family_id"
        class="form-control ew-select<?= $Page->family_id->isInvalidClass() ?>"
        data-select2-id="ffamily_infoadd_x_family_id"
        data-table="family_info"
        data-field="x_family_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->family_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->family_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->family_id->getPlaceHolder()) ?>"
        <?= $Page->family_id->editAttributes() ?>>
        <?= $Page->family_id->selectOptionListHtml("x_family_id") ?>
    </select>
    <?= $Page->family_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->family_id->getErrorMessage() ?></div>
<?= $Page->family_id->Lookup->getParamTag($Page, "p_x_family_id") ?>
<script>
loadjs.ready("ffamily_infoadd", function() {
    var options = { name: "x_family_id", selectId: "ffamily_infoadd_x_family_id" };
    if (ffamily_infoadd.lists.family_id?.lookupOptions.length) {
        options.data = { id: "x_family_id", form: "ffamily_infoadd" };
    } else {
        options.ajax = { id: "x_family_id", form: "ffamily_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.family_info.fields.family_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lifecycle->Visible) { // lifecycle ?>
    <div id="r_lifecycle"<?= $Page->lifecycle->rowAttributes() ?>>
        <label id="elh_family_info_lifecycle" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lifecycle->caption() ?><?= $Page->lifecycle->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lifecycle->cellAttributes() ?>>
<span id="el_family_info_lifecycle">
<template id="tp_x_lifecycle">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_lifecycle" name="x_lifecycle" id="x_lifecycle"<?= $Page->lifecycle->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_lifecycle" class="ew-item-list"></div>
<selection-list hidden
    id="x_lifecycle"
    name="x_lifecycle"
    value="<?= HtmlEncode($Page->lifecycle->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_lifecycle"
    data-target="dsl_x_lifecycle"
    data-repeatcolumn="5"
    class="form-control<?= $Page->lifecycle->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_lifecycle"
    data-value-separator="<?= $Page->lifecycle->displayValueSeparatorAttribute() ?>"
    <?= $Page->lifecycle->editAttributes() ?>></selection-list>
<?= $Page->lifecycle->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lifecycle->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label id="elh_family_info_gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gender->caption() ?><?= $Page->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gender->cellAttributes() ?>>
<span id="el_family_info_gender">
<template id="tp_x_gender">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_gender" name="x_gender" id="x_gender"<?= $Page->gender->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_gender" class="ew-item-list"></div>
<selection-list hidden
    id="x_gender"
    name="x_gender"
    value="<?= HtmlEncode($Page->gender->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_gender"
    data-target="dsl_x_gender"
    data-repeatcolumn="5"
    class="form-control<?= $Page->gender->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_gender"
    data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
    <?= $Page->gender->editAttributes() ?>></selection-list>
<?= $Page->gender->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_title->Visible) { // title ?>
    <div id="r__title"<?= $Page->_title->rowAttributes() ?>>
        <label id="elh_family_info__title" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_title->caption() ?><?= $Page->_title->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_title->cellAttributes() ?>>
<span id="el_family_info__title">
<template id="tp_x__title">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x__title" name="x__title" id="x__title"<?= $Page->_title->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x__title" class="ew-item-list"></div>
<selection-list hidden
    id="x__title"
    name="x__title"
    value="<?= HtmlEncode($Page->_title->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x__title"
    data-target="dsl_x__title"
    data-repeatcolumn="5"
    class="form-control<?= $Page->_title->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x__title"
    data-value-separator="<?= $Page->_title->displayValueSeparatorAttribute() ?>"
    <?= $Page->_title->editAttributes() ?>></selection-list>
<?= $Page->_title->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_title->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <label id="elh_family_info_marital_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->marital_status->caption() ?><?= $Page->marital_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->marital_status->cellAttributes() ?>>
<span id="el_family_info_marital_status">
<template id="tp_x_marital_status">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="family_info" data-field="x_marital_status" name="x_marital_status" id="x_marital_status"<?= $Page->marital_status->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_marital_status" class="ew-item-list"></div>
<selection-list hidden
    id="x_marital_status"
    name="x_marital_status"
    value="<?= HtmlEncode($Page->marital_status->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_marital_status"
    data-target="dsl_x_marital_status"
    data-repeatcolumn="5"
    class="form-control<?= $Page->marital_status->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_marital_status"
    data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
    <?= $Page->marital_status->editAttributes() ?>></selection-list>
<?= $Page->marital_status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_family_info_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_family_info_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="family_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_family_info_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_family_info_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="family_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->spouse_name->Visible) { // spouse_name ?>
    <div id="r_spouse_name"<?= $Page->spouse_name->rowAttributes() ?>>
        <label id="elh_family_info_spouse_name" for="x_spouse_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->spouse_name->caption() ?><?= $Page->spouse_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->spouse_name->cellAttributes() ?>>
<span id="el_family_info_spouse_name">
<input type="<?= $Page->spouse_name->getInputTextType() ?>" name="x_spouse_name" id="x_spouse_name" data-table="family_info" data-field="x_spouse_name" value="<?= $Page->spouse_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_name->formatPattern()) ?>"<?= $Page->spouse_name->editAttributes() ?> aria-describedby="x_spouse_name_help">
<?= $Page->spouse_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->spouse_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_spouse->Visible) { // mobile_spouse ?>
    <div id="r_mobile_spouse"<?= $Page->mobile_spouse->rowAttributes() ?>>
        <label id="elh_family_info_mobile_spouse" for="x_mobile_spouse" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_spouse->caption() ?><?= $Page->mobile_spouse->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_spouse->cellAttributes() ?>>
<span id="el_family_info_mobile_spouse">
<input type="<?= $Page->mobile_spouse->getInputTextType() ?>" name="x_mobile_spouse" id="x_mobile_spouse" data-table="family_info" data-field="x_mobile_spouse" value="<?= $Page->mobile_spouse->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->mobile_spouse->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_spouse->formatPattern()) ?>"<?= $Page->mobile_spouse->editAttributes() ?> aria-describedby="x_mobile_spouse_help">
<?= $Page->mobile_spouse->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_spouse->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_family_info__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_family_info__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="family_info" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_family_info_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_family_info_category">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_category"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "family_misc") && !$Page->category->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->category->caption() ?>" data-title="<?= $Page->category->caption() ?>" data-ew-action="add-option" data-el="x_category[]" data-url="<?= GetUrl("familymiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->event->Visible) { // event ?>
    <div id="r_event"<?= $Page->event->rowAttributes() ?>>
        <label id="elh_family_info_event" class="<?= $Page->LeftColumnClass ?>"><?= $Page->event->caption() ?><?= $Page->event->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->event->cellAttributes() ?>>
<span id="el_family_info_event">
<template id="tp_x_event">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="family_info" data-field="x_event" name="x_event" id="x_event"<?= $Page->event->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_event" class="ew-item-list"></div>
<selection-list hidden
    id="x_event[]"
    name="x_event[]"
    value="<?= HtmlEncode($Page->event->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_event"
    data-target="dsl_x_event"
    data-repeatcolumn="3"
    class="form-control<?= $Page->event->isInvalidClass() ?>"
    data-table="family_info"
    data-field="x_event"
    data-value-separator="<?= $Page->event->displayValueSeparatorAttribute() ?>"
    <?= $Page->event->editAttributes() ?>></selection-list>
<?= $Page->event->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->event->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "family_event_list") && !$Page->event->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_event" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->event->caption() ?>" data-title="<?= $Page->event->caption() ?>" data-ew-action="add-option" data-el="x_event[]" data-url="<?= GetUrl("familyeventlistaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->event->Lookup->getParamTag($Page, "p_x_event") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label id="elh_family_info_dob" for="x_dob" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dob->caption() ?><?= $Page->dob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dob->cellAttributes() ?>>
<span id="el_family_info_dob">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="family_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
<?= $Page->dob->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infoadd", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <label id="elh_family_info_dom" for="x_dom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dom->caption() ?><?= $Page->dom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dom->cellAttributes() ?>>
<span id="el_family_info_dom">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="family_info" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?> aria-describedby="x_dom_help">
<?= $Page->dom->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage() ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_infoadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_infoadd", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_family_info_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_family_info_address">
<textarea data-table="family_info" data-field="x_address" name="x_address" id="x_address" cols="35" rows="3" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label id="elh_family_info_country" class="<?= $Page->LeftColumnClass ?>"><?= $Page->country->caption() ?><?= $Page->country->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->country->cellAttributes() ?>>
<span id="el_family_info_country">
<?php
if (IsRTL()) {
    $Page->country->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_country" class="ew-auto-suggest">
    <input type="<?= $Page->country->getInputTextType() ?>" class="form-control" name="sv_x_country" id="sv_x_country" value="<?= RemoveHtml($Page->country->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->country->formatPattern()) ?>"<?= $Page->country->editAttributes() ?> aria-describedby="x_country_help">
</span>
<selection-list hidden class="form-control" data-table="family_info" data-field="x_country" data-input="sv_x_country" data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>" name="x_country" id="x_country" value="<?= HtmlEncode($Page->country->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<?= $Page->country->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
<script>
loadjs.ready("ffamily_infoadd", function() {
    ffamily_infoadd.createAutoSuggest(Object.assign({"id":"x_country","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->country->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.country.autoSuggestOptions));
});
</script>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->state->Visible) { // state ?>
    <div id="r_state"<?= $Page->state->rowAttributes() ?>>
        <label id="elh_family_info_state" class="<?= $Page->LeftColumnClass ?>"><?= $Page->state->caption() ?><?= $Page->state->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->state->cellAttributes() ?>>
<span id="el_family_info_state">
<?php
if (IsRTL()) {
    $Page->state->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_state" class="ew-auto-suggest">
    <input type="<?= $Page->state->getInputTextType() ?>" class="form-control" name="sv_x_state" id="sv_x_state" value="<?= RemoveHtml($Page->state->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->state->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->state->formatPattern()) ?>"<?= $Page->state->editAttributes() ?> aria-describedby="x_state_help">
</span>
<selection-list hidden class="form-control" data-table="family_info" data-field="x_state" data-input="sv_x_state" data-value-separator="<?= $Page->state->displayValueSeparatorAttribute() ?>" name="x_state" id="x_state" value="<?= HtmlEncode($Page->state->CurrentValue) ?>"></selection-list>
<?= $Page->state->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->state->getErrorMessage() ?></div>
<script>
loadjs.ready("ffamily_infoadd", function() {
    ffamily_infoadd.createAutoSuggest(Object.assign({"id":"x_state","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->state->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_info.fields.state.autoSuggestOptions));
});
</script>
<?= $Page->state->Lookup->getParamTag($Page, "p_x_state") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <label id="elh_family_info_city_name" for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city_name->caption() ?><?= $Page->city_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city_name->cellAttributes() ?>>
<span id="el_family_info_city_name">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="family_info" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?> aria-describedby="x_city_name_help">
<?= $Page->city_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->work_details->Visible) { // work_details ?>
    <div id="r_work_details"<?= $Page->work_details->rowAttributes() ?>>
        <label id="elh_family_info_work_details" for="x_work_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->work_details->caption() ?><?= $Page->work_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->work_details->cellAttributes() ?>>
<span id="el_family_info_work_details">
<textarea data-table="family_info" data-field="x_work_details" name="x_work_details" id="x_work_details" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->work_details->getPlaceHolder()) ?>"<?= $Page->work_details->editAttributes() ?> aria-describedby="x_work_details_help"><?= $Page->work_details->EditValue ?></textarea>
<?= $Page->work_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->work_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_family_info_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_family_info_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ffamily_infoadd_x_status"
        <?php } ?>
        data-table="family_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_infoadd", function() {
    var options = { name: "x_status", selectId: "ffamily_infoadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_infoadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ffamily_infoadd" };
    } else {
        options.ajax = { id: "x_status", form: "ffamily_infoadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_infoadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_infoadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here, no need to add script tags.
            $("#r_family_id").show();
            $("#r_lifecycle").show();
            $("#r_gender").show();
            $("#r_marital_status").show();
            $("#r_spouse_name").show();
            $("#r_address").hide();
            $("#r_dob").hide();
            $("#r_dom").hide();
            $("#r_email").hide();
            $("#r_work_detail").hide();
        	var per = $("#dsl_x_family_personal input[type='radio']:checked").val()
    		if (per == 1)
    		{
    			$("#r_family_id").show();
    			$("#r_lifecycle").show();
    			$("#r_gender").show();
    			$("#r_marital_status").show();
    			$("#r_spouse_name").show();
    			$("#r_address").hide();
    			$("#r_dob").hide();
    			$("#r_dom").hide();
    			$("#r_email").hide();
    			$("#r_work_detail").hide();
    		}
    		else if (per == 0)
    		{
    			$("#r_family_id").show();
    			$("#r_lifecycle").show();
    			$("#r_gender").show();
    			$("#r_marital_status").show();
    			$("#r_spouse_name").show();
    			$("#r_address").show();
    			$("#r_dob").show();
    			$("#r_dom").show();
    			$("#r_email").show();
    			$("#r_work_detail").show();
    		}
    		else if (per == 2)
    		{
    			$("#r_family_id").hide();
    			$("#r_lifecycle").hide();
    			$("#r_gender").hide();
    			$("#r_marital_status").hide();
    			$("#r_spouse_name").hide();
    			$("#r_address").show();
    			$("#r_dob").show();
    			$("#r_dom").show();
    			$("#r_email").show();
    			$("#r_work_detail").show();
    		}
            var country = $("#x_country").val();
    		if (country == 96)
    		{
    			$("#r_city").hide();
    			$("#r_city_india").show();
    		}
    		else
    		{
    			$("#r_city").show();
    			$("#r_city_india").hide();
    		}
});
</script>
