<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyEventListAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_event_list: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ffamily_event_listadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ffamily_event_listadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["event_type", [fields.event_type.visible && fields.event_type.required ? ew.Validators.required(fields.event_type.caption) : null], fields.event_type.isInvalid],
            ["event_name", [fields.event_name.visible && fields.event_name.required ? ew.Validators.required(fields.event_name.caption) : null], fields.event_name.isInvalid],
            ["sub_event", [fields.sub_event.visible && fields.sub_event.required ? ew.Validators.required(fields.sub_event.caption) : null], fields.sub_event.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["start_date", [fields.start_date.visible && fields.start_date.required ? ew.Validators.required(fields.start_date.caption) : null, ew.Validators.datetime(fields.start_date.clientFormatPattern)], fields.start_date.isInvalid],
            ["end_date", [fields.end_date.visible && fields.end_date.required ? ew.Validators.required(fields.end_date.caption) : null, ew.Validators.datetime(fields.end_date.clientFormatPattern)], fields.end_date.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["_menu", [fields._menu.visible && fields._menu.required ? ew.Validators.required(fields._menu.caption) : null], fields._menu.isInvalid],
            ["decor", [fields.decor.visible && fields.decor.required ? ew.Validators.required(fields.decor.caption) : null], fields.decor.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "event_type": <?= $Page->event_type->toClientList($Page) ?>,
            "event_name": <?= $Page->event_name->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "datetime": <?= $Page->datetime->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_event_listadd" id="ffamily_event_listadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_event_list">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->event_type->Visible) { // event_type ?>
    <div id="r_event_type"<?= $Page->event_type->rowAttributes() ?>>
        <label id="elh_family_event_list_event_type" for="x_event_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->event_type->caption() ?><?= $Page->event_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->event_type->cellAttributes() ?>>
<span id="el_family_event_list_event_type">
    <select
        id="x_event_type"
        name="x_event_type"
        class="form-select ew-select<?= $Page->event_type->isInvalidClass() ?>"
        <?php if (!$Page->event_type->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_listadd_x_event_type"
        <?php } ?>
        data-table="family_event_list"
        data-field="x_event_type"
        data-value-separator="<?= $Page->event_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->event_type->getPlaceHolder()) ?>"
        <?= $Page->event_type->editAttributes() ?>>
        <?= $Page->event_type->selectOptionListHtml("x_event_type") ?>
    </select>
    <?= $Page->event_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->event_type->getErrorMessage() ?></div>
<?php if (!$Page->event_type->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_listadd", function() {
    var options = { name: "x_event_type", selectId: "ffamily_event_listadd_x_event_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_listadd.lists.event_type?.lookupOptions.length) {
        options.data = { id: "x_event_type", form: "ffamily_event_listadd" };
    } else {
        options.ajax = { id: "x_event_type", form: "ffamily_event_listadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_list.fields.event_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->event_name->Visible) { // event_name ?>
    <div id="r_event_name"<?= $Page->event_name->rowAttributes() ?>>
        <label id="elh_family_event_list_event_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->event_name->caption() ?><?= $Page->event_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->event_name->cellAttributes() ?>>
<span id="el_family_event_list_event_name">
<?php
if (IsRTL()) {
    $Page->event_name->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_event_name" class="ew-auto-suggest">
    <div class="input-group">
        <input type="<?= $Page->event_name->getInputTextType() ?>" class="form-control" name="sv_x_event_name" id="sv_x_event_name" value="<?= RemoveHtml($Page->event_name->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->event_name->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->event_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_name->formatPattern()) ?>"<?= $Page->event_name->editAttributes() ?> aria-describedby="x_event_name_help">
        <?php if (AllowAdd(CurrentProjectID() . "family_event_list") && !$Page->event_name->ReadOnly) { ?>
        <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_event_name" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->event_name->caption() ?>" data-title="<?= $Page->event_name->caption() ?>" data-ew-action="add-option" data-el="x_event_name" data-url="<?= GetUrl("familyeventlistaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
        <?php } ?>
    </div>
</span>
<selection-list hidden class="form-control" data-table="family_event_list" data-field="x_event_name" data-input="sv_x_event_name" data-value-separator="<?= $Page->event_name->displayValueSeparatorAttribute() ?>" name="x_event_name" id="x_event_name" value="<?= HtmlEncode($Page->event_name->CurrentValue) ?>"></selection-list>
<?= $Page->event_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->event_name->getErrorMessage() ?></div>
<script>
loadjs.ready("ffamily_event_listadd", function() {
    ffamily_event_listadd.createAutoSuggest(Object.assign({"id":"x_event_name","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->event_name->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_event_list.fields.event_name.autoSuggestOptions));
});
</script>
<?= $Page->event_name->Lookup->getParamTag($Page, "p_x_event_name") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sub_event->Visible) { // sub_event ?>
    <div id="r_sub_event"<?= $Page->sub_event->rowAttributes() ?>>
        <label id="elh_family_event_list_sub_event" for="x_sub_event" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sub_event->caption() ?><?= $Page->sub_event->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sub_event->cellAttributes() ?>>
<span id="el_family_event_list_sub_event">
<input type="<?= $Page->sub_event->getInputTextType() ?>" name="x_sub_event" id="x_sub_event" data-table="family_event_list" data-field="x_sub_event" value="<?= $Page->sub_event->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->sub_event->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sub_event->formatPattern()) ?>"<?= $Page->sub_event->editAttributes() ?> aria-describedby="x_sub_event_help">
<?= $Page->sub_event->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sub_event->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_family_event_list_description" for="x_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_family_event_list_description">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="family_event_list" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help">
<?= $Page->description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->start_date->Visible) { // start_date ?>
    <div id="r_start_date"<?= $Page->start_date->rowAttributes() ?>>
        <label id="elh_family_event_list_start_date" for="x_start_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->start_date->caption() ?><?= $Page->start_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->start_date->cellAttributes() ?>>
<span id="el_family_event_list_start_date">
<input type="<?= $Page->start_date->getInputTextType() ?>" name="x_start_date" id="x_start_date" data-table="family_event_list" data-field="x_start_date" value="<?= $Page->start_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->start_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->start_date->formatPattern()) ?>"<?= $Page->start_date->editAttributes() ?> aria-describedby="x_start_date_help">
<?= $Page->start_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->start_date->getErrorMessage() ?></div>
<?php if (!$Page->start_date->ReadOnly && !$Page->start_date->Disabled && !isset($Page->start_date->EditAttrs["readonly"]) && !isset($Page->start_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_event_listadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_event_listadd", "x_start_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->end_date->Visible) { // end_date ?>
    <div id="r_end_date"<?= $Page->end_date->rowAttributes() ?>>
        <label id="elh_family_event_list_end_date" for="x_end_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->end_date->caption() ?><?= $Page->end_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->end_date->cellAttributes() ?>>
<span id="el_family_event_list_end_date">
<input type="<?= $Page->end_date->getInputTextType() ?>" name="x_end_date" id="x_end_date" data-table="family_event_list" data-field="x_end_date" value="<?= $Page->end_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->end_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->end_date->formatPattern()) ?>"<?= $Page->end_date->editAttributes() ?> aria-describedby="x_end_date_help">
<?= $Page->end_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->end_date->getErrorMessage() ?></div>
<?php if (!$Page->end_date->ReadOnly && !$Page->end_date->Disabled && !isset($Page->end_date->EditAttrs["readonly"]) && !isset($Page->end_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_event_listadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_event_listadd", "x_end_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_family_event_list_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_family_event_list_location">
<input type="<?= $Page->location->getInputTextType() ?>" name="x_location" id="x_location" data-table="family_event_list" data-field="x_location" value="<?= $Page->location->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?> aria-describedby="x_location_help">
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_family_event_list_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_family_event_list_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_listadd_x_status"
        <?php } ?>
        data-table="family_event_list"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_listadd", function() {
    var options = { name: "x_status", selectId: "ffamily_event_listadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_listadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "ffamily_event_listadd" };
    } else {
        options.ajax = { id: "x_status", form: "ffamily_event_listadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_list.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_menu->Visible) { // menu ?>
    <div id="r__menu"<?= $Page->_menu->rowAttributes() ?>>
        <label id="elh_family_event_list__menu" for="x__menu" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_menu->caption() ?><?= $Page->_menu->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_menu->cellAttributes() ?>>
<span id="el_family_event_list__menu">
<input type="<?= $Page->_menu->getInputTextType() ?>" name="x__menu" id="x__menu" data-table="family_event_list" data-field="x__menu" value="<?= $Page->_menu->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->_menu->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_menu->formatPattern()) ?>"<?= $Page->_menu->editAttributes() ?> aria-describedby="x__menu_help">
<?= $Page->_menu->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_menu->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->decor->Visible) { // decor ?>
    <div id="r_decor"<?= $Page->decor->rowAttributes() ?>>
        <label id="elh_family_event_list_decor" for="x_decor" class="<?= $Page->LeftColumnClass ?>"><?= $Page->decor->caption() ?><?= $Page->decor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->decor->cellAttributes() ?>>
<span id="el_family_event_list_decor">
<input type="<?= $Page->decor->getInputTextType() ?>" name="x_decor" id="x_decor" data-table="family_event_list" data-field="x_decor" value="<?= $Page->decor->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->decor->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->decor->formatPattern()) ?>"<?= $Page->decor->editAttributes() ?> aria-describedby="x_decor_help">
<?= $Page->decor->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->decor->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_event_listadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_event_listadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_event_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
