<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyEventEstimateSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_event_estimate: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffamily_event_estimatesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffamily_event_estimatesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["family_id", [], fields.family_id.isInvalid],
            ["event_id", [], fields.event_id.isInvalid],
            ["event_1", [], fields.event_1.isInvalid],
            ["event_2", [], fields.event_2.isInvalid],
            ["event_3", [], fields.event_3.isInvalid],
            ["event_4", [], fields.event_4.isInvalid],
            ["event_5", [], fields.event_5.isInvalid],
            ["event_6", [], fields.event_6.isInvalid],
            ["event_7", [], fields.event_7.isInvalid],
            ["event_8", [], fields.event_8.isInvalid],
            ["event_9", [], fields.event_9.isInvalid],
            ["event_10", [], fields.event_10.isInvalid],
            ["event_11", [ew.Validators.integer], fields.event_11.isInvalid],
            ["event_12", [ew.Validators.integer], fields.event_12.isInvalid],
            ["event_13", [ew.Validators.integer], fields.event_13.isInvalid],
            ["event_14", [ew.Validators.integer], fields.event_14.isInvalid],
            ["event_15", [ew.Validators.integer], fields.event_15.isInvalid],
            ["event_16", [ew.Validators.integer], fields.event_16.isInvalid],
            ["event_17", [ew.Validators.integer], fields.event_17.isInvalid],
            ["event_18", [ew.Validators.integer], fields.event_18.isInvalid],
            ["event_19", [ew.Validators.integer], fields.event_19.isInvalid],
            ["event_20", [ew.Validators.integer], fields.event_20.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_id": <?= $Page->family_id->toClientList($Page) ?>,
            "event_id": <?= $Page->event_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_event_estimatesearch" id="ffamily_event_estimatesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_event_estimate">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="family_event_estimate" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->family_id->Visible) { // family_id ?>
    <div id="r_family_id" class="row"<?= $Page->family_id->rowAttributes() ?>>
        <label for="x_family_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_family_id"><?= $Page->family_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_family_id" id="z_family_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->family_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_family_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_family_id"
        name="x_family_id"
        class="form-select ew-select<?= $Page->family_id->isInvalidClass() ?>"
        <?php if (!$Page->family_id->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_estimatesearch_x_family_id"
        <?php } ?>
        data-table="family_event_estimate"
        data-field="x_family_id"
        data-value-separator="<?= $Page->family_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->family_id->getPlaceHolder()) ?>"
        <?= $Page->family_id->editAttributes() ?>>
        <?= $Page->family_id->selectOptionListHtml("x_family_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->family_id->getErrorMessage(false) ?></div>
<?= $Page->family_id->Lookup->getParamTag($Page, "p_x_family_id") ?>
<?php if (!$Page->family_id->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_estimatesearch", function() {
    var options = { name: "x_family_id", selectId: "ffamily_event_estimatesearch_x_family_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_estimatesearch.lists.family_id?.lookupOptions.length) {
        options.data = { id: "x_family_id", form: "ffamily_event_estimatesearch" };
    } else {
        options.ajax = { id: "x_family_id", form: "ffamily_event_estimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_estimate.fields.family_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_id->Visible) { // event_id ?>
    <div id="r_event_id" class="row"<?= $Page->event_id->rowAttributes() ?>>
        <label for="x_event_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_id"><?= $Page->event_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_id" id="z_event_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_event_id"
        name="x_event_id"
        class="form-select ew-select<?= $Page->event_id->isInvalidClass() ?>"
        <?php if (!$Page->event_id->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_estimatesearch_x_event_id"
        <?php } ?>
        data-table="family_event_estimate"
        data-field="x_event_id"
        data-value-separator="<?= $Page->event_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->event_id->getPlaceHolder()) ?>"
        <?= $Page->event_id->editAttributes() ?>>
        <?= $Page->event_id->selectOptionListHtml("x_event_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->event_id->getErrorMessage(false) ?></div>
<?= $Page->event_id->Lookup->getParamTag($Page, "p_x_event_id") ?>
<?php if (!$Page->event_id->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_estimatesearch", function() {
    var options = { name: "x_event_id", selectId: "ffamily_event_estimatesearch_x_event_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_estimatesearch.lists.event_id?.lookupOptions.length) {
        options.data = { id: "x_event_id", form: "ffamily_event_estimatesearch" };
    } else {
        options.ajax = { id: "x_event_id", form: "ffamily_event_estimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_estimate.fields.event_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_1->Visible) { // event_1 ?>
    <div id="r_event_1" class="row"<?= $Page->event_1->rowAttributes() ?>>
        <label for="x_event_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_1"><?= $Page->event_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_1" id="z_event_1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_1->getInputTextType() ?>" name="x_event_1" id="x_event_1" data-table="family_event_estimate" data-field="x_event_1" value="<?= $Page->event_1->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_1->formatPattern()) ?>"<?= $Page->event_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_2->Visible) { // event_2 ?>
    <div id="r_event_2" class="row"<?= $Page->event_2->rowAttributes() ?>>
        <label for="x_event_2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_2"><?= $Page->event_2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_2" id="z_event_2" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_2->getInputTextType() ?>" name="x_event_2" id="x_event_2" data-table="family_event_estimate" data-field="x_event_2" value="<?= $Page->event_2->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_2->formatPattern()) ?>"<?= $Page->event_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_3->Visible) { // event_3 ?>
    <div id="r_event_3" class="row"<?= $Page->event_3->rowAttributes() ?>>
        <label for="x_event_3" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_3"><?= $Page->event_3->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_3" id="z_event_3" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_3->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_3->getInputTextType() ?>" name="x_event_3" id="x_event_3" data-table="family_event_estimate" data-field="x_event_3" value="<?= $Page->event_3->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_3->formatPattern()) ?>"<?= $Page->event_3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_3->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_4->Visible) { // event_4 ?>
    <div id="r_event_4" class="row"<?= $Page->event_4->rowAttributes() ?>>
        <label for="x_event_4" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_4"><?= $Page->event_4->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_4" id="z_event_4" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_4->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_4" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_4->getInputTextType() ?>" name="x_event_4" id="x_event_4" data-table="family_event_estimate" data-field="x_event_4" value="<?= $Page->event_4->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_4->formatPattern()) ?>"<?= $Page->event_4->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_4->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_5->Visible) { // event_5 ?>
    <div id="r_event_5" class="row"<?= $Page->event_5->rowAttributes() ?>>
        <label for="x_event_5" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_5"><?= $Page->event_5->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_5" id="z_event_5" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_5->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_5" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_5->getInputTextType() ?>" name="x_event_5" id="x_event_5" data-table="family_event_estimate" data-field="x_event_5" value="<?= $Page->event_5->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_5->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_5->formatPattern()) ?>"<?= $Page->event_5->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_5->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_6->Visible) { // event_6 ?>
    <div id="r_event_6" class="row"<?= $Page->event_6->rowAttributes() ?>>
        <label for="x_event_6" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_6"><?= $Page->event_6->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_6" id="z_event_6" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_6->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_6" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_6->getInputTextType() ?>" name="x_event_6" id="x_event_6" data-table="family_event_estimate" data-field="x_event_6" value="<?= $Page->event_6->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_6->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_6->formatPattern()) ?>"<?= $Page->event_6->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_6->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_7->Visible) { // event_7 ?>
    <div id="r_event_7" class="row"<?= $Page->event_7->rowAttributes() ?>>
        <label for="x_event_7" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_7"><?= $Page->event_7->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_7" id="z_event_7" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_7->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_7" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_7->getInputTextType() ?>" name="x_event_7" id="x_event_7" data-table="family_event_estimate" data-field="x_event_7" value="<?= $Page->event_7->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_7->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_7->formatPattern()) ?>"<?= $Page->event_7->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_7->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_8->Visible) { // event_8 ?>
    <div id="r_event_8" class="row"<?= $Page->event_8->rowAttributes() ?>>
        <label for="x_event_8" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_8"><?= $Page->event_8->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_8" id="z_event_8" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_8->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_8" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_8->getInputTextType() ?>" name="x_event_8" id="x_event_8" data-table="family_event_estimate" data-field="x_event_8" value="<?= $Page->event_8->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_8->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_8->formatPattern()) ?>"<?= $Page->event_8->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_8->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_9->Visible) { // event_9 ?>
    <div id="r_event_9" class="row"<?= $Page->event_9->rowAttributes() ?>>
        <label for="x_event_9" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_9"><?= $Page->event_9->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_9" id="z_event_9" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_9->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_9" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_9->getInputTextType() ?>" name="x_event_9" id="x_event_9" data-table="family_event_estimate" data-field="x_event_9" value="<?= $Page->event_9->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_9->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_9->formatPattern()) ?>"<?= $Page->event_9->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_9->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_10->Visible) { // event_10 ?>
    <div id="r_event_10" class="row"<?= $Page->event_10->rowAttributes() ?>>
        <label for="x_event_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_10"><?= $Page->event_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_event_10" id="z_event_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_10->getInputTextType() ?>" name="x_event_10" id="x_event_10" data-table="family_event_estimate" data-field="x_event_10" value="<?= $Page->event_10->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_10->formatPattern()) ?>"<?= $Page->event_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_10->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_11->Visible) { // event_11 ?>
    <div id="r_event_11" class="row"<?= $Page->event_11->rowAttributes() ?>>
        <label for="x_event_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_11"><?= $Page->event_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_11" id="z_event_11" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_11->getInputTextType() ?>" name="x_event_11" id="x_event_11" data-table="family_event_estimate" data-field="x_event_11" value="<?= $Page->event_11->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_11->formatPattern()) ?>"<?= $Page->event_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_12->Visible) { // event_12 ?>
    <div id="r_event_12" class="row"<?= $Page->event_12->rowAttributes() ?>>
        <label for="x_event_12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_12"><?= $Page->event_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_12" id="z_event_12" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_12->getInputTextType() ?>" name="x_event_12" id="x_event_12" data-table="family_event_estimate" data-field="x_event_12" value="<?= $Page->event_12->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_12->formatPattern()) ?>"<?= $Page->event_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_13->Visible) { // event_13 ?>
    <div id="r_event_13" class="row"<?= $Page->event_13->rowAttributes() ?>>
        <label for="x_event_13" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_13"><?= $Page->event_13->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_13" id="z_event_13" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_13->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_13" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_13->getInputTextType() ?>" name="x_event_13" id="x_event_13" data-table="family_event_estimate" data-field="x_event_13" value="<?= $Page->event_13->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_13->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_13->formatPattern()) ?>"<?= $Page->event_13->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_13->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_14->Visible) { // event_14 ?>
    <div id="r_event_14" class="row"<?= $Page->event_14->rowAttributes() ?>>
        <label for="x_event_14" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_14"><?= $Page->event_14->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_14" id="z_event_14" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_14->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_14" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_14->getInputTextType() ?>" name="x_event_14" id="x_event_14" data-table="family_event_estimate" data-field="x_event_14" value="<?= $Page->event_14->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_14->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_14->formatPattern()) ?>"<?= $Page->event_14->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_14->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_15->Visible) { // event_15 ?>
    <div id="r_event_15" class="row"<?= $Page->event_15->rowAttributes() ?>>
        <label for="x_event_15" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_15"><?= $Page->event_15->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_15" id="z_event_15" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_15->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_15" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_15->getInputTextType() ?>" name="x_event_15" id="x_event_15" data-table="family_event_estimate" data-field="x_event_15" value="<?= $Page->event_15->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_15->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_15->formatPattern()) ?>"<?= $Page->event_15->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_15->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_16->Visible) { // event_16 ?>
    <div id="r_event_16" class="row"<?= $Page->event_16->rowAttributes() ?>>
        <label for="x_event_16" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_16"><?= $Page->event_16->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_16" id="z_event_16" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_16->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_16" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_16->getInputTextType() ?>" name="x_event_16" id="x_event_16" data-table="family_event_estimate" data-field="x_event_16" value="<?= $Page->event_16->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_16->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_16->formatPattern()) ?>"<?= $Page->event_16->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_16->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_17->Visible) { // event_17 ?>
    <div id="r_event_17" class="row"<?= $Page->event_17->rowAttributes() ?>>
        <label for="x_event_17" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_17"><?= $Page->event_17->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_17" id="z_event_17" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_17->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_17" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_17->getInputTextType() ?>" name="x_event_17" id="x_event_17" data-table="family_event_estimate" data-field="x_event_17" value="<?= $Page->event_17->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_17->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_17->formatPattern()) ?>"<?= $Page->event_17->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_17->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_18->Visible) { // event_18 ?>
    <div id="r_event_18" class="row"<?= $Page->event_18->rowAttributes() ?>>
        <label for="x_event_18" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_18"><?= $Page->event_18->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_18" id="z_event_18" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_18->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_18" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_18->getInputTextType() ?>" name="x_event_18" id="x_event_18" data-table="family_event_estimate" data-field="x_event_18" value="<?= $Page->event_18->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_18->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_18->formatPattern()) ?>"<?= $Page->event_18->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_18->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_19->Visible) { // event_19 ?>
    <div id="r_event_19" class="row"<?= $Page->event_19->rowAttributes() ?>>
        <label for="x_event_19" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_19"><?= $Page->event_19->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_19" id="z_event_19" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_19->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_19" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_19->getInputTextType() ?>" name="x_event_19" id="x_event_19" data-table="family_event_estimate" data-field="x_event_19" value="<?= $Page->event_19->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_19->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_19->formatPattern()) ?>"<?= $Page->event_19->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_19->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->event_20->Visible) { // event_20 ?>
    <div id="r_event_20" class="row"<?= $Page->event_20->rowAttributes() ?>>
        <label for="x_event_20" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_event_20"><?= $Page->event_20->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_20" id="z_event_20" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->event_20->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_event_20" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_20->getInputTextType() ?>" name="x_event_20" id="x_event_20" data-table="family_event_estimate" data-field="x_event_20" value="<?= $Page->event_20->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_20->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_20->formatPattern()) ?>"<?= $Page->event_20->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_20->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="family_event_estimate" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffamily_event_estimatesearch", function() {
    ffamily_event_estimatesearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_event_estimate.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_family_event_estimate_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_family_event_estimate_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="family_event_estimate" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_event_estimatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_event_estimatesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ffamily_event_estimatesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_event_estimatesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="ffamily_event_estimatesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_event_estimate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here, no need to add script tags.
    var event_id =  getCookie("fibre_x_event_id");
    $.getJSON(window.location.origin +"/apcajaxfm?getEventHead="+event_id,function(data){
        for (var i = 1; i <= 20; i++) {
            var eventVal = data['event_' + i];
            if (eventVal == '--NA--') {
                $("#elh_family_event_estimate_event_" + i).hide();
            } else {
                $("#elh_family_event_estimate_event_" + i).html(eventVal);
            }
        }
    });
});
</script>
