<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyEventEstimateSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_event_estimate: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var ffamily_event_estimatesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffamily_event_estimatesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["family_id", [], fields.family_id.isInvalid],
            ["event_id", [], fields.event_id.isInvalid],
            ["event_1", [], fields.event_1.isInvalid],
            ["event_2", [], fields.event_2.isInvalid],
            ["event_3", [], fields.event_3.isInvalid],
            ["event_4", [], fields.event_4.isInvalid],
            ["event_5", [], fields.event_5.isInvalid],
            ["event_6", [], fields.event_6.isInvalid],
            ["event_7", [], fields.event_7.isInvalid],
            ["event_8", [], fields.event_8.isInvalid],
            ["event_9", [], fields.event_9.isInvalid],
            ["event_10", [], fields.event_10.isInvalid],
            ["event_11", [ew.Validators.integer], fields.event_11.isInvalid],
            ["event_12", [ew.Validators.integer], fields.event_12.isInvalid],
            ["event_13", [ew.Validators.integer], fields.event_13.isInvalid],
            ["event_14", [ew.Validators.integer], fields.event_14.isInvalid],
            ["event_15", [ew.Validators.integer], fields.event_15.isInvalid],
            ["event_16", [ew.Validators.integer], fields.event_16.isInvalid],
            ["event_17", [ew.Validators.integer], fields.event_17.isInvalid],
            ["event_18", [ew.Validators.integer], fields.event_18.isInvalid],
            ["event_19", [ew.Validators.integer], fields.event_19.isInvalid],
            ["event_20", [ew.Validators.integer], fields.event_20.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "family_id": <?= $Page->family_id->toClientList($Page) ?>,
            "event_id": <?= $Page->event_id->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ffamily_event_estimatesearch" id="ffamily_event_estimatesearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("familyeventestimatelist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_event_estimate">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_family_event_estimate_id" class="family_event_estimatesearch"><span id="el_family_event_estimate_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="family_event_estimate" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_family_id" class="family_event_estimatesearch"><span id="el_family_event_estimate_family_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_family_id"
        name="x_family_id"
        class="form-select ew-select<?= $Page->family_id->isInvalidClass() ?>"
        <?php if (!$Page->family_id->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_estimatesearch_x_family_id"
        <?php } ?>
        data-table="family_event_estimate"
        data-field="x_family_id"
        data-value-separator="<?= $Page->family_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->family_id->getPlaceHolder()) ?>"
        <?= $Page->family_id->editAttributes() ?>>
        <?= $Page->family_id->selectOptionListHtml("x_family_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->family_id->getErrorMessage(false) ?></div>
<?= $Page->family_id->Lookup->getParamTag($Page, "p_x_family_id") ?>
<?php if (!$Page->family_id->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_estimatesearch", function() {
    var options = { name: "x_family_id", selectId: "ffamily_event_estimatesearch_x_family_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_estimatesearch.lists.family_id?.lookupOptions.length) {
        options.data = { id: "x_family_id", form: "ffamily_event_estimatesearch" };
    } else {
        options.ajax = { id: "x_family_id", form: "ffamily_event_estimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_estimate.fields.family_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_family_event_estimate_event_id" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_event_id"
        name="x_event_id"
        class="form-select ew-select<?= $Page->event_id->isInvalidClass() ?>"
        <?php if (!$Page->event_id->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_estimatesearch_x_event_id"
        <?php } ?>
        data-table="family_event_estimate"
        data-field="x_event_id"
        data-value-separator="<?= $Page->event_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->event_id->getPlaceHolder()) ?>"
        <?= $Page->event_id->editAttributes() ?>>
        <?= $Page->event_id->selectOptionListHtml("x_event_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->event_id->getErrorMessage(false) ?></div>
<?= $Page->event_id->Lookup->getParamTag($Page, "p_x_event_id") ?>
<?php if (!$Page->event_id->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_estimatesearch", function() {
    var options = { name: "x_event_id", selectId: "ffamily_event_estimatesearch_x_event_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_estimatesearch.lists.event_id?.lookupOptions.length) {
        options.data = { id: "x_event_id", form: "ffamily_event_estimatesearch" };
    } else {
        options.ajax = { id: "x_event_id", form: "ffamily_event_estimatesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_estimate.fields.event_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_family_event_estimate_event_1" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_1->getInputTextType() ?>" name="x_event_1" id="x_event_1" data-table="family_event_estimate" data-field="x_event_1" value="<?= $Page->event_1->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_1->formatPattern()) ?>"<?= $Page->event_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_1->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_2" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_2->getInputTextType() ?>" name="x_event_2" id="x_event_2" data-table="family_event_estimate" data-field="x_event_2" value="<?= $Page->event_2->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_2->formatPattern()) ?>"<?= $Page->event_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_2->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_3" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_3->getInputTextType() ?>" name="x_event_3" id="x_event_3" data-table="family_event_estimate" data-field="x_event_3" value="<?= $Page->event_3->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_3->formatPattern()) ?>"<?= $Page->event_3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_3->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_4" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_4" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_4->getInputTextType() ?>" name="x_event_4" id="x_event_4" data-table="family_event_estimate" data-field="x_event_4" value="<?= $Page->event_4->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_4->formatPattern()) ?>"<?= $Page->event_4->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_4->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_5" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_5" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_5->getInputTextType() ?>" name="x_event_5" id="x_event_5" data-table="family_event_estimate" data-field="x_event_5" value="<?= $Page->event_5->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_5->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_5->formatPattern()) ?>"<?= $Page->event_5->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_5->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_6" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_6" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_6->getInputTextType() ?>" name="x_event_6" id="x_event_6" data-table="family_event_estimate" data-field="x_event_6" value="<?= $Page->event_6->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_6->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_6->formatPattern()) ?>"<?= $Page->event_6->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_6->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_7" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_7" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_7->getInputTextType() ?>" name="x_event_7" id="x_event_7" data-table="family_event_estimate" data-field="x_event_7" value="<?= $Page->event_7->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_7->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_7->formatPattern()) ?>"<?= $Page->event_7->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_7->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_8" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_8" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_8->getInputTextType() ?>" name="x_event_8" id="x_event_8" data-table="family_event_estimate" data-field="x_event_8" value="<?= $Page->event_8->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_8->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_8->formatPattern()) ?>"<?= $Page->event_8->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_8->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_9" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_9" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_9->getInputTextType() ?>" name="x_event_9" id="x_event_9" data-table="family_event_estimate" data-field="x_event_9" value="<?= $Page->event_9->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_9->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_9->formatPattern()) ?>"<?= $Page->event_9->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_9->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_10" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_10" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_10->getInputTextType() ?>" name="x_event_10" id="x_event_10" data-table="family_event_estimate" data-field="x_event_10" value="<?= $Page->event_10->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_10->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_10->formatPattern()) ?>"<?= $Page->event_10->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_10->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_11" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_11->getInputTextType() ?>" name="x_event_11" id="x_event_11" data-table="family_event_estimate" data-field="x_event_11" value="<?= $Page->event_11->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_11->formatPattern()) ?>"<?= $Page->event_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_11->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_12" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_12->getInputTextType() ?>" name="x_event_12" id="x_event_12" data-table="family_event_estimate" data-field="x_event_12" value="<?= $Page->event_12->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_12->formatPattern()) ?>"<?= $Page->event_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_12->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_13" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_13" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_13->getInputTextType() ?>" name="x_event_13" id="x_event_13" data-table="family_event_estimate" data-field="x_event_13" value="<?= $Page->event_13->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_13->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_13->formatPattern()) ?>"<?= $Page->event_13->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_13->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_14" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_14" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_14->getInputTextType() ?>" name="x_event_14" id="x_event_14" data-table="family_event_estimate" data-field="x_event_14" value="<?= $Page->event_14->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_14->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_14->formatPattern()) ?>"<?= $Page->event_14->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_14->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_15" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_15" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_15->getInputTextType() ?>" name="x_event_15" id="x_event_15" data-table="family_event_estimate" data-field="x_event_15" value="<?= $Page->event_15->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_15->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_15->formatPattern()) ?>"<?= $Page->event_15->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_15->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_16" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_16" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_16->getInputTextType() ?>" name="x_event_16" id="x_event_16" data-table="family_event_estimate" data-field="x_event_16" value="<?= $Page->event_16->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_16->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_16->formatPattern()) ?>"<?= $Page->event_16->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_16->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_17" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_17" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_17->getInputTextType() ?>" name="x_event_17" id="x_event_17" data-table="family_event_estimate" data-field="x_event_17" value="<?= $Page->event_17->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_17->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_17->formatPattern()) ?>"<?= $Page->event_17->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_17->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_18" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_18" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_18->getInputTextType() ?>" name="x_event_18" id="x_event_18" data-table="family_event_estimate" data-field="x_event_18" value="<?= $Page->event_18->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_18->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_18->formatPattern()) ?>"<?= $Page->event_18->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_18->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_19" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_19" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_19->getInputTextType() ?>" name="x_event_19" id="x_event_19" data-table="family_event_estimate" data-field="x_event_19" value="<?= $Page->event_19->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_19->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_19->formatPattern()) ?>"<?= $Page->event_19->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_19->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_event_20" class="family_event_estimatesearch"><span id="el_family_event_estimate_event_20" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->event_20->getInputTextType() ?>" name="x_event_20" id="x_event_20" data-table="family_event_estimate" data-field="x_event_20" value="<?= $Page->event_20->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->event_20->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->event_20->formatPattern()) ?>"<?= $Page->event_20->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->event_20->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_family_event_estimate_operator" class="family_event_estimatesearch"><span id="el_family_event_estimate_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="family_event_estimate" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("ffamily_event_estimatesearch", function() {
    ffamily_event_estimatesearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.family_event_estimate.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span></template>
<template id="tpx_family_event_estimate_datetime" class="family_event_estimatesearch"><span id="el_family_event_estimate_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="family_event_estimate" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ffamily_event_estimatesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ffamily_event_estimatesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="family_event_estimate_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "family_id",
                type: "integer",
                label: currentTable.fields.family_id.caption,
                operators: currentTable.fields.family_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.family_id.validators),
                data: {
                    format: currentTable.fields.family_id.clientFormatPattern
                }
            },
            {
                id: "event_id",
                type: "integer",
                label: currentTable.fields.event_id.caption,
                operators: currentTable.fields.event_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_id.validators),
                data: {
                    format: currentTable.fields.event_id.clientFormatPattern
                }
            },
            {
                id: "event_1",
                type: "integer",
                label: currentTable.fields.event_1.caption,
                operators: currentTable.fields.event_1.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_1.validators),
                data: {
                    format: currentTable.fields.event_1.clientFormatPattern
                }
            },
            {
                id: "event_2",
                type: "integer",
                label: currentTable.fields.event_2.caption,
                operators: currentTable.fields.event_2.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_2.validators),
                data: {
                    format: currentTable.fields.event_2.clientFormatPattern
                }
            },
            {
                id: "event_3",
                type: "integer",
                label: currentTable.fields.event_3.caption,
                operators: currentTable.fields.event_3.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_3.validators),
                data: {
                    format: currentTable.fields.event_3.clientFormatPattern
                }
            },
            {
                id: "event_4",
                type: "integer",
                label: currentTable.fields.event_4.caption,
                operators: currentTable.fields.event_4.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_4.validators),
                data: {
                    format: currentTable.fields.event_4.clientFormatPattern
                }
            },
            {
                id: "event_5",
                type: "integer",
                label: currentTable.fields.event_5.caption,
                operators: currentTable.fields.event_5.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_5.validators),
                data: {
                    format: currentTable.fields.event_5.clientFormatPattern
                }
            },
            {
                id: "event_6",
                type: "integer",
                label: currentTable.fields.event_6.caption,
                operators: currentTable.fields.event_6.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_6.validators),
                data: {
                    format: currentTable.fields.event_6.clientFormatPattern
                }
            },
            {
                id: "event_7",
                type: "integer",
                label: currentTable.fields.event_7.caption,
                operators: currentTable.fields.event_7.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_7.validators),
                data: {
                    format: currentTable.fields.event_7.clientFormatPattern
                }
            },
            {
                id: "event_8",
                type: "integer",
                label: currentTable.fields.event_8.caption,
                operators: currentTable.fields.event_8.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_8.validators),
                data: {
                    format: currentTable.fields.event_8.clientFormatPattern
                }
            },
            {
                id: "event_9",
                type: "integer",
                label: currentTable.fields.event_9.caption,
                operators: currentTable.fields.event_9.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_9.validators),
                data: {
                    format: currentTable.fields.event_9.clientFormatPattern
                }
            },
            {
                id: "event_10",
                type: "integer",
                label: currentTable.fields.event_10.caption,
                operators: currentTable.fields.event_10.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_10.validators),
                data: {
                    format: currentTable.fields.event_10.clientFormatPattern
                }
            },
            {
                id: "event_11",
                type: "integer",
                label: currentTable.fields.event_11.caption,
                operators: currentTable.fields.event_11.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_11.validators),
                data: {
                    format: currentTable.fields.event_11.clientFormatPattern
                }
            },
            {
                id: "event_12",
                type: "integer",
                label: currentTable.fields.event_12.caption,
                operators: currentTable.fields.event_12.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_12.validators),
                data: {
                    format: currentTable.fields.event_12.clientFormatPattern
                }
            },
            {
                id: "event_13",
                type: "integer",
                label: currentTable.fields.event_13.caption,
                operators: currentTable.fields.event_13.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_13.validators),
                data: {
                    format: currentTable.fields.event_13.clientFormatPattern
                }
            },
            {
                id: "event_14",
                type: "integer",
                label: currentTable.fields.event_14.caption,
                operators: currentTable.fields.event_14.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_14.validators),
                data: {
                    format: currentTable.fields.event_14.clientFormatPattern
                }
            },
            {
                id: "event_15",
                type: "integer",
                label: currentTable.fields.event_15.caption,
                operators: currentTable.fields.event_15.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_15.validators),
                data: {
                    format: currentTable.fields.event_15.clientFormatPattern
                }
            },
            {
                id: "event_16",
                type: "integer",
                label: currentTable.fields.event_16.caption,
                operators: currentTable.fields.event_16.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_16.validators),
                data: {
                    format: currentTable.fields.event_16.clientFormatPattern
                }
            },
            {
                id: "event_17",
                type: "integer",
                label: currentTable.fields.event_17.caption,
                operators: currentTable.fields.event_17.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_17.validators),
                data: {
                    format: currentTable.fields.event_17.clientFormatPattern
                }
            },
            {
                id: "event_18",
                type: "integer",
                label: currentTable.fields.event_18.caption,
                operators: currentTable.fields.event_18.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_18.validators),
                data: {
                    format: currentTable.fields.event_18.clientFormatPattern
                }
            },
            {
                id: "event_19",
                type: "integer",
                label: currentTable.fields.event_19.caption,
                operators: currentTable.fields.event_19.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_19.validators),
                data: {
                    format: currentTable.fields.event_19.clientFormatPattern
                }
            },
            {
                id: "event_20",
                type: "integer",
                label: currentTable.fields.event_20.caption,
                operators: currentTable.fields.event_20.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.event_20.validators),
                data: {
                    format: currentTable.fields.event_20.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(ffamily_event_estimatesearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#family_event_estimate_query_builder"),
        args = {},
        rules = ew.parseJson($("#ffamily_event_estimatesearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#ffamily_event_estimatesearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="ffamily_event_estimatesearch" formaction="<?= HtmlEncode(GetUrl("familyeventestimatelist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ffamily_event_estimatesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="ffamily_event_estimatesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_event_estimate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here, no need to add script tags.
    var event_id =  getCookie("fibre_x_event_id");
    $.getJSON(window.location.origin +"/apcajaxfm?getEventHead="+event_id,function(data){
        for (var i = 1; i <= 20; i++) {
            var eventVal = data['event_' + i];
            if (eventVal == '--NA--') {
                $("#elh_family_event_estimate_event_" + i).hide();
            } else {
                $("#elh_family_event_estimate_event_" + i).html(eventVal);
            }
        }
    });
});
</script>
