<?php

namespace PHPMaker2024\fibre;

// Page object
$FamilyEventEstimateList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_event_estimate: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "family_id": <?= $Page->family_id->toClientList($Page) ?>,
            "event_id": <?= $Page->event_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="ffamily_event_estimatesrch" id="ffamily_event_estimatesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="ffamily_event_estimatesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { family_event_estimate: currentTable } });
var currentForm;
var ffamily_event_estimatesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("ffamily_event_estimatesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["event_id", [], fields.event_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "family_id": <?= $Page->family_id->toClientList($Page) ?>,
            "event_id": <?= $Page->event_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->family_id->Visible) { // family_id ?>
<?php
if (!$Page->family_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_family_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->family_id->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_family_id"
            name="x_family_id[]"
            class="form-control ew-select<?= $Page->family_id->isInvalidClass() ?>"
            data-select2-id="ffamily_event_estimatesrch_x_family_id"
            data-table="family_event_estimate"
            data-field="x_family_id"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->family_id->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->family_id->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->family_id->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->family_id->editAttributes() ?>>
            <?= $Page->family_id->selectOptionListHtml("x_family_id", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->family_id->getErrorMessage(false) ?></div>
        <?= $Page->family_id->Lookup->getParamTag($Page, "p_x_family_id") ?>
        <script>
        loadjs.ready("ffamily_event_estimatesrch", function() {
            var options = {
                name: "x_family_id",
                selectId: "ffamily_event_estimatesrch_x_family_id",
                ajax: { id: "x_family_id", form: "ffamily_event_estimatesrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.family_event_estimate.fields.family_id.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->event_id->Visible) { // event_id ?>
<?php
if (!$Page->event_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_event_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->event_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_event_id" class="ew-search-caption ew-label"><?= $Page->event_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_event_id" id="z_event_id" value="=">
</div>
        </div>
        <div id="el_family_event_estimate_event_id" class="ew-search-field">
    <select
        id="x_event_id"
        name="x_event_id"
        class="form-select ew-select<?= $Page->event_id->isInvalidClass() ?>"
        <?php if (!$Page->event_id->IsNativeSelect) { ?>
        data-select2-id="ffamily_event_estimatesrch_x_event_id"
        <?php } ?>
        data-table="family_event_estimate"
        data-field="x_event_id"
        data-value-separator="<?= $Page->event_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->event_id->getPlaceHolder()) ?>"
        <?= $Page->event_id->editAttributes() ?>>
        <?= $Page->event_id->selectOptionListHtml("x_event_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->event_id->getErrorMessage(false) ?></div>
<?= $Page->event_id->Lookup->getParamTag($Page, "p_x_event_id") ?>
<?php if (!$Page->event_id->IsNativeSelect) { ?>
<script>
loadjs.ready("ffamily_event_estimatesrch", function() {
    var options = { name: "x_event_id", selectId: "ffamily_event_estimatesrch_x_event_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ffamily_event_estimatesrch.lists.event_id?.lookupOptions.length) {
        options.data = { id: "x_event_id", form: "ffamily_event_estimatesrch" };
    } else {
        options.ajax = { id: "x_event_id", form: "ffamily_event_estimatesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.family_event_estimate.fields.event_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="ffamily_event_estimatesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="ffamily_event_estimatesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="ffamily_event_estimatesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="ffamily_event_estimatesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="ffamily_event_estimatesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="ffamily_event_estimatesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="ffamily_event_estimatesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="family_event_estimate">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_family_event_estimate" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_family_event_estimatelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_family_event_estimate_id" class="family_event_estimate_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->family_id->Visible) { // family_id ?>
        <th data-name="family_id" class="<?= $Page->family_id->headerCellClass() ?>"><div id="elh_family_event_estimate_family_id" class="family_event_estimate_family_id"><?= $Page->renderFieldHeader($Page->family_id) ?></div></th>
<?php } ?>
<?php if ($Page->event_id->Visible) { // event_id ?>
        <th data-name="event_id" class="<?= $Page->event_id->headerCellClass() ?>"><div id="elh_family_event_estimate_event_id" class="family_event_estimate_event_id"><?= $Page->renderFieldHeader($Page->event_id) ?></div></th>
<?php } ?>
<?php if ($Page->event_1->Visible) { // event_1 ?>
        <th data-name="event_1" class="<?= $Page->event_1->headerCellClass() ?>"><div id="elh_family_event_estimate_event_1" class="family_event_estimate_event_1"><?= $Page->renderFieldHeader($Page->event_1) ?></div></th>
<?php } ?>
<?php if ($Page->event_2->Visible) { // event_2 ?>
        <th data-name="event_2" class="<?= $Page->event_2->headerCellClass() ?>"><div id="elh_family_event_estimate_event_2" class="family_event_estimate_event_2"><?= $Page->renderFieldHeader($Page->event_2) ?></div></th>
<?php } ?>
<?php if ($Page->event_3->Visible) { // event_3 ?>
        <th data-name="event_3" class="<?= $Page->event_3->headerCellClass() ?>"><div id="elh_family_event_estimate_event_3" class="family_event_estimate_event_3"><?= $Page->renderFieldHeader($Page->event_3) ?></div></th>
<?php } ?>
<?php if ($Page->event_4->Visible) { // event_4 ?>
        <th data-name="event_4" class="<?= $Page->event_4->headerCellClass() ?>"><div id="elh_family_event_estimate_event_4" class="family_event_estimate_event_4"><?= $Page->renderFieldHeader($Page->event_4) ?></div></th>
<?php } ?>
<?php if ($Page->event_5->Visible) { // event_5 ?>
        <th data-name="event_5" class="<?= $Page->event_5->headerCellClass() ?>"><div id="elh_family_event_estimate_event_5" class="family_event_estimate_event_5"><?= $Page->renderFieldHeader($Page->event_5) ?></div></th>
<?php } ?>
<?php if ($Page->event_6->Visible) { // event_6 ?>
        <th data-name="event_6" class="<?= $Page->event_6->headerCellClass() ?>"><div id="elh_family_event_estimate_event_6" class="family_event_estimate_event_6"><?= $Page->renderFieldHeader($Page->event_6) ?></div></th>
<?php } ?>
<?php if ($Page->event_7->Visible) { // event_7 ?>
        <th data-name="event_7" class="<?= $Page->event_7->headerCellClass() ?>"><div id="elh_family_event_estimate_event_7" class="family_event_estimate_event_7"><?= $Page->renderFieldHeader($Page->event_7) ?></div></th>
<?php } ?>
<?php if ($Page->event_8->Visible) { // event_8 ?>
        <th data-name="event_8" class="<?= $Page->event_8->headerCellClass() ?>"><div id="elh_family_event_estimate_event_8" class="family_event_estimate_event_8"><?= $Page->renderFieldHeader($Page->event_8) ?></div></th>
<?php } ?>
<?php if ($Page->event_9->Visible) { // event_9 ?>
        <th data-name="event_9" class="<?= $Page->event_9->headerCellClass() ?>"><div id="elh_family_event_estimate_event_9" class="family_event_estimate_event_9"><?= $Page->renderFieldHeader($Page->event_9) ?></div></th>
<?php } ?>
<?php if ($Page->event_10->Visible) { // event_10 ?>
        <th data-name="event_10" class="<?= $Page->event_10->headerCellClass() ?>"><div id="elh_family_event_estimate_event_10" class="family_event_estimate_event_10"><?= $Page->renderFieldHeader($Page->event_10) ?></div></th>
<?php } ?>
<?php if ($Page->event_11->Visible) { // event_11 ?>
        <th data-name="event_11" class="<?= $Page->event_11->headerCellClass() ?>"><div id="elh_family_event_estimate_event_11" class="family_event_estimate_event_11"><?= $Page->renderFieldHeader($Page->event_11) ?></div></th>
<?php } ?>
<?php if ($Page->event_12->Visible) { // event_12 ?>
        <th data-name="event_12" class="<?= $Page->event_12->headerCellClass() ?>"><div id="elh_family_event_estimate_event_12" class="family_event_estimate_event_12"><?= $Page->renderFieldHeader($Page->event_12) ?></div></th>
<?php } ?>
<?php if ($Page->event_13->Visible) { // event_13 ?>
        <th data-name="event_13" class="<?= $Page->event_13->headerCellClass() ?>"><div id="elh_family_event_estimate_event_13" class="family_event_estimate_event_13"><?= $Page->renderFieldHeader($Page->event_13) ?></div></th>
<?php } ?>
<?php if ($Page->event_14->Visible) { // event_14 ?>
        <th data-name="event_14" class="<?= $Page->event_14->headerCellClass() ?>"><div id="elh_family_event_estimate_event_14" class="family_event_estimate_event_14"><?= $Page->renderFieldHeader($Page->event_14) ?></div></th>
<?php } ?>
<?php if ($Page->event_15->Visible) { // event_15 ?>
        <th data-name="event_15" class="<?= $Page->event_15->headerCellClass() ?>"><div id="elh_family_event_estimate_event_15" class="family_event_estimate_event_15"><?= $Page->renderFieldHeader($Page->event_15) ?></div></th>
<?php } ?>
<?php if ($Page->event_16->Visible) { // event_16 ?>
        <th data-name="event_16" class="<?= $Page->event_16->headerCellClass() ?>"><div id="elh_family_event_estimate_event_16" class="family_event_estimate_event_16"><?= $Page->renderFieldHeader($Page->event_16) ?></div></th>
<?php } ?>
<?php if ($Page->event_17->Visible) { // event_17 ?>
        <th data-name="event_17" class="<?= $Page->event_17->headerCellClass() ?>"><div id="elh_family_event_estimate_event_17" class="family_event_estimate_event_17"><?= $Page->renderFieldHeader($Page->event_17) ?></div></th>
<?php } ?>
<?php if ($Page->event_18->Visible) { // event_18 ?>
        <th data-name="event_18" class="<?= $Page->event_18->headerCellClass() ?>"><div id="elh_family_event_estimate_event_18" class="family_event_estimate_event_18"><?= $Page->renderFieldHeader($Page->event_18) ?></div></th>
<?php } ?>
<?php if ($Page->event_19->Visible) { // event_19 ?>
        <th data-name="event_19" class="<?= $Page->event_19->headerCellClass() ?>"><div id="elh_family_event_estimate_event_19" class="family_event_estimate_event_19"><?= $Page->renderFieldHeader($Page->event_19) ?></div></th>
<?php } ?>
<?php if ($Page->event_20->Visible) { // event_20 ?>
        <th data-name="event_20" class="<?= $Page->event_20->headerCellClass() ?>"><div id="elh_family_event_estimate_event_20" class="family_event_estimate_event_20"><?= $Page->renderFieldHeader($Page->event_20) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_id" class="el_family_event_estimate_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->family_id->Visible) { // family_id ?>
        <td data-name="family_id"<?= $Page->family_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_family_id" class="el_family_event_estimate_family_id">
<span<?= $Page->family_id->viewAttributes() ?>>
<?= $Page->family_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_id->Visible) { // event_id ?>
        <td data-name="event_id"<?= $Page->event_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_id" class="el_family_event_estimate_event_id">
<span<?= $Page->event_id->viewAttributes() ?>>
<?= $Page->event_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_1->Visible) { // event_1 ?>
        <td data-name="event_1"<?= $Page->event_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_1" class="el_family_event_estimate_event_1">
<span<?= $Page->event_1->viewAttributes() ?>>
<?= $Page->event_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_2->Visible) { // event_2 ?>
        <td data-name="event_2"<?= $Page->event_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_2" class="el_family_event_estimate_event_2">
<span<?= $Page->event_2->viewAttributes() ?>>
<?= $Page->event_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_3->Visible) { // event_3 ?>
        <td data-name="event_3"<?= $Page->event_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_3" class="el_family_event_estimate_event_3">
<span<?= $Page->event_3->viewAttributes() ?>>
<?= $Page->event_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_4->Visible) { // event_4 ?>
        <td data-name="event_4"<?= $Page->event_4->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_4" class="el_family_event_estimate_event_4">
<span<?= $Page->event_4->viewAttributes() ?>>
<?= $Page->event_4->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_5->Visible) { // event_5 ?>
        <td data-name="event_5"<?= $Page->event_5->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_5" class="el_family_event_estimate_event_5">
<span<?= $Page->event_5->viewAttributes() ?>>
<?= $Page->event_5->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_6->Visible) { // event_6 ?>
        <td data-name="event_6"<?= $Page->event_6->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_6" class="el_family_event_estimate_event_6">
<span<?= $Page->event_6->viewAttributes() ?>>
<?= $Page->event_6->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_7->Visible) { // event_7 ?>
        <td data-name="event_7"<?= $Page->event_7->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_7" class="el_family_event_estimate_event_7">
<span<?= $Page->event_7->viewAttributes() ?>>
<?= $Page->event_7->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_8->Visible) { // event_8 ?>
        <td data-name="event_8"<?= $Page->event_8->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_8" class="el_family_event_estimate_event_8">
<span<?= $Page->event_8->viewAttributes() ?>>
<?= $Page->event_8->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_9->Visible) { // event_9 ?>
        <td data-name="event_9"<?= $Page->event_9->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_9" class="el_family_event_estimate_event_9">
<span<?= $Page->event_9->viewAttributes() ?>>
<?= $Page->event_9->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_10->Visible) { // event_10 ?>
        <td data-name="event_10"<?= $Page->event_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_10" class="el_family_event_estimate_event_10">
<span<?= $Page->event_10->viewAttributes() ?>>
<?= $Page->event_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_11->Visible) { // event_11 ?>
        <td data-name="event_11"<?= $Page->event_11->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_11" class="el_family_event_estimate_event_11">
<span<?= $Page->event_11->viewAttributes() ?>>
<?= $Page->event_11->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_12->Visible) { // event_12 ?>
        <td data-name="event_12"<?= $Page->event_12->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_12" class="el_family_event_estimate_event_12">
<span<?= $Page->event_12->viewAttributes() ?>>
<?= $Page->event_12->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_13->Visible) { // event_13 ?>
        <td data-name="event_13"<?= $Page->event_13->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_13" class="el_family_event_estimate_event_13">
<span<?= $Page->event_13->viewAttributes() ?>>
<?= $Page->event_13->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_14->Visible) { // event_14 ?>
        <td data-name="event_14"<?= $Page->event_14->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_14" class="el_family_event_estimate_event_14">
<span<?= $Page->event_14->viewAttributes() ?>>
<?= $Page->event_14->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_15->Visible) { // event_15 ?>
        <td data-name="event_15"<?= $Page->event_15->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_15" class="el_family_event_estimate_event_15">
<span<?= $Page->event_15->viewAttributes() ?>>
<?= $Page->event_15->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_16->Visible) { // event_16 ?>
        <td data-name="event_16"<?= $Page->event_16->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_16" class="el_family_event_estimate_event_16">
<span<?= $Page->event_16->viewAttributes() ?>>
<?= $Page->event_16->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_17->Visible) { // event_17 ?>
        <td data-name="event_17"<?= $Page->event_17->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_17" class="el_family_event_estimate_event_17">
<span<?= $Page->event_17->viewAttributes() ?>>
<?= $Page->event_17->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_18->Visible) { // event_18 ?>
        <td data-name="event_18"<?= $Page->event_18->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_18" class="el_family_event_estimate_event_18">
<span<?= $Page->event_18->viewAttributes() ?>>
<?= $Page->event_18->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_19->Visible) { // event_19 ?>
        <td data-name="event_19"<?= $Page->event_19->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_19" class="el_family_event_estimate_event_19">
<span<?= $Page->event_19->viewAttributes() ?>>
<?= $Page->event_19->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->event_20->Visible) { // event_20 ?>
        <td data-name="event_20"<?= $Page->event_20->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_family_event_estimate_event_20" class="el_family_event_estimate_event_20">
<span<?= $Page->event_20->viewAttributes() ?>>
<?= $Page->event_20->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_family_event_estimate_id" class="family_event_estimate_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->family_id->Visible) { // family_id ?>
        <td data-name="family_id" class="<?= $Page->family_id->footerCellClass() ?>"><span id="elf_family_event_estimate_family_id" class="family_event_estimate_family_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->event_id->Visible) { // event_id ?>
        <td data-name="event_id" class="<?= $Page->event_id->footerCellClass() ?>"><span id="elf_family_event_estimate_event_id" class="family_event_estimate_event_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->event_1->Visible) { // event_1 ?>
        <td data-name="event_1" class="<?= $Page->event_1->footerCellClass() ?>"><span id="elf_family_event_estimate_event_1" class="family_event_estimate_event_1">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_1->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_2->Visible) { // event_2 ?>
        <td data-name="event_2" class="<?= $Page->event_2->footerCellClass() ?>"><span id="elf_family_event_estimate_event_2" class="family_event_estimate_event_2">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_2->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_3->Visible) { // event_3 ?>
        <td data-name="event_3" class="<?= $Page->event_3->footerCellClass() ?>"><span id="elf_family_event_estimate_event_3" class="family_event_estimate_event_3">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_3->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_4->Visible) { // event_4 ?>
        <td data-name="event_4" class="<?= $Page->event_4->footerCellClass() ?>"><span id="elf_family_event_estimate_event_4" class="family_event_estimate_event_4">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_4->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_5->Visible) { // event_5 ?>
        <td data-name="event_5" class="<?= $Page->event_5->footerCellClass() ?>"><span id="elf_family_event_estimate_event_5" class="family_event_estimate_event_5">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_5->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_6->Visible) { // event_6 ?>
        <td data-name="event_6" class="<?= $Page->event_6->footerCellClass() ?>"><span id="elf_family_event_estimate_event_6" class="family_event_estimate_event_6">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_6->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_7->Visible) { // event_7 ?>
        <td data-name="event_7" class="<?= $Page->event_7->footerCellClass() ?>"><span id="elf_family_event_estimate_event_7" class="family_event_estimate_event_7">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_7->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_8->Visible) { // event_8 ?>
        <td data-name="event_8" class="<?= $Page->event_8->footerCellClass() ?>"><span id="elf_family_event_estimate_event_8" class="family_event_estimate_event_8">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_8->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_9->Visible) { // event_9 ?>
        <td data-name="event_9" class="<?= $Page->event_9->footerCellClass() ?>"><span id="elf_family_event_estimate_event_9" class="family_event_estimate_event_9">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_9->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_10->Visible) { // event_10 ?>
        <td data-name="event_10" class="<?= $Page->event_10->footerCellClass() ?>"><span id="elf_family_event_estimate_event_10" class="family_event_estimate_event_10">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_10->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_11->Visible) { // event_11 ?>
        <td data-name="event_11" class="<?= $Page->event_11->footerCellClass() ?>"><span id="elf_family_event_estimate_event_11" class="family_event_estimate_event_11">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_11->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_12->Visible) { // event_12 ?>
        <td data-name="event_12" class="<?= $Page->event_12->footerCellClass() ?>"><span id="elf_family_event_estimate_event_12" class="family_event_estimate_event_12">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_12->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_13->Visible) { // event_13 ?>
        <td data-name="event_13" class="<?= $Page->event_13->footerCellClass() ?>"><span id="elf_family_event_estimate_event_13" class="family_event_estimate_event_13">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_13->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_14->Visible) { // event_14 ?>
        <td data-name="event_14" class="<?= $Page->event_14->footerCellClass() ?>"><span id="elf_family_event_estimate_event_14" class="family_event_estimate_event_14">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_14->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_15->Visible) { // event_15 ?>
        <td data-name="event_15" class="<?= $Page->event_15->footerCellClass() ?>"><span id="elf_family_event_estimate_event_15" class="family_event_estimate_event_15">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_15->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_16->Visible) { // event_16 ?>
        <td data-name="event_16" class="<?= $Page->event_16->footerCellClass() ?>"><span id="elf_family_event_estimate_event_16" class="family_event_estimate_event_16">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_16->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_17->Visible) { // event_17 ?>
        <td data-name="event_17" class="<?= $Page->event_17->footerCellClass() ?>"><span id="elf_family_event_estimate_event_17" class="family_event_estimate_event_17">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_17->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_18->Visible) { // event_18 ?>
        <td data-name="event_18" class="<?= $Page->event_18->footerCellClass() ?>"><span id="elf_family_event_estimate_event_18" class="family_event_estimate_event_18">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_18->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_19->Visible) { // event_19 ?>
        <td data-name="event_19" class="<?= $Page->event_19->footerCellClass() ?>"><span id="elf_family_event_estimate_event_19" class="family_event_estimate_event_19">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_19->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->event_20->Visible) { // event_20 ?>
        <td data-name="event_20" class="<?= $Page->event_20->footerCellClass() ?>"><span id="elf_family_event_estimate_event_20" class="family_event_estimate_event_20">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->event_20->ViewValue ?></span>
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("family_event_estimate");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here, no need to add script tags.
    var event_id =  getCookie("fibre_x_event_id");
    $.getJSON(window.location.origin +"/apcajaxfm?getEventHead="+event_id,function(data){
        for (var i = 1; i <= 20; i++) {
            var eventVal = data['event_' + i];
            if (eventVal == '--NA--') {
                $("#elh_family_event_estimate_event_" + i).hide();
            } else {
                $("#elh_family_event_estimate_event_" + i).html(eventVal);
            }
        }
    });
});
</script>
<?php } ?>
