<?php

namespace PHPMaker2024\fibre;

// Page object
$Dashboard2Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { dashboard2: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fdashboard2search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fdashboard2search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["item_group", [], fields.item_group.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["target_window", [], fields.target_window.isInvalid],
            ["_title", [], fields._title.isInvalid],
            ["sub_title", [], fields.sub_title.isInvalid],
            ["url_link", [], fields.url_link.isInvalid],
            ["code", [], fields.code.isInvalid],
            ["order_by", [ew.Validators.integer], fields.order_by.isInvalid],
            ["user_level", [], fields.user_level.isInvalid],
            ["sub_group_by", [], fields.sub_group_by.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "item_group": <?= $Page->item_group->toClientList($Page) ?>,
            "target_window": <?= $Page->target_window->toClientList($Page) ?>,
            "user_level": <?= $Page->user_level->toClientList($Page) ?>,
            "sub_group_by": <?= $Page->sub_group_by->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fdashboard2search" id="fdashboard2search" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="dashboard2">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="dashboard2" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->item_group->Visible) { // item_group ?>
    <div id="r_item_group" class="row"<?= $Page->item_group->rowAttributes() ?>>
        <label for="x_item_group" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_item_group"><?= $Page->item_group->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_item_group" id="z_item_group" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->item_group->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_item_group" class="ew-search-field ew-search-field-single">
    <select
        id="x_item_group"
        name="x_item_group"
        class="form-select ew-select<?= $Page->item_group->isInvalidClass() ?>"
        <?php if (!$Page->item_group->IsNativeSelect) { ?>
        data-select2-id="fdashboard2search_x_item_group"
        <?php } ?>
        data-table="dashboard2"
        data-field="x_item_group"
        data-value-separator="<?= $Page->item_group->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->item_group->getPlaceHolder()) ?>"
        <?= $Page->item_group->editAttributes() ?>>
        <?= $Page->item_group->selectOptionListHtml("x_item_group") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->item_group->getErrorMessage(false) ?></div>
<?php if (!$Page->item_group->IsNativeSelect) { ?>
<script>
loadjs.ready("fdashboard2search", function() {
    var options = { name: "x_item_group", selectId: "fdashboard2search_x_item_group" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fdashboard2search.lists.item_group?.lookupOptions.length) {
        options.data = { id: "x_item_group", form: "fdashboard2search" };
    } else {
        options.ajax = { id: "x_item_group", form: "fdashboard2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.dashboard2.fields.item_group.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="dashboard2" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->target_window->Visible) { // target_window ?>
    <div id="r_target_window" class="row"<?= $Page->target_window->rowAttributes() ?>>
        <label for="x_target_window" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_target_window"><?= $Page->target_window->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_target_window" id="z_target_window" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->target_window->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_target_window" class="ew-search-field ew-search-field-single">
    <select
        id="x_target_window"
        name="x_target_window"
        class="form-select ew-select<?= $Page->target_window->isInvalidClass() ?>"
        <?php if (!$Page->target_window->IsNativeSelect) { ?>
        data-select2-id="fdashboard2search_x_target_window"
        <?php } ?>
        data-table="dashboard2"
        data-field="x_target_window"
        data-value-separator="<?= $Page->target_window->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->target_window->getPlaceHolder()) ?>"
        <?= $Page->target_window->editAttributes() ?>>
        <?= $Page->target_window->selectOptionListHtml("x_target_window") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->target_window->getErrorMessage(false) ?></div>
<?php if (!$Page->target_window->IsNativeSelect) { ?>
<script>
loadjs.ready("fdashboard2search", function() {
    var options = { name: "x_target_window", selectId: "fdashboard2search_x_target_window" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fdashboard2search.lists.target_window?.lookupOptions.length) {
        options.data = { id: "x_target_window", form: "fdashboard2search" };
    } else {
        options.ajax = { id: "x_target_window", form: "fdashboard2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.dashboard2.fields.target_window.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_title->Visible) { // title ?>
    <div id="r__title" class="row"<?= $Page->_title->rowAttributes() ?>>
        <label for="x__title" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2__title"><?= $Page->_title->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__title" id="z__title" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_title->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2__title" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_title->getInputTextType() ?>" name="x__title" id="x__title" data-table="dashboard2" data-field="x__title" value="<?= $Page->_title->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_title->formatPattern()) ?>"<?= $Page->_title->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_title->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sub_title->Visible) { // sub_title ?>
    <div id="r_sub_title" class="row"<?= $Page->sub_title->rowAttributes() ?>>
        <label for="x_sub_title" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_sub_title"><?= $Page->sub_title->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sub_title" id="z_sub_title" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sub_title->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_sub_title" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sub_title->getInputTextType() ?>" name="x_sub_title" id="x_sub_title" data-table="dashboard2" data-field="x_sub_title" value="<?= $Page->sub_title->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->sub_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sub_title->formatPattern()) ?>"<?= $Page->sub_title->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sub_title->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url_link->Visible) { // url_link ?>
    <div id="r_url_link" class="row"<?= $Page->url_link->rowAttributes() ?>>
        <label for="x_url_link" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_url_link"><?= $Page->url_link->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url_link" id="z_url_link" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url_link->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_url_link" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url_link->getInputTextType() ?>" name="x_url_link" id="x_url_link" data-table="dashboard2" data-field="x_url_link" value="<?= $Page->url_link->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->url_link->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url_link->formatPattern()) ?>"<?= $Page->url_link->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url_link->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="dashboard2" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_by->Visible) { // order_by ?>
    <div id="r_order_by" class="row"<?= $Page->order_by->rowAttributes() ?>>
        <label for="x_order_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_order_by"><?= $Page->order_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_by" id="z_order_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_order_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_by->getInputTextType() ?>" name="x_order_by" id="x_order_by" data-table="dashboard2" data-field="x_order_by" value="<?= $Page->order_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_by->formatPattern()) ?>"<?= $Page->order_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user_level->Visible) { // user_level ?>
    <div id="r_user_level" class="row"<?= $Page->user_level->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_user_level"><?= $Page->user_level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_user_level" id="z_user_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user_level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_user_level" class="ew-search-field ew-search-field-single">
<template id="tp_x_user_level">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="dashboard2" data-field="x_user_level" name="x_user_level" id="x_user_level"<?= $Page->user_level->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_user_level" class="ew-item-list"></div>
<selection-list hidden
    id="x_user_level[]"
    name="x_user_level[]"
    value="<?= HtmlEncode($Page->user_level->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_user_level"
    data-target="dsl_x_user_level"
    data-repeatcolumn="4"
    class="form-control<?= $Page->user_level->isInvalidClass() ?>"
    data-table="dashboard2"
    data-field="x_user_level"
    data-value-separator="<?= $Page->user_level->displayValueSeparatorAttribute() ?>"
    <?= $Page->user_level->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->user_level->getErrorMessage(false) ?></div>
<?= $Page->user_level->Lookup->getParamTag($Page, "p_x_user_level") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sub_group_by->Visible) { // sub_group_by ?>
    <div id="r_sub_group_by" class="row"<?= $Page->sub_group_by->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_sub_group_by"><?= $Page->sub_group_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sub_group_by" id="z_sub_group_by" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sub_group_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_sub_group_by" class="ew-search-field ew-search-field-single">
<template id="tp_x_sub_group_by">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="dashboard2" data-field="x_sub_group_by" name="x_sub_group_by" id="x_sub_group_by"<?= $Page->sub_group_by->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_sub_group_by" class="ew-item-list"></div>
<selection-list hidden
    id="x_sub_group_by[]"
    name="x_sub_group_by[]"
    value="<?= HtmlEncode($Page->sub_group_by->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_sub_group_by"
    data-target="dsl_x_sub_group_by"
    data-repeatcolumn="4"
    class="form-control<?= $Page->sub_group_by->isInvalidClass() ?>"
    data-table="dashboard2"
    data-field="x_sub_group_by"
    data-value-separator="<?= $Page->sub_group_by->displayValueSeparatorAttribute() ?>"
    <?= $Page->sub_group_by->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->sub_group_by->getErrorMessage(false) ?></div>
<?= $Page->sub_group_by->Lookup->getParamTag($Page, "p_x_sub_group_by") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fdashboard2search_x_status"
        <?php } ?>
        data-table="dashboard2"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fdashboard2search", function() {
    var options = { name: "x_status", selectId: "fdashboard2search_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fdashboard2search.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fdashboard2search" };
    } else {
        options.ajax = { id: "x_status", form: "fdashboard2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.dashboard2.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="dashboard2" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fdashboard2search", function() {
    fdashboard2search.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.dashboard2.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_dashboard2_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_dashboard2_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="dashboard2" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdashboard2search", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fdashboard2search", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fdashboard2search"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fdashboard2search"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fdashboard2search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("dashboard2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
