<?php

namespace PHPMaker2024\fibre;

// Page object
$CustomizedMessageView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fcustomized_messageview" id="fcustomized_messageview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customized_message: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fcustomized_messageview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomized_messageview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_customized_message_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <tr id="r_reference"<?= $Page->reference->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_reference"><?= $Page->reference->caption() ?></span></td>
        <td data-name="reference"<?= $Page->reference->cellAttributes() ?>>
<span id="el_customized_message_reference">
<span<?= $Page->reference->viewAttributes() ?>>
<?= $Page->reference->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->message_type->Visible) { // message_type ?>
    <tr id="r_message_type"<?= $Page->message_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_message_type"><?= $Page->message_type->caption() ?></span></td>
        <td data-name="message_type"<?= $Page->message_type->cellAttributes() ?>>
<span id="el_customized_message_message_type">
<span<?= $Page->message_type->viewAttributes() ?>>
<?= $Page->message_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->wa_type->Visible) { // wa_type ?>
    <tr id="r_wa_type"<?= $Page->wa_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_wa_type"><?= $Page->wa_type->caption() ?></span></td>
        <td data-name="wa_type"<?= $Page->wa_type->cellAttributes() ?>>
<span id="el_customized_message_wa_type">
<span<?= $Page->wa_type->viewAttributes() ?>>
<?= $Page->wa_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->wa_id->Visible) { // wa_id ?>
    <tr id="r_wa_id"<?= $Page->wa_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_wa_id"><?= $Page->wa_id->caption() ?></span></td>
        <td data-name="wa_id"<?= $Page->wa_id->cellAttributes() ?>>
<span id="el_customized_message_wa_id">
<span<?= $Page->wa_id->viewAttributes() ?>>
<?= $Page->wa_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->mobile_no->Visible) { // mobile_no ?>
    <tr id="r_mobile_no"<?= $Page->mobile_no->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_mobile_no"><?= $Page->mobile_no->caption() ?></span></td>
        <td data-name="mobile_no"<?= $Page->mobile_no->cellAttributes() ?>>
<span id="el_customized_message_mobile_no">
<span<?= $Page->mobile_no->viewAttributes() ?>>
<?= $Page->mobile_no->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <tr id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message__email"><?= $Page->_email->caption() ?></span></td>
        <td data-name="_email"<?= $Page->_email->cellAttributes() ?>>
<span id="el_customized_message__email">
<span<?= $Page->_email->viewAttributes() ?>>
<?= $Page->_email->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->subject->Visible) { // subject ?>
    <tr id="r_subject"<?= $Page->subject->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_subject"><?= $Page->subject->caption() ?></span></td>
        <td data-name="subject"<?= $Page->subject->cellAttributes() ?>>
<span id="el_customized_message_subject">
<span<?= $Page->subject->viewAttributes() ?>>
<?= $Page->subject->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->_message->Visible) { // message ?>
    <tr id="r__message"<?= $Page->_message->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message__message"><?= $Page->_message->caption() ?></span></td>
        <td data-name="_message"<?= $Page->_message->cellAttributes() ?>>
<span id="el_customized_message__message">
<span<?= $Page->_message->viewAttributes() ?>>
<?= $Page->_message->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->_sms->Visible) { // sms ?>
    <tr id="r__sms"<?= $Page->_sms->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message__sms"><?= $Page->_sms->caption() ?></span></td>
        <td data-name="_sms"<?= $Page->_sms->cellAttributes() ?>>
<span id="el_customized_message__sms">
<span<?= $Page->_sms->viewAttributes() ?>>
<?= $Page->_sms->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <tr id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_uploads"><?= $Page->uploads->caption() ?></span></td>
        <td data-name="uploads"<?= $Page->uploads->cellAttributes() ?>>
<span id="el_customized_message_uploads">
<span<?= $Page->uploads->viewAttributes() ?>>
<?= GetFileViewTag($Page->uploads, $Page->uploads->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_type->Visible) { // b_type ?>
    <tr id="r_b_type"<?= $Page->b_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_b_type"><?= $Page->b_type->caption() ?></span></td>
        <td data-name="b_type"<?= $Page->b_type->cellAttributes() ?>>
<span id="el_customized_message_b_type">
<span<?= $Page->b_type->viewAttributes() ?>>
<?= $Page->b_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_1->Visible) { // b_1 ?>
    <tr id="r_b_1"<?= $Page->b_1->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_b_1"><?= $Page->b_1->caption() ?></span></td>
        <td data-name="b_1"<?= $Page->b_1->cellAttributes() ?>>
<span id="el_customized_message_b_1">
<span<?= $Page->b_1->viewAttributes() ?>>
<?= $Page->b_1->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_2->Visible) { // b_2 ?>
    <tr id="r_b_2"<?= $Page->b_2->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_b_2"><?= $Page->b_2->caption() ?></span></td>
        <td data-name="b_2"<?= $Page->b_2->cellAttributes() ?>>
<span id="el_customized_message_b_2">
<span<?= $Page->b_2->viewAttributes() ?>>
<?= $Page->b_2->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_3->Visible) { // b_3 ?>
    <tr id="r_b_3"<?= $Page->b_3->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_b_3"><?= $Page->b_3->caption() ?></span></td>
        <td data-name="b_3"<?= $Page->b_3->cellAttributes() ?>>
<span id="el_customized_message_b_3">
<span<?= $Page->b_3->viewAttributes() ?>>
<?= $Page->b_3->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_customized_message_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_customized_message_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_customized_message_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
