<?php

namespace PHPMaker2024\fibre;

// Page object
$CustomizedMessageSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customized_message: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcustomized_messagesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcustomized_messagesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["reference", [], fields.reference.isInvalid],
            ["message_type", [], fields.message_type.isInvalid],
            ["wa_type", [], fields.wa_type.isInvalid],
            ["wa_id", [], fields.wa_id.isInvalid],
            ["mobile_no", [], fields.mobile_no.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["subject", [], fields.subject.isInvalid],
            ["_message", [], fields._message.isInvalid],
            ["_sms", [], fields._sms.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["b_type", [], fields.b_type.isInvalid],
            ["b_1", [], fields.b_1.isInvalid],
            ["b_2", [], fields.b_2.isInvalid],
            ["b_3", [], fields.b_3.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "message_type": <?= $Page->message_type->toClientList($Page) ?>,
            "wa_type": <?= $Page->wa_type->toClientList($Page) ?>,
            "wa_id": <?= $Page->wa_id->toClientList($Page) ?>,
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcustomized_messagesearch" id="fcustomized_messagesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="customized_message" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference" class="row"<?= $Page->reference->rowAttributes() ?>>
        <label for="x_reference" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_reference"><?= $Page->reference->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reference" id="z_reference" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_reference" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="customized_message" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->message_type->Visible) { // message_type ?>
    <div id="r_message_type" class="row"<?= $Page->message_type->rowAttributes() ?>>
        <label for="x_message_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_message_type"><?= $Page->message_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_message_type" id="z_message_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->message_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_message_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_message_type"
        name="x_message_type"
        class="form-select ew-select<?= $Page->message_type->isInvalidClass() ?>"
        <?php if (!$Page->message_type->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messagesearch_x_message_type"
        <?php } ?>
        data-table="customized_message"
        data-field="x_message_type"
        data-value-separator="<?= $Page->message_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->message_type->getPlaceHolder()) ?>"
        <?= $Page->message_type->editAttributes() ?>>
        <?= $Page->message_type->selectOptionListHtml("x_message_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->message_type->getErrorMessage(false) ?></div>
<?= $Page->message_type->Lookup->getParamTag($Page, "p_x_message_type") ?>
<?php if (!$Page->message_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messagesearch", function() {
    var options = { name: "x_message_type", selectId: "fcustomized_messagesearch_x_message_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messagesearch.lists.message_type?.lookupOptions.length) {
        options.data = { id: "x_message_type", form: "fcustomized_messagesearch" };
    } else {
        options.ajax = { id: "x_message_type", form: "fcustomized_messagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.message_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_type->Visible) { // wa_type ?>
    <div id="r_wa_type" class="row"<?= $Page->wa_type->rowAttributes() ?>>
        <label for="x_wa_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_wa_type"><?= $Page->wa_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_type" id="z_wa_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_wa_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_type"
        name="x_wa_type"
        class="form-select ew-select<?= $Page->wa_type->isInvalidClass() ?>"
        <?php if (!$Page->wa_type->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messagesearch_x_wa_type"
        <?php } ?>
        data-table="customized_message"
        data-field="x_wa_type"
        data-value-separator="<?= $Page->wa_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_type->getPlaceHolder()) ?>"
        <?= $Page->wa_type->editAttributes() ?>>
        <?= $Page->wa_type->selectOptionListHtml("x_wa_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_type->getErrorMessage(false) ?></div>
<?= $Page->wa_type->Lookup->getParamTag($Page, "p_x_wa_type") ?>
<?php if (!$Page->wa_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messagesearch", function() {
    var options = { name: "x_wa_type", selectId: "fcustomized_messagesearch_x_wa_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messagesearch.lists.wa_type?.lookupOptions.length) {
        options.data = { id: "x_wa_type", form: "fcustomized_messagesearch" };
    } else {
        options.ajax = { id: "x_wa_type", form: "fcustomized_messagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.wa_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->wa_id->Visible) { // wa_id ?>
    <div id="r_wa_id" class="row"<?= $Page->wa_id->rowAttributes() ?>>
        <label for="x_wa_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_wa_id"><?= $Page->wa_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_wa_id" id="z_wa_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->wa_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_wa_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_wa_id"
        name="x_wa_id"
        class="form-select ew-select<?= $Page->wa_id->isInvalidClass() ?>"
        <?php if (!$Page->wa_id->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messagesearch_x_wa_id"
        <?php } ?>
        data-table="customized_message"
        data-field="x_wa_id"
        data-value-separator="<?= $Page->wa_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_id->getPlaceHolder()) ?>"
        <?= $Page->wa_id->editAttributes() ?>>
        <?= $Page->wa_id->selectOptionListHtml("x_wa_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->wa_id->getErrorMessage(false) ?></div>
<?= $Page->wa_id->Lookup->getParamTag($Page, "p_x_wa_id") ?>
<?php if (!$Page->wa_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messagesearch", function() {
    var options = { name: "x_wa_id", selectId: "fcustomized_messagesearch_x_wa_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messagesearch.lists.wa_id?.lookupOptions.length) {
        options.data = { id: "x_wa_id", form: "fcustomized_messagesearch" };
    } else {
        options.ajax = { id: "x_wa_id", form: "fcustomized_messagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.wa_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_no->Visible) { // mobile_no ?>
    <div id="r_mobile_no" class="row"<?= $Page->mobile_no->rowAttributes() ?>>
        <label for="x_mobile_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_mobile_no"><?= $Page->mobile_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_no" id="z_mobile_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_mobile_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_no->getInputTextType() ?>" name="x_mobile_no" id="x_mobile_no" data-table="customized_message" data-field="x_mobile_no" value="<?= $Page->mobile_no->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->mobile_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_no->formatPattern()) ?>"<?= $Page->mobile_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="customized_message" data-field="x__email" value="<?= $Page->_email->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->subject->Visible) { // subject ?>
    <div id="r_subject" class="row"<?= $Page->subject->rowAttributes() ?>>
        <label for="x_subject" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_subject"><?= $Page->subject->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_subject" id="z_subject" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->subject->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_subject" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->subject->getInputTextType() ?>" name="x_subject" id="x_subject" data-table="customized_message" data-field="x_subject" value="<?= $Page->subject->EditValue ?>" maxlength="150" placeholder="<?= HtmlEncode($Page->subject->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->subject->formatPattern()) ?>"<?= $Page->subject->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->subject->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_message->Visible) { // message ?>
    <div id="r__message" class="row"<?= $Page->_message->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message__message"><?= $Page->_message->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__message" id="z__message" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_message->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message__message" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_message->getInputTextType() ?>" name="x__message" id="x__message" data-table="customized_message" data-field="x__message" value="<?= $Page->_message->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->_message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_message->formatPattern()) ?>"<?= $Page->_message->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_message->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_sms->Visible) { // sms ?>
    <div id="r__sms" class="row"<?= $Page->_sms->rowAttributes() ?>>
        <label for="x__sms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message__sms"><?= $Page->_sms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__sms" id="z__sms" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_sms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message__sms" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_sms->getInputTextType() ?>" name="x__sms" id="x__sms" data-table="customized_message" data-field="x__sms" value="<?= $Page->_sms->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->_sms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_sms->formatPattern()) ?>"<?= $Page->_sms->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_sms->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="customized_message" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" maxlength="1000" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_type->Visible) { // b_type ?>
    <div id="r_b_type" class="row"<?= $Page->b_type->rowAttributes() ?>>
        <label for="x_b_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_b_type"><?= $Page->b_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_type" id="z_b_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_b_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_b_type"
        name="x_b_type"
        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
        <?php if (!$Page->b_type->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messagesearch_x_b_type"
        <?php } ?>
        data-table="customized_message"
        data-field="x_b_type"
        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
        <?= $Page->b_type->editAttributes() ?>>
        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage(false) ?></div>
<?php if (!$Page->b_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messagesearch", function() {
    var options = { name: "x_b_type", selectId: "fcustomized_messagesearch_x_b_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messagesearch.lists.b_type?.lookupOptions.length) {
        options.data = { id: "x_b_type", form: "fcustomized_messagesearch" };
    } else {
        options.ajax = { id: "x_b_type", form: "fcustomized_messagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.b_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_1->Visible) { // b_1 ?>
    <div id="r_b_1" class="row"<?= $Page->b_1->rowAttributes() ?>>
        <label for="x_b_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_b_1"><?= $Page->b_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_1" id="z_b_1" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_b_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_1->getInputTextType() ?>" name="x_b_1" id="x_b_1" data-table="customized_message" data-field="x_b_1" value="<?= $Page->b_1->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->b_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_1->formatPattern()) ?>"<?= $Page->b_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_2->Visible) { // b_2 ?>
    <div id="r_b_2" class="row"<?= $Page->b_2->rowAttributes() ?>>
        <label for="x_b_2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_b_2"><?= $Page->b_2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_2" id="z_b_2" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_b_2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_2->getInputTextType() ?>" name="x_b_2" id="x_b_2" data-table="customized_message" data-field="x_b_2" value="<?= $Page->b_2->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->b_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_2->formatPattern()) ?>"<?= $Page->b_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_3->Visible) { // b_3 ?>
    <div id="r_b_3" class="row"<?= $Page->b_3->rowAttributes() ?>>
        <label for="x_b_3" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_b_3"><?= $Page->b_3->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_3" id="z_b_3" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_3->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_b_3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_3->getInputTextType() ?>" name="x_b_3" id="x_b_3" data-table="customized_message" data-field="x_b_3" value="<?= $Page->b_3->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->b_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_3->formatPattern()) ?>"<?= $Page->b_3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_3->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="customized_message" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcustomized_messagesearch", function() {
    fcustomized_messagesearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.customized_message.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_customized_message_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_customized_message_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="customized_message" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcustomized_messagesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcustomized_messagesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcustomized_messagesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcustomized_messagesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fcustomized_messagesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("customized_message");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
