<?php

namespace PHPMaker2024\fibre;

// Page object
$CustomizedMessageAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { customized_message: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fcustomized_messageadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcustomized_messageadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["message_type", [fields.message_type.visible && fields.message_type.required ? ew.Validators.required(fields.message_type.caption) : null], fields.message_type.isInvalid],
            ["wa_type", [fields.wa_type.visible && fields.wa_type.required ? ew.Validators.required(fields.wa_type.caption) : null], fields.wa_type.isInvalid],
            ["wa_id", [fields.wa_id.visible && fields.wa_id.required ? ew.Validators.required(fields.wa_id.caption) : null], fields.wa_id.isInvalid],
            ["mobile_no", [fields.mobile_no.visible && fields.mobile_no.required ? ew.Validators.required(fields.mobile_no.caption) : null], fields.mobile_no.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null, ew.Validators.email], fields._email.isInvalid],
            ["subject", [fields.subject.visible && fields.subject.required ? ew.Validators.required(fields.subject.caption) : null], fields.subject.isInvalid],
            ["_message", [fields._message.visible && fields._message.required ? ew.Validators.required(fields._message.caption) : null], fields._message.isInvalid],
            ["_sms", [fields._sms.visible && fields._sms.required ? ew.Validators.required(fields._sms.caption) : null], fields._sms.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["b_type", [fields.b_type.visible && fields.b_type.required ? ew.Validators.required(fields.b_type.caption) : null], fields.b_type.isInvalid],
            ["b_1", [fields.b_1.visible && fields.b_1.required ? ew.Validators.required(fields.b_1.caption) : null], fields.b_1.isInvalid],
            ["b_2", [fields.b_2.visible && fields.b_2.required ? ew.Validators.required(fields.b_2.caption) : null], fields.b_2.isInvalid],
            ["b_3", [fields.b_3.visible && fields.b_3.required ? ew.Validators.required(fields.b_3.caption) : null], fields.b_3.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "message_type": <?= $Page->message_type->toClientList($Page) ?>,
            "wa_type": <?= $Page->wa_type->toClientList($Page) ?>,
            "wa_id": <?= $Page->wa_id->toClientList($Page) ?>,
            "b_type": <?= $Page->b_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcustomized_messageadd" id="fcustomized_messageadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference"<?= $Page->reference->rowAttributes() ?>>
        <label id="elh_customized_message_reference" for="x_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference->caption() ?><?= $Page->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference->cellAttributes() ?>>
<span id="el_customized_message_reference">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="customized_message" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?> aria-describedby="x_reference_help">
<?= $Page->reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->message_type->Visible) { // message_type ?>
    <div id="r_message_type"<?= $Page->message_type->rowAttributes() ?>>
        <label id="elh_customized_message_message_type" for="x_message_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->message_type->caption() ?><?= $Page->message_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->message_type->cellAttributes() ?>>
<span id="el_customized_message_message_type">
    <select
        id="x_message_type"
        name="x_message_type"
        class="form-select ew-select<?= $Page->message_type->isInvalidClass() ?>"
        <?php if (!$Page->message_type->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messageadd_x_message_type"
        <?php } ?>
        data-table="customized_message"
        data-field="x_message_type"
        data-value-separator="<?= $Page->message_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->message_type->getPlaceHolder()) ?>"
        <?= $Page->message_type->editAttributes() ?>>
        <?= $Page->message_type->selectOptionListHtml("x_message_type") ?>
    </select>
    <?= $Page->message_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->message_type->getErrorMessage() ?></div>
<?= $Page->message_type->Lookup->getParamTag($Page, "p_x_message_type") ?>
<?php if (!$Page->message_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messageadd", function() {
    var options = { name: "x_message_type", selectId: "fcustomized_messageadd_x_message_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messageadd.lists.message_type?.lookupOptions.length) {
        options.data = { id: "x_message_type", form: "fcustomized_messageadd" };
    } else {
        options.ajax = { id: "x_message_type", form: "fcustomized_messageadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.message_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->wa_type->Visible) { // wa_type ?>
    <div id="r_wa_type"<?= $Page->wa_type->rowAttributes() ?>>
        <label id="elh_customized_message_wa_type" for="x_wa_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->wa_type->caption() ?><?= $Page->wa_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->wa_type->cellAttributes() ?>>
<span id="el_customized_message_wa_type">
    <select
        id="x_wa_type"
        name="x_wa_type"
        class="form-select ew-select<?= $Page->wa_type->isInvalidClass() ?>"
        <?php if (!$Page->wa_type->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messageadd_x_wa_type"
        <?php } ?>
        data-table="customized_message"
        data-field="x_wa_type"
        data-value-separator="<?= $Page->wa_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_type->getPlaceHolder()) ?>"
        <?= $Page->wa_type->editAttributes() ?>>
        <?= $Page->wa_type->selectOptionListHtml("x_wa_type") ?>
    </select>
    <?= $Page->wa_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->wa_type->getErrorMessage() ?></div>
<?= $Page->wa_type->Lookup->getParamTag($Page, "p_x_wa_type") ?>
<?php if (!$Page->wa_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messageadd", function() {
    var options = { name: "x_wa_type", selectId: "fcustomized_messageadd_x_wa_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messageadd.lists.wa_type?.lookupOptions.length) {
        options.data = { id: "x_wa_type", form: "fcustomized_messageadd" };
    } else {
        options.ajax = { id: "x_wa_type", form: "fcustomized_messageadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.wa_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->wa_id->Visible) { // wa_id ?>
    <div id="r_wa_id"<?= $Page->wa_id->rowAttributes() ?>>
        <label id="elh_customized_message_wa_id" for="x_wa_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->wa_id->caption() ?><?= $Page->wa_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->wa_id->cellAttributes() ?>>
<span id="el_customized_message_wa_id">
    <select
        id="x_wa_id"
        name="x_wa_id"
        class="form-select ew-select<?= $Page->wa_id->isInvalidClass() ?>"
        <?php if (!$Page->wa_id->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messageadd_x_wa_id"
        <?php } ?>
        data-table="customized_message"
        data-field="x_wa_id"
        data-value-separator="<?= $Page->wa_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->wa_id->getPlaceHolder()) ?>"
        <?= $Page->wa_id->editAttributes() ?>>
        <?= $Page->wa_id->selectOptionListHtml("x_wa_id") ?>
    </select>
    <?= $Page->wa_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->wa_id->getErrorMessage() ?></div>
<?= $Page->wa_id->Lookup->getParamTag($Page, "p_x_wa_id") ?>
<?php if (!$Page->wa_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messageadd", function() {
    var options = { name: "x_wa_id", selectId: "fcustomized_messageadd_x_wa_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messageadd.lists.wa_id?.lookupOptions.length) {
        options.data = { id: "x_wa_id", form: "fcustomized_messageadd" };
    } else {
        options.ajax = { id: "x_wa_id", form: "fcustomized_messageadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.wa_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_no->Visible) { // mobile_no ?>
    <div id="r_mobile_no"<?= $Page->mobile_no->rowAttributes() ?>>
        <label id="elh_customized_message_mobile_no" for="x_mobile_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_no->caption() ?><?= $Page->mobile_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_no->cellAttributes() ?>>
<span id="el_customized_message_mobile_no">
<input type="<?= $Page->mobile_no->getInputTextType() ?>" name="x_mobile_no" id="x_mobile_no" data-table="customized_message" data-field="x_mobile_no" value="<?= $Page->mobile_no->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->mobile_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_no->formatPattern()) ?>"<?= $Page->mobile_no->editAttributes() ?> aria-describedby="x_mobile_no_help">
<?= $Page->mobile_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_customized_message__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_customized_message__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="customized_message" data-field="x__email" value="<?= $Page->_email->EditValue ?>" maxlength="65535" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->subject->Visible) { // subject ?>
    <div id="r_subject"<?= $Page->subject->rowAttributes() ?>>
        <label id="elh_customized_message_subject" for="x_subject" class="<?= $Page->LeftColumnClass ?>"><?= $Page->subject->caption() ?><?= $Page->subject->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->subject->cellAttributes() ?>>
<span id="el_customized_message_subject">
<textarea data-table="customized_message" data-field="x_subject" name="x_subject" id="x_subject" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->subject->getPlaceHolder()) ?>"<?= $Page->subject->editAttributes() ?> aria-describedby="x_subject_help"><?= $Page->subject->EditValue ?></textarea>
<?= $Page->subject->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->subject->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_message->Visible) { // message ?>
    <div id="r__message"<?= $Page->_message->rowAttributes() ?>>
        <label id="elh_customized_message__message" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_message->caption() ?><?= $Page->_message->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_message->cellAttributes() ?>>
<span id="el_customized_message__message">
<?php $Page->_message->EditAttrs->appendClass("editor"); ?>
<textarea data-table="customized_message" data-field="x__message" name="x__message" id="x__message" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_message->getPlaceHolder()) ?>"<?= $Page->_message->editAttributes() ?> aria-describedby="x__message_help"><?= $Page->_message->EditValue ?></textarea>
<?= $Page->_message->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_message->getErrorMessage() ?></div>
<script>
loadjs.ready(["fcustomized_messageadd", "editor"], function() {
    ew.createEditor("fcustomized_messageadd", "x__message", 0, 0, <?= $Page->_message->ReadOnly || false ? "true" : "false" ?>);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_sms->Visible) { // sms ?>
    <div id="r__sms"<?= $Page->_sms->rowAttributes() ?>>
        <label id="elh_customized_message__sms" for="x__sms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_sms->caption() ?><?= $Page->_sms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_sms->cellAttributes() ?>>
<span id="el_customized_message__sms">
<textarea data-table="customized_message" data-field="x__sms" name="x__sms" id="x__sms" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_sms->getPlaceHolder()) ?>"<?= $Page->_sms->editAttributes() ?> aria-describedby="x__sms_help"><?= $Page->_sms->EditValue ?></textarea>
<?= $Page->_sms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_sms->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_customized_message_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_customized_message_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="customized_message"
        data-field="x_uploads"
        data-size="1000"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_type->Visible) { // b_type ?>
    <div id="r_b_type"<?= $Page->b_type->rowAttributes() ?>>
        <label id="elh_customized_message_b_type" for="x_b_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_type->caption() ?><?= $Page->b_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_type->cellAttributes() ?>>
<span id="el_customized_message_b_type">
    <select
        id="x_b_type"
        name="x_b_type"
        class="form-select ew-select<?= $Page->b_type->isInvalidClass() ?>"
        <?php if (!$Page->b_type->IsNativeSelect) { ?>
        data-select2-id="fcustomized_messageadd_x_b_type"
        <?php } ?>
        data-table="customized_message"
        data-field="x_b_type"
        data-value-separator="<?= $Page->b_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->b_type->getPlaceHolder()) ?>"
        <?= $Page->b_type->editAttributes() ?>>
        <?= $Page->b_type->selectOptionListHtml("x_b_type") ?>
    </select>
    <?= $Page->b_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->b_type->getErrorMessage() ?></div>
<?php if (!$Page->b_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcustomized_messageadd", function() {
    var options = { name: "x_b_type", selectId: "fcustomized_messageadd_x_b_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcustomized_messageadd.lists.b_type?.lookupOptions.length) {
        options.data = { id: "x_b_type", form: "fcustomized_messageadd" };
    } else {
        options.ajax = { id: "x_b_type", form: "fcustomized_messageadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.customized_message.fields.b_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_1->Visible) { // b_1 ?>
    <div id="r_b_1"<?= $Page->b_1->rowAttributes() ?>>
        <label id="elh_customized_message_b_1" for="x_b_1" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_1->caption() ?><?= $Page->b_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_1->cellAttributes() ?>>
<span id="el_customized_message_b_1">
<input type="<?= $Page->b_1->getInputTextType() ?>" name="x_b_1" id="x_b_1" data-table="customized_message" data-field="x_b_1" value="<?= $Page->b_1->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->b_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_1->formatPattern()) ?>"<?= $Page->b_1->editAttributes() ?> aria-describedby="x_b_1_help">
<?= $Page->b_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->b_1->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_2->Visible) { // b_2 ?>
    <div id="r_b_2"<?= $Page->b_2->rowAttributes() ?>>
        <label id="elh_customized_message_b_2" for="x_b_2" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_2->caption() ?><?= $Page->b_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_2->cellAttributes() ?>>
<span id="el_customized_message_b_2">
<input type="<?= $Page->b_2->getInputTextType() ?>" name="x_b_2" id="x_b_2" data-table="customized_message" data-field="x_b_2" value="<?= $Page->b_2->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->b_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_2->formatPattern()) ?>"<?= $Page->b_2->editAttributes() ?> aria-describedby="x_b_2_help">
<?= $Page->b_2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->b_2->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->b_3->Visible) { // b_3 ?>
    <div id="r_b_3"<?= $Page->b_3->rowAttributes() ?>>
        <label id="elh_customized_message_b_3" for="x_b_3" class="<?= $Page->LeftColumnClass ?>"><?= $Page->b_3->caption() ?><?= $Page->b_3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->b_3->cellAttributes() ?>>
<span id="el_customized_message_b_3">
<input type="<?= $Page->b_3->getInputTextType() ?>" name="x_b_3" id="x_b_3" data-table="customized_message" data-field="x_b_3" value="<?= $Page->b_3->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->b_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_3->formatPattern()) ?>"<?= $Page->b_3->editAttributes() ?> aria-describedby="x_b_3_help">
<?= $Page->b_3->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->b_3->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcustomized_messageadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcustomized_messageadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("customized_message");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    	$("#r_mobile_no").hide();
    	$("#r_sms").hide();
    	$("#r_uploads").hide();		
    	$("#r__email").show();		
    	$("#r_subject").show();		
    	$("#r_message").show();
    	$("#r_wa_id").hide();		
    	$("#r_wa_type").hide();		
    	$("#r_b_type").hide();
    	$("#r_b_1").hide();
    	$("#r_b_2").hide();
    	$("#r_b_3").hide();
    	$("#r_b_4").hide();
});
</script>
