<?php

namespace PHPMaker2024\fibre;

// Page object
$CurrencyEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fcurrencyedit" id="fcurrencyedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { currency: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fcurrencyedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcurrencyedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["symbol", [fields.symbol.visible && fields.symbol.required ? ew.Validators.required(fields.symbol.caption) : null], fields.symbol.isInvalid],
            ["default_currency", [fields.default_currency.visible && fields.default_currency.required ? ew.Validators.required(fields.default_currency.caption) : null], fields.default_currency.isInvalid],
            ["exchange_inr", [fields.exchange_inr.visible && fields.exchange_inr.required ? ew.Validators.required(fields.exchange_inr.caption) : null, ew.Validators.float], fields.exchange_inr.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "default_currency": <?= $Page->default_currency->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="currency">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_currency_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_currency_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="currency" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_currency_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_currency_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="currency" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label id="elh_currency_code" for="x_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->code->cellAttributes() ?>>
<span id="el_currency_code">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="currency" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_currency_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_currency_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fcurrencyedit_x_status"
        <?php } ?>
        data-table="currency"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fcurrencyedit", function() {
    var options = { name: "x_status", selectId: "fcurrencyedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcurrencyedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fcurrencyedit" };
    } else {
        options.ajax = { id: "x_status", form: "fcurrencyedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.currency.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->symbol->Visible) { // symbol ?>
    <div id="r_symbol"<?= $Page->symbol->rowAttributes() ?>>
        <label id="elh_currency_symbol" for="x_symbol" class="<?= $Page->LeftColumnClass ?>"><?= $Page->symbol->caption() ?><?= $Page->symbol->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->symbol->cellAttributes() ?>>
<span id="el_currency_symbol">
<input type="<?= $Page->symbol->getInputTextType() ?>" name="x_symbol" id="x_symbol" data-table="currency" data-field="x_symbol" value="<?= $Page->symbol->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->symbol->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->symbol->formatPattern()) ?>"<?= $Page->symbol->editAttributes() ?> aria-describedby="x_symbol_help">
<?= $Page->symbol->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->symbol->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->default_currency->Visible) { // default_currency ?>
    <div id="r_default_currency"<?= $Page->default_currency->rowAttributes() ?>>
        <label id="elh_currency_default_currency" for="x_default_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->default_currency->caption() ?><?= $Page->default_currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->default_currency->cellAttributes() ?>>
<span id="el_currency_default_currency">
    <select
        id="x_default_currency"
        name="x_default_currency"
        class="form-select ew-select<?= $Page->default_currency->isInvalidClass() ?>"
        <?php if (!$Page->default_currency->IsNativeSelect) { ?>
        data-select2-id="fcurrencyedit_x_default_currency"
        <?php } ?>
        data-table="currency"
        data-field="x_default_currency"
        data-value-separator="<?= $Page->default_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->default_currency->getPlaceHolder()) ?>"
        <?= $Page->default_currency->editAttributes() ?>>
        <?= $Page->default_currency->selectOptionListHtml("x_default_currency") ?>
    </select>
    <?= $Page->default_currency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->default_currency->getErrorMessage() ?></div>
<?php if (!$Page->default_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fcurrencyedit", function() {
    var options = { name: "x_default_currency", selectId: "fcurrencyedit_x_default_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcurrencyedit.lists.default_currency?.lookupOptions.length) {
        options.data = { id: "x_default_currency", form: "fcurrencyedit" };
    } else {
        options.ajax = { id: "x_default_currency", form: "fcurrencyedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.currency.fields.default_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->exchange_inr->Visible) { // exchange_inr ?>
    <div id="r_exchange_inr"<?= $Page->exchange_inr->rowAttributes() ?>>
        <label id="elh_currency_exchange_inr" for="x_exchange_inr" class="<?= $Page->LeftColumnClass ?>"><?= $Page->exchange_inr->caption() ?><?= $Page->exchange_inr->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->exchange_inr->cellAttributes() ?>>
<span id="el_currency_exchange_inr">
<input type="<?= $Page->exchange_inr->getInputTextType() ?>" name="x_exchange_inr" id="x_exchange_inr" data-table="currency" data-field="x_exchange_inr" value="<?= $Page->exchange_inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->exchange_inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->exchange_inr->formatPattern()) ?>"<?= $Page->exchange_inr->editAttributes() ?> aria-describedby="x_exchange_inr_help">
<?= $Page->exchange_inr->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->exchange_inr->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcurrencyedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcurrencyedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("currency");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
