<?php

namespace PHPMaker2024\fibre;

// Page object
$CurrencyAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { currency: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fcurrencyaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcurrencyaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["symbol", [fields.symbol.visible && fields.symbol.required ? ew.Validators.required(fields.symbol.caption) : null], fields.symbol.isInvalid],
            ["default_currency", [fields.default_currency.visible && fields.default_currency.required ? ew.Validators.required(fields.default_currency.caption) : null], fields.default_currency.isInvalid],
            ["exchange_inr", [fields.exchange_inr.visible && fields.exchange_inr.required ? ew.Validators.required(fields.exchange_inr.caption) : null, ew.Validators.float], fields.exchange_inr.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "default_currency": <?= $Page->default_currency->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fcurrencyaddopt" id="fcurrencyaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="currency">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_name"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->name->cellAttributes() ?>>
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="currency" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_code"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->code->cellAttributes() ?>>
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="currency" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fcurrencyaddopt_x_status"
        <?php } ?>
        data-table="currency"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fcurrencyaddopt", function() {
    var options = { name: "x_status", selectId: "fcurrencyaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcurrencyaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fcurrencyaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "fcurrencyaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.currency.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="currency" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="currency" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->symbol->Visible) { // symbol ?>
    <div id="r_symbol"<?= $Page->symbol->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_symbol"><?= $Page->symbol->caption() ?><?= $Page->symbol->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->symbol->cellAttributes() ?>>
<input type="<?= $Page->symbol->getInputTextType() ?>" name="x_symbol" id="x_symbol" data-table="currency" data-field="x_symbol" value="<?= $Page->symbol->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->symbol->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->symbol->formatPattern()) ?>"<?= $Page->symbol->editAttributes() ?> aria-describedby="x_symbol_help">
<?= $Page->symbol->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->symbol->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->default_currency->Visible) { // default_currency ?>
    <div id="r_default_currency"<?= $Page->default_currency->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_default_currency"><?= $Page->default_currency->caption() ?><?= $Page->default_currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->default_currency->cellAttributes() ?>>
    <select
        id="x_default_currency"
        name="x_default_currency"
        class="form-select ew-select<?= $Page->default_currency->isInvalidClass() ?>"
        <?php if (!$Page->default_currency->IsNativeSelect) { ?>
        data-select2-id="fcurrencyaddopt_x_default_currency"
        <?php } ?>
        data-table="currency"
        data-field="x_default_currency"
        data-value-separator="<?= $Page->default_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->default_currency->getPlaceHolder()) ?>"
        <?= $Page->default_currency->editAttributes() ?>>
        <?= $Page->default_currency->selectOptionListHtml("x_default_currency") ?>
    </select>
    <?= $Page->default_currency->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->default_currency->getErrorMessage() ?></div>
<?php if (!$Page->default_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fcurrencyaddopt", function() {
    var options = { name: "x_default_currency", selectId: "fcurrencyaddopt_x_default_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcurrencyaddopt.lists.default_currency?.lookupOptions.length) {
        options.data = { id: "x_default_currency", form: "fcurrencyaddopt" };
    } else {
        options.ajax = { id: "x_default_currency", form: "fcurrencyaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.currency.fields.default_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->exchange_inr->Visible) { // exchange_inr ?>
    <div id="r_exchange_inr"<?= $Page->exchange_inr->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_exchange_inr"><?= $Page->exchange_inr->caption() ?><?= $Page->exchange_inr->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->exchange_inr->cellAttributes() ?>>
<input type="<?= $Page->exchange_inr->getInputTextType() ?>" name="x_exchange_inr" id="x_exchange_inr" data-table="currency" data-field="x_exchange_inr" value="<?= $Page->exchange_inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->exchange_inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->exchange_inr->formatPattern()) ?>"<?= $Page->exchange_inr->editAttributes() ?> aria-describedby="x_exchange_inr_help">
<?= $Page->exchange_inr->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->exchange_inr->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("currency");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
