<?php

namespace PHPMaker2024\fibre;

// Page object
$CostCalculatorSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cost_calculator: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcost_calculatorsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcost_calculatorsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["price_inr", [ew.Validators.float], fields.price_inr.isInvalid],
            ["shape", [], fields.shape.isInvalid],
            ["w_cm", [ew.Validators.integer], fields.w_cm.isInvalid],
            ["l_cm", [ew.Validators.integer], fields.l_cm.isInvalid],
            ["bom_percent", [ew.Validators.float], fields.bom_percent.isInvalid],
            ["process_percent", [ew.Validators.float], fields.process_percent.isInvalid],
            ["other_sqm", [ew.Validators.float], fields.other_sqm.isInvalid],
            ["margin_percent", [ew.Validators.float], fields.margin_percent.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "shape": <?= $Page->shape->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcost_calculatorsearch" id="fcost_calculatorsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cost_calculator">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="cost_calculator" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsearch_x_buyer_id"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_buyer_id", selectId: "fcost_calculatorsearch_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fcost_calculatorsearch_x_rid"
        data-table="cost_calculator"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_rid", selectId: "fcost_calculatorsearch_x_rid" };
    if (fcost_calculatorsearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cost_calculator.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsearch_x_batch_no"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_batch_no", selectId: "fcost_calculatorsearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_inr->Visible) { // price_inr ?>
    <div id="r_price_inr" class="row"<?= $Page->price_inr->rowAttributes() ?>>
        <label for="x_price_inr" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_price_inr"><?= $Page->price_inr->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_inr" id="z_price_inr" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_inr->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_price_inr" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_inr->getInputTextType() ?>" name="x_price_inr" id="x_price_inr" data-table="cost_calculator" data-field="x_price_inr" value="<?= $Page->price_inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_inr->formatPattern()) ?>"<?= $Page->price_inr->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_inr->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <div id="r_shape" class="row"<?= $Page->shape->rowAttributes() ?>>
        <label for="x_shape" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_shape"><?= $Page->shape->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shape" id="z_shape" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shape->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_shape" class="ew-search-field ew-search-field-single">
    <select
        id="x_shape"
        name="x_shape"
        class="form-select ew-select<?= $Page->shape->isInvalidClass() ?>"
        <?php if (!$Page->shape->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsearch_x_shape"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_shape"
        data-value-separator="<?= $Page->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shape->getPlaceHolder()) ?>"
        <?= $Page->shape->editAttributes() ?>>
        <?= $Page->shape->selectOptionListHtml("x_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shape->getErrorMessage(false) ?></div>
<?= $Page->shape->Lookup->getParamTag($Page, "p_x_shape") ?>
<?php if (!$Page->shape->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_shape", selectId: "fcost_calculatorsearch_x_shape" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsearch.lists.shape?.lookupOptions.length) {
        options.data = { id: "x_shape", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_shape", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.shape.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm" class="row"<?= $Page->w_cm->rowAttributes() ?>>
        <label for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_w_cm"><?= $Page->w_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_w_cm" id="z_w_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="cost_calculator" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm" class="row"<?= $Page->l_cm->rowAttributes() ?>>
        <label for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_l_cm"><?= $Page->l_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_l_cm" id="z_l_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="cost_calculator" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bom_percent->Visible) { // bom_percent ?>
    <div id="r_bom_percent" class="row"<?= $Page->bom_percent->rowAttributes() ?>>
        <label for="x_bom_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_bom_percent"><?= $Page->bom_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_bom_percent" id="z_bom_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bom_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_bom_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bom_percent->getInputTextType() ?>" name="x_bom_percent" id="x_bom_percent" data-table="cost_calculator" data-field="x_bom_percent" value="<?= $Page->bom_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bom_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bom_percent->formatPattern()) ?>"<?= $Page->bom_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bom_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_percent->Visible) { // process_percent ?>
    <div id="r_process_percent" class="row"<?= $Page->process_percent->rowAttributes() ?>>
        <label for="x_process_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_process_percent"><?= $Page->process_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_process_percent" id="z_process_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_process_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->process_percent->getInputTextType() ?>" name="x_process_percent" id="x_process_percent" data-table="cost_calculator" data-field="x_process_percent" value="<?= $Page->process_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->process_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_percent->formatPattern()) ?>"<?= $Page->process_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_sqm->Visible) { // other_sqm ?>
    <div id="r_other_sqm" class="row"<?= $Page->other_sqm->rowAttributes() ?>>
        <label for="x_other_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_other_sqm"><?= $Page->other_sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_other_sqm" id="z_other_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_other_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_sqm->getInputTextType() ?>" name="x_other_sqm" id="x_other_sqm" data-table="cost_calculator" data-field="x_other_sqm" value="<?= $Page->other_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->other_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_sqm->formatPattern()) ?>"<?= $Page->other_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->margin_percent->Visible) { // margin_percent ?>
    <div id="r_margin_percent" class="row"<?= $Page->margin_percent->rowAttributes() ?>>
        <label for="x_margin_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_margin_percent"><?= $Page->margin_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_margin_percent" id="z_margin_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->margin_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_margin_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->margin_percent->getInputTextType() ?>" name="x_margin_percent" id="x_margin_percent" data-table="cost_calculator" data-field="x_margin_percent" value="<?= $Page->margin_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->margin_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->margin_percent->formatPattern()) ?>"<?= $Page->margin_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->margin_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="cost_calculator" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsearch_x_currency"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_currency", selectId: "fcost_calculatorsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="cost_calculator" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcost_calculatorsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcost_calculatorsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsearch_x_packing_type"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_packing_type", selectId: "fcost_calculatorsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsearch_x_operator"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsearch", function() {
    var options = { name: "x_operator", selectId: "fcost_calculatorsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fcost_calculatorsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fcost_calculatorsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="cost_calculator" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcost_calculatorsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcost_calculatorsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcost_calculatorsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcost_calculatorsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fcost_calculatorsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cost_calculator");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
