<?php

namespace PHPMaker2024\fibre;

// Page object
$CostCalculatorList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cost_calculator: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fcost_calculatorsrch" id="fcost_calculatorsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fcost_calculatorsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cost_calculator: currentTable } });
var currentForm;
var fcost_calculatorsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcost_calculatorsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["rid", [], fields.rid.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
<?php
if (!$Page->buyer_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_id" class="ew-search-caption ew-label"><?= $Page->buyer_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</div>
        </div>
        <div id="el_cost_calculator_buyer_id" class="ew-search-field">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fcost_calculatorsrch_x_buyer_id"
        <?php } ?>
        data-table="cost_calculator"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculatorsrch", function() {
    var options = { name: "x_buyer_id", selectId: "fcost_calculatorsrch_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculatorsrch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fcost_calculatorsrch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fcost_calculatorsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_rid" class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</div>
        </div>
        <div id="el_cost_calculator_rid" class="ew-search-field">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fcost_calculatorsrch_x_rid"
        data-table="cost_calculator"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fcost_calculatorsrch", function() {
    var options = { name: "x_rid", selectId: "fcost_calculatorsrch_x_rid" };
    if (fcost_calculatorsrch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fcost_calculatorsrch" };
    } else {
        options.ajax = { id: "x_rid", form: "fcost_calculatorsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.cost_calculator.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fcost_calculatorsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fcost_calculatorsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fcost_calculatorsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fcost_calculatorsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fcost_calculatorsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fcost_calculatorsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fcost_calculatorsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cost_calculator">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_cost_calculator" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_cost_calculatorlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <th data-name="buyer_id" class="<?= $Page->buyer_id->headerCellClass() ?>"><div id="elh_cost_calculator_buyer_id" class="cost_calculator_buyer_id"><?= $Page->renderFieldHeader($Page->buyer_id) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_cost_calculator_rid" class="cost_calculator_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_cost_calculator_batch_no" class="cost_calculator_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->price_inr->Visible) { // price_inr ?>
        <th data-name="price_inr" class="<?= $Page->price_inr->headerCellClass() ?>"><div id="elh_cost_calculator_price_inr" class="cost_calculator_price_inr"><?= $Page->renderFieldHeader($Page->price_inr) ?></div></th>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Page->shape->headerCellClass() ?>"><div id="elh_cost_calculator_shape" class="cost_calculator_shape"><?= $Page->renderFieldHeader($Page->shape) ?></div></th>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
        <th data-name="w_cm" class="<?= $Page->w_cm->headerCellClass() ?>"><div id="elh_cost_calculator_w_cm" class="cost_calculator_w_cm"><?= $Page->renderFieldHeader($Page->w_cm) ?></div></th>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
        <th data-name="l_cm" class="<?= $Page->l_cm->headerCellClass() ?>"><div id="elh_cost_calculator_l_cm" class="cost_calculator_l_cm"><?= $Page->renderFieldHeader($Page->l_cm) ?></div></th>
<?php } ?>
<?php if ($Page->bom_percent->Visible) { // bom_percent ?>
        <th data-name="bom_percent" class="<?= $Page->bom_percent->headerCellClass() ?>"><div id="elh_cost_calculator_bom_percent" class="cost_calculator_bom_percent"><?= $Page->renderFieldHeader($Page->bom_percent) ?></div></th>
<?php } ?>
<?php if ($Page->process_percent->Visible) { // process_percent ?>
        <th data-name="process_percent" class="<?= $Page->process_percent->headerCellClass() ?>"><div id="elh_cost_calculator_process_percent" class="cost_calculator_process_percent"><?= $Page->renderFieldHeader($Page->process_percent) ?></div></th>
<?php } ?>
<?php if ($Page->other_sqm->Visible) { // other_sqm ?>
        <th data-name="other_sqm" class="<?= $Page->other_sqm->headerCellClass() ?>"><div id="elh_cost_calculator_other_sqm" class="cost_calculator_other_sqm"><?= $Page->renderFieldHeader($Page->other_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->margin_percent->Visible) { // margin_percent ?>
        <th data-name="margin_percent" class="<?= $Page->margin_percent->headerCellClass() ?>"><div id="elh_cost_calculator_margin_percent" class="cost_calculator_margin_percent"><?= $Page->renderFieldHeader($Page->margin_percent) ?></div></th>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Page->price->headerCellClass() ?>"><div id="elh_cost_calculator_price" class="cost_calculator_price"><?= $Page->renderFieldHeader($Page->price) ?></div></th>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Page->currency->headerCellClass() ?>"><div id="elh_cost_calculator_currency" class="cost_calculator_currency"><?= $Page->renderFieldHeader($Page->currency) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_cost_calculator_dated" class="cost_calculator_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_cost_calculator_packing_type" class="cost_calculator_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->buyer_id->Visible) { // buyer_id ?>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_buyer_id" class="el_cost_calculator_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?= $Page->buyer_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_rid" class="el_cost_calculator_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_batch_no" class="el_cost_calculator_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->getViewValue()) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><?= $Page->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price_inr->Visible) { // price_inr ?>
        <td data-name="price_inr"<?= $Page->price_inr->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_price_inr" class="el_cost_calculator_price_inr">
<span<?= $Page->price_inr->viewAttributes() ?>>
<?php if (!EmptyString($Page->price_inr->getViewValue()) && $Page->price_inr->linkAttributes() != "") { ?>
<a<?= $Page->price_inr->linkAttributes() ?>><?= $Page->price_inr->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->price_inr->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_shape" class="el_cost_calculator_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->w_cm->Visible) { // w_cm ?>
        <td data-name="w_cm"<?= $Page->w_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_w_cm" class="el_cost_calculator_w_cm">
<span<?= $Page->w_cm->viewAttributes() ?>>
<?= $Page->w_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->l_cm->Visible) { // l_cm ?>
        <td data-name="l_cm"<?= $Page->l_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_l_cm" class="el_cost_calculator_l_cm">
<span<?= $Page->l_cm->viewAttributes() ?>>
<?= $Page->l_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bom_percent->Visible) { // bom_percent ?>
        <td data-name="bom_percent"<?= $Page->bom_percent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_bom_percent" class="el_cost_calculator_bom_percent">
<span<?= $Page->bom_percent->viewAttributes() ?>>
<?= $Page->bom_percent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_percent->Visible) { // process_percent ?>
        <td data-name="process_percent"<?= $Page->process_percent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_process_percent" class="el_cost_calculator_process_percent">
<span<?= $Page->process_percent->viewAttributes() ?>>
<?= $Page->process_percent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->other_sqm->Visible) { // other_sqm ?>
        <td data-name="other_sqm"<?= $Page->other_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_other_sqm" class="el_cost_calculator_other_sqm">
<span<?= $Page->other_sqm->viewAttributes() ?>>
<?= $Page->other_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->margin_percent->Visible) { // margin_percent ?>
        <td data-name="margin_percent"<?= $Page->margin_percent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_margin_percent" class="el_cost_calculator_margin_percent">
<span<?= $Page->margin_percent->viewAttributes() ?>>
<?= $Page->margin_percent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price"<?= $Page->price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_price" class="el_cost_calculator_price">
<span<?= $Page->price->viewAttributes() ?>>
<?= $Page->price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Page->currency->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_currency" class="el_cost_calculator_currency">
<span<?= $Page->currency->viewAttributes() ?>>
<?= $Page->currency->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_dated" class="el_cost_calculator_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cost_calculator_packing_type" class="el_cost_calculator_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cost_calculator");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
