<?php

namespace PHPMaker2024\fibre;

// Page object
$CostCalculatorDetailedSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cost_calculator_detailed: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcost_calculator_detailedsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcost_calculator_detailedsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["cc_id", [], fields.cc_id.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["item", [], fields.item.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["method", [], fields.method.isInvalid],
            ["qty", [ew.Validators.float], fields.qty.isInvalid],
            ["last_price", [ew.Validators.float], fields.last_price.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["w_cm", [ew.Validators.integer], fields.w_cm.isInvalid],
            ["l_cm", [ew.Validators.integer], fields.l_cm.isInvalid],
            ["description", [], fields.description.isInvalid],
            ["overhead", [ew.Validators.float], fields.overhead.isInvalid],
            ["margin", [ew.Validators.float], fields.margin.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "cc_id": <?= $Page->cc_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "item": <?= $Page->item->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "method": <?= $Page->method->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcost_calculator_detailedsearch" id="fcost_calculator_detailedsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cost_calculator_detailed">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="cost_calculator_detailed" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cc_id->Visible) { // cc_id ?>
    <div id="r_cc_id" class="row"<?= $Page->cc_id->rowAttributes() ?>>
        <label for="x_cc_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_cc_id"><?= $Page->cc_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cc_id" id="z_cc_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cc_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_cc_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_cc_id"
        name="x_cc_id"
        class="form-select ew-select<?= $Page->cc_id->isInvalidClass() ?>"
        <?php if (!$Page->cc_id->IsNativeSelect) { ?>
        data-select2-id="fcost_calculator_detailedsearch_x_cc_id"
        <?php } ?>
        data-table="cost_calculator_detailed"
        data-field="x_cc_id"
        data-value-separator="<?= $Page->cc_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cc_id->getPlaceHolder()) ?>"
        <?= $Page->cc_id->editAttributes() ?>>
        <?= $Page->cc_id->selectOptionListHtml("x_cc_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cc_id->getErrorMessage(false) ?></div>
<?= $Page->cc_id->Lookup->getParamTag($Page, "p_x_cc_id") ?>
<?php if (!$Page->cc_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculator_detailedsearch", function() {
    var options = { name: "x_cc_id", selectId: "fcost_calculator_detailedsearch_x_cc_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculator_detailedsearch.lists.cc_id?.lookupOptions.length) {
        options.data = { id: "x_cc_id", form: "fcost_calculator_detailedsearch" };
    } else {
        options.ajax = { id: "x_cc_id", form: "fcost_calculator_detailedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator_detailed.fields.cc_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fcost_calculator_detailedsearch_x_rid"
        <?php } ?>
        data-table="cost_calculator_detailed"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculator_detailedsearch", function() {
    var options = { name: "x_rid", selectId: "fcost_calculator_detailedsearch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculator_detailedsearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fcost_calculator_detailedsearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fcost_calculator_detailedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator_detailed.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="cost_calculator_detailed" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item" class="row"<?= $Page->item->rowAttributes() ?>>
        <label for="x_item" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_item"><?= $Page->item->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_item" id="z_item" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->item->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_item" class="ew-search-field ew-search-field-single">
    <select
        id="x_item"
        name="x_item"
        class="form-select ew-select<?= $Page->item->isInvalidClass() ?>"
        <?php if (!$Page->item->IsNativeSelect) { ?>
        data-select2-id="fcost_calculator_detailedsearch_x_item"
        <?php } ?>
        data-table="cost_calculator_detailed"
        data-field="x_item"
        data-value-separator="<?= $Page->item->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>"
        <?= $Page->item->editAttributes() ?>>
        <?= $Page->item->selectOptionListHtml("x_item") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->item->getErrorMessage(false) ?></div>
<?= $Page->item->Lookup->getParamTag($Page, "p_x_item") ?>
<?php if (!$Page->item->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculator_detailedsearch", function() {
    var options = { name: "x_item", selectId: "fcost_calculator_detailedsearch_x_item" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculator_detailedsearch.lists.item?.lookupOptions.length) {
        options.data = { id: "x_item", form: "fcost_calculator_detailedsearch" };
    } else {
        options.ajax = { id: "x_item", form: "fcost_calculator_detailedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator_detailed.fields.item.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fcost_calculator_detailedsearch_x_packing_type"
        <?php } ?>
        data-table="cost_calculator_detailed"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculator_detailedsearch", function() {
    var options = { name: "x_packing_type", selectId: "fcost_calculator_detailedsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculator_detailedsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fcost_calculator_detailedsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fcost_calculator_detailedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator_detailed.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->method->Visible) { // method ?>
    <div id="r_method" class="row"<?= $Page->method->rowAttributes() ?>>
        <label for="x_method" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_method"><?= $Page->method->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_method" id="z_method" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->method->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_method" class="ew-search-field ew-search-field-single">
    <select
        id="x_method"
        name="x_method"
        class="form-select ew-select<?= $Page->method->isInvalidClass() ?>"
        <?php if (!$Page->method->IsNativeSelect) { ?>
        data-select2-id="fcost_calculator_detailedsearch_x_method"
        <?php } ?>
        data-table="cost_calculator_detailed"
        data-field="x_method"
        data-value-separator="<?= $Page->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->method->getPlaceHolder()) ?>"
        <?= $Page->method->editAttributes() ?>>
        <?= $Page->method->selectOptionListHtml("x_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->method->getErrorMessage(false) ?></div>
<?= $Page->method->Lookup->getParamTag($Page, "p_x_method") ?>
<?php if (!$Page->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculator_detailedsearch", function() {
    var options = { name: "x_method", selectId: "fcost_calculator_detailedsearch_x_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculator_detailedsearch.lists.method?.lookupOptions.length) {
        options.data = { id: "x_method", form: "fcost_calculator_detailedsearch" };
    } else {
        options.ajax = { id: "x_method", form: "fcost_calculator_detailedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator_detailed.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="cost_calculator_detailed" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_price->Visible) { // last_price ?>
    <div id="r_last_price" class="row"<?= $Page->last_price->rowAttributes() ?>>
        <label for="x_last_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_last_price"><?= $Page->last_price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_price" id="z_last_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_last_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_price->getInputTextType() ?>" name="x_last_price" id="x_last_price" data-table="cost_calculator_detailed" data-field="x_last_price" value="<?= $Page->last_price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->last_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_price->formatPattern()) ?>"<?= $Page->last_price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="cost_calculator_detailed" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fcost_calculator_detailedsearch_x_process"
        <?php } ?>
        data-table="cost_calculator_detailed"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fcost_calculator_detailedsearch", function() {
    var options = { name: "x_process", selectId: "fcost_calculator_detailedsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcost_calculator_detailedsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fcost_calculator_detailedsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fcost_calculator_detailedsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cost_calculator_detailed.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm" class="row"<?= $Page->w_cm->rowAttributes() ?>>
        <label for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_w_cm"><?= $Page->w_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_w_cm" id="z_w_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="cost_calculator_detailed" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm" class="row"<?= $Page->l_cm->rowAttributes() ?>>
        <label for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_l_cm"><?= $Page->l_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_l_cm" id="z_l_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="cost_calculator_detailed" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description" class="row"<?= $Page->description->rowAttributes() ?>>
        <label for="x_description" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_description"><?= $Page->description->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_description" id="z_description" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_description" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->description->getInputTextType() ?>" name="x_description" id="x_description" data-table="cost_calculator_detailed" data-field="x_description" value="<?= $Page->description->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->description->formatPattern()) ?>"<?= $Page->description->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->overhead->Visible) { // overhead ?>
    <div id="r_overhead" class="row"<?= $Page->overhead->rowAttributes() ?>>
        <label for="x_overhead" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_overhead"><?= $Page->overhead->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_overhead" id="z_overhead" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->overhead->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_overhead" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->overhead->getInputTextType() ?>" name="x_overhead" id="x_overhead" data-table="cost_calculator_detailed" data-field="x_overhead" value="<?= $Page->overhead->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->overhead->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->overhead->formatPattern()) ?>"<?= $Page->overhead->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->overhead->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->margin->Visible) { // margin ?>
    <div id="r_margin" class="row"<?= $Page->margin->rowAttributes() ?>>
        <label for="x_margin" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_margin"><?= $Page->margin->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_margin" id="z_margin" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->margin->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_margin" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->margin->getInputTextType() ?>" name="x_margin" id="x_margin" data-table="cost_calculator_detailed" data-field="x_margin" value="<?= $Page->margin->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->margin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->margin->formatPattern()) ?>"<?= $Page->margin->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->margin->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="cost_calculator_detailed" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cost_calculator_detailed_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cost_calculator_detailed_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="cost_calculator_detailed" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcost_calculator_detailedsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcost_calculator_detailedsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcost_calculator_detailedsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcost_calculator_detailedsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fcost_calculator_detailedsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cost_calculator_detailed");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
