<?php

namespace PHPMaker2024\fibre;

// Page object
$CollectionLogSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { collection_log: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcollection_logsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcollection_logsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["agent", [], fields.agent.isInvalid],
            ["account_no", [ew.Validators.integer], fields.account_no.isInvalid],
            ["emi_no", [ew.Validators.integer], fields.emi_no.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["revised_date", [ew.Validators.datetime(fields.revised_date.clientFormatPattern)], fields.revised_date.isInvalid],
            ["y_revised_date", [ew.Validators.between], false],
            ["updated", [], fields.updated.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "account_no": <?= $Page->account_no->toClientList($Page) ?>,
            "updated": <?= $Page->updated->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcollection_logsearch" id="fcollection_logsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="collection_log">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="collection_log" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fcollection_logsearch_x_location"
        <?php } ?>
        data-table="collection_log"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fcollection_logsearch", function() {
    var options = { name: "x_location", selectId: "fcollection_logsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcollection_logsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fcollection_logsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fcollection_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.collection_log.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label for="x_agent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fcollection_logsearch_x_agent"
        <?php } ?>
        data-table="collection_log"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fcollection_logsearch", function() {
    var options = { name: "x_agent", selectId: "fcollection_logsearch_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcollection_logsearch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fcollection_logsearch" };
    } else {
        options.ajax = { id: "x_agent", form: "fcollection_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.collection_log.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
    <div id="r_account_no" class="row"<?= $Page->account_no->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_account_no"><?= $Page->account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_account_no" id="z_account_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_account_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_account_no"
        name="x_account_no"
        class="form-control ew-select<?= $Page->account_no->isInvalidClass() ?>"
        data-select2-id="fcollection_logsearch_x_account_no"
        data-table="collection_log"
        data-field="x_account_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->account_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->account_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->account_no->getPlaceHolder()) ?>"
        <?= $Page->account_no->editAttributes() ?>>
        <?= $Page->account_no->selectOptionListHtml("x_account_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->account_no->getErrorMessage(false) ?></div>
<?= $Page->account_no->Lookup->getParamTag($Page, "p_x_account_no") ?>
<script>
loadjs.ready("fcollection_logsearch", function() {
    var options = { name: "x_account_no", selectId: "fcollection_logsearch_x_account_no" };
    if (fcollection_logsearch.lists.account_no?.lookupOptions.length) {
        options.data = { id: "x_account_no", form: "fcollection_logsearch" };
    } else {
        options.ajax = { id: "x_account_no", form: "fcollection_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.collection_log.fields.account_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emi_no->Visible) { // emi_no ?>
    <div id="r_emi_no" class="row"<?= $Page->emi_no->rowAttributes() ?>>
        <label for="x_emi_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_emi_no"><?= $Page->emi_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_emi_no" id="z_emi_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emi_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_emi_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emi_no->getInputTextType() ?>" name="x_emi_no" id="x_emi_no" data-table="collection_log" data-field="x_emi_no" value="<?= $Page->emi_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->emi_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emi_no->formatPattern()) ?>"<?= $Page->emi_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emi_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="collection_log" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="collection_log" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcollection_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcollection_logsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->revised_date->Visible) { // revised_date ?>
    <div id="r_revised_date" class="row"<?= $Page->revised_date->rowAttributes() ?>>
        <label for="x_revised_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_revised_date"><?= $Page->revised_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->revised_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_revised_date" id="z_revised_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->revised_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->revised_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_collection_log_revised_date" class="ew-search-field">
<input type="<?= $Page->revised_date->getInputTextType() ?>" name="x_revised_date" id="x_revised_date" data-table="collection_log" data-field="x_revised_date" value="<?= $Page->revised_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->revised_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->revised_date->formatPattern()) ?>"<?= $Page->revised_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->revised_date->getErrorMessage(false) ?></div>
<?php if (!$Page->revised_date->ReadOnly && !$Page->revised_date->Disabled && !isset($Page->revised_date->EditAttrs["readonly"]) && !isset($Page->revised_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcollection_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcollection_logsearch", "x_revised_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_collection_log_revised_date" class="ew-search-field2 d-none">
<input type="<?= $Page->revised_date->getInputTextType() ?>" name="y_revised_date" id="y_revised_date" data-table="collection_log" data-field="x_revised_date" value="<?= $Page->revised_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->revised_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->revised_date->formatPattern()) ?>"<?= $Page->revised_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->revised_date->getErrorMessage(false) ?></div>
<?php if (!$Page->revised_date->ReadOnly && !$Page->revised_date->Disabled && !isset($Page->revised_date->EditAttrs["readonly"]) && !isset($Page->revised_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcollection_logsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcollection_logsearch", "y_revised_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
    <div id="r_updated" class="row"<?= $Page->updated->rowAttributes() ?>>
        <label for="x_updated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_collection_log_updated"><?= $Page->updated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_updated" id="z_updated" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->updated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_collection_log_updated" class="ew-search-field ew-search-field-single">
    <select
        id="x_updated"
        name="x_updated"
        class="form-select ew-select<?= $Page->updated->isInvalidClass() ?>"
        <?php if (!$Page->updated->IsNativeSelect) { ?>
        data-select2-id="fcollection_logsearch_x_updated"
        <?php } ?>
        data-table="collection_log"
        data-field="x_updated"
        data-value-separator="<?= $Page->updated->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>"
        <?= $Page->updated->editAttributes() ?>>
        <?= $Page->updated->selectOptionListHtml("x_updated") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->updated->getErrorMessage(false) ?></div>
<?php if (!$Page->updated->IsNativeSelect) { ?>
<script>
loadjs.ready("fcollection_logsearch", function() {
    var options = { name: "x_updated", selectId: "fcollection_logsearch_x_updated" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcollection_logsearch.lists.updated?.lookupOptions.length) {
        options.data = { id: "x_updated", form: "fcollection_logsearch" };
    } else {
        options.ajax = { id: "x_updated", form: "fcollection_logsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.collection_log.fields.updated.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcollection_logsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcollection_logsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fcollection_logsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("collection_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
