<?php

namespace PHPMaker2024\fibre;

// Page object
$CollectionLogList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { collection_log: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fcollection_logsrch" id="fcollection_logsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fcollection_logsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { collection_log: currentTable } });
var currentForm;
var fcollection_logsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcollection_logsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["agent", [], fields.agent.isInvalid],
            ["account_no", [ew.Validators.integer], fields.account_no.isInvalid],
            ["revised_date", [ew.Validators.datetime(fields.revised_date.clientFormatPattern)], fields.revised_date.isInvalid],
            ["y_revised_date", [ew.Validators.between], false],
            ["updated", [], fields.updated.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "account_no": <?= $Page->account_no->toClientList($Page) ?>,
            "updated": <?= $Page->updated->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_collection_log_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fcollection_logsrch_x_location"
        <?php } ?>
        data-table="collection_log"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fcollection_logsrch", function() {
    var options = { name: "x_location", selectId: "fcollection_logsrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcollection_logsrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fcollection_logsrch" };
    } else {
        options.ajax = { id: "x_location", form: "fcollection_logsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.collection_log.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
<?php
if (!$Page->agent->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_agent" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->agent->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_agent" class="ew-search-caption ew-label"><?= $Page->agent->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</div>
        </div>
        <div id="el_collection_log_agent" class="ew-search-field">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fcollection_logsrch_x_agent"
        <?php } ?>
        data-table="collection_log"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fcollection_logsrch", function() {
    var options = { name: "x_agent", selectId: "fcollection_logsrch_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcollection_logsrch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fcollection_logsrch" };
    } else {
        options.ajax = { id: "x_agent", form: "fcollection_logsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.collection_log.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
<?php
if (!$Page->account_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_account_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->account_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->account_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_account_no" id="z_account_no" value="=">
</div>
        </div>
        <div id="el_collection_log_account_no" class="ew-search-field">
    <select
        id="x_account_no"
        name="x_account_no"
        class="form-control ew-select<?= $Page->account_no->isInvalidClass() ?>"
        data-select2-id="fcollection_logsrch_x_account_no"
        data-table="collection_log"
        data-field="x_account_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->account_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->account_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->account_no->getPlaceHolder()) ?>"
        <?= $Page->account_no->editAttributes() ?>>
        <?= $Page->account_no->selectOptionListHtml("x_account_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->account_no->getErrorMessage(false) ?></div>
<?= $Page->account_no->Lookup->getParamTag($Page, "p_x_account_no") ?>
<script>
loadjs.ready("fcollection_logsrch", function() {
    var options = { name: "x_account_no", selectId: "fcollection_logsrch_x_account_no" };
    if (fcollection_logsrch.lists.account_no?.lookupOptions.length) {
        options.data = { id: "x_account_no", form: "fcollection_logsrch" };
    } else {
        options.ajax = { id: "x_account_no", form: "fcollection_logsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.collection_log.fields.account_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->revised_date->Visible) { // revised_date ?>
<?php
if (!$Page->revised_date->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_revised_date" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->revised_date->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_revised_date" class="ew-search-caption ew-label"><?= $Page->revised_date->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_revised_date" id="z_revised_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->revised_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->revised_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_collection_log_revised_date" class="ew-search-field">
<input type="<?= $Page->revised_date->getInputTextType() ?>" name="x_revised_date" id="x_revised_date" data-table="collection_log" data-field="x_revised_date" value="<?= $Page->revised_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->revised_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->revised_date->formatPattern()) ?>"<?= $Page->revised_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->revised_date->getErrorMessage(false) ?></div>
<?php if (!$Page->revised_date->ReadOnly && !$Page->revised_date->Disabled && !isset($Page->revised_date->EditAttrs["readonly"]) && !isset($Page->revised_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcollection_logsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcollection_logsrch", "x_revised_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_collection_log_revised_date" class="ew-search-field2 d-none">
<input type="<?= $Page->revised_date->getInputTextType() ?>" name="y_revised_date" id="y_revised_date" data-table="collection_log" data-field="x_revised_date" value="<?= $Page->revised_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->revised_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->revised_date->formatPattern()) ?>"<?= $Page->revised_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->revised_date->getErrorMessage(false) ?></div>
<?php if (!$Page->revised_date->ReadOnly && !$Page->revised_date->Disabled && !isset($Page->revised_date->EditAttrs["readonly"]) && !isset($Page->revised_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcollection_logsrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcollection_logsrch", "y_revised_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
<?php
if (!$Page->updated->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_updated" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->updated->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_updated" class="ew-search-caption ew-label"><?= $Page->updated->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_updated" id="z_updated" value="LIKE">
</div>
        </div>
        <div id="el_collection_log_updated" class="ew-search-field">
    <select
        id="x_updated"
        name="x_updated"
        class="form-select ew-select<?= $Page->updated->isInvalidClass() ?>"
        <?php if (!$Page->updated->IsNativeSelect) { ?>
        data-select2-id="fcollection_logsrch_x_updated"
        <?php } ?>
        data-table="collection_log"
        data-field="x_updated"
        data-value-separator="<?= $Page->updated->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->updated->getPlaceHolder()) ?>"
        <?= $Page->updated->editAttributes() ?>>
        <?= $Page->updated->selectOptionListHtml("x_updated") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->updated->getErrorMessage(false) ?></div>
<?php if (!$Page->updated->IsNativeSelect) { ?>
<script>
loadjs.ready("fcollection_logsrch", function() {
    var options = { name: "x_updated", selectId: "fcollection_logsrch_x_updated" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcollection_logsrch.lists.updated?.lookupOptions.length) {
        options.data = { id: "x_updated", form: "fcollection_logsrch" };
    } else {
        options.ajax = { id: "x_updated", form: "fcollection_logsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.collection_log.fields.updated.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fcollection_logsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fcollection_logsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fcollection_logsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fcollection_logsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fcollection_logsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fcollection_logsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fcollection_logsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="collection_log">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_collection_log" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_collection_loglist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_collection_log_id" class="collection_log_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_collection_log_location" class="collection_log_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
        <th data-name="agent" class="<?= $Page->agent->headerCellClass() ?>"><div id="elh_collection_log_agent" class="collection_log_agent"><?= $Page->renderFieldHeader($Page->agent) ?></div></th>
<?php } ?>
<?php if ($Page->account_no->Visible) { // account_no ?>
        <th data-name="account_no" class="<?= $Page->account_no->headerCellClass() ?>"><div id="elh_collection_log_account_no" class="collection_log_account_no"><?= $Page->renderFieldHeader($Page->account_no) ?></div></th>
<?php } ?>
<?php if ($Page->emi_no->Visible) { // emi_no ?>
        <th data-name="emi_no" class="<?= $Page->emi_no->headerCellClass() ?>"><div id="elh_collection_log_emi_no" class="collection_log_emi_no"><?= $Page->renderFieldHeader($Page->emi_no) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_collection_log_amount" class="collection_log_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->revised_date->Visible) { // revised_date ?>
        <th data-name="revised_date" class="<?= $Page->revised_date->headerCellClass() ?>"><div id="elh_collection_log_revised_date" class="collection_log_revised_date"><?= $Page->renderFieldHeader($Page->revised_date) ?></div></th>
<?php } ?>
<?php if ($Page->updated->Visible) { // updated ?>
        <th data-name="updated" class="<?= $Page->updated->headerCellClass() ?>"><div id="elh_collection_log_updated" class="collection_log_updated"><?= $Page->renderFieldHeader($Page->updated) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_id" class="el_collection_log_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_location" class="el_collection_log_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->agent->Visible) { // agent ?>
        <td data-name="agent"<?= $Page->agent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_agent" class="el_collection_log_agent">
<span<?= $Page->agent->viewAttributes() ?>>
<?= $Page->agent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->account_no->Visible) { // account_no ?>
        <td data-name="account_no"<?= $Page->account_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_account_no" class="el_collection_log_account_no">
<span<?= $Page->account_no->viewAttributes() ?>>
<?= $Page->account_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emi_no->Visible) { // emi_no ?>
        <td data-name="emi_no"<?= $Page->emi_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_emi_no" class="el_collection_log_emi_no">
<span<?= $Page->emi_no->viewAttributes() ?>>
<?= $Page->emi_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_amount" class="el_collection_log_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?php if (!EmptyString($Page->amount->getViewValue()) && $Page->amount->linkAttributes() != "") { ?>
<a<?= $Page->amount->linkAttributes() ?>><?= $Page->amount->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->revised_date->Visible) { // revised_date ?>
        <td data-name="revised_date"<?= $Page->revised_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_revised_date" class="el_collection_log_revised_date">
<span<?= $Page->revised_date->viewAttributes() ?>>
<?= $Page->revised_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->updated->Visible) { // updated ?>
        <td data-name="updated"<?= $Page->updated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_collection_log_updated" class="el_collection_log_updated">
<span<?= $Page->updated->viewAttributes() ?>>
<?= $Page->updated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_collection_log_id" class="collection_log_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location" class="<?= $Page->location->footerCellClass() ?>"><span id="elf_collection_log_location" class="collection_log_location">
        </span></td>
    <?php } ?>
    <?php if ($Page->agent->Visible) { // agent ?>
        <td data-name="agent" class="<?= $Page->agent->footerCellClass() ?>"><span id="elf_collection_log_agent" class="collection_log_agent">
        </span></td>
    <?php } ?>
    <?php if ($Page->account_no->Visible) { // account_no ?>
        <td data-name="account_no" class="<?= $Page->account_no->footerCellClass() ?>"><span id="elf_collection_log_account_no" class="collection_log_account_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->emi_no->Visible) { // emi_no ?>
        <td data-name="emi_no" class="<?= $Page->emi_no->footerCellClass() ?>"><span id="elf_collection_log_emi_no" class="collection_log_emi_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_collection_log_amount" class="collection_log_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->amount->ViewValue) && $Page->amount->linkAttributes() != "") { ?>
        <a<?= $Page->amount->linkAttributes() ?>><?= $Page->amount->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->amount->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->revised_date->Visible) { // revised_date ?>
        <td data-name="revised_date" class="<?= $Page->revised_date->footerCellClass() ?>"><span id="elf_collection_log_revised_date" class="collection_log_revised_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->updated->Visible) { // updated ?>
        <td data-name="updated" class="<?= $Page->updated->footerCellClass() ?>"><span id="elf_collection_log_updated" class="collection_log_updated">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("collection_log");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
