<?php

namespace PHPMaker2024\fibre;

// Page object
$CodeExchangeAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { code_exchange: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fcode_exchangeadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcode_exchangeadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.integer], fields.code.isInvalid],
            ["consume_by", [fields.consume_by.visible && fields.consume_by.required ? ew.Validators.required(fields.consume_by.caption) : null, ew.Validators.integer], fields.consume_by.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcode_exchangeadd" id="fcode_exchangeadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="code_exchange">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label id="elh_code_exchange_code" for="x_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->code->cellAttributes() ?>>
<span id="el_code_exchange_code">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="code_exchange" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consume_by->Visible) { // consume_by ?>
    <div id="r_consume_by"<?= $Page->consume_by->rowAttributes() ?>>
        <label id="elh_code_exchange_consume_by" for="x_consume_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consume_by->caption() ?><?= $Page->consume_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consume_by->cellAttributes() ?>>
<span id="el_code_exchange_consume_by">
<input type="<?= $Page->consume_by->getInputTextType() ?>" name="x_consume_by" id="x_consume_by" data-table="code_exchange" data-field="x_consume_by" value="<?= $Page->consume_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->consume_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consume_by->formatPattern()) ?>"<?= $Page->consume_by->editAttributes() ?> aria-describedby="x_consume_by_help">
<?= $Page->consume_by->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->consume_by->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcode_exchangeadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcode_exchangeadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("code_exchange");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var code = $("#x_code").val();
    		$.getJSON(window.location.origin +'/apcajax?bcode_exchange='+code,function(data){
    		$('#error').remove();
    		$('#r_code').append('<span id="error" style="color: red">Design:'+data.Design_10D+'<BR>Size: '+data.SizeCM+'<BR>Buyer: '+data.Buyer+'<BR>Buyer PO: '+data.Buyer_PO+'<BR>Buyer Ref: '+data.Buyer_Ref+'<BR>Delivery Week: '+data.Week+'<BR>Status: '+data.item+'</span>');
    		});
    		var ccode = $("#x_consume_by").val();
    		if ((ccode === undefined || ccode === null || ccode === '')  == false)
    		{
    			if (code == ccode)
    				{
    					alert('Same Code Can\'t be used as Consume By');
    					$("#x_consume_by").val('');
    				}
    			else
    			{
    				$.getJSON(window.location.origin +'/apcajax?bcode_exchange='+ccode,function(datacc){
    				$('#error1').remove();
    				$('#r_consume_by').append('<span id="error1" style="color: red">Design:'+datacc.Design_10D+'<BR>Size: '+datacc.SizeCM+'<BR>Buyer: '+datacc.Buyer+'<BR>Buyer PO: '+datacc.Buyer_PO+'<BR>Buyer Ref: '+datacc.Buyer_Ref+'<BR>Delivery Week: '+datacc.Week+'<BR>Status: '+data.item+'</span>');
    			});
    			}
    		}
});
</script>
