<?php

namespace PHPMaker2024\fibre;

// Page object
$ClientHardwareDataSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { client_hardware_data: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fclient_hardware_datasearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fclient_hardware_datasearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["customer_grp", [], fields.customer_grp.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["partner_id", [ew.Validators.integer], fields.partner_id.isInvalid],
            ["y_partner_id", [ew.Validators.between], false],
            ["name_ref", [], fields.name_ref.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["area", [], fields.area.isInvalid],
            ["billing_name", [], fields.billing_name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["personal_ref", [], fields.personal_ref.isInvalid],
            ["harward_code", [], fields.harward_code.isInvalid],
            ["serial_no", [], fields.serial_no.isInvalid],
            ["invoice_no", [], fields.invoice_no.isInvalid],
            ["invoice_date", [ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["first_counter", [ew.Validators.integer], fields.first_counter.isInvalid],
            ["guarantee", [], fields.guarantee.isInvalid],
            ["valid_till", [ew.Validators.datetime(fields.valid_till.clientFormatPattern)], fields.valid_till.isInvalid],
            ["valid_till_counter", [ew.Validators.integer], fields.valid_till_counter.isInvalid],
            ["free_service", [ew.Validators.integer], fields.free_service.isInvalid],
            ["toner_life", [ew.Validators.integer], fields.toner_life.isInvalid],
            ["drum_life", [ew.Validators.integer], fields.drum_life.isInvalid],
            ["developer_life", [ew.Validators.integer], fields.developer_life.isInvalid],
            ["date_install", [ew.Validators.datetime(fields.date_install.clientFormatPattern)], fields.date_install.isInvalid],
            ["date_start", [ew.Validators.datetime(fields.date_start.clientFormatPattern)], fields.date_start.isInvalid],
            ["remark", [], fields.remark.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["schedule_service_type", [], fields.schedule_service_type.isInvalid],
            ["schedule_service_interval_days", [ew.Validators.integer], fields.schedule_service_interval_days.isInvalid],
            ["schedule_service_updated_till", [ew.Validators.datetime(fields.schedule_service_updated_till.clientFormatPattern)], fields.schedule_service_updated_till.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["copy_average_1", [ew.Validators.integer], fields.copy_average_1.isInvalid],
            ["copy_average_2", [ew.Validators.integer], fields.copy_average_2.isInvalid],
            ["copy_average_3", [ew.Validators.integer], fields.copy_average_3.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "customer_grp": <?= $Page->customer_grp->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "area": <?= $Page->area->toClientList($Page) ?>,
            "personal_ref": <?= $Page->personal_ref->toClientList($Page) ?>,
            "guarantee": <?= $Page->guarantee->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "schedule_service_type": <?= $Page->schedule_service_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fclient_hardware_datasearch" id="fclient_hardware_datasearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="client_hardware_data">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="client_hardware_data" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->customer_grp->Visible) { // customer_grp ?>
    <div id="r_customer_grp" class="row"<?= $Page->customer_grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_customer_grp"><?= $Page->customer_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_customer_grp" id="z_customer_grp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->customer_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_customer_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_customer_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="client_hardware_data" data-field="x_customer_grp" name="x_customer_grp" id="x_customer_grp"<?= $Page->customer_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_customer_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_customer_grp[]"
    name="x_customer_grp[]"
    value="<?= HtmlEncode($Page->customer_grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_customer_grp"
    data-target="dsl_x_customer_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->customer_grp->isInvalidClass() ?>"
    data-table="client_hardware_data"
    data-field="x_customer_grp"
    data-value-separator="<?= $Page->customer_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->customer_grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->customer_grp->getErrorMessage(false) ?></div>
<?= $Page->customer_grp->Lookup->getParamTag($Page, "p_x_customer_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="client_hardware_data" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_partner_id"><?= $Page->partner_id->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_partner_id" id="z_partner_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->partner_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->partner_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_client_hardware_data_partner_id" class="ew-search-field">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_datasearch_x_partner_id"
        data-table="client_hardware_data"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_partner_id", selectId: "fclient_hardware_datasearch_x_partner_id" };
    if (fclient_hardware_datasearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_client_hardware_data_partner_id" class="ew-search-field2 d-none">
    <select
        id="y_partner_id"
        name="y_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_datasearch_y_partner_id"
        data-table="client_hardware_data"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("y_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_y_partner_id") ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "y_partner_id", selectId: "fclient_hardware_datasearch_y_partner_id" };
    if (fclient_hardware_datasearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "y_partner_id", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "y_partner_id", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name_ref->Visible) { // name_ref ?>
    <div id="r_name_ref" class="row"<?= $Page->name_ref->rowAttributes() ?>>
        <label for="x_name_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_name_ref"><?= $Page->name_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name_ref" id="z_name_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_name_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name_ref->getInputTextType() ?>" name="x_name_ref" id="x_name_ref" data-table="client_hardware_data" data-field="x_name_ref" value="<?= $Page->name_ref->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name_ref->formatPattern()) ?>"<?= $Page->name_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name" class="row"<?= $Page->city_name->rowAttributes() ?>>
        <label for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_city_name"><?= $Page->city_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_city_name" id="z_city_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_city_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="client_hardware_data" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->area->Visible) { // area ?>
    <div id="r_area" class="row"<?= $Page->area->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_area"><?= $Page->area->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_area" id="z_area" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->area->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_area" class="ew-search-field ew-search-field-single">
    <select
        id="x_area"
        name="x_area"
        class="form-control ew-select<?= $Page->area->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_datasearch_x_area"
        data-table="client_hardware_data"
        data-field="x_area"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->area->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->area->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->area->getPlaceHolder()) ?>"
        <?= $Page->area->editAttributes() ?>>
        <?= $Page->area->selectOptionListHtml("x_area") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->area->getErrorMessage(false) ?></div>
<?= $Page->area->Lookup->getParamTag($Page, "p_x_area") ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_area", selectId: "fclient_hardware_datasearch_x_area" };
    if (fclient_hardware_datasearch.lists.area?.lookupOptions.length) {
        options.data = { id: "x_area", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_area", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.area.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->billing_name->Visible) { // billing_name ?>
    <div id="r_billing_name" class="row"<?= $Page->billing_name->rowAttributes() ?>>
        <label for="x_billing_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_billing_name"><?= $Page->billing_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_billing_name" id="z_billing_name" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->billing_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_billing_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->billing_name->getInputTextType() ?>" name="x_billing_name" id="x_billing_name" data-table="client_hardware_data" data-field="x_billing_name" value="<?= $Page->billing_name->EditValue ?>" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->billing_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->billing_name->formatPattern()) ?>"<?= $Page->billing_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->billing_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="client_hardware_data" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->personal_ref->Visible) { // personal_ref ?>
    <div id="r_personal_ref" class="row"<?= $Page->personal_ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_personal_ref"><?= $Page->personal_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_personal_ref" id="z_personal_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->personal_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_personal_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_personal_ref[]"
        name="x_personal_ref[]"
        class="form-control ew-select<?= $Page->personal_ref->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_datasearch_x_personal_ref[]"
        data-table="client_hardware_data"
        data-field="x_personal_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->personal_ref->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->personal_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->personal_ref->getPlaceHolder()) ?>"
        <?= $Page->personal_ref->editAttributes() ?>>
        <?= $Page->personal_ref->selectOptionListHtml("x_personal_ref[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->personal_ref->getErrorMessage(false) ?></div>
<?= $Page->personal_ref->Lookup->getParamTag($Page, "p_x_personal_ref") ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_personal_ref[]", selectId: "fclient_hardware_datasearch_x_personal_ref[]" };
    options.multiple = true;
    if (fclient_hardware_datasearch.lists.personal_ref?.lookupOptions.length) {
        options.data = { id: "x_personal_ref[]", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_personal_ref[]", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.personal_ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->harward_code->Visible) { // harward_code ?>
    <div id="r_harward_code" class="row"<?= $Page->harward_code->rowAttributes() ?>>
        <label for="x_harward_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_harward_code"><?= $Page->harward_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_harward_code" id="z_harward_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->harward_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_harward_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->harward_code->getInputTextType() ?>" name="x_harward_code" id="x_harward_code" data-table="client_hardware_data" data-field="x_harward_code" value="<?= $Page->harward_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->harward_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->harward_code->formatPattern()) ?>"<?= $Page->harward_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->harward_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->serial_no->Visible) { // serial_no ?>
    <div id="r_serial_no" class="row"<?= $Page->serial_no->rowAttributes() ?>>
        <label for="x_serial_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_serial_no"><?= $Page->serial_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_serial_no" id="z_serial_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->serial_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_serial_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->serial_no->getInputTextType() ?>" name="x_serial_no" id="x_serial_no" data-table="client_hardware_data" data-field="x_serial_no" value="<?= $Page->serial_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->serial_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->serial_no->formatPattern()) ?>"<?= $Page->serial_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->serial_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
    <div id="r_invoice_no" class="row"<?= $Page->invoice_no->rowAttributes() ?>>
        <label for="x_invoice_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_invoice_no"><?= $Page->invoice_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice_no" id="z_invoice_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_invoice_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_no->getInputTextType() ?>" name="x_invoice_no" id="x_invoice_no" data-table="client_hardware_data" data-field="x_invoice_no" value="<?= $Page->invoice_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->invoice_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_no->formatPattern()) ?>"<?= $Page->invoice_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date" class="row"<?= $Page->invoice_date->rowAttributes() ?>>
        <label for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_invoice_date"><?= $Page->invoice_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_date" id="z_invoice_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_invoice_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="client_hardware_data" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasearch", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->first_counter->Visible) { // first_counter ?>
    <div id="r_first_counter" class="row"<?= $Page->first_counter->rowAttributes() ?>>
        <label for="x_first_counter" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_first_counter"><?= $Page->first_counter->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_first_counter" id="z_first_counter" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->first_counter->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_first_counter" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->first_counter->getInputTextType() ?>" name="x_first_counter" id="x_first_counter" data-table="client_hardware_data" data-field="x_first_counter" value="<?= $Page->first_counter->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->first_counter->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->first_counter->formatPattern()) ?>"<?= $Page->first_counter->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->first_counter->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->guarantee->Visible) { // guarantee ?>
    <div id="r_guarantee" class="row"<?= $Page->guarantee->rowAttributes() ?>>
        <label for="x_guarantee" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_guarantee"><?= $Page->guarantee->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_guarantee" id="z_guarantee" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->guarantee->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_guarantee" class="ew-search-field ew-search-field-single">
    <select
        id="x_guarantee"
        name="x_guarantee"
        class="form-select ew-select<?= $Page->guarantee->isInvalidClass() ?>"
        <?php if (!$Page->guarantee->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_datasearch_x_guarantee"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_guarantee"
        data-value-separator="<?= $Page->guarantee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->guarantee->getPlaceHolder()) ?>"
        <?= $Page->guarantee->editAttributes() ?>>
        <?= $Page->guarantee->selectOptionListHtml("x_guarantee") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->guarantee->getErrorMessage(false) ?></div>
<?php if (!$Page->guarantee->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_guarantee", selectId: "fclient_hardware_datasearch_x_guarantee" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_datasearch.lists.guarantee?.lookupOptions.length) {
        options.data = { id: "x_guarantee", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_guarantee", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.guarantee.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->valid_till->Visible) { // valid_till ?>
    <div id="r_valid_till" class="row"<?= $Page->valid_till->rowAttributes() ?>>
        <label for="x_valid_till" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_valid_till"><?= $Page->valid_till->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_valid_till" id="z_valid_till" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->valid_till->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_valid_till" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->valid_till->getInputTextType() ?>" name="x_valid_till" id="x_valid_till" data-table="client_hardware_data" data-field="x_valid_till" value="<?= $Page->valid_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->valid_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->valid_till->formatPattern()) ?>"<?= $Page->valid_till->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->valid_till->getErrorMessage(false) ?></div>
<?php if (!$Page->valid_till->ReadOnly && !$Page->valid_till->Disabled && !isset($Page->valid_till->EditAttrs["readonly"]) && !isset($Page->valid_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasearch", "x_valid_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->valid_till_counter->Visible) { // valid_till_counter ?>
    <div id="r_valid_till_counter" class="row"<?= $Page->valid_till_counter->rowAttributes() ?>>
        <label for="x_valid_till_counter" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_valid_till_counter"><?= $Page->valid_till_counter->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_valid_till_counter" id="z_valid_till_counter" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->valid_till_counter->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_valid_till_counter" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->valid_till_counter->getInputTextType() ?>" name="x_valid_till_counter" id="x_valid_till_counter" data-table="client_hardware_data" data-field="x_valid_till_counter" value="<?= $Page->valid_till_counter->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->valid_till_counter->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->valid_till_counter->formatPattern()) ?>"<?= $Page->valid_till_counter->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->valid_till_counter->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->free_service->Visible) { // free_service ?>
    <div id="r_free_service" class="row"<?= $Page->free_service->rowAttributes() ?>>
        <label for="x_free_service" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_free_service"><?= $Page->free_service->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_free_service" id="z_free_service" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->free_service->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_free_service" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->free_service->getInputTextType() ?>" name="x_free_service" id="x_free_service" data-table="client_hardware_data" data-field="x_free_service" value="<?= $Page->free_service->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->free_service->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->free_service->formatPattern()) ?>"<?= $Page->free_service->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->free_service->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->toner_life->Visible) { // toner_life ?>
    <div id="r_toner_life" class="row"<?= $Page->toner_life->rowAttributes() ?>>
        <label for="x_toner_life" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_toner_life"><?= $Page->toner_life->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_toner_life" id="z_toner_life" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->toner_life->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_toner_life" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->toner_life->getInputTextType() ?>" name="x_toner_life" id="x_toner_life" data-table="client_hardware_data" data-field="x_toner_life" value="<?= $Page->toner_life->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->toner_life->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->toner_life->formatPattern()) ?>"<?= $Page->toner_life->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->toner_life->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->drum_life->Visible) { // drum_life ?>
    <div id="r_drum_life" class="row"<?= $Page->drum_life->rowAttributes() ?>>
        <label for="x_drum_life" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_drum_life"><?= $Page->drum_life->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_drum_life" id="z_drum_life" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->drum_life->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_drum_life" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->drum_life->getInputTextType() ?>" name="x_drum_life" id="x_drum_life" data-table="client_hardware_data" data-field="x_drum_life" value="<?= $Page->drum_life->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->drum_life->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->drum_life->formatPattern()) ?>"<?= $Page->drum_life->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->drum_life->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->developer_life->Visible) { // developer_life ?>
    <div id="r_developer_life" class="row"<?= $Page->developer_life->rowAttributes() ?>>
        <label for="x_developer_life" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_developer_life"><?= $Page->developer_life->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_developer_life" id="z_developer_life" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->developer_life->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_developer_life" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->developer_life->getInputTextType() ?>" name="x_developer_life" id="x_developer_life" data-table="client_hardware_data" data-field="x_developer_life" value="<?= $Page->developer_life->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->developer_life->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->developer_life->formatPattern()) ?>"<?= $Page->developer_life->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->developer_life->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->date_install->Visible) { // date_install ?>
    <div id="r_date_install" class="row"<?= $Page->date_install->rowAttributes() ?>>
        <label for="x_date_install" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_date_install"><?= $Page->date_install->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_date_install" id="z_date_install" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->date_install->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_date_install" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->date_install->getInputTextType() ?>" name="x_date_install" id="x_date_install" data-table="client_hardware_data" data-field="x_date_install" value="<?= $Page->date_install->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_install->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_install->formatPattern()) ?>"<?= $Page->date_install->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->date_install->getErrorMessage(false) ?></div>
<?php if (!$Page->date_install->ReadOnly && !$Page->date_install->Disabled && !isset($Page->date_install->EditAttrs["readonly"]) && !isset($Page->date_install->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasearch", "x_date_install", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->date_start->Visible) { // date_start ?>
    <div id="r_date_start" class="row"<?= $Page->date_start->rowAttributes() ?>>
        <label for="x_date_start" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_date_start"><?= $Page->date_start->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_date_start" id="z_date_start" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->date_start->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_date_start" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->date_start->getInputTextType() ?>" name="x_date_start" id="x_date_start" data-table="client_hardware_data" data-field="x_date_start" value="<?= $Page->date_start->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_start->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_start->formatPattern()) ?>"<?= $Page->date_start->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->date_start->getErrorMessage(false) ?></div>
<?php if (!$Page->date_start->ReadOnly && !$Page->date_start->Disabled && !isset($Page->date_start->EditAttrs["readonly"]) && !isset($Page->date_start->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasearch", "x_date_start", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark" class="row"<?= $Page->remark->rowAttributes() ?>>
        <label for="x_remark" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_remark"><?= $Page->remark->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remark" id="z_remark" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remark->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_remark" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="client_hardware_data" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_datasearch_x_status"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_status", selectId: "fclient_hardware_datasearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_datasearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_status", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->schedule_service_type->Visible) { // schedule_service_type ?>
    <div id="r_schedule_service_type" class="row"<?= $Page->schedule_service_type->rowAttributes() ?>>
        <label for="x_schedule_service_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_schedule_service_type"><?= $Page->schedule_service_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_schedule_service_type" id="z_schedule_service_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->schedule_service_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_schedule_service_type" class="ew-search-field">
    <select
        id="x_schedule_service_type"
        name="x_schedule_service_type"
        class="form-select ew-select<?= $Page->schedule_service_type->isInvalidClass() ?>"
        <?php if (!$Page->schedule_service_type->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_datasearch_x_schedule_service_type"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_schedule_service_type"
        data-value-separator="<?= $Page->schedule_service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->schedule_service_type->getPlaceHolder()) ?>"
        <?= $Page->schedule_service_type->editAttributes() ?>>
        <?= $Page->schedule_service_type->selectOptionListHtml("x_schedule_service_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->schedule_service_type->getErrorMessage(false) ?></div>
<?= $Page->schedule_service_type->Lookup->getParamTag($Page, "p_x_schedule_service_type") ?>
<?php if (!$Page->schedule_service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_schedule_service_type", selectId: "fclient_hardware_datasearch_x_schedule_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_datasearch.lists.schedule_service_type?.lookupOptions.length) {
        options.data = { id: "x_schedule_service_type", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_schedule_service_type", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.schedule_service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_schedule_service_type_1" name="v_schedule_service_type" value="AND"<?= ($Page->schedule_service_type->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_schedule_service_type_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_schedule_service_type_2" name="v_schedule_service_type" value="OR"<?= ($Page->schedule_service_type->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_schedule_service_type_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_schedule_service_type" id="w_schedule_service_type" value="=">
</span>
                    <span id="el2_client_hardware_data_schedule_service_type" class="ew-search-field2">
    <select
        id="y_schedule_service_type"
        name="y_schedule_service_type"
        class="form-select ew-select<?= $Page->schedule_service_type->isInvalidClass() ?>"
        <?php if (!$Page->schedule_service_type->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_datasearch_y_schedule_service_type"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_schedule_service_type"
        data-value-separator="<?= $Page->schedule_service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->schedule_service_type->getPlaceHolder()) ?>"
        <?= $Page->schedule_service_type->editAttributes() ?>>
        <?= $Page->schedule_service_type->selectOptionListHtml("y_schedule_service_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->schedule_service_type->getErrorMessage(false) ?></div>
<?= $Page->schedule_service_type->Lookup->getParamTag($Page, "p_y_schedule_service_type") ?>
<?php if (!$Page->schedule_service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "y_schedule_service_type", selectId: "fclient_hardware_datasearch_y_schedule_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_datasearch.lists.schedule_service_type?.lookupOptions.length) {
        options.data = { id: "y_schedule_service_type", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "y_schedule_service_type", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.schedule_service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
    <div id="r_schedule_service_interval_days" class="row"<?= $Page->schedule_service_interval_days->rowAttributes() ?>>
        <label for="x_schedule_service_interval_days" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_schedule_service_interval_days"><?= $Page->schedule_service_interval_days->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_schedule_service_interval_days" id="z_schedule_service_interval_days" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->schedule_service_interval_days->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_schedule_service_interval_days" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->schedule_service_interval_days->getInputTextType() ?>" name="x_schedule_service_interval_days" id="x_schedule_service_interval_days" data-table="client_hardware_data" data-field="x_schedule_service_interval_days" value="<?= $Page->schedule_service_interval_days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->schedule_service_interval_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->schedule_service_interval_days->formatPattern()) ?>"<?= $Page->schedule_service_interval_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->schedule_service_interval_days->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
    <div id="r_schedule_service_updated_till" class="row"<?= $Page->schedule_service_updated_till->rowAttributes() ?>>
        <label for="x_schedule_service_updated_till" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_schedule_service_updated_till"><?= $Page->schedule_service_updated_till->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_schedule_service_updated_till" id="z_schedule_service_updated_till" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->schedule_service_updated_till->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_schedule_service_updated_till" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->schedule_service_updated_till->getInputTextType() ?>" name="x_schedule_service_updated_till" id="x_schedule_service_updated_till" data-table="client_hardware_data" data-field="x_schedule_service_updated_till" value="<?= $Page->schedule_service_updated_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->schedule_service_updated_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->schedule_service_updated_till->formatPattern()) ?>"<?= $Page->schedule_service_updated_till->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->schedule_service_updated_till->getErrorMessage(false) ?></div>
<?php if (!$Page->schedule_service_updated_till->ReadOnly && !$Page->schedule_service_updated_till->Disabled && !isset($Page->schedule_service_updated_till->EditAttrs["readonly"]) && !isset($Page->schedule_service_updated_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasearch", "x_schedule_service_updated_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
<script>
loadjs.ready("head", function() {
jQuery("#x_schedule_service_updated_till:not(.ew-template #x_schedule_service_updated_till)").colorpicker(ew.colorPickerOptions);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_datasearch_x_operator"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_datasearch", function() {
    var options = { name: "x_operator", selectId: "fclient_hardware_datasearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_datasearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fclient_hardware_datasearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fclient_hardware_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="client_hardware_data" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->copy_average_1->Visible) { // copy_average_1 ?>
    <div id="r_copy_average_1" class="row"<?= $Page->copy_average_1->rowAttributes() ?>>
        <label for="x_copy_average_1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_copy_average_1"><?= $Page->copy_average_1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_copy_average_1" id="z_copy_average_1" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->copy_average_1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_copy_average_1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->copy_average_1->getInputTextType() ?>" name="x_copy_average_1" id="x_copy_average_1" data-table="client_hardware_data" data-field="x_copy_average_1" value="<?= $Page->copy_average_1->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->copy_average_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->copy_average_1->formatPattern()) ?>"<?= $Page->copy_average_1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->copy_average_1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->copy_average_2->Visible) { // copy_average_2 ?>
    <div id="r_copy_average_2" class="row"<?= $Page->copy_average_2->rowAttributes() ?>>
        <label for="x_copy_average_2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_copy_average_2"><?= $Page->copy_average_2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_copy_average_2" id="z_copy_average_2" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->copy_average_2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_copy_average_2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->copy_average_2->getInputTextType() ?>" name="x_copy_average_2" id="x_copy_average_2" data-table="client_hardware_data" data-field="x_copy_average_2" value="<?= $Page->copy_average_2->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->copy_average_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->copy_average_2->formatPattern()) ?>"<?= $Page->copy_average_2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->copy_average_2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->copy_average_3->Visible) { // copy_average_3 ?>
    <div id="r_copy_average_3" class="row"<?= $Page->copy_average_3->rowAttributes() ?>>
        <label for="x_copy_average_3" class="<?= $Page->LeftColumnClass ?>"><span id="elh_client_hardware_data_copy_average_3"><?= $Page->copy_average_3->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_copy_average_3" id="z_copy_average_3" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->copy_average_3->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_client_hardware_data_copy_average_3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->copy_average_3->getInputTextType() ?>" name="x_copy_average_3" id="x_copy_average_3" data-table="client_hardware_data" data-field="x_copy_average_3" value="<?= $Page->copy_average_3->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->copy_average_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->copy_average_3->formatPattern()) ?>"<?= $Page->copy_average_3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->copy_average_3->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fclient_hardware_datasearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fclient_hardware_datasearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fclient_hardware_datasearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("client_hardware_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
