<?php

namespace PHPMaker2024\fibre;

// Page object
$ClientHardwareDataList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { client_hardware_data: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fclient_hardware_datasrch" id="fclient_hardware_datasrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fclient_hardware_datasrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { client_hardware_data: currentTable } });
var currentForm;
var fclient_hardware_datasrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fclient_hardware_datasrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["partner_id", [ew.Validators.integer], fields.partner_id.isInvalid],
            ["y_partner_id", [ew.Validators.between], false],
            ["schedule_service_updated_till", [ew.Validators.datetime(fields.schedule_service_updated_till.clientFormatPattern)], fields.schedule_service_updated_till.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
<?php
if (!$Page->partner_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->partner_id->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_partner_id" id="z_partner_id" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->partner_id->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->partner_id->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_client_hardware_data_partner_id" class="ew-search-field">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_datasrch_x_partner_id"
        data-table="client_hardware_data"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<script>
loadjs.ready("fclient_hardware_datasrch", function() {
    var options = { name: "x_partner_id", selectId: "fclient_hardware_datasrch_x_partner_id" };
    if (fclient_hardware_datasrch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fclient_hardware_datasrch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fclient_hardware_datasrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_client_hardware_data_partner_id" class="ew-search-field2 d-none">
    <select
        id="y_partner_id"
        name="y_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_datasrch_y_partner_id"
        data-table="client_hardware_data"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("y_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_y_partner_id") ?>
<script>
loadjs.ready("fclient_hardware_datasrch", function() {
    var options = { name: "y_partner_id", selectId: "fclient_hardware_datasrch_y_partner_id" };
    if (fclient_hardware_datasrch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "y_partner_id", form: "fclient_hardware_datasrch" };
    } else {
        options.ajax = { id: "y_partner_id", form: "fclient_hardware_datasrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
<?php
if (!$Page->schedule_service_updated_till->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_schedule_service_updated_till" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->schedule_service_updated_till->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_schedule_service_updated_till" class="ew-search-caption ew-label"><?= $Page->schedule_service_updated_till->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_schedule_service_updated_till" id="z_schedule_service_updated_till" value="=">
</div>
        </div>
        <div id="el_client_hardware_data_schedule_service_updated_till" class="ew-search-field">
<input type="<?= $Page->schedule_service_updated_till->getInputTextType() ?>" name="x_schedule_service_updated_till" id="x_schedule_service_updated_till" data-table="client_hardware_data" data-field="x_schedule_service_updated_till" value="<?= $Page->schedule_service_updated_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->schedule_service_updated_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->schedule_service_updated_till->formatPattern()) ?>"<?= $Page->schedule_service_updated_till->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->schedule_service_updated_till->getErrorMessage(false) ?></div>
<?php if (!$Page->schedule_service_updated_till->ReadOnly && !$Page->schedule_service_updated_till->Disabled && !isset($Page->schedule_service_updated_till->EditAttrs["readonly"]) && !isset($Page->schedule_service_updated_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_datasrch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_datasrch", "x_schedule_service_updated_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
<script>
loadjs.ready("head", function() {
jQuery("#x_schedule_service_updated_till:not(.ew-template #x_schedule_service_updated_till)").colorpicker(ew.colorPickerOptions);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fclient_hardware_datasrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fclient_hardware_datasrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fclient_hardware_datasrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fclient_hardware_datasrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fclient_hardware_datasrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fclient_hardware_datasrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fclient_hardware_datasrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="client_hardware_data">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_client_hardware_data" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_client_hardware_datalist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_client_hardware_data_id" class="client_hardware_data_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_client_hardware_data_ref" class="client_hardware_data_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Page->partner_id->headerCellClass() ?>"><div id="elh_client_hardware_data_partner_id" class="client_hardware_data_partner_id"><?= $Page->renderFieldHeader($Page->partner_id) ?></div></th>
<?php } ?>
<?php if ($Page->name_ref->Visible) { // name_ref ?>
        <th data-name="name_ref" class="<?= $Page->name_ref->headerCellClass() ?>"><div id="elh_client_hardware_data_name_ref" class="client_hardware_data_name_ref"><?= $Page->renderFieldHeader($Page->name_ref) ?></div></th>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
        <th data-name="city_name" class="<?= $Page->city_name->headerCellClass() ?>"><div id="elh_client_hardware_data_city_name" class="client_hardware_data_city_name"><?= $Page->renderFieldHeader($Page->city_name) ?></div></th>
<?php } ?>
<?php if ($Page->area->Visible) { // area ?>
        <th data-name="area" class="<?= $Page->area->headerCellClass() ?>"><div id="elh_client_hardware_data_area" class="client_hardware_data_area"><?= $Page->renderFieldHeader($Page->area) ?></div></th>
<?php } ?>
<?php if ($Page->harward_code->Visible) { // harward_code ?>
        <th data-name="harward_code" class="<?= $Page->harward_code->headerCellClass() ?>"><div id="elh_client_hardware_data_harward_code" class="client_hardware_data_harward_code"><?= $Page->renderFieldHeader($Page->harward_code) ?></div></th>
<?php } ?>
<?php if ($Page->serial_no->Visible) { // serial_no ?>
        <th data-name="serial_no" class="<?= $Page->serial_no->headerCellClass() ?>"><div id="elh_client_hardware_data_serial_no" class="client_hardware_data_serial_no"><?= $Page->renderFieldHeader($Page->serial_no) ?></div></th>
<?php } ?>
<?php if ($Page->date_install->Visible) { // date_install ?>
        <th data-name="date_install" class="<?= $Page->date_install->headerCellClass() ?>"><div id="elh_client_hardware_data_date_install" class="client_hardware_data_date_install"><?= $Page->renderFieldHeader($Page->date_install) ?></div></th>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
        <th data-name="remark" class="<?= $Page->remark->headerCellClass() ?>"><div id="elh_client_hardware_data_remark" class="client_hardware_data_remark"><?= $Page->renderFieldHeader($Page->remark) ?></div></th>
<?php } ?>
<?php if ($Page->schedule_service_type->Visible) { // schedule_service_type ?>
        <th data-name="schedule_service_type" class="<?= $Page->schedule_service_type->headerCellClass() ?>"><div id="elh_client_hardware_data_schedule_service_type" class="client_hardware_data_schedule_service_type"><?= $Page->renderFieldHeader($Page->schedule_service_type) ?></div></th>
<?php } ?>
<?php if ($Page->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
        <th data-name="schedule_service_interval_days" class="<?= $Page->schedule_service_interval_days->headerCellClass() ?>"><div id="elh_client_hardware_data_schedule_service_interval_days" class="client_hardware_data_schedule_service_interval_days"><?= $Page->renderFieldHeader($Page->schedule_service_interval_days) ?></div></th>
<?php } ?>
<?php if ($Page->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
        <th data-name="schedule_service_updated_till" class="<?= $Page->schedule_service_updated_till->headerCellClass() ?>"><div id="elh_client_hardware_data_schedule_service_updated_till" class="client_hardware_data_schedule_service_updated_till"><?= $Page->renderFieldHeader($Page->schedule_service_updated_till) ?></div></th>
<?php } ?>
<?php if ($Page->copy_average_1->Visible) { // copy_average_1 ?>
        <th data-name="copy_average_1" class="<?= $Page->copy_average_1->headerCellClass() ?>"><div id="elh_client_hardware_data_copy_average_1" class="client_hardware_data_copy_average_1"><?= $Page->renderFieldHeader($Page->copy_average_1) ?></div></th>
<?php } ?>
<?php if ($Page->copy_average_2->Visible) { // copy_average_2 ?>
        <th data-name="copy_average_2" class="<?= $Page->copy_average_2->headerCellClass() ?>"><div id="elh_client_hardware_data_copy_average_2" class="client_hardware_data_copy_average_2"><?= $Page->renderFieldHeader($Page->copy_average_2) ?></div></th>
<?php } ?>
<?php if ($Page->copy_average_3->Visible) { // copy_average_3 ?>
        <th data-name="copy_average_3" class="<?= $Page->copy_average_3->headerCellClass() ?>"><div id="elh_client_hardware_data_copy_average_3" class="client_hardware_data_copy_average_3"><?= $Page->renderFieldHeader($Page->copy_average_3) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_id" class="el_client_hardware_data_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_ref" class="el_client_hardware_data_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Page->partner_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_partner_id" class="el_client_hardware_data_partner_id">
<span<?= $Page->partner_id->viewAttributes() ?>>
<?= $Page->partner_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->name_ref->Visible) { // name_ref ?>
        <td data-name="name_ref"<?= $Page->name_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_name_ref" class="el_client_hardware_data_name_ref">
<span<?= $Page->name_ref->viewAttributes() ?>>
<?= $Page->name_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city_name->Visible) { // city_name ?>
        <td data-name="city_name"<?= $Page->city_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_city_name" class="el_client_hardware_data_city_name">
<span<?= $Page->city_name->viewAttributes() ?>>
<?= $Page->city_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->area->Visible) { // area ?>
        <td data-name="area"<?= $Page->area->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_area" class="el_client_hardware_data_area">
<span<?= $Page->area->viewAttributes() ?>>
<?= $Page->area->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->harward_code->Visible) { // harward_code ?>
        <td data-name="harward_code"<?= $Page->harward_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_harward_code" class="el_client_hardware_data_harward_code">
<span<?= $Page->harward_code->viewAttributes() ?>>
<?= $Page->harward_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->serial_no->Visible) { // serial_no ?>
        <td data-name="serial_no"<?= $Page->serial_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_serial_no" class="el_client_hardware_data_serial_no">
<span<?= $Page->serial_no->viewAttributes() ?>>
<?= $Page->serial_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->date_install->Visible) { // date_install ?>
        <td data-name="date_install"<?= $Page->date_install->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_date_install" class="el_client_hardware_data_date_install">
<span<?= $Page->date_install->viewAttributes() ?>>
<?= $Page->date_install->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remark->Visible) { // remark ?>
        <td data-name="remark"<?= $Page->remark->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_remark" class="el_client_hardware_data_remark">
<span<?= $Page->remark->viewAttributes() ?>>
<?= $Page->remark->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->schedule_service_type->Visible) { // schedule_service_type ?>
        <td data-name="schedule_service_type"<?= $Page->schedule_service_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_schedule_service_type" class="el_client_hardware_data_schedule_service_type">
<span<?= $Page->schedule_service_type->viewAttributes() ?>>
<?= $Page->schedule_service_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
        <td data-name="schedule_service_interval_days"<?= $Page->schedule_service_interval_days->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_schedule_service_interval_days" class="el_client_hardware_data_schedule_service_interval_days">
<span<?= $Page->schedule_service_interval_days->viewAttributes() ?>>
<?= $Page->schedule_service_interval_days->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
        <td data-name="schedule_service_updated_till"<?= $Page->schedule_service_updated_till->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_schedule_service_updated_till" class="el_client_hardware_data_schedule_service_updated_till">
<span<?= $Page->schedule_service_updated_till->viewAttributes() ?>>
<?= $Page->schedule_service_updated_till->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->copy_average_1->Visible) { // copy_average_1 ?>
        <td data-name="copy_average_1"<?= $Page->copy_average_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_copy_average_1" class="el_client_hardware_data_copy_average_1">
<span<?= $Page->copy_average_1->viewAttributes() ?>>
<?= $Page->copy_average_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->copy_average_2->Visible) { // copy_average_2 ?>
        <td data-name="copy_average_2"<?= $Page->copy_average_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_copy_average_2" class="el_client_hardware_data_copy_average_2">
<span<?= $Page->copy_average_2->viewAttributes() ?>>
<?= $Page->copy_average_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->copy_average_3->Visible) { // copy_average_3 ?>
        <td data-name="copy_average_3"<?= $Page->copy_average_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_client_hardware_data_copy_average_3" class="el_client_hardware_data_copy_average_3">
<span<?= $Page->copy_average_3->viewAttributes() ?>>
<?= $Page->copy_average_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("client_hardware_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
