<?php

namespace PHPMaker2024\fibre;

// Page object
$ClientHardwareDataAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { client_hardware_data: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fclient_hardware_dataaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fclient_hardware_dataaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["customer_grp", [fields.customer_grp.visible && fields.customer_grp.required ? ew.Validators.required(fields.customer_grp.caption) : null], fields.customer_grp.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null, ew.Validators.integer], fields.partner_id.isInvalid],
            ["name_ref", [fields.name_ref.visible && fields.name_ref.required ? ew.Validators.required(fields.name_ref.caption) : null], fields.name_ref.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["area", [fields.area.visible && fields.area.required ? ew.Validators.required(fields.area.caption) : null], fields.area.isInvalid],
            ["billing_name", [fields.billing_name.visible && fields.billing_name.required ? ew.Validators.required(fields.billing_name.caption) : null], fields.billing_name.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["personal_ref", [fields.personal_ref.visible && fields.personal_ref.required ? ew.Validators.required(fields.personal_ref.caption) : null], fields.personal_ref.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["rid_1", [fields.rid_1.visible && fields.rid_1.required ? ew.Validators.required(fields.rid_1.caption) : null], fields.rid_1.isInvalid],
            ["harward_code", [fields.harward_code.visible && fields.harward_code.required ? ew.Validators.required(fields.harward_code.caption) : null], fields.harward_code.isInvalid],
            ["serial_no", [fields.serial_no.visible && fields.serial_no.required ? ew.Validators.required(fields.serial_no.caption) : null], fields.serial_no.isInvalid],
            ["invoice_no", [fields.invoice_no.visible && fields.invoice_no.required ? ew.Validators.required(fields.invoice_no.caption) : null], fields.invoice_no.isInvalid],
            ["invoice_date", [fields.invoice_date.visible && fields.invoice_date.required ? ew.Validators.required(fields.invoice_date.caption) : null, ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid],
            ["first_counter", [fields.first_counter.visible && fields.first_counter.required ? ew.Validators.required(fields.first_counter.caption) : null, ew.Validators.integer], fields.first_counter.isInvalid],
            ["guarantee", [fields.guarantee.visible && fields.guarantee.required ? ew.Validators.required(fields.guarantee.caption) : null], fields.guarantee.isInvalid],
            ["valid_till", [fields.valid_till.visible && fields.valid_till.required ? ew.Validators.required(fields.valid_till.caption) : null, ew.Validators.datetime(fields.valid_till.clientFormatPattern)], fields.valid_till.isInvalid],
            ["valid_till_counter", [fields.valid_till_counter.visible && fields.valid_till_counter.required ? ew.Validators.required(fields.valid_till_counter.caption) : null, ew.Validators.integer], fields.valid_till_counter.isInvalid],
            ["free_service", [fields.free_service.visible && fields.free_service.required ? ew.Validators.required(fields.free_service.caption) : null, ew.Validators.integer], fields.free_service.isInvalid],
            ["toner_life", [fields.toner_life.visible && fields.toner_life.required ? ew.Validators.required(fields.toner_life.caption) : null, ew.Validators.integer], fields.toner_life.isInvalid],
            ["drum_life", [fields.drum_life.visible && fields.drum_life.required ? ew.Validators.required(fields.drum_life.caption) : null, ew.Validators.integer], fields.drum_life.isInvalid],
            ["developer_life", [fields.developer_life.visible && fields.developer_life.required ? ew.Validators.required(fields.developer_life.caption) : null, ew.Validators.integer], fields.developer_life.isInvalid],
            ["date_install", [fields.date_install.visible && fields.date_install.required ? ew.Validators.required(fields.date_install.caption) : null, ew.Validators.datetime(fields.date_install.clientFormatPattern)], fields.date_install.isInvalid],
            ["date_start", [fields.date_start.visible && fields.date_start.required ? ew.Validators.required(fields.date_start.caption) : null, ew.Validators.datetime(fields.date_start.clientFormatPattern)], fields.date_start.isInvalid],
            ["remark", [fields.remark.visible && fields.remark.required ? ew.Validators.required(fields.remark.caption) : null], fields.remark.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["schedule_service_type", [fields.schedule_service_type.visible && fields.schedule_service_type.required ? ew.Validators.required(fields.schedule_service_type.caption) : null], fields.schedule_service_type.isInvalid],
            ["schedule_service_interval_days", [fields.schedule_service_interval_days.visible && fields.schedule_service_interval_days.required ? ew.Validators.required(fields.schedule_service_interval_days.caption) : null, ew.Validators.integer], fields.schedule_service_interval_days.isInvalid],
            ["schedule_service_updated_till", [fields.schedule_service_updated_till.visible && fields.schedule_service_updated_till.required ? ew.Validators.required(fields.schedule_service_updated_till.caption) : null, ew.Validators.datetime(fields.schedule_service_updated_till.clientFormatPattern)], fields.schedule_service_updated_till.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["copy_average_1", [fields.copy_average_1.visible && fields.copy_average_1.required ? ew.Validators.required(fields.copy_average_1.caption) : null, ew.Validators.integer], fields.copy_average_1.isInvalid],
            ["copy_average_2", [fields.copy_average_2.visible && fields.copy_average_2.required ? ew.Validators.required(fields.copy_average_2.caption) : null, ew.Validators.integer], fields.copy_average_2.isInvalid],
            ["copy_average_3", [fields.copy_average_3.visible && fields.copy_average_3.required ? ew.Validators.required(fields.copy_average_3.caption) : null, ew.Validators.integer], fields.copy_average_3.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "customer_grp": <?= $Page->customer_grp->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "area": <?= $Page->area->toClientList($Page) ?>,
            "personal_ref": <?= $Page->personal_ref->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "guarantee": <?= $Page->guarantee->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "schedule_service_type": <?= $Page->schedule_service_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fclient_hardware_dataaddopt" id="fclient_hardware_dataaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="client_hardware_data">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->customer_grp->Visible) { // customer_grp ?>
    <div id="r_customer_grp"<?= $Page->customer_grp->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->customer_grp->caption() ?><?= $Page->customer_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->customer_grp->cellAttributes() ?>>
<template id="tp_x_customer_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="client_hardware_data" data-field="x_customer_grp" name="x_customer_grp" id="x_customer_grp"<?= $Page->customer_grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_customer_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_customer_grp[]"
    name="x_customer_grp[]"
    value="<?= HtmlEncode($Page->customer_grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_customer_grp"
    data-target="dsl_x_customer_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->customer_grp->isInvalidClass() ?>"
    data-table="client_hardware_data"
    data-field="x_customer_grp"
    data-value-separator="<?= $Page->customer_grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->customer_grp->editAttributes() ?>></selection-list>
<?= $Page->customer_grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->customer_grp->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "client_category") && !$Page->customer_grp->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_customer_grp" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->customer_grp->caption() ?>" data-title="<?= $Page->customer_grp->caption() ?>" data-ew-action="add-option" data-el="x_customer_grp[]" data-url="<?= GetUrl("clientcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->customer_grp->Lookup->getParamTag($Page, "p_x_customer_grp") ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_ref"><?= $Page->ref->caption() ?><?= $Page->ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->ref->cellAttributes() ?>>
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="client_hardware_data" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?> aria-describedby="x_ref_help">
<?= $Page->ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->partner_id->caption() ?><?= $Page->partner_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->partner_id->cellAttributes() ?>>
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_dataaddopt_x_partner_id"
        data-table="client_hardware_data"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <?= $Page->partner_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage() ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_partner_id", selectId: "fclient_hardware_dataaddopt_x_partner_id" };
    if (fclient_hardware_dataaddopt.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name_ref->Visible) { // name_ref ?>
    <div id="r_name_ref"<?= $Page->name_ref->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_name_ref"><?= $Page->name_ref->caption() ?><?= $Page->name_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->name_ref->cellAttributes() ?>>
<input type="<?= $Page->name_ref->getInputTextType() ?>" name="x_name_ref" id="x_name_ref" data-table="client_hardware_data" data-field="x_name_ref" value="<?= $Page->name_ref->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name_ref->formatPattern()) ?>"<?= $Page->name_ref->editAttributes() ?> aria-describedby="x_name_ref_help">
<?= $Page->name_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name_ref->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name"<?= $Page->city_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_city_name"><?= $Page->city_name->caption() ?><?= $Page->city_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->city_name->cellAttributes() ?>>
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="client_hardware_data" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?> aria-describedby="x_city_name_help">
<?= $Page->city_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->area->Visible) { // area ?>
    <div id="r_area"<?= $Page->area->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->area->caption() ?><?= $Page->area->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->area->cellAttributes() ?>>
    <select
        id="x_area"
        name="x_area"
        class="form-control ew-select<?= $Page->area->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_dataaddopt_x_area"
        data-table="client_hardware_data"
        data-field="x_area"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->area->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->area->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->area->getPlaceHolder()) ?>"
        <?= $Page->area->editAttributes() ?>>
        <?= $Page->area->selectOptionListHtml("x_area") ?>
    </select>
    <?= $Page->area->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->area->getErrorMessage() ?></div>
<?= $Page->area->Lookup->getParamTag($Page, "p_x_area") ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_area", selectId: "fclient_hardware_dataaddopt_x_area" };
    if (fclient_hardware_dataaddopt.lists.area?.lookupOptions.length) {
        options.data = { id: "x_area", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_area", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.area.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->billing_name->Visible) { // billing_name ?>
    <div id="r_billing_name"<?= $Page->billing_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_billing_name"><?= $Page->billing_name->caption() ?><?= $Page->billing_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->billing_name->cellAttributes() ?>>
<input type="<?= $Page->billing_name->getInputTextType() ?>" name="x_billing_name" id="x_billing_name" data-table="client_hardware_data" data-field="x_billing_name" value="<?= $Page->billing_name->EditValue ?>" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->billing_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->billing_name->formatPattern()) ?>"<?= $Page->billing_name->editAttributes() ?> aria-describedby="x_billing_name_help">
<?= $Page->billing_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->billing_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_address"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->address->cellAttributes() ?>>
<textarea data-table="client_hardware_data" data-field="x_address" name="x_address" id="x_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->personal_ref->Visible) { // personal_ref ?>
    <div id="r_personal_ref"<?= $Page->personal_ref->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->personal_ref->caption() ?><?= $Page->personal_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->personal_ref->cellAttributes() ?>>
<div class="input-group flex-nowrap">
    <select
        id="x_personal_ref[]"
        name="x_personal_ref[]"
        class="form-control ew-select<?= $Page->personal_ref->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_dataaddopt_x_personal_ref[]"
        data-table="client_hardware_data"
        data-field="x_personal_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->personal_ref->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->personal_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->personal_ref->getPlaceHolder()) ?>"
        <?= $Page->personal_ref->editAttributes() ?>>
        <?= $Page->personal_ref->selectOptionListHtml("x_personal_ref[]") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "personal_info") && !$Page->personal_ref->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_personal_ref" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->personal_ref->caption() ?>" data-title="<?= $Page->personal_ref->caption() ?>" data-ew-action="add-option" data-el="x_personal_ref[]" data-url="<?= GetUrl("personalinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->personal_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->personal_ref->getErrorMessage() ?></div>
<?= $Page->personal_ref->Lookup->getParamTag($Page, "p_x_personal_ref") ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_personal_ref[]", selectId: "fclient_hardware_dataaddopt_x_personal_ref[]" };
    options.multiple = true;
    if (fclient_hardware_dataaddopt.lists.personal_ref?.lookupOptions.length) {
        options.data = { id: "x_personal_ref[]", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_personal_ref[]", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.personal_ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_grp"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->grp->cellAttributes() ?>>
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_dataaddopt_x_grp"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_grp", selectId: "fclient_hardware_dataaddopt_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_dataaddopt.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_grp", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->s_grp->cellAttributes() ?>>
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_dataaddopt_x_s_grp"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_s_grp", selectId: "fclient_hardware_dataaddopt_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_dataaddopt.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_product"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->product->cellAttributes() ?>>
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_dataaddopt_x_product"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <?= $Page->product->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_product", selectId: "fclient_hardware_dataaddopt_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_dataaddopt.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_product", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->rid->cellAttributes() ?>>
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fclient_hardware_dataaddopt_x_rid"
        data-table="client_hardware_data"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <?= $Page->rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_rid", selectId: "fclient_hardware_dataaddopt_x_rid" };
    if (fclient_hardware_dataaddopt.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_rid", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.client_hardware_data.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_1->Visible) { // rid_1 ?>
    <div id="r_rid_1"<?= $Page->rid_1->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_rid_1"><?= $Page->rid_1->caption() ?><?= $Page->rid_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->rid_1->cellAttributes() ?>>
<input type="<?= $Page->rid_1->getInputTextType() ?>" name="x_rid_1" id="x_rid_1" data-table="client_hardware_data" data-field="x_rid_1" value="<?= $Page->rid_1->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->rid_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid_1->formatPattern()) ?>"<?= $Page->rid_1->editAttributes() ?> aria-describedby="x_rid_1_help">
<?= $Page->rid_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rid_1->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->harward_code->Visible) { // harward_code ?>
    <div id="r_harward_code"<?= $Page->harward_code->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_harward_code"><?= $Page->harward_code->caption() ?><?= $Page->harward_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->harward_code->cellAttributes() ?>>
<input type="<?= $Page->harward_code->getInputTextType() ?>" name="x_harward_code" id="x_harward_code" data-table="client_hardware_data" data-field="x_harward_code" value="<?= $Page->harward_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->harward_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->harward_code->formatPattern()) ?>"<?= $Page->harward_code->editAttributes() ?> aria-describedby="x_harward_code_help">
<?= $Page->harward_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->harward_code->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->serial_no->Visible) { // serial_no ?>
    <div id="r_serial_no"<?= $Page->serial_no->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_serial_no"><?= $Page->serial_no->caption() ?><?= $Page->serial_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->serial_no->cellAttributes() ?>>
<input type="<?= $Page->serial_no->getInputTextType() ?>" name="x_serial_no" id="x_serial_no" data-table="client_hardware_data" data-field="x_serial_no" value="<?= $Page->serial_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->serial_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->serial_no->formatPattern()) ?>"<?= $Page->serial_no->editAttributes() ?> aria-describedby="x_serial_no_help">
<?= $Page->serial_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->serial_no->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_no->Visible) { // invoice_no ?>
    <div id="r_invoice_no"<?= $Page->invoice_no->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_invoice_no"><?= $Page->invoice_no->caption() ?><?= $Page->invoice_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->invoice_no->cellAttributes() ?>>
<input type="<?= $Page->invoice_no->getInputTextType() ?>" name="x_invoice_no" id="x_invoice_no" data-table="client_hardware_data" data-field="x_invoice_no" value="<?= $Page->invoice_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->invoice_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_no->formatPattern()) ?>"<?= $Page->invoice_no->editAttributes() ?> aria-describedby="x_invoice_no_help">
<?= $Page->invoice_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_no->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date"<?= $Page->invoice_date->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_invoice_date"><?= $Page->invoice_date->caption() ?><?= $Page->invoice_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->invoice_date->cellAttributes() ?>>
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="client_hardware_data" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?> aria-describedby="x_invoice_date_help">
<?= $Page->invoice_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage() ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_dataaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->first_counter->Visible) { // first_counter ?>
    <div id="r_first_counter"<?= $Page->first_counter->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_first_counter"><?= $Page->first_counter->caption() ?><?= $Page->first_counter->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->first_counter->cellAttributes() ?>>
<input type="<?= $Page->first_counter->getInputTextType() ?>" name="x_first_counter" id="x_first_counter" data-table="client_hardware_data" data-field="x_first_counter" value="<?= $Page->first_counter->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->first_counter->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->first_counter->formatPattern()) ?>"<?= $Page->first_counter->editAttributes() ?> aria-describedby="x_first_counter_help">
<?= $Page->first_counter->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->first_counter->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->guarantee->Visible) { // guarantee ?>
    <div id="r_guarantee"<?= $Page->guarantee->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_guarantee"><?= $Page->guarantee->caption() ?><?= $Page->guarantee->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->guarantee->cellAttributes() ?>>
    <select
        id="x_guarantee"
        name="x_guarantee"
        class="form-select ew-select<?= $Page->guarantee->isInvalidClass() ?>"
        <?php if (!$Page->guarantee->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_dataaddopt_x_guarantee"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_guarantee"
        data-value-separator="<?= $Page->guarantee->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->guarantee->getPlaceHolder()) ?>"
        <?= $Page->guarantee->editAttributes() ?>>
        <?= $Page->guarantee->selectOptionListHtml("x_guarantee") ?>
    </select>
    <?= $Page->guarantee->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->guarantee->getErrorMessage() ?></div>
<?php if (!$Page->guarantee->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_guarantee", selectId: "fclient_hardware_dataaddopt_x_guarantee" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_dataaddopt.lists.guarantee?.lookupOptions.length) {
        options.data = { id: "x_guarantee", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_guarantee", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.guarantee.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->valid_till->Visible) { // valid_till ?>
    <div id="r_valid_till"<?= $Page->valid_till->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_valid_till"><?= $Page->valid_till->caption() ?><?= $Page->valid_till->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->valid_till->cellAttributes() ?>>
<input type="<?= $Page->valid_till->getInputTextType() ?>" name="x_valid_till" id="x_valid_till" data-table="client_hardware_data" data-field="x_valid_till" value="<?= $Page->valid_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->valid_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->valid_till->formatPattern()) ?>"<?= $Page->valid_till->editAttributes() ?> aria-describedby="x_valid_till_help">
<?= $Page->valid_till->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->valid_till->getErrorMessage() ?></div>
<?php if (!$Page->valid_till->ReadOnly && !$Page->valid_till->Disabled && !isset($Page->valid_till->EditAttrs["readonly"]) && !isset($Page->valid_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_dataaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_valid_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->valid_till_counter->Visible) { // valid_till_counter ?>
    <div id="r_valid_till_counter"<?= $Page->valid_till_counter->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_valid_till_counter"><?= $Page->valid_till_counter->caption() ?><?= $Page->valid_till_counter->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->valid_till_counter->cellAttributes() ?>>
<input type="<?= $Page->valid_till_counter->getInputTextType() ?>" name="x_valid_till_counter" id="x_valid_till_counter" data-table="client_hardware_data" data-field="x_valid_till_counter" value="<?= $Page->valid_till_counter->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->valid_till_counter->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->valid_till_counter->formatPattern()) ?>"<?= $Page->valid_till_counter->editAttributes() ?> aria-describedby="x_valid_till_counter_help">
<?= $Page->valid_till_counter->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->valid_till_counter->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->free_service->Visible) { // free_service ?>
    <div id="r_free_service"<?= $Page->free_service->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_free_service"><?= $Page->free_service->caption() ?><?= $Page->free_service->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->free_service->cellAttributes() ?>>
<input type="<?= $Page->free_service->getInputTextType() ?>" name="x_free_service" id="x_free_service" data-table="client_hardware_data" data-field="x_free_service" value="<?= $Page->free_service->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->free_service->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->free_service->formatPattern()) ?>"<?= $Page->free_service->editAttributes() ?> aria-describedby="x_free_service_help">
<?= $Page->free_service->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->free_service->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->toner_life->Visible) { // toner_life ?>
    <div id="r_toner_life"<?= $Page->toner_life->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_toner_life"><?= $Page->toner_life->caption() ?><?= $Page->toner_life->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->toner_life->cellAttributes() ?>>
<input type="<?= $Page->toner_life->getInputTextType() ?>" name="x_toner_life" id="x_toner_life" data-table="client_hardware_data" data-field="x_toner_life" value="<?= $Page->toner_life->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->toner_life->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->toner_life->formatPattern()) ?>"<?= $Page->toner_life->editAttributes() ?> aria-describedby="x_toner_life_help">
<?= $Page->toner_life->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->toner_life->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->drum_life->Visible) { // drum_life ?>
    <div id="r_drum_life"<?= $Page->drum_life->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_drum_life"><?= $Page->drum_life->caption() ?><?= $Page->drum_life->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->drum_life->cellAttributes() ?>>
<input type="<?= $Page->drum_life->getInputTextType() ?>" name="x_drum_life" id="x_drum_life" data-table="client_hardware_data" data-field="x_drum_life" value="<?= $Page->drum_life->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->drum_life->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->drum_life->formatPattern()) ?>"<?= $Page->drum_life->editAttributes() ?> aria-describedby="x_drum_life_help">
<?= $Page->drum_life->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->drum_life->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->developer_life->Visible) { // developer_life ?>
    <div id="r_developer_life"<?= $Page->developer_life->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_developer_life"><?= $Page->developer_life->caption() ?><?= $Page->developer_life->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->developer_life->cellAttributes() ?>>
<input type="<?= $Page->developer_life->getInputTextType() ?>" name="x_developer_life" id="x_developer_life" data-table="client_hardware_data" data-field="x_developer_life" value="<?= $Page->developer_life->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->developer_life->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->developer_life->formatPattern()) ?>"<?= $Page->developer_life->editAttributes() ?> aria-describedby="x_developer_life_help">
<?= $Page->developer_life->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->developer_life->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->date_install->Visible) { // date_install ?>
    <div id="r_date_install"<?= $Page->date_install->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_date_install"><?= $Page->date_install->caption() ?><?= $Page->date_install->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->date_install->cellAttributes() ?>>
<input type="<?= $Page->date_install->getInputTextType() ?>" name="x_date_install" id="x_date_install" data-table="client_hardware_data" data-field="x_date_install" value="<?= $Page->date_install->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_install->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_install->formatPattern()) ?>"<?= $Page->date_install->editAttributes() ?> aria-describedby="x_date_install_help">
<?= $Page->date_install->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->date_install->getErrorMessage() ?></div>
<?php if (!$Page->date_install->ReadOnly && !$Page->date_install->Disabled && !isset($Page->date_install->EditAttrs["readonly"]) && !isset($Page->date_install->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_dataaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_date_install", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->date_start->Visible) { // date_start ?>
    <div id="r_date_start"<?= $Page->date_start->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_date_start"><?= $Page->date_start->caption() ?><?= $Page->date_start->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->date_start->cellAttributes() ?>>
<input type="<?= $Page->date_start->getInputTextType() ?>" name="x_date_start" id="x_date_start" data-table="client_hardware_data" data-field="x_date_start" value="<?= $Page->date_start->EditValue ?>" placeholder="<?= HtmlEncode($Page->date_start->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->date_start->formatPattern()) ?>"<?= $Page->date_start->editAttributes() ?> aria-describedby="x_date_start_help">
<?= $Page->date_start->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->date_start->getErrorMessage() ?></div>
<?php if (!$Page->date_start->ReadOnly && !$Page->date_start->Disabled && !isset($Page->date_start->EditAttrs["readonly"]) && !isset($Page->date_start->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_dataaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_date_start", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remark->Visible) { // remark ?>
    <div id="r_remark"<?= $Page->remark->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_remark"><?= $Page->remark->caption() ?><?= $Page->remark->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->remark->cellAttributes() ?>>
<input type="<?= $Page->remark->getInputTextType() ?>" name="x_remark" id="x_remark" data-table="client_hardware_data" data-field="x_remark" value="<?= $Page->remark->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remark->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remark->formatPattern()) ?>"<?= $Page->remark->editAttributes() ?> aria-describedby="x_remark_help">
<?= $Page->remark->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remark->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_dataaddopt_x_status"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_status", selectId: "fclient_hardware_dataaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_dataaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->schedule_service_type->Visible) { // schedule_service_type ?>
    <div id="r_schedule_service_type"<?= $Page->schedule_service_type->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_schedule_service_type"><?= $Page->schedule_service_type->caption() ?><?= $Page->schedule_service_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->schedule_service_type->cellAttributes() ?>>
    <select
        id="x_schedule_service_type"
        name="x_schedule_service_type"
        class="form-select ew-select<?= $Page->schedule_service_type->isInvalidClass() ?>"
        <?php if (!$Page->schedule_service_type->IsNativeSelect) { ?>
        data-select2-id="fclient_hardware_dataaddopt_x_schedule_service_type"
        <?php } ?>
        data-table="client_hardware_data"
        data-field="x_schedule_service_type"
        data-value-separator="<?= $Page->schedule_service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->schedule_service_type->getPlaceHolder()) ?>"
        <?= $Page->schedule_service_type->editAttributes() ?>>
        <?= $Page->schedule_service_type->selectOptionListHtml("x_schedule_service_type") ?>
    </select>
    <?= $Page->schedule_service_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->schedule_service_type->getErrorMessage() ?></div>
<?= $Page->schedule_service_type->Lookup->getParamTag($Page, "p_x_schedule_service_type") ?>
<?php if (!$Page->schedule_service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fclient_hardware_dataaddopt", function() {
    var options = { name: "x_schedule_service_type", selectId: "fclient_hardware_dataaddopt_x_schedule_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fclient_hardware_dataaddopt.lists.schedule_service_type?.lookupOptions.length) {
        options.data = { id: "x_schedule_service_type", form: "fclient_hardware_dataaddopt" };
    } else {
        options.ajax = { id: "x_schedule_service_type", form: "fclient_hardware_dataaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.client_hardware_data.fields.schedule_service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->schedule_service_interval_days->Visible) { // schedule_service_interval_days ?>
    <div id="r_schedule_service_interval_days"<?= $Page->schedule_service_interval_days->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_schedule_service_interval_days"><?= $Page->schedule_service_interval_days->caption() ?><?= $Page->schedule_service_interval_days->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->schedule_service_interval_days->cellAttributes() ?>>
<input type="<?= $Page->schedule_service_interval_days->getInputTextType() ?>" name="x_schedule_service_interval_days" id="x_schedule_service_interval_days" data-table="client_hardware_data" data-field="x_schedule_service_interval_days" value="<?= $Page->schedule_service_interval_days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->schedule_service_interval_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->schedule_service_interval_days->formatPattern()) ?>"<?= $Page->schedule_service_interval_days->editAttributes() ?> aria-describedby="x_schedule_service_interval_days_help">
<?= $Page->schedule_service_interval_days->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->schedule_service_interval_days->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->schedule_service_updated_till->Visible) { // schedule_service_updated_till ?>
    <div id="r_schedule_service_updated_till"<?= $Page->schedule_service_updated_till->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_schedule_service_updated_till"><?= $Page->schedule_service_updated_till->caption() ?><?= $Page->schedule_service_updated_till->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->schedule_service_updated_till->cellAttributes() ?>>
<input type="<?= $Page->schedule_service_updated_till->getInputTextType() ?>" name="x_schedule_service_updated_till" id="x_schedule_service_updated_till" data-table="client_hardware_data" data-field="x_schedule_service_updated_till" value="<?= $Page->schedule_service_updated_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->schedule_service_updated_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->schedule_service_updated_till->formatPattern()) ?>"<?= $Page->schedule_service_updated_till->editAttributes() ?> aria-describedby="x_schedule_service_updated_till_help">
<?= $Page->schedule_service_updated_till->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->schedule_service_updated_till->getErrorMessage() ?></div>
<?php if (!$Page->schedule_service_updated_till->ReadOnly && !$Page->schedule_service_updated_till->Disabled && !isset($Page->schedule_service_updated_till->EditAttrs["readonly"]) && !isset($Page->schedule_service_updated_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fclient_hardware_dataaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fclient_hardware_dataaddopt", "x_schedule_service_updated_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
<script>
loadjs.ready("head", function() {
jQuery("#x_schedule_service_updated_till:not(.ew-template #x_schedule_service_updated_till)").colorpicker(ew.colorPickerOptions);
});
</script>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="client_hardware_data" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="client_hardware_data" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->copy_average_1->Visible) { // copy_average_1 ?>
    <div id="r_copy_average_1"<?= $Page->copy_average_1->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_copy_average_1"><?= $Page->copy_average_1->caption() ?><?= $Page->copy_average_1->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->copy_average_1->cellAttributes() ?>>
<input type="<?= $Page->copy_average_1->getInputTextType() ?>" name="x_copy_average_1" id="x_copy_average_1" data-table="client_hardware_data" data-field="x_copy_average_1" value="<?= $Page->copy_average_1->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->copy_average_1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->copy_average_1->formatPattern()) ?>"<?= $Page->copy_average_1->editAttributes() ?> aria-describedby="x_copy_average_1_help">
<?= $Page->copy_average_1->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->copy_average_1->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->copy_average_2->Visible) { // copy_average_2 ?>
    <div id="r_copy_average_2"<?= $Page->copy_average_2->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_copy_average_2"><?= $Page->copy_average_2->caption() ?><?= $Page->copy_average_2->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->copy_average_2->cellAttributes() ?>>
<input type="<?= $Page->copy_average_2->getInputTextType() ?>" name="x_copy_average_2" id="x_copy_average_2" data-table="client_hardware_data" data-field="x_copy_average_2" value="<?= $Page->copy_average_2->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->copy_average_2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->copy_average_2->formatPattern()) ?>"<?= $Page->copy_average_2->editAttributes() ?> aria-describedby="x_copy_average_2_help">
<?= $Page->copy_average_2->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->copy_average_2->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->copy_average_3->Visible) { // copy_average_3 ?>
    <div id="r_copy_average_3"<?= $Page->copy_average_3->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_copy_average_3"><?= $Page->copy_average_3->caption() ?><?= $Page->copy_average_3->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->copy_average_3->cellAttributes() ?>>
<input type="<?= $Page->copy_average_3->getInputTextType() ?>" name="x_copy_average_3" id="x_copy_average_3" data-table="client_hardware_data" data-field="x_copy_average_3" value="<?= $Page->copy_average_3->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->copy_average_3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->copy_average_3->formatPattern()) ?>"<?= $Page->copy_average_3->editAttributes() ?> aria-describedby="x_copy_average_3_help">
<?= $Page->copy_average_3->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->copy_average_3->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("client_hardware_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
