<?php

namespace PHPMaker2024\fibre;

// Page object
$ClientDbEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fclient_dbedit" id="fclient_dbedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { client_db: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fclient_dbedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fclient_dbedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["sub_category", [fields.sub_category.visible && fields.sub_category.required ? ew.Validators.required(fields.sub_category.caption) : null], fields.sub_category.isInvalid],
            ["lead_type", [fields.lead_type.visible && fields.lead_type.required ? ew.Validators.required(fields.lead_type.caption) : null], fields.lead_type.isInvalid],
            ["lead_by", [fields.lead_by.visible && fields.lead_by.required ? ew.Validators.required(fields.lead_by.caption) : null], fields.lead_by.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
            "lead_type": <?= $Page->lead_type->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "_email": <?= $Page->_email->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="client_db">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_client_db_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_client_db_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="client_db" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_client_db_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_client_db_category">
<template id="tp_x_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_category" name="x_category" id="x_category"<?= $Page->category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_category[]"
    name="x_category[]"
    value="<?= HtmlEncode($Page->category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_category"
    data-target="dsl_x_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->category->isInvalidClass() ?>"
    data-table="client_db"
    data-field="x_category"
    data-ew-action="update-options"
    data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
    <?= $Page->category->editAttributes() ?>></selection-list>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "client_category") && !$Page->category->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->category->caption() ?>" data-title="<?= $Page->category->caption() ?>" data-ew-action="add-option" data-el="x_category[]" data-url="<?= GetUrl("clientcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sub_category->Visible) { // sub_category ?>
    <div id="r_sub_category"<?= $Page->sub_category->rowAttributes() ?>>
        <label id="elh_client_db_sub_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sub_category->caption() ?><?= $Page->sub_category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sub_category->cellAttributes() ?>>
<span id="el_client_db_sub_category">
<template id="tp_x_sub_category">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="client_db" data-field="x_sub_category" name="x_sub_category" id="x_sub_category"<?= $Page->sub_category->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_sub_category" class="ew-item-list"></div>
<selection-list hidden
    id="x_sub_category[]"
    name="x_sub_category[]"
    value="<?= HtmlEncode($Page->sub_category->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_sub_category"
    data-target="dsl_x_sub_category"
    data-repeatcolumn="3"
    class="form-control<?= $Page->sub_category->isInvalidClass() ?>"
    data-table="client_db"
    data-field="x_sub_category"
    data-value-separator="<?= $Page->sub_category->displayValueSeparatorAttribute() ?>"
    <?= $Page->sub_category->editAttributes() ?>></selection-list>
<?= $Page->sub_category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sub_category->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "client_category") && !$Page->sub_category->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sub_category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->sub_category->caption() ?>" data-title="<?= $Page->sub_category->caption() ?>" data-ew-action="add-option" data-el="x_sub_category[]" data-url="<?= GetUrl("clientcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->sub_category->Lookup->getParamTag($Page, "p_x_sub_category") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_type->Visible) { // lead_type ?>
    <div id="r_lead_type"<?= $Page->lead_type->rowAttributes() ?>>
        <label id="elh_client_db_lead_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_type->caption() ?><?= $Page->lead_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_type->cellAttributes() ?>>
<span id="el_client_db_lead_type">
<template id="tp_x_lead_type">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="client_db" data-field="x_lead_type" name="x_lead_type" id="x_lead_type"<?= $Page->lead_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_lead_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_lead_type"
    name="x_lead_type"
    value="<?= HtmlEncode($Page->lead_type->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_lead_type"
    data-target="dsl_x_lead_type"
    data-repeatcolumn="5"
    class="form-control<?= $Page->lead_type->isInvalidClass() ?>"
    data-table="client_db"
    data-field="x_lead_type"
    data-value-separator="<?= $Page->lead_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->lead_type->editAttributes() ?>></selection-list>
<?= $Page->lead_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lead_type->getErrorMessage() ?></div>
<?= $Page->lead_type->Lookup->getParamTag($Page, "p_x_lead_type") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_by->Visible) { // lead_by ?>
    <div id="r_lead_by"<?= $Page->lead_by->rowAttributes() ?>>
        <label id="elh_client_db_lead_by" for="x_lead_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_by->caption() ?><?= $Page->lead_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_by->cellAttributes() ?>>
<span id="el_client_db_lead_by">
<input type="<?= $Page->lead_by->getInputTextType() ?>" name="x_lead_by" id="x_lead_by" data-table="client_db" data-field="x_lead_by" value="<?= $Page->lead_by->EditValue ?>" size="30" maxlength="92" placeholder="<?= HtmlEncode($Page->lead_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_by->formatPattern()) ?>"<?= $Page->lead_by->editAttributes() ?> aria-describedby="x_lead_by_help">
<?= $Page->lead_by->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lead_by->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label id="elh_client_db_city" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city->cellAttributes() ?>>
<span id="el_client_db_city">
<?php
if (IsRTL()) {
    $Page->city->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_city" class="ew-auto-suggest">
    <input type="<?= $Page->city->getInputTextType() ?>" class="form-control" name="sv_x_city" id="sv_x_city" value="<?= RemoveHtml($Page->city->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city->formatPattern()) ?>"<?= $Page->city->editAttributes() ?> aria-describedby="x_city_help">
</span>
<selection-list hidden class="form-control" data-table="client_db" data-field="x_city" data-input="sv_x_city" data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?= HtmlEncode($Page->city->CurrentValue) ?>"></selection-list>
<?= $Page->city->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
<script>
loadjs.ready("fclient_dbedit", function() {
    fclient_dbedit.createAutoSuggest(Object.assign({"id":"x_city","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->city->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.client_db.fields.city.autoSuggestOptions));
});
</script>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_client_db_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_client_db_name">
<?php
if (IsRTL()) {
    $Page->name->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_name" class="ew-auto-suggest">
    <input type="<?= $Page->name->getInputTextType() ?>" class="form-control" name="sv_x_name" id="sv_x_name" value="<?= RemoveHtml($Page->name->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
</span>
<selection-list hidden class="form-control" data-table="client_db" data-field="x_name" data-input="sv_x_name" data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?= HtmlEncode($Page->name->CurrentValue) ?>"></selection-list>
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
<script>
loadjs.ready("fclient_dbedit", function() {
    fclient_dbedit.createAutoSuggest(Object.assign({"id":"x_name","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->name->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.client_db.fields.name.autoSuggestOptions));
});
</script>
<?= $Page->name->Lookup->getParamTag($Page, "p_x_name") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_client_db_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_client_db_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="client_db" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_client_db__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_client_db__email">
<?php
if (IsRTL()) {
    $Page->_email->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x__email" class="ew-auto-suggest">
    <input type="<?= $Page->_email->getInputTextType() ?>" class="form-control" name="sv_x__email" id="sv_x__email" value="<?= RemoveHtml($Page->_email->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
</span>
<selection-list hidden class="form-control" data-table="client_db" data-field="x__email" data-input="sv_x__email" data-value-separator="<?= $Page->_email->displayValueSeparatorAttribute() ?>" name="x__email" id="x__email" value="<?= HtmlEncode($Page->_email->CurrentValue) ?>"></selection-list>
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
<script>
loadjs.ready("fclient_dbedit", function() {
    fclient_dbedit.createAutoSuggest(Object.assign({"id":"x__email","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->_email->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.client_db.fields._email.autoSuggestOptions));
});
</script>
<?= $Page->_email->Lookup->getParamTag($Page, "p_x__email") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_client_db_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_client_db_address">
<textarea data-table="client_db" data-field="x_address" name="x_address" id="x_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_client_db_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_client_db_remarks">
<textarea data-table="client_db" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label id="elh_client_db_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->image->caption() ?><?= $Page->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->image->cellAttributes() ?>>
<span id="el_client_db_image">
<div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_image"
        name="x_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="client_db"
        data-field="x_image"
        data-size="500"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_image_help"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="<?= (Post("fa_x_image") == "0") ? "0" : "1" ?>">
<table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fclient_dbedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fclient_dbedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("client_db");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
