<?php

namespace PHPMaker2024\fibre;

// Page object
$CartBLiveSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cart_b_live: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcart_b_livesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcart_b_livesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["order_quantity", [ew.Validators.float], fields.order_quantity.isInvalid],
            ["sale_quantity", [ew.Validators.float], fields.sale_quantity.isInvalid],
            ["processed_quantity", [ew.Validators.float], fields.processed_quantity.isInvalid],
            ["pending_quantity", [ew.Validators.float], fields.pending_quantity.isInvalid],
            ["y_pending_quantity", [ew.Validators.between], false],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["dispatch_date", [ew.Validators.datetime(fields.dispatch_date.clientFormatPattern)], fields.dispatch_date.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["partner_order_date", [ew.Validators.datetime(fields.partner_order_date.clientFormatPattern)], fields.partner_order_date.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po": <?= $Page->po->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcart_b_livesearch" id="fcart_b_livesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cart_b_live">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="cart_b_live" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_po" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->po->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po" class="ew-auto-suggest">
    <input type="<?= $Page->po->getInputTextType() ?>" class="form-control" name="sv_x_po" id="sv_x_po" value="<?= RemoveHtml($Page->po->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="cart_b_live" data-field="x_po" data-input="sv_x_po" data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    fcart_b_livesearch.createAutoSuggest(Object.assign({"id":"x_po","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.cart_b_live.fields.po.autoSuggestOptions));
});
</script>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
    <div id="r_partner_order_no" class="row"<?= $Page->partner_order_no->rowAttributes() ?>>
        <label for="x_partner_order_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_partner_order_no"><?= $Page->partner_order_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_order_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_partner_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="cart_b_live" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_grp"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_grp", selectId: "fcart_b_livesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_s_grp"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_s_grp", selectId: "fcart_b_livesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_product"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_product", selectId: "fcart_b_livesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="cart_b_live" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    fcart_b_livesearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.cart_b_live.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_quantity->Visible) { // order_quantity ?>
    <div id="r_order_quantity" class="row"<?= $Page->order_quantity->rowAttributes() ?>>
        <label for="x_order_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_order_quantity"><?= $Page->order_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_quantity" id="z_order_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_order_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_quantity->getInputTextType() ?>" name="x_order_quantity" id="x_order_quantity" data-table="cart_b_live" data-field="x_order_quantity" value="<?= $Page->order_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_quantity->formatPattern()) ?>"<?= $Page->order_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sale_quantity->Visible) { // sale_quantity ?>
    <div id="r_sale_quantity" class="row"<?= $Page->sale_quantity->rowAttributes() ?>>
        <label for="x_sale_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_sale_quantity"><?= $Page->sale_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sale_quantity" id="z_sale_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sale_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_sale_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sale_quantity->getInputTextType() ?>" name="x_sale_quantity" id="x_sale_quantity" data-table="cart_b_live" data-field="x_sale_quantity" value="<?= $Page->sale_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sale_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sale_quantity->formatPattern()) ?>"<?= $Page->sale_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sale_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->processed_quantity->Visible) { // processed_quantity ?>
    <div id="r_processed_quantity" class="row"<?= $Page->processed_quantity->rowAttributes() ?>>
        <label for="x_processed_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_processed_quantity"><?= $Page->processed_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_processed_quantity" id="z_processed_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->processed_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_processed_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->processed_quantity->getInputTextType() ?>" name="x_processed_quantity" id="x_processed_quantity" data-table="cart_b_live" data-field="x_processed_quantity" value="<?= $Page->processed_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->processed_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->processed_quantity->formatPattern()) ?>"<?= $Page->processed_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->processed_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending_quantity->Visible) { // pending_quantity ?>
    <div id="r_pending_quantity" class="row"<?= $Page->pending_quantity->rowAttributes() ?>>
        <label for="x_pending_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_pending_quantity"><?= $Page->pending_quantity->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_pending_quantity" id="z_pending_quantity" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending_quantity->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending_quantity->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_cart_b_live_pending_quantity" class="ew-search-field">
<input type="<?= $Page->pending_quantity->getInputTextType() ?>" name="x_pending_quantity" id="x_pending_quantity" data-table="cart_b_live" data-field="x_pending_quantity" value="<?= $Page->pending_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_quantity->formatPattern()) ?>"<?= $Page->pending_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_quantity->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_cart_b_live_pending_quantity" class="ew-search-field2 d-none">
<input type="<?= $Page->pending_quantity->getInputTextType() ?>" name="y_pending_quantity" id="y_pending_quantity" data-table="cart_b_live" data-field="x_pending_quantity" value="<?= $Page->pending_quantity->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_quantity->formatPattern()) ?>"<?= $Page->pending_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label for="x_partner_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_partner_id"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_partner_id", selectId: "fcart_b_livesearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fcart_b_livesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_company_id"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_company_id", selectId: "fcart_b_livesearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
    <div id="r_dispatch_date" class="row"<?= $Page->dispatch_date->rowAttributes() ?>>
        <label for="x_dispatch_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_dispatch_date"><?= $Page->dispatch_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dispatch_date" id="z_dispatch_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dispatch_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_dispatch_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dispatch_date->getInputTextType() ?>" name="x_dispatch_date" id="x_dispatch_date" data-table="cart_b_live" data-field="x_dispatch_date" value="<?= $Page->dispatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->dispatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dispatch_date->formatPattern()) ?>"<?= $Page->dispatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dispatch_date->getErrorMessage(false) ?></div>
<?php if (!$Page->dispatch_date->ReadOnly && !$Page->dispatch_date->Disabled && !isset($Page->dispatch_date->EditAttrs["readonly"]) && !isset($Page->dispatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcart_b_livesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcart_b_livesearch", "x_dispatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_packing_type"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_packing_type", selectId: "fcart_b_livesearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_order_date->Visible) { // partner_order_date ?>
    <div id="r_partner_order_date" class="row"<?= $Page->partner_order_date->rowAttributes() ?>>
        <label for="x_partner_order_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_cart_b_live_partner_order_date"><?= $Page->partner_order_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_order_date" id="z_partner_order_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_order_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_cart_b_live_partner_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_date->getInputTextType() ?>" name="x_partner_order_date" id="x_partner_order_date" data-table="cart_b_live" data-field="x_partner_order_date" value="<?= $Page->partner_order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->partner_order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_date->formatPattern()) ?>"<?= $Page->partner_order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->partner_order_date->ReadOnly && !$Page->partner_order_date->Disabled && !isset($Page->partner_order_date->EditAttrs["readonly"]) && !isset($Page->partner_order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcart_b_livesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcart_b_livesearch", "x_partner_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcart_b_livesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcart_b_livesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fcart_b_livesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cart_b_live");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
