<?php

namespace PHPMaker2024\fibre;

// Page object
$CartBLiveSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cart_b_live: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fcart_b_livesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcart_b_livesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["order_quantity", [ew.Validators.float], fields.order_quantity.isInvalid],
            ["sale_quantity", [ew.Validators.float], fields.sale_quantity.isInvalid],
            ["processed_quantity", [ew.Validators.float], fields.processed_quantity.isInvalid],
            ["pending_quantity", [ew.Validators.float], fields.pending_quantity.isInvalid],
            ["y_pending_quantity", [ew.Validators.between], false],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["dispatch_date", [ew.Validators.datetime(fields.dispatch_date.clientFormatPattern)], fields.dispatch_date.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["partner_order_date", [ew.Validators.datetime(fields.partner_order_date.clientFormatPattern)], fields.partner_order_date.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "po": <?= $Page->po->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcart_b_livesearch" id="fcart_b_livesearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("cartblivelist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cart_b_live">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_cart_b_live_id" class="cart_b_livesearch"><span id="el_cart_b_live_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="cart_b_live" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_cart_b_live_po" class="cart_b_livesearch"><span id="el_cart_b_live_po" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->po->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po" class="ew-auto-suggest">
    <input type="<?= $Page->po->getInputTextType() ?>" class="form-control" name="sv_x_po" id="sv_x_po" value="<?= RemoveHtml($Page->po->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="cart_b_live" data-field="x_po" data-input="sv_x_po" data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    fcart_b_livesearch.createAutoSuggest(Object.assign({"id":"x_po","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.cart_b_live.fields.po.autoSuggestOptions));
});
</script>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
</span></template>
<template id="tpx_cart_b_live_partner_order_no" class="cart_b_livesearch"><span id="el_cart_b_live_partner_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="cart_b_live" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_cart_b_live_grp" class="cart_b_livesearch"><span id="el_cart_b_live_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_grp"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_grp", selectId: "fcart_b_livesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_s_grp" class="cart_b_livesearch"><span id="el_cart_b_live_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_s_grp"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_s_grp", selectId: "fcart_b_livesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_product" class="cart_b_livesearch"><span id="el_cart_b_live_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_product"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_product", selectId: "fcart_b_livesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_rid" class="cart_b_livesearch"><span id="el_cart_b_live_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="cart_b_live" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    fcart_b_livesearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.cart_b_live.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span></template>
<template id="tpx_cart_b_live_order_quantity" class="cart_b_livesearch"><span id="el_cart_b_live_order_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_quantity->getInputTextType() ?>" name="x_order_quantity" id="x_order_quantity" data-table="cart_b_live" data-field="x_order_quantity" value="<?= $Page->order_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_quantity->formatPattern()) ?>"<?= $Page->order_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_cart_b_live_sale_quantity" class="cart_b_livesearch"><span id="el_cart_b_live_sale_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sale_quantity->getInputTextType() ?>" name="x_sale_quantity" id="x_sale_quantity" data-table="cart_b_live" data-field="x_sale_quantity" value="<?= $Page->sale_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sale_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sale_quantity->formatPattern()) ?>"<?= $Page->sale_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sale_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_cart_b_live_processed_quantity" class="cart_b_livesearch"><span id="el_cart_b_live_processed_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->processed_quantity->getInputTextType() ?>" name="x_processed_quantity" id="x_processed_quantity" data-table="cart_b_live" data-field="x_processed_quantity" value="<?= $Page->processed_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->processed_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->processed_quantity->formatPattern()) ?>"<?= $Page->processed_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->processed_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_cart_b_live_pending_quantity" class="cart_b_livesearch"><span id="el_cart_b_live_pending_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending_quantity->getInputTextType() ?>" name="x_pending_quantity" id="x_pending_quantity" data-table="cart_b_live" data-field="x_pending_quantity" value="<?= $Page->pending_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_quantity->formatPattern()) ?>"<?= $Page->pending_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_quantity->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_cart_b_live_partner_id" class="cart_b_livesearch"><span id="el_cart_b_live_partner_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-select ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        <?php if (!$Page->partner_id->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_partner_id"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_partner_id"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<?php if (!$Page->partner_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_partner_id", selectId: "fcart_b_livesearch_x_partner_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fcart_b_livesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.partner_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_company_id" class="cart_b_livesearch"><span id="el_cart_b_live_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_company_id"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_company_id", selectId: "fcart_b_livesearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_dispatch_date" class="cart_b_livesearch"><span id="el_cart_b_live_dispatch_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dispatch_date->getInputTextType() ?>" name="x_dispatch_date" id="x_dispatch_date" data-table="cart_b_live" data-field="x_dispatch_date" value="<?= $Page->dispatch_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->dispatch_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dispatch_date->formatPattern()) ?>"<?= $Page->dispatch_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dispatch_date->getErrorMessage(false) ?></div>
<?php if (!$Page->dispatch_date->ReadOnly && !$Page->dispatch_date->Disabled && !isset($Page->dispatch_date->EditAttrs["readonly"]) && !isset($Page->dispatch_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcart_b_livesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcart_b_livesearch", "x_dispatch_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_packing_type" class="cart_b_livesearch"><span id="el_cart_b_live_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesearch_x_packing_type"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesearch", function() {
    var options = { name: "x_packing_type", selectId: "fcart_b_livesearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fcart_b_livesearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fcart_b_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_cart_b_live_partner_order_date" class="cart_b_livesearch"><span id="el_cart_b_live_partner_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_date->getInputTextType() ?>" name="x_partner_order_date" id="x_partner_order_date" data-table="cart_b_live" data-field="x_partner_order_date" value="<?= $Page->partner_order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->partner_order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_date->formatPattern()) ?>"<?= $Page->partner_order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->partner_order_date->ReadOnly && !$Page->partner_order_date->Disabled && !isset($Page->partner_order_date->EditAttrs["readonly"]) && !isset($Page->partner_order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcart_b_livesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcart_b_livesearch", "x_partner_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="cart_b_live_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "integer",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "partner_order_no",
                type: "string",
                label: currentTable.fields.partner_order_no.caption,
                operators: currentTable.fields.partner_order_no.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.partner_order_no.validators),
                data: {
                    format: currentTable.fields.partner_order_no.clientFormatPattern
                }
            },
            {
                id: "grp",
                type: "integer",
                label: currentTable.fields.grp.caption,
                operators: currentTable.fields.grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.grp.validators),
                data: {
                    format: currentTable.fields.grp.clientFormatPattern
                }
            },
            {
                id: "s_grp",
                type: "integer",
                label: currentTable.fields.s_grp.caption,
                operators: currentTable.fields.s_grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.s_grp.validators),
                data: {
                    format: currentTable.fields.s_grp.clientFormatPattern
                }
            },
            {
                id: "product",
                type: "integer",
                label: currentTable.fields.product.caption,
                operators: currentTable.fields.product.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.product.validators),
                data: {
                    format: currentTable.fields.product.clientFormatPattern
                }
            },
            {
                id: "rid",
                type: "string",
                label: currentTable.fields.rid.caption,
                operators: currentTable.fields.rid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.rid.validators),
                data: {
                    format: currentTable.fields.rid.clientFormatPattern
                }
            },
            {
                id: "order_quantity",
                type: "double",
                label: currentTable.fields.order_quantity.caption,
                operators: currentTable.fields.order_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.order_quantity.validators),
                data: {
                    format: currentTable.fields.order_quantity.clientFormatPattern
                }
            },
            {
                id: "sale_quantity",
                type: "double",
                label: currentTable.fields.sale_quantity.caption,
                operators: currentTable.fields.sale_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.sale_quantity.validators),
                data: {
                    format: currentTable.fields.sale_quantity.clientFormatPattern
                }
            },
            {
                id: "processed_quantity",
                type: "double",
                label: currentTable.fields.processed_quantity.caption,
                operators: currentTable.fields.processed_quantity.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.processed_quantity.validators),
                data: {
                    format: currentTable.fields.processed_quantity.clientFormatPattern
                }
            },
            {
                id: "pending_quantity",
                type: "double",
                label: currentTable.fields.pending_quantity.caption,
                operators: currentTable.fields.pending_quantity.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.pending_quantity.validators),
                data: {
                    format: currentTable.fields.pending_quantity.clientFormatPattern
                }
            },
            {
                id: "partner_id",
                type: "integer",
                label: currentTable.fields.partner_id.caption,
                operators: currentTable.fields.partner_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.partner_id.validators),
                data: {
                    format: currentTable.fields.partner_id.clientFormatPattern
                }
            },
            {
                id: "company_id",
                type: "integer",
                label: currentTable.fields.company_id.caption,
                operators: currentTable.fields.company_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.company_id.validators),
                data: {
                    format: currentTable.fields.company_id.clientFormatPattern
                }
            },
            {
                id: "dispatch_date",
                type: "datetime",
                label: currentTable.fields.dispatch_date.caption,
                operators: currentTable.fields.dispatch_date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.dispatch_date.validators),
                data: {
                    format: currentTable.fields.dispatch_date.clientFormatPattern
                }
            },
            {
                id: "packing_type",
                type: "integer",
                label: currentTable.fields.packing_type.caption,
                operators: currentTable.fields.packing_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.packing_type.validators),
                data: {
                    format: currentTable.fields.packing_type.clientFormatPattern
                }
            },
            {
                id: "partner_order_date",
                type: "datetime",
                label: currentTable.fields.partner_order_date.caption,
                operators: currentTable.fields.partner_order_date.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fcart_b_livesearch.fields.partner_order_date.validators),
                data: {
                    format: currentTable.fields.partner_order_date.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#cart_b_live_query_builder"),
        args = {},
        rules = ew.parseJson($("#fcart_b_livesearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fcart_b_livesearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fcart_b_livesearch" formaction="<?= HtmlEncode(GetUrl("cartblivelist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcart_b_livesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fcart_b_livesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cart_b_live");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
