<?php

namespace PHPMaker2024\fibre;

// Page object
$CartBLiveList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cart_b_live: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fcart_b_livesrch" id="fcart_b_livesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fcart_b_livesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { cart_b_live: currentTable } });
var currentForm;
var fcart_b_livesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcart_b_livesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [], fields.po.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["pending_quantity", [ew.Validators.float], fields.pending_quantity.isInvalid],
            ["y_pending_quantity", [ew.Validators.between], false],
            ["company_id", [], fields.company_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po": <?= $Page->po->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</div>
        </div>
        <div id="el_cart_b_live_po" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->po->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po" class="ew-auto-suggest">
    <input type="<?= $Page->po->getInputTextType() ?>" class="form-control" name="sv_x_po" id="sv_x_po" value="<?= RemoveHtml($Page->po->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="cart_b_live" data-field="x_po" data-input="sv_x_po" data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcart_b_livesrch", function() {
    fcart_b_livesrch.createAutoSuggest(Object.assign({"id":"x_po","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.cart_b_live.fields.po.autoSuggestOptions));
});
</script>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
<?php
if (!$Page->partner_order_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_order_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_order_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_partner_order_no" class="ew-search-caption ew-label"><?= $Page->partner_order_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE">
</div>
        </div>
        <div id="el_cart_b_live_partner_order_no" class="ew-search-field">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="cart_b_live" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</div>
        </div>
        <div id="el_cart_b_live_rid" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="cart_b_live" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fcart_b_livesrch", function() {
    fcart_b_livesrch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.cart_b_live.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pending_quantity->Visible) { // pending_quantity ?>
<?php
if (!$Page->pending_quantity->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pending_quantity" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pending_quantity->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pending_quantity" class="ew-search-caption ew-label"><?= $Page->pending_quantity->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_pending_quantity" id="z_pending_quantity" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending_quantity->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending_quantity->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_cart_b_live_pending_quantity" class="ew-search-field">
<input type="<?= $Page->pending_quantity->getInputTextType() ?>" name="x_pending_quantity" id="x_pending_quantity" data-table="cart_b_live" data-field="x_pending_quantity" value="<?= $Page->pending_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_quantity->formatPattern()) ?>"<?= $Page->pending_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_quantity->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_cart_b_live_pending_quantity" class="ew-search-field2 d-none">
<input type="<?= $Page->pending_quantity->getInputTextType() ?>" name="y_pending_quantity" id="y_pending_quantity" data-table="cart_b_live" data-field="x_pending_quantity" value="<?= $Page->pending_quantity->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_quantity->formatPattern()) ?>"<?= $Page->pending_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_quantity->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
<?php
if (!$Page->company_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_company_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->company_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_company_id" class="ew-search-caption ew-label"><?= $Page->company_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</div>
        </div>
        <div id="el_cart_b_live_company_id" class="ew-search-field">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fcart_b_livesrch_x_company_id"
        <?php } ?>
        data-table="cart_b_live"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcart_b_livesrch", function() {
    var options = { name: "x_company_id", selectId: "fcart_b_livesrch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcart_b_livesrch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fcart_b_livesrch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fcart_b_livesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.cart_b_live.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fcart_b_livesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fcart_b_livesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fcart_b_livesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fcart_b_livesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fcart_b_livesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fcart_b_livesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fcart_b_livesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="cart_b_live">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_cart_b_live" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_cart_b_livelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_cart_b_live_id" class="cart_b_live_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_cart_b_live_po" class="cart_b_live_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
        <th data-name="partner_order_no" class="<?= $Page->partner_order_no->headerCellClass() ?>"><div id="elh_cart_b_live_partner_order_no" class="cart_b_live_partner_order_no"><?= $Page->renderFieldHeader($Page->partner_order_no) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_cart_b_live_s_grp" class="cart_b_live_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_cart_b_live_product" class="cart_b_live_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_cart_b_live_rid" class="cart_b_live_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <th data-name="order_quantity" class="<?= $Page->order_quantity->headerCellClass() ?>"><div id="elh_cart_b_live_order_quantity" class="cart_b_live_order_quantity"><?= $Page->renderFieldHeader($Page->order_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->sale_quantity->Visible) { // sale_quantity ?>
        <th data-name="sale_quantity" class="<?= $Page->sale_quantity->headerCellClass() ?>"><div id="elh_cart_b_live_sale_quantity" class="cart_b_live_sale_quantity"><?= $Page->renderFieldHeader($Page->sale_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->processed_quantity->Visible) { // processed_quantity ?>
        <th data-name="processed_quantity" class="<?= $Page->processed_quantity->headerCellClass() ?>"><div id="elh_cart_b_live_processed_quantity" class="cart_b_live_processed_quantity"><?= $Page->renderFieldHeader($Page->processed_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->pending_quantity->Visible) { // pending_quantity ?>
        <th data-name="pending_quantity" class="<?= $Page->pending_quantity->headerCellClass() ?>"><div id="elh_cart_b_live_pending_quantity" class="cart_b_live_pending_quantity"><?= $Page->renderFieldHeader($Page->pending_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Page->partner_id->headerCellClass() ?>"><div id="elh_cart_b_live_partner_id" class="cart_b_live_partner_id"><?= $Page->renderFieldHeader($Page->partner_id) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_cart_b_live_company_id" class="cart_b_live_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
        <th data-name="dispatch_date" class="<?= $Page->dispatch_date->headerCellClass() ?>"><div id="elh_cart_b_live_dispatch_date" class="cart_b_live_dispatch_date"><?= $Page->renderFieldHeader($Page->dispatch_date) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_cart_b_live_packing_type" class="cart_b_live_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->partner_order_date->Visible) { // partner_order_date ?>
        <th data-name="partner_order_date" class="<?= $Page->partner_order_date->headerCellClass() ?>"><div id="elh_cart_b_live_partner_order_date" class="cart_b_live_partner_order_date"><?= $Page->renderFieldHeader($Page->partner_order_date) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_id" class="el_cart_b_live_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_po" class="el_cart_b_live_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
        <td data-name="partner_order_no"<?= $Page->partner_order_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_partner_order_no" class="el_cart_b_live_partner_order_no">
<span<?= $Page->partner_order_no->viewAttributes() ?>>
<?= $Page->partner_order_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_s_grp" class="el_cart_b_live_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_product" class="el_cart_b_live_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_rid" class="el_cart_b_live_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <td data-name="order_quantity"<?= $Page->order_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_order_quantity" class="el_cart_b_live_order_quantity">
<span<?= $Page->order_quantity->viewAttributes() ?>>
<?= $Page->order_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sale_quantity->Visible) { // sale_quantity ?>
        <td data-name="sale_quantity"<?= $Page->sale_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_sale_quantity" class="el_cart_b_live_sale_quantity">
<span<?= $Page->sale_quantity->viewAttributes() ?>>
<?= $Page->sale_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->processed_quantity->Visible) { // processed_quantity ?>
        <td data-name="processed_quantity"<?= $Page->processed_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_processed_quantity" class="el_cart_b_live_processed_quantity">
<span<?= $Page->processed_quantity->viewAttributes() ?>>
<?= $Page->processed_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_quantity->Visible) { // pending_quantity ?>
        <td data-name="pending_quantity"<?= $Page->pending_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_pending_quantity" class="el_cart_b_live_pending_quantity">
<span<?= $Page->pending_quantity->viewAttributes() ?>>
<?= $Page->pending_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Page->partner_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_partner_id" class="el_cart_b_live_partner_id">
<span<?= $Page->partner_id->viewAttributes() ?>>
<?= $Page->partner_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_company_id" class="el_cart_b_live_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dispatch_date->Visible) { // dispatch_date ?>
        <td data-name="dispatch_date"<?= $Page->dispatch_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_dispatch_date" class="el_cart_b_live_dispatch_date">
<span<?= $Page->dispatch_date->viewAttributes() ?>>
<?= $Page->dispatch_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_packing_type" class="el_cart_b_live_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_order_date->Visible) { // partner_order_date ?>
        <td data-name="partner_order_date"<?= $Page->partner_order_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_cart_b_live_partner_order_date" class="el_cart_b_live_partner_order_date">
<span<?= $Page->partner_order_date->viewAttributes() ?>>
<?= $Page->partner_order_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("cart_b_live");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
