<?php

namespace PHPMaker2024\fibre;

// Page object
$CarpetSetupList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { carpet_setup: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fcarpet_setupsrch" id="fcarpet_setupsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fcarpet_setupsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { carpet_setup: currentTable } });
var currentForm;
var fcarpet_setupsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fcarpet_setupsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fcarpet_setupsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fcarpet_setupsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fcarpet_setupsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fcarpet_setupsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fcarpet_setupsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fcarpet_setupsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fcarpet_setupsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="carpet_setup">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_carpet_setup" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_carpet_setuplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_carpet_setup_id" class="carpet_setup_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->cs_min_width->Visible) { // cs_min_width ?>
        <th data-name="cs_min_width" class="<?= $Page->cs_min_width->headerCellClass() ?>"><div id="elh_carpet_setup_cs_min_width" class="carpet_setup_cs_min_width"><?= $Page->renderFieldHeader($Page->cs_min_width) ?></div></th>
<?php } ?>
<?php if ($Page->cs_min_qty->Visible) { // cs_min_qty ?>
        <th data-name="cs_min_qty" class="<?= $Page->cs_min_qty->headerCellClass() ?>"><div id="elh_carpet_setup_cs_min_qty" class="carpet_setup_cs_min_qty"><?= $Page->renderFieldHeader($Page->cs_min_qty) ?></div></th>
<?php } ?>
<?php if ($Page->payment_sqm->Visible) { // payment_sqm ?>
        <th data-name="payment_sqm" class="<?= $Page->payment_sqm->headerCellClass() ?>"><div id="elh_carpet_setup_payment_sqm" class="carpet_setup_payment_sqm"><?= $Page->renderFieldHeader($Page->payment_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->payment_sqm_byepass_category->Visible) { // payment_sqm_byepass_category ?>
        <th data-name="payment_sqm_byepass_category" class="<?= $Page->payment_sqm_byepass_category->headerCellClass() ?>"><div id="elh_carpet_setup_payment_sqm_byepass_category" class="carpet_setup_payment_sqm_byepass_category"><?= $Page->renderFieldHeader($Page->payment_sqm_byepass_category) ?></div></th>
<?php } ?>
<?php if ($Page->process_byepass->Visible) { // process_byepass ?>
        <th data-name="process_byepass" class="<?= $Page->process_byepass->headerCellClass() ?>"><div id="elh_carpet_setup_process_byepass" class="carpet_setup_process_byepass"><?= $Page->renderFieldHeader($Page->process_byepass) ?></div></th>
<?php } ?>
<?php if ($Page->jc_bom_wastage->Visible) { // jc_bom_wastage ?>
        <th data-name="jc_bom_wastage" class="<?= $Page->jc_bom_wastage->headerCellClass() ?>"><div id="elh_carpet_setup_jc_bom_wastage" class="carpet_setup_jc_bom_wastage"><?= $Page->renderFieldHeader($Page->jc_bom_wastage) ?></div></th>
<?php } ?>
<?php if ($Page->bom_1000->Visible) { // bom_1000 ?>
        <th data-name="bom_1000" class="<?= $Page->bom_1000->headerCellClass() ?>"><div id="elh_carpet_setup_bom_1000" class="carpet_setup_bom_1000"><?= $Page->renderFieldHeader($Page->bom_1000) ?></div></th>
<?php } ?>
<?php if ($Page->batch_authorized_id->Visible) { // batch_authorized_id ?>
        <th data-name="batch_authorized_id" class="<?= $Page->batch_authorized_id->headerCellClass() ?>"><div id="elh_carpet_setup_batch_authorized_id" class="carpet_setup_batch_authorized_id"><?= $Page->renderFieldHeader($Page->batch_authorized_id) ?></div></th>
<?php } ?>
<?php if ($Page->tufting_plan_active->Visible) { // tufting_plan_active ?>
        <th data-name="tufting_plan_active" class="<?= $Page->tufting_plan_active->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_plan_active" class="carpet_setup_tufting_plan_active"><?= $Page->renderFieldHeader($Page->tufting_plan_active) ?></div></th>
<?php } ?>
<?php if ($Page->tufting_plan_sgrp->Visible) { // tufting_plan_sgrp ?>
        <th data-name="tufting_plan_sgrp" class="<?= $Page->tufting_plan_sgrp->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_plan_sgrp" class="carpet_setup_tufting_plan_sgrp"><?= $Page->renderFieldHeader($Page->tufting_plan_sgrp) ?></div></th>
<?php } ?>
<?php if ($Page->tufting_plan_loom_group->Visible) { // tufting_plan_loom_group ?>
        <th data-name="tufting_plan_loom_group" class="<?= $Page->tufting_plan_loom_group->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_plan_loom_group" class="carpet_setup_tufting_plan_loom_group"><?= $Page->renderFieldHeader($Page->tufting_plan_loom_group) ?></div></th>
<?php } ?>
<?php if ($Page->tufting_performance_percent->Visible) { // tufting_performance_percent ?>
        <th data-name="tufting_performance_percent" class="<?= $Page->tufting_performance_percent->headerCellClass() ?>"><div id="elh_carpet_setup_tufting_performance_percent" class="carpet_setup_tufting_performance_percent"><?= $Page->renderFieldHeader($Page->tufting_performance_percent) ?></div></th>
<?php } ?>
<?php if ($Page->jc_weeks->Visible) { // jc_weeks ?>
        <th data-name="jc_weeks" class="<?= $Page->jc_weeks->headerCellClass() ?>"><div id="elh_carpet_setup_jc_weeks" class="carpet_setup_jc_weeks"><?= $Page->renderFieldHeader($Page->jc_weeks) ?></div></th>
<?php } ?>
<?php if ($Page->required_material_overall_update->Visible) { // required_material_overall_update ?>
        <th data-name="required_material_overall_update" class="<?= $Page->required_material_overall_update->headerCellClass() ?>"><div id="elh_carpet_setup_required_material_overall_update" class="carpet_setup_required_material_overall_update"><?= $Page->renderFieldHeader($Page->required_material_overall_update) ?></div></th>
<?php } ?>
<?php if ($Page->jc_material_issue->Visible) { // jc_material_issue ?>
        <th data-name="jc_material_issue" class="<?= $Page->jc_material_issue->headerCellClass() ?>"><div id="elh_carpet_setup_jc_material_issue" class="carpet_setup_jc_material_issue"><?= $Page->renderFieldHeader($Page->jc_material_issue) ?></div></th>
<?php } ?>
<?php if ($Page->jc_qr->Visible) { // jc_qr ?>
        <th data-name="jc_qr" class="<?= $Page->jc_qr->headerCellClass() ?>"><div id="elh_carpet_setup_jc_qr" class="carpet_setup_jc_qr"><?= $Page->renderFieldHeader($Page->jc_qr) ?></div></th>
<?php } ?>
<?php if ($Page->jc_mrlot->Visible) { // jc_mrlot ?>
        <th data-name="jc_mrlot" class="<?= $Page->jc_mrlot->headerCellClass() ?>"><div id="elh_carpet_setup_jc_mrlot" class="carpet_setup_jc_mrlot"><?= $Page->renderFieldHeader($Page->jc_mrlot) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_carpet_setup_operator" class="carpet_setup_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_carpet_setup_datetime" class="carpet_setup_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->max_jobcard->Visible) { // max_jobcard ?>
        <th data-name="max_jobcard" class="<?= $Page->max_jobcard->headerCellClass() ?>"><div id="elh_carpet_setup_max_jobcard" class="carpet_setup_max_jobcard"><?= $Page->renderFieldHeader($Page->max_jobcard) ?></div></th>
<?php } ?>
<?php if ($Page->jc_pending_delete_days->Visible) { // jc_pending_delete_days ?>
        <th data-name="jc_pending_delete_days" class="<?= $Page->jc_pending_delete_days->headerCellClass() ?>"><div id="elh_carpet_setup_jc_pending_delete_days" class="carpet_setup_jc_pending_delete_days"><?= $Page->renderFieldHeader($Page->jc_pending_delete_days) ?></div></th>
<?php } ?>
<?php if ($Page->batch_pp_id->Visible) { // batch_pp_id ?>
        <th data-name="batch_pp_id" class="<?= $Page->batch_pp_id->headerCellClass() ?>"><div id="elh_carpet_setup_batch_pp_id" class="carpet_setup_batch_pp_id"><?= $Page->renderFieldHeader($Page->batch_pp_id) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_id" class="el_carpet_setup_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cs_min_width->Visible) { // cs_min_width ?>
        <td data-name="cs_min_width"<?= $Page->cs_min_width->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_cs_min_width" class="el_carpet_setup_cs_min_width">
<span<?= $Page->cs_min_width->viewAttributes() ?>>
<?= $Page->cs_min_width->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cs_min_qty->Visible) { // cs_min_qty ?>
        <td data-name="cs_min_qty"<?= $Page->cs_min_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_cs_min_qty" class="el_carpet_setup_cs_min_qty">
<span<?= $Page->cs_min_qty->viewAttributes() ?>>
<?= $Page->cs_min_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_sqm->Visible) { // payment_sqm ?>
        <td data-name="payment_sqm"<?= $Page->payment_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_payment_sqm" class="el_carpet_setup_payment_sqm">
<span<?= $Page->payment_sqm->viewAttributes() ?>>
<?= $Page->payment_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_sqm_byepass_category->Visible) { // payment_sqm_byepass_category ?>
        <td data-name="payment_sqm_byepass_category"<?= $Page->payment_sqm_byepass_category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_payment_sqm_byepass_category" class="el_carpet_setup_payment_sqm_byepass_category">
<span<?= $Page->payment_sqm_byepass_category->viewAttributes() ?>>
<?= $Page->payment_sqm_byepass_category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_byepass->Visible) { // process_byepass ?>
        <td data-name="process_byepass"<?= $Page->process_byepass->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_process_byepass" class="el_carpet_setup_process_byepass">
<span<?= $Page->process_byepass->viewAttributes() ?>>
<?= $Page->process_byepass->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_bom_wastage->Visible) { // jc_bom_wastage ?>
        <td data-name="jc_bom_wastage"<?= $Page->jc_bom_wastage->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_jc_bom_wastage" class="el_carpet_setup_jc_bom_wastage">
<span<?= $Page->jc_bom_wastage->viewAttributes() ?>>
<?= $Page->jc_bom_wastage->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bom_1000->Visible) { // bom_1000 ?>
        <td data-name="bom_1000"<?= $Page->bom_1000->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_bom_1000" class="el_carpet_setup_bom_1000">
<span<?= $Page->bom_1000->viewAttributes() ?>>
<?= $Page->bom_1000->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_authorized_id->Visible) { // batch_authorized_id ?>
        <td data-name="batch_authorized_id"<?= $Page->batch_authorized_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_batch_authorized_id" class="el_carpet_setup_batch_authorized_id">
<span<?= $Page->batch_authorized_id->viewAttributes() ?>>
<?= $Page->batch_authorized_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tufting_plan_active->Visible) { // tufting_plan_active ?>
        <td data-name="tufting_plan_active"<?= $Page->tufting_plan_active->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_tufting_plan_active" class="el_carpet_setup_tufting_plan_active">
<span<?= $Page->tufting_plan_active->viewAttributes() ?>>
<?= $Page->tufting_plan_active->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tufting_plan_sgrp->Visible) { // tufting_plan_sgrp ?>
        <td data-name="tufting_plan_sgrp"<?= $Page->tufting_plan_sgrp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_tufting_plan_sgrp" class="el_carpet_setup_tufting_plan_sgrp">
<span<?= $Page->tufting_plan_sgrp->viewAttributes() ?>>
<?= $Page->tufting_plan_sgrp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tufting_plan_loom_group->Visible) { // tufting_plan_loom_group ?>
        <td data-name="tufting_plan_loom_group"<?= $Page->tufting_plan_loom_group->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_tufting_plan_loom_group" class="el_carpet_setup_tufting_plan_loom_group">
<span<?= $Page->tufting_plan_loom_group->viewAttributes() ?>>
<?= $Page->tufting_plan_loom_group->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tufting_performance_percent->Visible) { // tufting_performance_percent ?>
        <td data-name="tufting_performance_percent"<?= $Page->tufting_performance_percent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_tufting_performance_percent" class="el_carpet_setup_tufting_performance_percent">
<span<?= $Page->tufting_performance_percent->viewAttributes() ?>>
<?= $Page->tufting_performance_percent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_weeks->Visible) { // jc_weeks ?>
        <td data-name="jc_weeks"<?= $Page->jc_weeks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_jc_weeks" class="el_carpet_setup_jc_weeks">
<span<?= $Page->jc_weeks->viewAttributes() ?>>
<?= $Page->jc_weeks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->required_material_overall_update->Visible) { // required_material_overall_update ?>
        <td data-name="required_material_overall_update"<?= $Page->required_material_overall_update->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_required_material_overall_update" class="el_carpet_setup_required_material_overall_update">
<span<?= $Page->required_material_overall_update->viewAttributes() ?>>
<?= $Page->required_material_overall_update->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_material_issue->Visible) { // jc_material_issue ?>
        <td data-name="jc_material_issue"<?= $Page->jc_material_issue->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_jc_material_issue" class="el_carpet_setup_jc_material_issue">
<span<?= $Page->jc_material_issue->viewAttributes() ?>>
<?= $Page->jc_material_issue->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_qr->Visible) { // jc_qr ?>
        <td data-name="jc_qr"<?= $Page->jc_qr->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_jc_qr" class="el_carpet_setup_jc_qr">
<span<?= $Page->jc_qr->viewAttributes() ?>>
<?= $Page->jc_qr->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_mrlot->Visible) { // jc_mrlot ?>
        <td data-name="jc_mrlot"<?= $Page->jc_mrlot->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_jc_mrlot" class="el_carpet_setup_jc_mrlot">
<span<?= $Page->jc_mrlot->viewAttributes() ?>>
<?= $Page->jc_mrlot->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_operator" class="el_carpet_setup_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_datetime" class="el_carpet_setup_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->max_jobcard->Visible) { // max_jobcard ?>
        <td data-name="max_jobcard"<?= $Page->max_jobcard->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_max_jobcard" class="el_carpet_setup_max_jobcard">
<span<?= $Page->max_jobcard->viewAttributes() ?>>
<?= $Page->max_jobcard->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_pending_delete_days->Visible) { // jc_pending_delete_days ?>
        <td data-name="jc_pending_delete_days"<?= $Page->jc_pending_delete_days->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_jc_pending_delete_days" class="el_carpet_setup_jc_pending_delete_days">
<span<?= $Page->jc_pending_delete_days->viewAttributes() ?>>
<?= $Page->jc_pending_delete_days->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_pp_id->Visible) { // batch_pp_id ?>
        <td data-name="batch_pp_id"<?= $Page->batch_pp_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_carpet_setup_batch_pp_id" class="el_carpet_setup_batch_pp_id">
<span<?= $Page->batch_pp_id->viewAttributes() ?>>
<?= $Page->batch_pp_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("carpet_setup");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
