<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("CapacityPlanGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fcapacity_plangrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { capacity_plan: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcapacity_plangrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["user_id", [fields.user_id.visible && fields.user_id.required ? ew.Validators.required(fields.user_id.caption) : null], fields.user_id.isInvalid],
            ["period", [fields.period.visible && fields.period.required ? ew.Validators.required(fields.period.caption) : null], fields.period.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["capacity", [fields.capacity.visible && fields.capacity.required ? ew.Validators.required(fields.capacity.caption) : null, ew.Validators.float], fields.capacity.isInvalid],
            ["method", [fields.method.visible && fields.method.required ? ew.Validators.required(fields.method.caption) : null], fields.method.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["user_id",false],["period",false],["grp",false],["s_grp",false],["capacity",false],["method",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "user_id": <?= $Grid->user_id->toClientList($Grid) ?>,
            "period": <?= $Grid->period->toClientList($Grid) ?>,
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "s_grp": <?= $Grid->s_grp->toClientList($Grid) ?>,
            "method": <?= $Grid->method->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fcapacity_plangrid" class="ew-form ew-list-form">
<div id="gmp_capacity_plan" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_capacity_plangrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_capacity_plan_id" class="capacity_plan_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->user_id->Visible) { // user_id ?>
        <th data-name="user_id" class="<?= $Grid->user_id->headerCellClass() ?>"><div id="elh_capacity_plan_user_id" class="capacity_plan_user_id"><?= $Grid->renderFieldHeader($Grid->user_id) ?></div></th>
<?php } ?>
<?php if ($Grid->period->Visible) { // period ?>
        <th data-name="period" class="<?= $Grid->period->headerCellClass() ?>"><div id="elh_capacity_plan_period" class="capacity_plan_period"><?= $Grid->renderFieldHeader($Grid->period) ?></div></th>
<?php } ?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_capacity_plan_grp" class="capacity_plan_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Grid->s_grp->headerCellClass() ?>"><div id="elh_capacity_plan_s_grp" class="capacity_plan_s_grp"><?= $Grid->renderFieldHeader($Grid->s_grp) ?></div></th>
<?php } ?>
<?php if ($Grid->capacity->Visible) { // capacity ?>
        <th data-name="capacity" class="<?= $Grid->capacity->headerCellClass() ?>"><div id="elh_capacity_plan_capacity" class="capacity_plan_capacity"><?= $Grid->renderFieldHeader($Grid->capacity) ?></div></th>
<?php } ?>
<?php if ($Grid->method->Visible) { // method ?>
        <th data-name="method" class="<?= $Grid->method->headerCellClass() ?>"><div id="elh_capacity_plan_method" class="capacity_plan_method"><?= $Grid->renderFieldHeader($Grid->method) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_capacity_plan_operator" class="capacity_plan_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_capacity_plan_datetime" class="capacity_plan_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_id" class="el_capacity_plan_id"></span>
<input type="hidden" data-table="capacity_plan" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_id" class="el_capacity_plan_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="capacity_plan" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_id" class="el_capacity_plan_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_id" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_id" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_id" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_id" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="capacity_plan" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->user_id->Visible) { // user_id ?>
        <td data-name="user_id"<?= $Grid->user_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->user_id->getSessionValue() != "") { ?>
<span<?= $Grid->user_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->user_id->getDisplayValue($Grid->user_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_user_id" name="x<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_user_id" class="el_capacity_plan_user_id">
    <select
        id="x<?= $Grid->RowIndex ?>_user_id"
        name="x<?= $Grid->RowIndex ?>_user_id"
        class="form-select ew-select<?= $Grid->user_id->isInvalidClass() ?>"
        <?php if (!$Grid->user_id->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_user_id"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_user_id"
        data-value-separator="<?= $Grid->user_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->user_id->getPlaceHolder()) ?>"
        <?= $Grid->user_id->editAttributes() ?>>
        <?= $Grid->user_id->selectOptionListHtml("x{$Grid->RowIndex}_user_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->user_id->getErrorMessage() ?></div>
<?= $Grid->user_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_user_id") ?>
<?php if (!$Grid->user_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_user_id", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_user_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.user_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.user_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="capacity_plan" data-field="x_user_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_user_id" id="o<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->user_id->getSessionValue() != "") { ?>
<span<?= $Grid->user_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->user_id->getDisplayValue($Grid->user_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_user_id" name="x<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_user_id" class="el_capacity_plan_user_id">
    <select
        id="x<?= $Grid->RowIndex ?>_user_id"
        name="x<?= $Grid->RowIndex ?>_user_id"
        class="form-select ew-select<?= $Grid->user_id->isInvalidClass() ?>"
        <?php if (!$Grid->user_id->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_user_id"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_user_id"
        data-value-separator="<?= $Grid->user_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->user_id->getPlaceHolder()) ?>"
        <?= $Grid->user_id->editAttributes() ?>>
        <?= $Grid->user_id->selectOptionListHtml("x{$Grid->RowIndex}_user_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->user_id->getErrorMessage() ?></div>
<?= $Grid->user_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_user_id") ?>
<?php if (!$Grid->user_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_user_id", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_user_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.user_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_user_id", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.user_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_user_id" class="el_capacity_plan_user_id">
<span<?= $Grid->user_id->viewAttributes() ?>>
<?= $Grid->user_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_user_id" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_user_id" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_user_id" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_user_id" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_user_id" value="<?= HtmlEncode($Grid->user_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->period->Visible) { // period ?>
        <td data-name="period"<?= $Grid->period->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_period" class="el_capacity_plan_period">
    <select
        id="x<?= $Grid->RowIndex ?>_period"
        name="x<?= $Grid->RowIndex ?>_period"
        class="form-select ew-select<?= $Grid->period->isInvalidClass() ?>"
        <?php if (!$Grid->period->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_period"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_period"
        data-value-separator="<?= $Grid->period->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->period->getPlaceHolder()) ?>"
        <?= $Grid->period->editAttributes() ?>>
        <?= $Grid->period->selectOptionListHtml("x{$Grid->RowIndex}_period") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->period->getErrorMessage() ?></div>
<?= $Grid->period->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_period") ?>
<?php if (!$Grid->period->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_period", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_period" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.period?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_period", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_period", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.period.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_period" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_period" id="o<?= $Grid->RowIndex ?>_period" value="<?= HtmlEncode($Grid->period->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_period" class="el_capacity_plan_period">
    <select
        id="x<?= $Grid->RowIndex ?>_period"
        name="x<?= $Grid->RowIndex ?>_period"
        class="form-select ew-select<?= $Grid->period->isInvalidClass() ?>"
        <?php if (!$Grid->period->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_period"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_period"
        data-value-separator="<?= $Grid->period->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->period->getPlaceHolder()) ?>"
        <?= $Grid->period->editAttributes() ?>>
        <?= $Grid->period->selectOptionListHtml("x{$Grid->RowIndex}_period") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->period->getErrorMessage() ?></div>
<?= $Grid->period->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_period") ?>
<?php if (!$Grid->period->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_period", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_period" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.period?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_period", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_period", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.period.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_period" class="el_capacity_plan_period">
<span<?= $Grid->period->viewAttributes() ?>>
<?= $Grid->period->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_period" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_period" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_period" value="<?= HtmlEncode($Grid->period->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_period" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_period" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_period" value="<?= HtmlEncode($Grid->period->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_grp" class="el_capacity_plan_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_grp" class="el_capacity_plan_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_grp" class="el_capacity_plan_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?= $Grid->grp->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_grp" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_grp" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_grp" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_grp" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Grid->s_grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_s_grp" class="el_capacity_plan_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_grp" id="o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_s_grp" class="el_capacity_plan_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_s_grp" class="el_capacity_plan_s_grp">
<span<?= $Grid->s_grp->viewAttributes() ?>>
<?= $Grid->s_grp->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_s_grp" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_s_grp" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_s_grp" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_s_grp" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->capacity->Visible) { // capacity ?>
        <td data-name="capacity"<?= $Grid->capacity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_capacity" class="el_capacity_plan_capacity">
<input type="<?= $Grid->capacity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_capacity" id="x<?= $Grid->RowIndex ?>_capacity" data-table="capacity_plan" data-field="x_capacity" value="<?= $Grid->capacity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->capacity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->capacity->formatPattern()) ?>"<?= $Grid->capacity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->capacity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_capacity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_capacity" id="o<?= $Grid->RowIndex ?>_capacity" value="<?= HtmlEncode($Grid->capacity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_capacity" class="el_capacity_plan_capacity">
<input type="<?= $Grid->capacity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_capacity" id="x<?= $Grid->RowIndex ?>_capacity" data-table="capacity_plan" data-field="x_capacity" value="<?= $Grid->capacity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->capacity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->capacity->formatPattern()) ?>"<?= $Grid->capacity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->capacity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_capacity" class="el_capacity_plan_capacity">
<span<?= $Grid->capacity->viewAttributes() ?>>
<?= $Grid->capacity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_capacity" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_capacity" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_capacity" value="<?= HtmlEncode($Grid->capacity->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_capacity" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_capacity" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_capacity" value="<?= HtmlEncode($Grid->capacity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->method->Visible) { // method ?>
        <td data-name="method"<?= $Grid->method->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_method" class="el_capacity_plan_method">
    <select
        id="x<?= $Grid->RowIndex ?>_method"
        name="x<?= $Grid->RowIndex ?>_method"
        class="form-select ew-select<?= $Grid->method->isInvalidClass() ?>"
        <?php if (!$Grid->method->IsNativeSelect) { ?>
        data-select2-id="fcapacity_plangrid_x<?= $Grid->RowIndex ?>_method"
        <?php } ?>
        data-table="capacity_plan"
        data-field="x_method"
        data-value-separator="<?= $Grid->method->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->method->getPlaceHolder()) ?>"
        <?= $Grid->method->editAttributes() ?>>
        <?= $Grid->method->selectOptionListHtml("x{$Grid->RowIndex}_method") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->method->getErrorMessage() ?></div>
<?php if (!$Grid->method->IsNativeSelect) { ?>
<script>
loadjs.ready("fcapacity_plangrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_method", selectId: "fcapacity_plangrid_x<?= $Grid->RowIndex ?>_method" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcapacity_plangrid.lists.method?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_method", form: "fcapacity_plangrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_method", form: "fcapacity_plangrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.capacity_plan.fields.method.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="capacity_plan" data-field="x_method" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_method" id="o<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_method" class="el_capacity_plan_method">
<span<?= $Grid->method->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->method->getDisplayValue($Grid->method->EditValue) ?></span></span>
<input type="hidden" data-table="capacity_plan" data-field="x_method" data-hidden="1" name="x<?= $Grid->RowIndex ?>_method" id="x<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_method" class="el_capacity_plan_method">
<span<?= $Grid->method->viewAttributes() ?>>
<?= $Grid->method->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_method" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_method" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_method" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_method" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_method" value="<?= HtmlEncode($Grid->method->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="capacity_plan" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_operator" class="el_capacity_plan_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_operator" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_operator" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_operator" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_operator" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="capacity_plan" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_capacity_plan_datetime" class="el_capacity_plan_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="capacity_plan" data-field="x_datetime" data-hidden="1" name="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_datetime" id="fcapacity_plangrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="capacity_plan" data-field="x_datetime" data-hidden="1" data-old name="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_datetime" id="fcapacity_plangrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fcapacity_plangrid","load"], () => fcapacity_plangrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fcapacity_plangrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("capacity_plan");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
