<?php

namespace PHPMaker2024\fibre;

// Page object
$CalendarAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { calendar: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fcalendaradd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fcalendaradd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["_title", [fields._title.visible && fields._title.required ? ew.Validators.required(fields._title.caption) : null], fields._title.isInvalid],
            ["start", [fields.start.visible && fields.start.required ? ew.Validators.required(fields.start.caption) : null, ew.Validators.datetime(fields.start.clientFormatPattern)], fields.start.isInvalid],
            ["end", [fields.end.visible && fields.end.required ? ew.Validators.required(fields.end.caption) : null, ew.Validators.datetime(fields.end.clientFormatPattern)], fields.end.isInvalid],
            ["allday", [fields.allday.visible && fields.allday.required ? ew.Validators.required(fields.allday.caption) : null], fields.allday.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["groupid", [fields.groupid.visible && fields.groupid.required ? ew.Validators.required(fields.groupid.caption) : null], fields.groupid.isInvalid],
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["backgroundcolor", [fields.backgroundcolor.visible && fields.backgroundcolor.required ? ew.Validators.required(fields.backgroundcolor.caption) : null], fields.backgroundcolor.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "allday": <?= $Page->allday->toClientList($Page) ?>,
            "groupid": <?= $Page->groupid->toClientList($Page) ?>,
            "backgroundcolor": <?= $Page->backgroundcolor->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fcalendaradd" id="fcalendaradd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="calendar">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->_title->Visible) { // title ?>
    <div id="r__title"<?= $Page->_title->rowAttributes() ?>>
        <label id="elh_calendar__title" for="x__title" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_title->caption() ?><?= $Page->_title->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_title->cellAttributes() ?>>
<span id="el_calendar__title">
<input type="<?= $Page->_title->getInputTextType() ?>" name="x__title" id="x__title" data-table="calendar" data-field="x__title" value="<?= $Page->_title->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_title->formatPattern()) ?>"<?= $Page->_title->editAttributes() ?> aria-describedby="x__title_help">
<?= $Page->_title->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_title->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->start->Visible) { // start ?>
    <div id="r_start"<?= $Page->start->rowAttributes() ?>>
        <label id="elh_calendar_start" for="x_start" class="<?= $Page->LeftColumnClass ?>"><?= $Page->start->caption() ?><?= $Page->start->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->start->cellAttributes() ?>>
<span id="el_calendar_start">
<input type="<?= $Page->start->getInputTextType() ?>" name="x_start" id="x_start" data-table="calendar" data-field="x_start" value="<?= $Page->start->EditValue ?>" placeholder="<?= HtmlEncode($Page->start->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->start->formatPattern()) ?>"<?= $Page->start->editAttributes() ?> aria-describedby="x_start_help">
<?= $Page->start->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->start->getErrorMessage() ?></div>
<?php if (!$Page->start->ReadOnly && !$Page->start->Disabled && !isset($Page->start->EditAttrs["readonly"]) && !isset($Page->start->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcalendaradd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcalendaradd", "x_start", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->end->Visible) { // end ?>
    <div id="r_end"<?= $Page->end->rowAttributes() ?>>
        <label id="elh_calendar_end" for="x_end" class="<?= $Page->LeftColumnClass ?>"><?= $Page->end->caption() ?><?= $Page->end->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->end->cellAttributes() ?>>
<span id="el_calendar_end">
<input type="<?= $Page->end->getInputTextType() ?>" name="x_end" id="x_end" data-table="calendar" data-field="x_end" value="<?= $Page->end->EditValue ?>" placeholder="<?= HtmlEncode($Page->end->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->end->formatPattern()) ?>"<?= $Page->end->editAttributes() ?> aria-describedby="x_end_help">
<?= $Page->end->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->end->getErrorMessage() ?></div>
<?php if (!$Page->end->ReadOnly && !$Page->end->Disabled && !isset($Page->end->EditAttrs["readonly"]) && !isset($Page->end->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fcalendaradd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fcalendaradd", "x_end", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->allday->Visible) { // allday ?>
    <div id="r_allday"<?= $Page->allday->rowAttributes() ?>>
        <label id="elh_calendar_allday" for="x_allday" class="<?= $Page->LeftColumnClass ?>"><?= $Page->allday->caption() ?><?= $Page->allday->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->allday->cellAttributes() ?>>
<span id="el_calendar_allday">
    <select
        id="x_allday"
        name="x_allday"
        class="form-select ew-select<?= $Page->allday->isInvalidClass() ?>"
        <?php if (!$Page->allday->IsNativeSelect) { ?>
        data-select2-id="fcalendaradd_x_allday"
        <?php } ?>
        data-table="calendar"
        data-field="x_allday"
        data-value-separator="<?= $Page->allday->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->allday->getPlaceHolder()) ?>"
        <?= $Page->allday->editAttributes() ?>>
        <?= $Page->allday->selectOptionListHtml("x_allday") ?>
    </select>
    <?= $Page->allday->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->allday->getErrorMessage() ?></div>
<?php if (!$Page->allday->IsNativeSelect) { ?>
<script>
loadjs.ready("fcalendaradd", function() {
    var options = { name: "x_allday", selectId: "fcalendaradd_x_allday" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcalendaradd.lists.allday?.lookupOptions.length) {
        options.data = { id: "x_allday", form: "fcalendaradd" };
    } else {
        options.ajax = { id: "x_allday", form: "fcalendaradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.calendar.fields.allday.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_calendar_description" for="x_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_calendar_description">
<textarea data-table="calendar" data-field="x_description" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->description->getPlaceHolder()) ?>"<?= $Page->description->editAttributes() ?> aria-describedby="x_description_help"><?= $Page->description->EditValue ?></textarea>
<?= $Page->description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->groupid->Visible) { // groupid ?>
    <div id="r_groupid"<?= $Page->groupid->rowAttributes() ?>>
        <label id="elh_calendar_groupid" for="x_groupid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->groupid->caption() ?><?= $Page->groupid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->groupid->cellAttributes() ?>>
<span id="el_calendar_groupid">
    <select
        id="x_groupid[]"
        name="x_groupid[]"
        class="form-select ew-select<?= $Page->groupid->isInvalidClass() ?>"
        <?php if (!$Page->groupid->IsNativeSelect) { ?>
        data-select2-id="fcalendaradd_x_groupid[]"
        <?php } ?>
        data-table="calendar"
        data-field="x_groupid"
        multiple
        size="1"
        data-value-separator="<?= $Page->groupid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->groupid->getPlaceHolder()) ?>"
        <?= $Page->groupid->editAttributes() ?>>
        <?= $Page->groupid->selectOptionListHtml("x_groupid[]") ?>
    </select>
    <?= $Page->groupid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->groupid->getErrorMessage() ?></div>
<?= $Page->groupid->Lookup->getParamTag($Page, "p_x_groupid") ?>
<?php if (!$Page->groupid->IsNativeSelect) { ?>
<script>
loadjs.ready("fcalendaradd", function() {
    var options = { name: "x_groupid[]", selectId: "fcalendaradd_x_groupid[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcalendaradd.lists.groupid?.lookupOptions.length) {
        options.data = { id: "x_groupid[]", form: "fcalendaradd" };
    } else {
        options.ajax = { id: "x_groupid[]", form: "fcalendaradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.calendar.fields.groupid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_calendar_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_calendar_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="calendar" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->backgroundcolor->Visible) { // backgroundcolor ?>
    <div id="r_backgroundcolor"<?= $Page->backgroundcolor->rowAttributes() ?>>
        <label id="elh_calendar_backgroundcolor" for="x_backgroundcolor" class="<?= $Page->LeftColumnClass ?>"><?= $Page->backgroundcolor->caption() ?><?= $Page->backgroundcolor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->backgroundcolor->cellAttributes() ?>>
<span id="el_calendar_backgroundcolor">
    <select
        id="x_backgroundcolor"
        name="x_backgroundcolor"
        class="form-select ew-select<?= $Page->backgroundcolor->isInvalidClass() ?>"
        <?php if (!$Page->backgroundcolor->IsNativeSelect) { ?>
        data-select2-id="fcalendaradd_x_backgroundcolor"
        <?php } ?>
        data-table="calendar"
        data-field="x_backgroundcolor"
        data-value-separator="<?= $Page->backgroundcolor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->backgroundcolor->getPlaceHolder()) ?>"
        <?= $Page->backgroundcolor->editAttributes() ?>>
        <?= $Page->backgroundcolor->selectOptionListHtml("x_backgroundcolor") ?>
    </select>
    <?= $Page->backgroundcolor->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->backgroundcolor->getErrorMessage() ?></div>
<?php if (!$Page->backgroundcolor->IsNativeSelect) { ?>
<script>
loadjs.ready("fcalendaradd", function() {
    var options = { name: "x_backgroundcolor", selectId: "fcalendaradd_x_backgroundcolor" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fcalendaradd.lists.backgroundcolor?.lookupOptions.length) {
        options.data = { id: "x_backgroundcolor", form: "fcalendaradd" };
    } else {
        options.ajax = { id: "x_backgroundcolor", form: "fcalendaradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.calendar.fields.backgroundcolor.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fcalendaradd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fcalendaradd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("calendar");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
