<?php

namespace PHPMaker2024\fibre;

// Page object
$ByproductComparisonSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { byproduct_comparison: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbyproduct_comparisonsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbyproduct_comparisonsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["s_grp", [], fields.s_grp.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["base", [ew.Validators.float], fields.base.isInvalid],
            ["n1", [ew.Validators.float], fields.n1.isInvalid],
            ["n2", [ew.Validators.float], fields.n2.isInvalid],
            ["s_total", [ew.Validators.float], fields.s_total.isInvalid],
            ["n3", [ew.Validators.float], fields.n3.isInvalid],
            ["n4", [ew.Validators.float], fields.n4.isInvalid],
            ["short", [ew.Validators.float], fields.short.isInvalid],
            ["processed_by", [ew.Validators.integer], fields.processed_by.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbyproduct_comparisonsearch" id="fbyproduct_comparisonsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="byproduct_comparison">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbyproduct_comparisonsearch_x_s_grp"
        <?php } ?>
        data-table="byproduct_comparison"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbyproduct_comparisonsearch", function() {
    var options = { name: "x_s_grp", selectId: "fbyproduct_comparisonsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbyproduct_comparisonsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fbyproduct_comparisonsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fbyproduct_comparisonsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.byproduct_comparison.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_rid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rid->getInputTextType() ?>" name="x_rid" id="x_rid" data-table="byproduct_comparison" data-field="x_rid" value="<?= $Page->rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="byproduct_comparison" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="byproduct_comparison" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="byproduct_comparison" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="40" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->base->Visible) { // base ?>
    <div id="r_base" class="row"<?= $Page->base->rowAttributes() ?>>
        <label for="x_base" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_base"><?= $Page->base->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_base" id="z_base" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->base->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_base" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->base->getInputTextType() ?>" name="x_base" id="x_base" data-table="byproduct_comparison" data-field="x_base" value="<?= $Page->base->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->base->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->base->formatPattern()) ?>"<?= $Page->base->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->base->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->n1->Visible) { // n1 ?>
    <div id="r_n1" class="row"<?= $Page->n1->rowAttributes() ?>>
        <label for="x_n1" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_n1"><?= $Page->n1->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_n1" id="z_n1" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->n1->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_n1" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->n1->getInputTextType() ?>" name="x_n1" id="x_n1" data-table="byproduct_comparison" data-field="x_n1" value="<?= $Page->n1->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->n1->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->n1->formatPattern()) ?>"<?= $Page->n1->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->n1->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->n2->Visible) { // n2 ?>
    <div id="r_n2" class="row"<?= $Page->n2->rowAttributes() ?>>
        <label for="x_n2" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_n2"><?= $Page->n2->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_n2" id="z_n2" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->n2->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_n2" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->n2->getInputTextType() ?>" name="x_n2" id="x_n2" data-table="byproduct_comparison" data-field="x_n2" value="<?= $Page->n2->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->n2->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->n2->formatPattern()) ?>"<?= $Page->n2->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->n2->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_total->Visible) { // s_total ?>
    <div id="r_s_total" class="row"<?= $Page->s_total->rowAttributes() ?>>
        <label for="x_s_total" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_s_total"><?= $Page->s_total->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_total" id="z_s_total" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_total->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_s_total" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->s_total->getInputTextType() ?>" name="x_s_total" id="x_s_total" data-table="byproduct_comparison" data-field="x_s_total" value="<?= $Page->s_total->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->s_total->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->s_total->formatPattern()) ?>"<?= $Page->s_total->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->s_total->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->n3->Visible) { // n3 ?>
    <div id="r_n3" class="row"<?= $Page->n3->rowAttributes() ?>>
        <label for="x_n3" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_n3"><?= $Page->n3->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_n3" id="z_n3" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->n3->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_n3" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->n3->getInputTextType() ?>" name="x_n3" id="x_n3" data-table="byproduct_comparison" data-field="x_n3" value="<?= $Page->n3->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->n3->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->n3->formatPattern()) ?>"<?= $Page->n3->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->n3->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->n4->Visible) { // n4 ?>
    <div id="r_n4" class="row"<?= $Page->n4->rowAttributes() ?>>
        <label for="x_n4" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_n4"><?= $Page->n4->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_n4" id="z_n4" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->n4->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_n4" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->n4->getInputTextType() ?>" name="x_n4" id="x_n4" data-table="byproduct_comparison" data-field="x_n4" value="<?= $Page->n4->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->n4->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->n4->formatPattern()) ?>"<?= $Page->n4->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->n4->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->short->Visible) { // short ?>
    <div id="r_short" class="row"<?= $Page->short->rowAttributes() ?>>
        <label for="x_short" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_short"><?= $Page->short->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_short" id="z_short" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->short->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_short" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->short->getInputTextType() ?>" name="x_short" id="x_short" data-table="byproduct_comparison" data-field="x_short" value="<?= $Page->short->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->short->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->short->formatPattern()) ?>"<?= $Page->short->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->short->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->processed_by->Visible) { // processed_by ?>
    <div id="r_processed_by" class="row"<?= $Page->processed_by->rowAttributes() ?>>
        <label for="x_processed_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_byproduct_comparison_processed_by"><?= $Page->processed_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_processed_by" id="z_processed_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->processed_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_byproduct_comparison_processed_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->processed_by->getInputTextType() ?>" name="x_processed_by" id="x_processed_by" data-table="byproduct_comparison" data-field="x_processed_by" value="<?= $Page->processed_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->processed_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->processed_by->formatPattern()) ?>"<?= $Page->processed_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->processed_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbyproduct_comparisonsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbyproduct_comparisonsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbyproduct_comparisonsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("byproduct_comparison");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
