<?php

namespace PHPMaker2024\fibre;

// Page object
$BuyerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { buyer: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbuyersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbuyersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["user_name", [], fields.user_name.isInvalid],
            ["_password", [], fields._password.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["sub_category", [], fields.sub_category.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["code", [ew.Validators.regex(/^([a-zA-Z0-9_-]){1,6}$/)], fields.code.isInvalid],
            ["seller", [], fields.seller.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["country", [], fields.country.isInvalid],
            ["region", [], fields.region.isInvalid],
            ["city", [], fields.city.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["tax_registration", [], fields.tax_registration.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["port_sea", [], fields.port_sea.isInvalid],
            ["incoterm", [], fields.incoterm.isInvalid],
            ["port_air", [], fields.port_air.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["performance", [ew.Validators.integer], fields.performance.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["price_percent", [ew.Validators.float], fields.price_percent.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "seller": <?= $Page->seller->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "region": <?= $Page->region->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "port_sea": <?= $Page->port_sea->toClientList($Page) ?>,
            "incoterm": <?= $Page->incoterm->toClientList($Page) ?>,
            "port_air": <?= $Page->port_air->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbuyersearch" id="fbuyersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="buyer">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="buyer" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name" class="row"<?= $Page->user_name->rowAttributes() ?>>
        <label for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_user_name"><?= $Page->user_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_user_name" id="z_user_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_user_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="buyer" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_password->Visible) { // password ?>
    <div id="r__password" class="row"<?= $Page->_password->rowAttributes() ?>>
        <label for="x__password" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer__password"><?= $Page->_password->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__password" id="z__password" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_password->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer__password" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_password->getInputTextType() ?>" name="x__password" id="x__password" data-table="buyer" data-field="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_password->formatPattern()) ?>"<?= $Page->_password->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_category"
        <?php } ?>
        data-table="buyer"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_category", selectId: "fbuyersearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_category", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sub_category->Visible) { // sub_category ?>
    <div id="r_sub_category" class="row"<?= $Page->sub_category->rowAttributes() ?>>
        <label for="x_sub_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_sub_category"><?= $Page->sub_category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sub_category" id="z_sub_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sub_category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_sub_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_sub_category"
        name="x_sub_category"
        class="form-select ew-select<?= $Page->sub_category->isInvalidClass() ?>"
        <?php if (!$Page->sub_category->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_sub_category"
        <?php } ?>
        data-table="buyer"
        data-field="x_sub_category"
        data-value-separator="<?= $Page->sub_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_category->getPlaceHolder()) ?>"
        <?= $Page->sub_category->editAttributes() ?>>
        <?= $Page->sub_category->selectOptionListHtml("x_sub_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sub_category->getErrorMessage(false) ?></div>
<?= $Page->sub_category->Lookup->getParamTag($Page, "p_x_sub_category") ?>
<?php if (!$Page->sub_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_sub_category", selectId: "fbuyersearch_x_sub_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.sub_category?.lookupOptions.length) {
        options.data = { id: "x_sub_category", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_sub_category", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.sub_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="buyer" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="buyer"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="buyer" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="buyer" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->seller->Visible) { // seller ?>
    <div id="r_seller" class="row"<?= $Page->seller->rowAttributes() ?>>
        <label for="x_seller" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_seller"><?= $Page->seller->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_seller" id="z_seller" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->seller->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_seller" class="ew-search-field ew-search-field-single">
    <select
        id="x_seller"
        name="x_seller"
        class="form-select ew-select<?= $Page->seller->isInvalidClass() ?>"
        <?php if (!$Page->seller->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_seller"
        <?php } ?>
        data-table="buyer"
        data-field="x_seller"
        data-value-separator="<?= $Page->seller->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->seller->getPlaceHolder()) ?>"
        <?= $Page->seller->editAttributes() ?>>
        <?= $Page->seller->selectOptionListHtml("x_seller") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->seller->getErrorMessage(false) ?></div>
<?= $Page->seller->Lookup->getParamTag($Page, "p_x_seller") ?>
<?php if (!$Page->seller->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_seller", selectId: "fbuyersearch_x_seller" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.seller?.lookupOptions.length) {
        options.data = { id: "x_seller", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_seller", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.seller.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="buyer" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="buyer" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country" class="row"<?= $Page->country->rowAttributes() ?>>
        <label for="x_country" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_country"><?= $Page->country->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_country" id="z_country" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->country->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_country" class="ew-search-field ew-search-field-single">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_country"
        <?php } ?>
        data-table="buyer"
        data-field="x_country"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage(false) ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_country", selectId: "fbuyersearch_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_country", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->region->Visible) { // region ?>
    <div id="r_region" class="row"<?= $Page->region->rowAttributes() ?>>
        <label for="x_region" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_region"><?= $Page->region->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_region" id="z_region" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->region->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_region" class="ew-search-field ew-search-field-single">
    <select
        id="x_region"
        name="x_region"
        class="form-select ew-select<?= $Page->region->isInvalidClass() ?>"
        <?php if (!$Page->region->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_region"
        <?php } ?>
        data-table="buyer"
        data-field="x_region"
        data-value-separator="<?= $Page->region->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->region->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->region->editAttributes() ?>>
        <?= $Page->region->selectOptionListHtml("x_region") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->region->getErrorMessage(false) ?></div>
<?= $Page->region->Lookup->getParamTag($Page, "p_x_region") ?>
<?php if (!$Page->region->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_region", selectId: "fbuyersearch_x_region" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.region?.lookupOptions.length) {
        options.data = { id: "x_region", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_region", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.region.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city" class="row"<?= $Page->city->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_city"><?= $Page->city->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_city" id="z_city" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_city" class="ew-search-field ew-search-field-single">
    <select
        id="x_city"
        name="x_city"
        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
        data-select2-id="fbuyersearch_x_city"
        data-table="buyer"
        data-field="x_city"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_city", selectId: "fbuyersearch_x_city" };
    if (fbuyersearch.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_city", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.buyer.fields.city.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="buyer" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_location" id="z_location" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_location" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->location->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_location" class="ew-auto-suggest">
    <input type="<?= $Page->location->getInputTextType() ?>" class="form-control" name="sv_x_location" id="sv_x_location" value="<?= RemoveHtml($Page->location->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="buyer" data-field="x_location" data-input="sv_x_location" data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbuyersearch", function() {
    fbuyersearch.createAutoSuggest(Object.assign({"id":"x_location","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->location->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.buyer.fields.location.autoSuggestOptions));
});
</script>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to[]"
        name="x_reports_to[]"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_reports_to[]"
        <?php } ?>
        data-table="buyer"
        data-field="x_reports_to"
        multiple
        size="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_reports_to[]", selectId: "fbuyersearch_x_reports_to[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to[]", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_reports_to[]", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_status"
        <?php } ?>
        data-table="buyer"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_status", selectId: "fbuyersearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tax_registration->Visible) { // tax_registration ?>
    <div id="r_tax_registration" class="row"<?= $Page->tax_registration->rowAttributes() ?>>
        <label for="x_tax_registration" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_tax_registration"><?= $Page->tax_registration->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_tax_registration" id="z_tax_registration" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tax_registration->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_tax_registration" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tax_registration->getInputTextType() ?>" name="x_tax_registration" id="x_tax_registration" data-table="buyer" data-field="x_tax_registration" value="<?= $Page->tax_registration->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->tax_registration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_registration->formatPattern()) ?>"<?= $Page->tax_registration->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tax_registration->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_currency"
        <?php } ?>
        data-table="buyer"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_currency", selectId: "fbuyersearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_sea->Visible) { // port_sea ?>
    <div id="r_port_sea" class="row"<?= $Page->port_sea->rowAttributes() ?>>
        <label for="x_port_sea" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_port_sea"><?= $Page->port_sea->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_port_sea" id="z_port_sea" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_sea->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_port_sea" class="ew-search-field ew-search-field-single">
    <select
        id="x_port_sea"
        name="x_port_sea"
        class="form-select ew-select<?= $Page->port_sea->isInvalidClass() ?>"
        <?php if (!$Page->port_sea->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_port_sea"
        <?php } ?>
        data-table="buyer"
        data-field="x_port_sea"
        data-value-separator="<?= $Page->port_sea->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_sea->getPlaceHolder()) ?>"
        <?= $Page->port_sea->editAttributes() ?>>
        <?= $Page->port_sea->selectOptionListHtml("x_port_sea") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->port_sea->getErrorMessage(false) ?></div>
<?= $Page->port_sea->Lookup->getParamTag($Page, "p_x_port_sea") ?>
<?php if (!$Page->port_sea->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_port_sea", selectId: "fbuyersearch_x_port_sea" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.port_sea?.lookupOptions.length) {
        options.data = { id: "x_port_sea", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_port_sea", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.port_sea.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->incoterm->Visible) { // incoterm ?>
    <div id="r_incoterm" class="row"<?= $Page->incoterm->rowAttributes() ?>>
        <label for="x_incoterm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_incoterm"><?= $Page->incoterm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_incoterm" id="z_incoterm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->incoterm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_incoterm" class="ew-search-field ew-search-field-single">
    <select
        id="x_incoterm[]"
        name="x_incoterm[]"
        class="form-select ew-select<?= $Page->incoterm->isInvalidClass() ?>"
        <?php if (!$Page->incoterm->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_incoterm[]"
        <?php } ?>
        data-table="buyer"
        data-field="x_incoterm"
        multiple
        size="1"
        data-value-separator="<?= $Page->incoterm->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->incoterm->getPlaceHolder()) ?>"
        <?= $Page->incoterm->editAttributes() ?>>
        <?= $Page->incoterm->selectOptionListHtml("x_incoterm[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->incoterm->getErrorMessage(false) ?></div>
<?= $Page->incoterm->Lookup->getParamTag($Page, "p_x_incoterm") ?>
<?php if (!$Page->incoterm->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_incoterm[]", selectId: "fbuyersearch_x_incoterm[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.incoterm?.lookupOptions.length) {
        options.data = { id: "x_incoterm[]", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_incoterm[]", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.incoterm.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_air->Visible) { // port_air ?>
    <div id="r_port_air" class="row"<?= $Page->port_air->rowAttributes() ?>>
        <label for="x_port_air" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_port_air"><?= $Page->port_air->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_port_air" id="z_port_air" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_air->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_port_air" class="ew-search-field ew-search-field-single">
    <select
        id="x_port_air"
        name="x_port_air"
        class="form-select ew-select<?= $Page->port_air->isInvalidClass() ?>"
        <?php if (!$Page->port_air->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_port_air"
        <?php } ?>
        data-table="buyer"
        data-field="x_port_air"
        data-value-separator="<?= $Page->port_air->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_air->getPlaceHolder()) ?>"
        <?= $Page->port_air->editAttributes() ?>>
        <?= $Page->port_air->selectOptionListHtml("x_port_air") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->port_air->getErrorMessage(false) ?></div>
<?= $Page->port_air->Lookup->getParamTag($Page, "p_x_port_air") ?>
<?php if (!$Page->port_air->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_port_air", selectId: "fbuyersearch_x_port_air" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.port_air?.lookupOptions.length) {
        options.data = { id: "x_port_air", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_port_air", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.port_air.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_operator"
        <?php } ?>
        data-table="buyer"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_operator", selectId: "fbuyersearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="buyer" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->performance->Visible) { // performance ?>
    <div id="r_performance" class="row"<?= $Page->performance->rowAttributes() ?>>
        <label for="x_performance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_performance"><?= $Page->performance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_performance" id="z_performance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->performance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_performance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->performance->getInputTextType() ?>" name="x_performance" id="x_performance" data-table="buyer" data-field="x_performance" value="<?= $Page->performance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->performance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->performance->formatPattern()) ?>"<?= $Page->performance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->performance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="buyer" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_percent->Visible) { // price_percent ?>
    <div id="r_price_percent" class="row"<?= $Page->price_percent->rowAttributes() ?>>
        <label for="x_price_percent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_buyer_price_percent"><?= $Page->price_percent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_percent" id="z_price_percent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_percent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_buyer_price_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_percent->getInputTextType() ?>" name="x_price_percent" id="x_price_percent" data-table="buyer" data-field="x_price_percent" value="<?= $Page->price_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_percent->formatPattern()) ?>"<?= $Page->price_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_percent->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbuyersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbuyersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbuyersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("buyer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
