<?php

namespace PHPMaker2024\fibre;

// Page object
$BuyerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { buyer: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbuyersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbuyersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["user_name", [], fields.user_name.isInvalid],
            ["_password", [], fields._password.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["sub_category", [], fields.sub_category.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["code", [ew.Validators.regex(/^([a-zA-Z0-9_-]){1,6}$/)], fields.code.isInvalid],
            ["seller", [], fields.seller.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["country", [], fields.country.isInvalid],
            ["region", [], fields.region.isInvalid],
            ["city", [], fields.city.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["tax_registration", [], fields.tax_registration.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["port_sea", [], fields.port_sea.isInvalid],
            ["incoterm", [], fields.incoterm.isInvalid],
            ["port_air", [], fields.port_air.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["performance", [ew.Validators.integer], fields.performance.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["price_percent", [ew.Validators.float], fields.price_percent.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "seller": <?= $Page->seller->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "region": <?= $Page->region->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "port_sea": <?= $Page->port_sea->toClientList($Page) ?>,
            "incoterm": <?= $Page->incoterm->toClientList($Page) ?>,
            "port_air": <?= $Page->port_air->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbuyersearch" id="fbuyersearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("buyerlist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="buyer">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_buyer_id" class="buyersearch"><span id="el_buyer_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="buyer" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_user_name" class="buyersearch"><span id="el_buyer_user_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="buyer" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer__password" class="buyersearch"><span id="el_buyer__password" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_password->getInputTextType() ?>" name="x__password" id="x__password" data-table="buyer" data-field="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_password->formatPattern()) ?>"<?= $Page->_password->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_category" class="buyersearch"><span id="el_buyer_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_category"
        <?php } ?>
        data-table="buyer"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_category", selectId: "fbuyersearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_category", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_sub_category" class="buyersearch"><span id="el_buyer_sub_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_sub_category"
        name="x_sub_category"
        class="form-select ew-select<?= $Page->sub_category->isInvalidClass() ?>"
        <?php if (!$Page->sub_category->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_sub_category"
        <?php } ?>
        data-table="buyer"
        data-field="x_sub_category"
        data-value-separator="<?= $Page->sub_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_category->getPlaceHolder()) ?>"
        <?= $Page->sub_category->editAttributes() ?>>
        <?= $Page->sub_category->selectOptionListHtml("x_sub_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->sub_category->getErrorMessage(false) ?></div>
<?= $Page->sub_category->Lookup->getParamTag($Page, "p_x_sub_category") ?>
<?php if (!$Page->sub_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_sub_category", selectId: "fbuyersearch_x_sub_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.sub_category?.lookupOptions.length) {
        options.data = { id: "x_sub_category", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_sub_category", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.sub_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_grp" class="buyersearch"><span id="el_buyer_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="buyer" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="buyer"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span></template>
<template id="tpx_buyer_name" class="buyersearch"><span id="el_buyer_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="buyer" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_code" class="buyersearch"><span id="el_buyer_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="buyer" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_seller" class="buyersearch"><span id="el_buyer_seller" class="ew-search-field ew-search-field-single">
    <select
        id="x_seller"
        name="x_seller"
        class="form-select ew-select<?= $Page->seller->isInvalidClass() ?>"
        <?php if (!$Page->seller->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_seller"
        <?php } ?>
        data-table="buyer"
        data-field="x_seller"
        data-value-separator="<?= $Page->seller->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->seller->getPlaceHolder()) ?>"
        <?= $Page->seller->editAttributes() ?>>
        <?= $Page->seller->selectOptionListHtml("x_seller") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->seller->getErrorMessage(false) ?></div>
<?= $Page->seller->Lookup->getParamTag($Page, "p_x_seller") ?>
<?php if (!$Page->seller->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_seller", selectId: "fbuyersearch_x_seller" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.seller?.lookupOptions.length) {
        options.data = { id: "x_seller", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_seller", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.seller.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_mobile" class="buyersearch"><span id="el_buyer_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="buyer" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer__email" class="buyersearch"><span id="el_buyer__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="buyer" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_country" class="buyersearch"><span id="el_buyer_country" class="ew-search-field ew-search-field-single">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_country"
        <?php } ?>
        data-table="buyer"
        data-field="x_country"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage(false) ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_country", selectId: "fbuyersearch_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_country", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_region" class="buyersearch"><span id="el_buyer_region" class="ew-search-field ew-search-field-single">
    <select
        id="x_region"
        name="x_region"
        class="form-select ew-select<?= $Page->region->isInvalidClass() ?>"
        <?php if (!$Page->region->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_region"
        <?php } ?>
        data-table="buyer"
        data-field="x_region"
        data-value-separator="<?= $Page->region->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->region->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->region->editAttributes() ?>>
        <?= $Page->region->selectOptionListHtml("x_region") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->region->getErrorMessage(false) ?></div>
<?= $Page->region->Lookup->getParamTag($Page, "p_x_region") ?>
<?php if (!$Page->region->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_region", selectId: "fbuyersearch_x_region" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.region?.lookupOptions.length) {
        options.data = { id: "x_region", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_region", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.region.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_city" class="buyersearch"><span id="el_buyer_city" class="ew-search-field ew-search-field-single">
    <select
        id="x_city"
        name="x_city"
        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
        data-select2-id="fbuyersearch_x_city"
        data-table="buyer"
        data-field="x_city"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_city", selectId: "fbuyersearch_x_city" };
    if (fbuyersearch.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_city", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.buyer.fields.city.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_buyer_city_name" class="buyersearch"><span id="el_buyer_city_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="buyer" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_address" class="buyersearch"><span id="el_buyer_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="buyer" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_location" class="buyersearch"><span id="el_buyer_location" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->location->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_location" class="ew-auto-suggest">
    <input type="<?= $Page->location->getInputTextType() ?>" class="form-control" name="sv_x_location" id="sv_x_location" value="<?= RemoveHtml($Page->location->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="buyer" data-field="x_location" data-input="sv_x_location" data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbuyersearch", function() {
    fbuyersearch.createAutoSuggest(Object.assign({"id":"x_location","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->location->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.buyer.fields.location.autoSuggestOptions));
});
</script>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span></template>
<template id="tpx_buyer_reports_to" class="buyersearch"><span id="el_buyer_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to[]"
        name="x_reports_to[]"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_reports_to[]"
        <?php } ?>
        data-table="buyer"
        data-field="x_reports_to"
        multiple
        size="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_reports_to[]", selectId: "fbuyersearch_x_reports_to[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to[]", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_reports_to[]", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_status" class="buyersearch"><span id="el_buyer_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_status"
        <?php } ?>
        data-table="buyer"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_status", selectId: "fbuyersearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_tax_registration" class="buyersearch"><span id="el_buyer_tax_registration" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tax_registration->getInputTextType() ?>" name="x_tax_registration" id="x_tax_registration" data-table="buyer" data-field="x_tax_registration" value="<?= $Page->tax_registration->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->tax_registration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_registration->formatPattern()) ?>"<?= $Page->tax_registration->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tax_registration->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_currency" class="buyersearch"><span id="el_buyer_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_currency"
        <?php } ?>
        data-table="buyer"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_currency", selectId: "fbuyersearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_port_sea" class="buyersearch"><span id="el_buyer_port_sea" class="ew-search-field ew-search-field-single">
    <select
        id="x_port_sea"
        name="x_port_sea"
        class="form-select ew-select<?= $Page->port_sea->isInvalidClass() ?>"
        <?php if (!$Page->port_sea->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_port_sea"
        <?php } ?>
        data-table="buyer"
        data-field="x_port_sea"
        data-value-separator="<?= $Page->port_sea->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_sea->getPlaceHolder()) ?>"
        <?= $Page->port_sea->editAttributes() ?>>
        <?= $Page->port_sea->selectOptionListHtml("x_port_sea") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->port_sea->getErrorMessage(false) ?></div>
<?= $Page->port_sea->Lookup->getParamTag($Page, "p_x_port_sea") ?>
<?php if (!$Page->port_sea->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_port_sea", selectId: "fbuyersearch_x_port_sea" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.port_sea?.lookupOptions.length) {
        options.data = { id: "x_port_sea", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_port_sea", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.port_sea.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_incoterm" class="buyersearch"><span id="el_buyer_incoterm" class="ew-search-field ew-search-field-single">
    <select
        id="x_incoterm[]"
        name="x_incoterm[]"
        class="form-select ew-select<?= $Page->incoterm->isInvalidClass() ?>"
        <?php if (!$Page->incoterm->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_incoterm[]"
        <?php } ?>
        data-table="buyer"
        data-field="x_incoterm"
        multiple
        size="1"
        data-value-separator="<?= $Page->incoterm->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->incoterm->getPlaceHolder()) ?>"
        <?= $Page->incoterm->editAttributes() ?>>
        <?= $Page->incoterm->selectOptionListHtml("x_incoterm[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->incoterm->getErrorMessage(false) ?></div>
<?= $Page->incoterm->Lookup->getParamTag($Page, "p_x_incoterm") ?>
<?php if (!$Page->incoterm->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_incoterm[]", selectId: "fbuyersearch_x_incoterm[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.incoterm?.lookupOptions.length) {
        options.data = { id: "x_incoterm[]", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_incoterm[]", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.incoterm.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_port_air" class="buyersearch"><span id="el_buyer_port_air" class="ew-search-field ew-search-field-single">
    <select
        id="x_port_air"
        name="x_port_air"
        class="form-select ew-select<?= $Page->port_air->isInvalidClass() ?>"
        <?php if (!$Page->port_air->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_port_air"
        <?php } ?>
        data-table="buyer"
        data-field="x_port_air"
        data-value-separator="<?= $Page->port_air->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_air->getPlaceHolder()) ?>"
        <?= $Page->port_air->editAttributes() ?>>
        <?= $Page->port_air->selectOptionListHtml("x_port_air") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->port_air->getErrorMessage(false) ?></div>
<?= $Page->port_air->Lookup->getParamTag($Page, "p_x_port_air") ?>
<?php if (!$Page->port_air->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_port_air", selectId: "fbuyersearch_x_port_air" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.port_air?.lookupOptions.length) {
        options.data = { id: "x_port_air", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_port_air", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.port_air.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_operator" class="buyersearch"><span id="el_buyer_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbuyersearch_x_operator"
        <?php } ?>
        data-table="buyer"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyersearch", function() {
    var options = { name: "x_operator", selectId: "fbuyersearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyersearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbuyersearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbuyersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_buyer_datetime" class="buyersearch"><span id="el_buyer_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="buyer" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_performance" class="buyersearch"><span id="el_buyer_performance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->performance->getInputTextType() ?>" name="x_performance" id="x_performance" data-table="buyer" data-field="x_performance" value="<?= $Page->performance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->performance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->performance->formatPattern()) ?>"<?= $Page->performance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->performance->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_remarks" class="buyersearch"><span id="el_buyer_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="buyer" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_buyer_price_percent" class="buyersearch"><span id="el_buyer_price_percent" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_percent->getInputTextType() ?>" name="x_price_percent" id="x_price_percent" data-table="buyer" data-field="x_price_percent" value="<?= $Page->price_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_percent->formatPattern()) ?>"<?= $Page->price_percent->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_percent->getErrorMessage(false) ?></div>
</span></template>
<div id="buyer_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "user_name",
                type: "string",
                label: currentTable.fields.user_name.caption,
                operators: currentTable.fields.user_name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.user_name.validators),
                data: {
                    format: currentTable.fields.user_name.clientFormatPattern
                }
            },
            {
                id: "_password",
                type: "string",
                label: currentTable.fields._password.caption,
                operators: currentTable.fields._password.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields._password.validators),
                data: {
                    format: currentTable.fields._password.clientFormatPattern
                }
            },
            {
                id: "category",
                type: "integer",
                label: currentTable.fields.category.caption,
                operators: currentTable.fields.category.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.category.validators),
                data: {
                    format: currentTable.fields.category.clientFormatPattern
                }
            },
            {
                id: "sub_category",
                type: "integer",
                label: currentTable.fields.sub_category.caption,
                operators: currentTable.fields.sub_category.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.sub_category.validators),
                data: {
                    format: currentTable.fields.sub_category.clientFormatPattern
                }
            },
            {
                id: "grp",
                type: "string",
                label: currentTable.fields.grp.caption,
                operators: currentTable.fields.grp.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.grp.validators),
                data: {
                    format: currentTable.fields.grp.clientFormatPattern
                }
            },
            {
                id: "name",
                type: "string",
                label: currentTable.fields.name.caption,
                operators: currentTable.fields.name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.name.validators),
                data: {
                    format: currentTable.fields.name.clientFormatPattern
                }
            },
            {
                id: "code",
                type: "string",
                label: currentTable.fields.code.caption,
                operators: currentTable.fields.code.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.code.validators),
                data: {
                    format: currentTable.fields.code.clientFormatPattern
                }
            },
            {
                id: "seller",
                type: "integer",
                label: currentTable.fields.seller.caption,
                operators: currentTable.fields.seller.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.seller.validators),
                data: {
                    format: currentTable.fields.seller.clientFormatPattern
                }
            },
            {
                id: "mobile",
                type: "string",
                label: currentTable.fields.mobile.caption,
                operators: currentTable.fields.mobile.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.mobile.validators),
                data: {
                    format: currentTable.fields.mobile.clientFormatPattern
                }
            },
            {
                id: "_email",
                type: "string",
                label: currentTable.fields._email.caption,
                operators: currentTable.fields._email.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields._email.validators),
                data: {
                    format: currentTable.fields._email.clientFormatPattern
                }
            },
            {
                id: "country",
                type: "integer",
                label: currentTable.fields.country.caption,
                operators: currentTable.fields.country.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.country.validators),
                data: {
                    format: currentTable.fields.country.clientFormatPattern
                }
            },
            {
                id: "region",
                type: "integer",
                label: currentTable.fields.region.caption,
                operators: currentTable.fields.region.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.region.validators),
                data: {
                    format: currentTable.fields.region.clientFormatPattern
                }
            },
            {
                id: "city",
                type: "string",
                label: currentTable.fields.city.caption,
                operators: currentTable.fields.city.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.city.validators),
                data: {
                    format: currentTable.fields.city.clientFormatPattern
                }
            },
            {
                id: "city_name",
                type: "string",
                label: currentTable.fields.city_name.caption,
                operators: currentTable.fields.city_name.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.city_name.validators),
                data: {
                    format: currentTable.fields.city_name.clientFormatPattern
                }
            },
            {
                id: "address",
                type: "string",
                label: currentTable.fields.address.caption,
                operators: currentTable.fields.address.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.address.validators),
                data: {
                    format: currentTable.fields.address.clientFormatPattern
                }
            },
            {
                id: "location",
                type: "string",
                label: currentTable.fields.location.caption,
                operators: currentTable.fields.location.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.location.validators),
                data: {
                    format: currentTable.fields.location.clientFormatPattern
                }
            },
            {
                id: "reports_to",
                type: "string",
                label: currentTable.fields.reports_to.caption,
                operators: currentTable.fields.reports_to.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.reports_to.validators),
                data: {
                    format: currentTable.fields.reports_to.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "tax_registration",
                type: "string",
                label: currentTable.fields.tax_registration.caption,
                operators: currentTable.fields.tax_registration.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.tax_registration.validators),
                data: {
                    format: currentTable.fields.tax_registration.clientFormatPattern
                }
            },
            {
                id: "currency",
                type: "integer",
                label: currentTable.fields.currency.caption,
                operators: currentTable.fields.currency.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.currency.validators),
                data: {
                    format: currentTable.fields.currency.clientFormatPattern
                }
            },
            {
                id: "port_sea",
                type: "integer",
                label: currentTable.fields.port_sea.caption,
                operators: currentTable.fields.port_sea.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.port_sea.validators),
                data: {
                    format: currentTable.fields.port_sea.clientFormatPattern
                }
            },
            {
                id: "incoterm",
                type: "string",
                label: currentTable.fields.incoterm.caption,
                operators: currentTable.fields.incoterm.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                multiple: true,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.incoterm.validators),
                data: {
                    format: currentTable.fields.incoterm.clientFormatPattern
                }
            },
            {
                id: "port_air",
                type: "integer",
                label: currentTable.fields.port_air.caption,
                operators: currentTable.fields.port_air.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.port_air.validators),
                data: {
                    format: currentTable.fields.port_air.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "performance",
                type: "integer",
                label: currentTable.fields.performance.caption,
                operators: currentTable.fields.performance.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.performance.validators),
                data: {
                    format: currentTable.fields.performance.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "price_percent",
                type: "double",
                label: currentTable.fields.price_percent.caption,
                operators: currentTable.fields.price_percent.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fbuyersearch.fields.price_percent.validators),
                data: {
                    format: currentTable.fields.price_percent.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#buyer_query_builder"),
        args = {},
        rules = ew.parseJson($("#fbuyersearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fbuyersearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fbuyersearch" formaction="<?= HtmlEncode(GetUrl("buyerlist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbuyersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fbuyersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("buyer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
