<?php

namespace PHPMaker2024\fibre;

// Page object
$BuyerAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { buyer: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fbuyeradd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbuyeradd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["user_name", [fields.user_name.visible && fields.user_name.required ? ew.Validators.required(fields.user_name.caption) : null], fields.user_name.isInvalid],
            ["_password", [fields._password.visible && fields._password.required ? ew.Validators.required(fields._password.caption) : null], fields._password.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["sub_category", [fields.sub_category.visible && fields.sub_category.required ? ew.Validators.required(fields.sub_category.caption) : null], fields.sub_category.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){1,6}$/)], fields.code.isInvalid],
            ["seller", [fields.seller.visible && fields.seller.required ? ew.Validators.required(fields.seller.caption) : null], fields.seller.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null], fields.country.isInvalid],
            ["region", [fields.region.visible && fields.region.required ? ew.Validators.required(fields.region.caption) : null], fields.region.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["reports_to", [fields.reports_to.visible && fields.reports_to.required ? ew.Validators.required(fields.reports_to.caption) : null], fields.reports_to.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["tax_registration", [fields.tax_registration.visible && fields.tax_registration.required ? ew.Validators.required(fields.tax_registration.caption) : null], fields.tax_registration.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["port_sea", [fields.port_sea.visible && fields.port_sea.required ? ew.Validators.required(fields.port_sea.caption) : null], fields.port_sea.isInvalid],
            ["incoterm", [fields.incoterm.visible && fields.incoterm.required ? ew.Validators.required(fields.incoterm.caption) : null], fields.incoterm.isInvalid],
            ["port_air", [fields.port_air.visible && fields.port_air.required ? ew.Validators.required(fields.port_air.caption) : null], fields.port_air.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["price_percent", [fields.price_percent.visible && fields.price_percent.required ? ew.Validators.required(fields.price_percent.caption) : null, ew.Validators.float], fields.price_percent.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "category": <?= $Page->category->toClientList($Page) ?>,
            "sub_category": <?= $Page->sub_category->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "seller": <?= $Page->seller->toClientList($Page) ?>,
            "country": <?= $Page->country->toClientList($Page) ?>,
            "region": <?= $Page->region->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "port_sea": <?= $Page->port_sea->toClientList($Page) ?>,
            "incoterm": <?= $Page->incoterm->toClientList($Page) ?>,
            "port_air": <?= $Page->port_air->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbuyeradd" id="fbuyeradd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="buyer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name"<?= $Page->user_name->rowAttributes() ?>>
        <label id="elh_buyer_user_name" for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->user_name->caption() ?><?= $Page->user_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->user_name->cellAttributes() ?>>
<span id="el_buyer_user_name">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="buyer" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?> aria-describedby="x_user_name_help">
<?= $Page->user_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_password->Visible) { // password ?>
    <div id="r__password"<?= $Page->_password->rowAttributes() ?>>
        <label id="elh_buyer__password" for="x__password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_password->caption() ?><?= $Page->_password->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_password->cellAttributes() ?>>
<span id="el_buyer__password">
<input type="<?= $Page->_password->getInputTextType() ?>" name="x__password" id="x__password" data-table="buyer" data-field="x__password" value="<?= $Page->_password->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->_password->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_password->formatPattern()) ?>"<?= $Page->_password->editAttributes() ?> aria-describedby="x__password_help">
<?= $Page->_password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_buyer_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_buyer_category">
<div class="input-group flex-nowrap">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_category"
        <?php } ?>
        data-table="buyer"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "pp_category") && !$Page->category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->category->caption() ?>" data-title="<?= $Page->category->caption() ?>" data-ew-action="add-option" data-el="x_category" data-url="<?= GetUrl("ppcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_category", selectId: "fbuyeradd_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_category", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sub_category->Visible) { // sub_category ?>
    <div id="r_sub_category"<?= $Page->sub_category->rowAttributes() ?>>
        <label id="elh_buyer_sub_category" for="x_sub_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sub_category->caption() ?><?= $Page->sub_category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sub_category->cellAttributes() ?>>
<span id="el_buyer_sub_category">
<div class="input-group flex-nowrap">
    <select
        id="x_sub_category"
        name="x_sub_category"
        class="form-select ew-select<?= $Page->sub_category->isInvalidClass() ?>"
        <?php if (!$Page->sub_category->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_sub_category"
        <?php } ?>
        data-table="buyer"
        data-field="x_sub_category"
        data-value-separator="<?= $Page->sub_category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->sub_category->getPlaceHolder()) ?>"
        <?= $Page->sub_category->editAttributes() ?>>
        <?= $Page->sub_category->selectOptionListHtml("x_sub_category") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "pp_category") && !$Page->sub_category->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sub_category" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->sub_category->caption() ?>" data-title="<?= $Page->sub_category->caption() ?>" data-ew-action="add-option" data-el="x_sub_category" data-url="<?= GetUrl("ppcategoryaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->sub_category->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sub_category->getErrorMessage() ?></div>
<?= $Page->sub_category->Lookup->getParamTag($Page, "p_x_sub_category") ?>
<?php if (!$Page->sub_category->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_sub_category", selectId: "fbuyeradd_x_sub_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.sub_category?.lookupOptions.length) {
        options.data = { id: "x_sub_category", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_sub_category", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.sub_category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_buyer_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_buyer_grp">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="buyer" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="buyer"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<?= $Page->grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_buyer_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_buyer_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="buyer" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label id="elh_buyer_code" for="x_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->code->cellAttributes() ?>>
<span id="el_buyer_code">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="buyer" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->seller->Visible) { // seller ?>
    <div id="r_seller"<?= $Page->seller->rowAttributes() ?>>
        <label id="elh_buyer_seller" for="x_seller" class="<?= $Page->LeftColumnClass ?>"><?= $Page->seller->caption() ?><?= $Page->seller->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->seller->cellAttributes() ?>>
<span id="el_buyer_seller">
    <select
        id="x_seller"
        name="x_seller"
        class="form-select ew-select<?= $Page->seller->isInvalidClass() ?>"
        <?php if (!$Page->seller->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_seller"
        <?php } ?>
        data-table="buyer"
        data-field="x_seller"
        data-value-separator="<?= $Page->seller->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->seller->getPlaceHolder()) ?>"
        <?= $Page->seller->editAttributes() ?>>
        <?= $Page->seller->selectOptionListHtml("x_seller") ?>
    </select>
    <?= $Page->seller->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->seller->getErrorMessage() ?></div>
<?= $Page->seller->Lookup->getParamTag($Page, "p_x_seller") ?>
<?php if (!$Page->seller->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_seller", selectId: "fbuyeradd_x_seller" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.seller?.lookupOptions.length) {
        options.data = { id: "x_seller", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_seller", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.seller.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_buyer_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_buyer_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="buyer" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_buyer__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_buyer__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="buyer" data-field="x__email" value="<?= $Page->_email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label id="elh_buyer_country" for="x_country" class="<?= $Page->LeftColumnClass ?>"><?= $Page->country->caption() ?><?= $Page->country->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->country->cellAttributes() ?>>
<span id="el_buyer_country">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_country"
        <?php } ?>
        data-table="buyer"
        data-field="x_country"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <?= $Page->country->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_country", selectId: "fbuyeradd_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_country", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->region->Visible) { // region ?>
    <div id="r_region"<?= $Page->region->rowAttributes() ?>>
        <label id="elh_buyer_region" for="x_region" class="<?= $Page->LeftColumnClass ?>"><?= $Page->region->caption() ?><?= $Page->region->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->region->cellAttributes() ?>>
<span id="el_buyer_region">
    <select
        id="x_region"
        name="x_region"
        class="form-select ew-select<?= $Page->region->isInvalidClass() ?>"
        <?php if (!$Page->region->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_region"
        <?php } ?>
        data-table="buyer"
        data-field="x_region"
        data-value-separator="<?= $Page->region->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->region->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->region->editAttributes() ?>>
        <?= $Page->region->selectOptionListHtml("x_region") ?>
    </select>
    <?= $Page->region->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->region->getErrorMessage() ?></div>
<?= $Page->region->Lookup->getParamTag($Page, "p_x_region") ?>
<?php if (!$Page->region->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_region", selectId: "fbuyeradd_x_region" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.region?.lookupOptions.length) {
        options.data = { id: "x_region", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_region", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.region.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label id="elh_buyer_city" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city->cellAttributes() ?>>
<span id="el_buyer_city">
    <select
        id="x_city"
        name="x_city"
        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
        data-select2-id="fbuyeradd_x_city"
        data-table="buyer"
        data-field="x_city"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <?= $Page->city->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_city", selectId: "fbuyeradd_x_city" };
    if (fbuyeradd.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_city", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.buyer.fields.city.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_buyer_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_buyer_address">
<textarea data-table="buyer" data-field="x_address" name="x_address" id="x_address" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_buyer_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_buyer_location">
<?php
if (IsRTL()) {
    $Page->location->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_location" class="ew-auto-suggest">
    <input type="<?= $Page->location->getInputTextType() ?>" class="form-control" name="sv_x_location" id="sv_x_location" value="<?= RemoveHtml($Page->location->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?> aria-describedby="x_location_help">
</span>
<selection-list hidden class="form-control" data-table="buyer" data-field="x_location" data-input="sv_x_location" data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->CurrentValue) ?>"></selection-list>
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<script>
loadjs.ready("fbuyeradd", function() {
    fbuyeradd.createAutoSuggest(Object.assign({"id":"x_location","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->location->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.buyer.fields.location.autoSuggestOptions));
});
</script>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to"<?= $Page->reports_to->rowAttributes() ?>>
        <label id="elh_buyer_reports_to" for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reports_to->caption() ?><?= $Page->reports_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reports_to->cellAttributes() ?>>
<span id="el_buyer_reports_to">
    <select
        id="x_reports_to[]"
        name="x_reports_to[]"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_reports_to[]"
        <?php } ?>
        data-table="buyer"
        data-field="x_reports_to"
        multiple
        size="1"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to[]") ?>
    </select>
    <?= $Page->reports_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage() ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_reports_to[]", selectId: "fbuyeradd_x_reports_to[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to[]", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_reports_to[]", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_buyer_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_buyer_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_status"
        <?php } ?>
        data-table="buyer"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_status", selectId: "fbuyeradd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_status", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->tax_registration->Visible) { // tax_registration ?>
    <div id="r_tax_registration"<?= $Page->tax_registration->rowAttributes() ?>>
        <label id="elh_buyer_tax_registration" for="x_tax_registration" class="<?= $Page->LeftColumnClass ?>"><?= $Page->tax_registration->caption() ?><?= $Page->tax_registration->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->tax_registration->cellAttributes() ?>>
<span id="el_buyer_tax_registration">
<input type="<?= $Page->tax_registration->getInputTextType() ?>" name="x_tax_registration" id="x_tax_registration" data-table="buyer" data-field="x_tax_registration" value="<?= $Page->tax_registration->EditValue ?>" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->tax_registration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_registration->formatPattern()) ?>"<?= $Page->tax_registration->editAttributes() ?> aria-describedby="x_tax_registration_help">
<?= $Page->tax_registration->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->tax_registration->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency"<?= $Page->currency->rowAttributes() ?>>
        <label id="elh_buyer_currency" for="x_currency" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency->caption() ?><?= $Page->currency->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency->cellAttributes() ?>>
<span id="el_buyer_currency">
<div class="input-group flex-nowrap">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_currency"
        <?php } ?>
        data-table="buyer"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "currency") && !$Page->currency->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_currency" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->currency->caption() ?>" data-title="<?= $Page->currency->caption() ?>" data-ew-action="add-option" data-el="x_currency" data-url="<?= GetUrl("currencyaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->currency->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->currency->getErrorMessage() ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_currency", selectId: "fbuyeradd_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_currency", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_sea->Visible) { // port_sea ?>
    <div id="r_port_sea"<?= $Page->port_sea->rowAttributes() ?>>
        <label id="elh_buyer_port_sea" for="x_port_sea" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_sea->caption() ?><?= $Page->port_sea->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_sea->cellAttributes() ?>>
<span id="el_buyer_port_sea">
<div class="input-group flex-nowrap">
    <select
        id="x_port_sea"
        name="x_port_sea"
        class="form-select ew-select<?= $Page->port_sea->isInvalidClass() ?>"
        <?php if (!$Page->port_sea->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_port_sea"
        <?php } ?>
        data-table="buyer"
        data-field="x_port_sea"
        data-value-separator="<?= $Page->port_sea->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_sea->getPlaceHolder()) ?>"
        <?= $Page->port_sea->editAttributes() ?>>
        <?= $Page->port_sea->selectOptionListHtml("x_port_sea") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "port") && !$Page->port_sea->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_port_sea" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->port_sea->caption() ?>" data-title="<?= $Page->port_sea->caption() ?>" data-ew-action="add-option" data-el="x_port_sea" data-url="<?= GetUrl("portaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->port_sea->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_sea->getErrorMessage() ?></div>
<?= $Page->port_sea->Lookup->getParamTag($Page, "p_x_port_sea") ?>
<?php if (!$Page->port_sea->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_port_sea", selectId: "fbuyeradd_x_port_sea" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.port_sea?.lookupOptions.length) {
        options.data = { id: "x_port_sea", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_port_sea", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.port_sea.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->incoterm->Visible) { // incoterm ?>
    <div id="r_incoterm"<?= $Page->incoterm->rowAttributes() ?>>
        <label id="elh_buyer_incoterm" for="x_incoterm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->incoterm->caption() ?><?= $Page->incoterm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->incoterm->cellAttributes() ?>>
<span id="el_buyer_incoterm">
<div class="input-group flex-nowrap">
    <select
        id="x_incoterm[]"
        name="x_incoterm[]"
        class="form-select ew-select<?= $Page->incoterm->isInvalidClass() ?>"
        <?php if (!$Page->incoterm->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_incoterm[]"
        <?php } ?>
        data-table="buyer"
        data-field="x_incoterm"
        multiple
        size="1"
        data-value-separator="<?= $Page->incoterm->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->incoterm->getPlaceHolder()) ?>"
        <?= $Page->incoterm->editAttributes() ?>>
        <?= $Page->incoterm->selectOptionListHtml("x_incoterm[]") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "incoterm") && !$Page->incoterm->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_incoterm" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->incoterm->caption() ?>" data-title="<?= $Page->incoterm->caption() ?>" data-ew-action="add-option" data-el="x_incoterm[]" data-url="<?= GetUrl("incotermaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->incoterm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->incoterm->getErrorMessage() ?></div>
<?= $Page->incoterm->Lookup->getParamTag($Page, "p_x_incoterm") ?>
<?php if (!$Page->incoterm->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_incoterm[]", selectId: "fbuyeradd_x_incoterm[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.incoterm?.lookupOptions.length) {
        options.data = { id: "x_incoterm[]", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_incoterm[]", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.incoterm.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_air->Visible) { // port_air ?>
    <div id="r_port_air"<?= $Page->port_air->rowAttributes() ?>>
        <label id="elh_buyer_port_air" for="x_port_air" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_air->caption() ?><?= $Page->port_air->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_air->cellAttributes() ?>>
<span id="el_buyer_port_air">
<div class="input-group flex-nowrap">
    <select
        id="x_port_air"
        name="x_port_air"
        class="form-select ew-select<?= $Page->port_air->isInvalidClass() ?>"
        <?php if (!$Page->port_air->IsNativeSelect) { ?>
        data-select2-id="fbuyeradd_x_port_air"
        <?php } ?>
        data-table="buyer"
        data-field="x_port_air"
        data-value-separator="<?= $Page->port_air->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_air->getPlaceHolder()) ?>"
        <?= $Page->port_air->editAttributes() ?>>
        <?= $Page->port_air->selectOptionListHtml("x_port_air") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "port") && !$Page->port_air->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_port_air" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->port_air->caption() ?>" data-title="<?= $Page->port_air->caption() ?>" data-ew-action="add-option" data-el="x_port_air" data-url="<?= GetUrl("portaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->port_air->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_air->getErrorMessage() ?></div>
<?= $Page->port_air->Lookup->getParamTag($Page, "p_x_port_air") ?>
<?php if (!$Page->port_air->IsNativeSelect) { ?>
<script>
loadjs.ready("fbuyeradd", function() {
    var options = { name: "x_port_air", selectId: "fbuyeradd_x_port_air" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbuyeradd.lists.port_air?.lookupOptions.length) {
        options.data = { id: "x_port_air", form: "fbuyeradd" };
    } else {
        options.ajax = { id: "x_port_air", form: "fbuyeradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.buyer.fields.port_air.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_buyer_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_buyer_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="buyer" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price_percent->Visible) { // price_percent ?>
    <div id="r_price_percent"<?= $Page->price_percent->rowAttributes() ?>>
        <label id="elh_buyer_price_percent" for="x_price_percent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price_percent->caption() ?><?= $Page->price_percent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price_percent->cellAttributes() ?>>
<span id="el_buyer_price_percent">
<input type="<?= $Page->price_percent->getInputTextType() ?>" name="x_price_percent" id="x_price_percent" data-table="buyer" data-field="x_price_percent" value="<?= $Page->price_percent->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_percent->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_percent->formatPattern()) ?>"<?= $Page->price_percent->editAttributes() ?> aria-describedby="x_price_percent_help">
<?= $Page->price_percent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->price_percent->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbuyeradd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbuyeradd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("buyer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
