<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fbookingview" id="fbookingview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fbookingview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbookingview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_booking_id">
<span<?= $Page->id->viewAttributes() ?>>
<?php if (!EmptyString($Page->id->getViewValue()) && $Page->id->linkAttributes() != "") { ?>
<a<?= $Page->id->linkAttributes() ?>><?= $Page->id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->booking_by->Visible) { // booking_by ?>
    <tr id="r_booking_by"<?= $Page->booking_by->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_booking_by"><?= $Page->booking_by->caption() ?></span></td>
        <td data-name="booking_by"<?= $Page->booking_by->cellAttributes() ?>>
<span id="el_booking_booking_by">
<span<?= $Page->booking_by->viewAttributes() ?>>
<?= $Page->booking_by->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <tr id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_company_id"><?= $Page->company_id->caption() ?></span></td>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el_booking_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <tr id="r_supplier"<?= $Page->supplier->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_supplier"><?= $Page->supplier->caption() ?></span></td>
        <td data-name="supplier"<?= $Page->supplier->cellAttributes() ?>>
<span id="el_booking_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?= $Page->supplier->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <tr id="r_ref"<?= $Page->ref->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_ref"><?= $Page->ref->caption() ?></span></td>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el_booking_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <tr id="r_status"<?= $Page->status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_status"><?= $Page->status->caption() ?></span></td>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el_booking_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <tr id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_s_grp"><?= $Page->s_grp->caption() ?></span></td>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_booking_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <tr id="r_product"<?= $Page->product->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_product"><?= $Page->product->caption() ?></span></td>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el_booking_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <tr id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_rid"><?= $Page->rid->caption() ?></span></td>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el_booking_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->getViewValue()) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><?= $Page->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <tr id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_quantity"><?= $Page->quantity->caption() ?></span></td>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el_booking_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_quantity->Visible) { // b_quantity ?>
    <tr id="r_b_quantity"<?= $Page->b_quantity->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_b_quantity"><?= $Page->b_quantity->caption() ?></span></td>
        <td data-name="b_quantity"<?= $Page->b_quantity->cellAttributes() ?>>
<span id="el_booking_b_quantity">
<span<?= $Page->b_quantity->viewAttributes() ?>>
<?= $Page->b_quantity->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->containers->Visible) { // containers ?>
    <tr id="r_containers"<?= $Page->containers->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_containers"><?= $Page->containers->caption() ?></span></td>
        <td data-name="containers"<?= $Page->containers->cellAttributes() ?>>
<span id="el_booking_containers">
<span<?= $Page->containers->viewAttributes() ?>>
<?= $Page->containers->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->booking_rate->Visible) { // booking_rate ?>
    <tr id="r_booking_rate"<?= $Page->booking_rate->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_booking_rate"><?= $Page->booking_rate->caption() ?></span></td>
        <td data-name="booking_rate"<?= $Page->booking_rate->cellAttributes() ?>>
<span id="el_booking_booking_rate">
<span<?= $Page->booking_rate->viewAttributes() ?>>
<?= $Page->booking_rate->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->booking_currency->Visible) { // booking_currency ?>
    <tr id="r_booking_currency"<?= $Page->booking_currency->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_booking_currency"><?= $Page->booking_currency->caption() ?></span></td>
        <td data-name="booking_currency"<?= $Page->booking_currency->cellAttributes() ?>>
<span id="el_booking_booking_currency">
<span<?= $Page->booking_currency->viewAttributes() ?>>
<?= $Page->booking_currency->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->currency_current_rate->Visible) { // currency_current_rate ?>
    <tr id="r_currency_current_rate"<?= $Page->currency_current_rate->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_currency_current_rate"><?= $Page->currency_current_rate->caption() ?></span></td>
        <td data-name="currency_current_rate"<?= $Page->currency_current_rate->cellAttributes() ?>>
<span id="el_booking_currency_current_rate">
<span<?= $Page->currency_current_rate->viewAttributes() ?>>
<?= $Page->currency_current_rate->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->booking_date->Visible) { // booking_date ?>
    <tr id="r_booking_date"<?= $Page->booking_date->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_booking_date"><?= $Page->booking_date->caption() ?></span></td>
        <td data-name="booking_date"<?= $Page->booking_date->cellAttributes() ?>>
<span id="el_booking_booking_date">
<span<?= $Page->booking_date->viewAttributes() ?>>
<?= $Page->booking_date->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->shipment_date->Visible) { // shipment_date ?>
    <tr id="r_shipment_date"<?= $Page->shipment_date->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_shipment_date"><?= $Page->shipment_date->caption() ?></span></td>
        <td data-name="shipment_date"<?= $Page->shipment_date->cellAttributes() ?>>
<span id="el_booking_shipment_date">
<span<?= $Page->shipment_date->viewAttributes() ?>>
<?= $Page->shipment_date->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->our_port->Visible) { // our_port ?>
    <tr id="r_our_port"<?= $Page->our_port->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_our_port"><?= $Page->our_port->caption() ?></span></td>
        <td data-name="our_port"<?= $Page->our_port->cellAttributes() ?>>
<span id="el_booking_our_port">
<span<?= $Page->our_port->viewAttributes() ?>>
<?= $Page->our_port->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <tr id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_remarks"><?= $Page->remarks->caption() ?></span></td>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el_booking_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_booking_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_booking_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->base_entry->Visible) { // base_entry ?>
    <tr id="r_base_entry"<?= $Page->base_entry->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_booking_base_entry"><?= $Page->base_entry->caption() ?></span></td>
        <td data-name="base_entry"<?= $Page->base_entry->cellAttributes() ?>>
<span id="el_booking_base_entry">
<span<?= $Page->base_entry->viewAttributes() ?>>
<?= $Page->base_entry->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
