<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbookingsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbookingsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["booking_by", [ew.Validators.integer], fields.booking_by.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["supplier", [], fields.supplier.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["agent", [], fields.agent.isInvalid],
            ["b_quantity", [ew.Validators.float], fields.b_quantity.isInvalid],
            ["confirm_quantity", [ew.Validators.float], fields.confirm_quantity.isInvalid],
            ["booking_rate", [ew.Validators.float], fields.booking_rate.isInvalid],
            ["y_booking_rate", [ew.Validators.between], false],
            ["booking_currency", [], fields.booking_currency.isInvalid],
            ["currency_current_rate", [ew.Validators.float], fields.currency_current_rate.isInvalid],
            ["y_currency_current_rate", [ew.Validators.between], false],
            ["booking_date", [ew.Validators.datetime(fields.booking_date.clientFormatPattern)], fields.booking_date.isInvalid],
            ["y_booking_date", [ew.Validators.between], false],
            ["shipment_date", [ew.Validators.datetime(fields.shipment_date.clientFormatPattern)], fields.shipment_date.isInvalid],
            ["y_shipment_date", [ew.Validators.between], false],
            ["our_port", [], fields.our_port.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
            "booking_currency": <?= $Page->booking_currency->toClientList($Page) ?>,
            "our_port": <?= $Page->our_port->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbookingsearch" id="fbookingsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="booking" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_by->Visible) { // booking_by ?>
    <div id="r_booking_by" class="row"<?= $Page->booking_by->rowAttributes() ?>>
        <label for="x_booking_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_booking_by"><?= $Page->booking_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_by" id="z_booking_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_booking_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->booking_by->getInputTextType() ?>" name="x_booking_by" id="x_booking_by" data-table="booking" data-field="x_booking_by" value="<?= $Page->booking_by->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_by->formatPattern()) ?>"<?= $Page->booking_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_company_id"
        <?php } ?>
        data-table="booking"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_company_id", selectId: "fbookingsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier" class="row"<?= $Page->supplier->rowAttributes() ?>>
        <label for="x_supplier" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_supplier"><?= $Page->supplier->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->supplier->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_supplier" class="ew-search-field ew-search-field-single">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_supplier"
        <?php } ?>
        data-table="booking"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_supplier", selectId: "fbookingsearch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_status"
        <?php } ?>
        data-table="booking"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_status", selectId: "fbookingsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_s_grp"
        <?php } ?>
        data-table="booking"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_s_grp", selectId: "fbookingsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_product"
        <?php } ?>
        data-table="booking"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_product", selectId: "fbookingsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
    <div id="r_agent" class="row"<?= $Page->agent->rowAttributes() ?>>
        <label for="x_agent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_agent"><?= $Page->agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_agent" id="z_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_agent"
        name="x_agent"
        class="form-select ew-select<?= $Page->agent->isInvalidClass() ?>"
        <?php if (!$Page->agent->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_agent"
        <?php } ?>
        data-table="booking"
        data-field="x_agent"
        data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
        <?= $Page->agent->editAttributes() ?>>
        <?= $Page->agent->selectOptionListHtml("x_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
<?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
<?php if (!$Page->agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_agent", selectId: "fbookingsearch_x_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.agent?.lookupOptions.length) {
        options.data = { id: "x_agent", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_agent", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_quantity->Visible) { // b_quantity ?>
    <div id="r_b_quantity" class="row"<?= $Page->b_quantity->rowAttributes() ?>>
        <label for="x_b_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_b_quantity"><?= $Page->b_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_quantity" id="z_b_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_b_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_quantity->getInputTextType() ?>" name="x_b_quantity" id="x_b_quantity" data-table="booking" data-field="x_b_quantity" value="<?= $Page->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_quantity->formatPattern()) ?>"<?= $Page->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_quantity->Visible) { // confirm_quantity ?>
    <div id="r_confirm_quantity" class="row"<?= $Page->confirm_quantity->rowAttributes() ?>>
        <label for="x_confirm_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_confirm_quantity"><?= $Page->confirm_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_quantity" id="z_confirm_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_confirm_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_quantity->getInputTextType() ?>" name="x_confirm_quantity" id="x_confirm_quantity" data-table="booking" data-field="x_confirm_quantity" value="<?= $Page->confirm_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->confirm_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_quantity->formatPattern()) ?>"<?= $Page->confirm_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_rate->Visible) { // booking_rate ?>
    <div id="r_booking_rate" class="row"<?= $Page->booking_rate->rowAttributes() ?>>
        <label for="x_booking_rate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_booking_rate"><?= $Page->booking_rate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_rate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_booking_rate" id="z_booking_rate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->booking_rate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->booking_rate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_booking_rate" class="ew-search-field">
<input type="<?= $Page->booking_rate->getInputTextType() ?>" name="x_booking_rate" id="x_booking_rate" data-table="booking" data-field="x_booking_rate" value="<?= $Page->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_rate->formatPattern()) ?>"<?= $Page->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_rate->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_booking_rate" class="ew-search-field2 d-none">
<input type="<?= $Page->booking_rate->getInputTextType() ?>" name="y_booking_rate" id="y_booking_rate" data-table="booking" data-field="x_booking_rate" value="<?= $Page->booking_rate->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_rate->formatPattern()) ?>"<?= $Page->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_rate->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_currency->Visible) { // booking_currency ?>
    <div id="r_booking_currency" class="row"<?= $Page->booking_currency->rowAttributes() ?>>
        <label for="x_booking_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_booking_currency"><?= $Page->booking_currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_currency" id="z_booking_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_booking_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_currency"
        name="x_booking_currency"
        class="form-select ew-select<?= $Page->booking_currency->isInvalidClass() ?>"
        <?php if (!$Page->booking_currency->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_booking_currency"
        <?php } ?>
        data-table="booking"
        data-field="x_booking_currency"
        data-value-separator="<?= $Page->booking_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_currency->getPlaceHolder()) ?>"
        <?= $Page->booking_currency->editAttributes() ?>>
        <?= $Page->booking_currency->selectOptionListHtml("x_booking_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_currency->getErrorMessage(false) ?></div>
<?= $Page->booking_currency->Lookup->getParamTag($Page, "p_x_booking_currency") ?>
<?php if (!$Page->booking_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_booking_currency", selectId: "fbookingsearch_x_booking_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.booking_currency?.lookupOptions.length) {
        options.data = { id: "x_booking_currency", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_booking_currency", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.booking_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency_current_rate->Visible) { // currency_current_rate ?>
    <div id="r_currency_current_rate" class="row"<?= $Page->currency_current_rate->rowAttributes() ?>>
        <label for="x_currency_current_rate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_currency_current_rate"><?= $Page->currency_current_rate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency_current_rate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_currency_current_rate" id="z_currency_current_rate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->currency_current_rate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->currency_current_rate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_currency_current_rate" class="ew-search-field">
<input type="<?= $Page->currency_current_rate->getInputTextType() ?>" name="x_currency_current_rate" id="x_currency_current_rate" data-table="booking" data-field="x_currency_current_rate" value="<?= $Page->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_current_rate->formatPattern()) ?>"<?= $Page->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->currency_current_rate->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_currency_current_rate" class="ew-search-field2 d-none">
<input type="<?= $Page->currency_current_rate->getInputTextType() ?>" name="y_currency_current_rate" id="y_currency_current_rate" data-table="booking" data-field="x_currency_current_rate" value="<?= $Page->currency_current_rate->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_current_rate->formatPattern()) ?>"<?= $Page->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->currency_current_rate->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_date->Visible) { // booking_date ?>
    <div id="r_booking_date" class="row"<?= $Page->booking_date->rowAttributes() ?>>
        <label for="x_booking_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_booking_date"><?= $Page->booking_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_booking_date" id="z_booking_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->booking_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->booking_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_booking_date" class="ew-search-field">
<input type="<?= $Page->booking_date->getInputTextType() ?>" name="x_booking_date" id="x_booking_date" data-table="booking" data-field="x_booking_date" value="<?= $Page->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_date->formatPattern()) ?>"<?= $Page->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_date->getErrorMessage(false) ?></div>
<?php if (!$Page->booking_date->ReadOnly && !$Page->booking_date->Disabled && !isset($Page->booking_date->EditAttrs["readonly"]) && !isset($Page->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookingsearch", "x_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_booking_date" class="ew-search-field2 d-none">
<input type="<?= $Page->booking_date->getInputTextType() ?>" name="y_booking_date" id="y_booking_date" data-table="booking" data-field="x_booking_date" value="<?= $Page->booking_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_date->formatPattern()) ?>"<?= $Page->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_date->getErrorMessage(false) ?></div>
<?php if (!$Page->booking_date->ReadOnly && !$Page->booking_date->Disabled && !isset($Page->booking_date->EditAttrs["readonly"]) && !isset($Page->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookingsearch", "y_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipment_date->Visible) { // shipment_date ?>
    <div id="r_shipment_date" class="row"<?= $Page->shipment_date->rowAttributes() ?>>
        <label for="x_shipment_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_shipment_date"><?= $Page->shipment_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipment_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_shipment_date" id="z_shipment_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->shipment_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->shipment_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_shipment_date" class="ew-search-field">
<input type="<?= $Page->shipment_date->getInputTextType() ?>" name="x_shipment_date" id="x_shipment_date" data-table="booking" data-field="x_shipment_date" value="<?= $Page->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipment_date->formatPattern()) ?>"<?= $Page->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipment_date->getErrorMessage(false) ?></div>
<?php if (!$Page->shipment_date->ReadOnly && !$Page->shipment_date->Disabled && !isset($Page->shipment_date->EditAttrs["readonly"]) && !isset($Page->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookingsearch", "x_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_shipment_date" class="ew-search-field2 d-none">
<input type="<?= $Page->shipment_date->getInputTextType() ?>" name="y_shipment_date" id="y_shipment_date" data-table="booking" data-field="x_shipment_date" value="<?= $Page->shipment_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipment_date->formatPattern()) ?>"<?= $Page->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipment_date->getErrorMessage(false) ?></div>
<?php if (!$Page->shipment_date->ReadOnly && !$Page->shipment_date->Disabled && !isset($Page->shipment_date->EditAttrs["readonly"]) && !isset($Page->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbookingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbookingsearch", "y_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->our_port->Visible) { // our_port ?>
    <div id="r_our_port" class="row"<?= $Page->our_port->rowAttributes() ?>>
        <label for="x_our_port" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_our_port"><?= $Page->our_port->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_our_port" id="z_our_port" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->our_port->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_our_port" class="ew-search-field ew-search-field-single">
    <select
        id="x_our_port"
        name="x_our_port"
        class="form-select ew-select<?= $Page->our_port->isInvalidClass() ?>"
        <?php if (!$Page->our_port->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_our_port"
        <?php } ?>
        data-table="booking"
        data-field="x_our_port"
        data-value-separator="<?= $Page->our_port->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->our_port->getPlaceHolder()) ?>"
        <?= $Page->our_port->editAttributes() ?>>
        <?= $Page->our_port->selectOptionListHtml("x_our_port") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->our_port->getErrorMessage(false) ?></div>
<?= $Page->our_port->Lookup->getParamTag($Page, "p_x_our_port") ?>
<?php if (!$Page->our_port->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_our_port", selectId: "fbookingsearch_x_our_port" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.our_port?.lookupOptions.length) {
        options.data = { id: "x_our_port", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_our_port", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.our_port.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="booking" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbookingsearch_x_operator"
        <?php } ?>
        data-table="booking"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsearch", function() {
    var options = { name: "x_operator", selectId: "fbookingsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbookingsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbookingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="booking" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbookingsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbookingsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbookingsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
