<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingRefSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fbooking_refsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbooking_refsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["supplier_id", [], fields.supplier_id.isInvalid],
            ["ref", [], fields.ref.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["b_quantity", [ew.Validators.float], fields.b_quantity.isInvalid],
            ["confirm_quantity", [ew.Validators.float], fields.confirm_quantity.isInvalid],
            ["confirm_pending", [ew.Validators.float], fields.confirm_pending.isInvalid],
            ["booking_date", [ew.Validators.datetime(fields.booking_date.clientFormatPattern)], fields.booking_date.isInvalid],
            ["y_booking_date", [ew.Validators.between], false],
            ["booking_rate", [ew.Validators.float], fields.booking_rate.isInvalid],
            ["y_booking_rate", [ew.Validators.between], false],
            ["booking_currency", [], fields.booking_currency.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["confirm_port_eta", [], fields.confirm_port_eta.isInvalid],
            ["reference", [], fields.reference.isInvalid],
            ["currency_current_rate", [ew.Validators.float], fields.currency_current_rate.isInvalid],
            ["y_currency_current_rate", [ew.Validators.between], false],
            ["shipment_date", [ew.Validators.datetime(fields.shipment_date.clientFormatPattern)], fields.shipment_date.isInvalid],
            ["y_shipment_date", [ew.Validators.between], false],
            ["our_port", [], fields.our_port.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["confirm_type", [ew.Validators.integer], fields.confirm_type.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier_id": <?= $Page->supplier_id->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "booking_currency": <?= $Page->booking_currency->toClientList($Page) ?>,
            "our_port": <?= $Page->our_port->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fbooking_refsearch" id="fbooking_refsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking_ref">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="booking_ref" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
    <div id="r_ref" class="row"<?= $Page->ref->rowAttributes() ?>>
        <label for="x_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_ref"><?= $Page->ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ref" id="z_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ref->getInputTextType() ?>" name="x_ref" id="x_ref" data-table="booking_ref" data-field="x_ref" value="<?= $Page->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ref->formatPattern()) ?>"<?= $Page->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbooking_refsearch_x_status"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refsearch", function() {
    var options = { name: "x_status", selectId: "fbooking_refsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbooking_refsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fbooking_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_ref" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_refsearch", function() {
    fbooking_refsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_ref.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_quantity->Visible) { // b_quantity ?>
    <div id="r_b_quantity" class="row"<?= $Page->b_quantity->rowAttributes() ?>>
        <label for="x_b_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_b_quantity"><?= $Page->b_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_b_quantity" id="z_b_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_b_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_quantity->getInputTextType() ?>" name="x_b_quantity" id="x_b_quantity" data-table="booking_ref" data-field="x_b_quantity" value="<?= $Page->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_quantity->formatPattern()) ?>"<?= $Page->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_quantity->Visible) { // confirm_quantity ?>
    <div id="r_confirm_quantity" class="row"<?= $Page->confirm_quantity->rowAttributes() ?>>
        <label for="x_confirm_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_quantity"><?= $Page->confirm_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_quantity" id="z_confirm_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_confirm_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_quantity->getInputTextType() ?>" name="x_confirm_quantity" id="x_confirm_quantity" data-table="booking_ref" data-field="x_confirm_quantity" value="<?= $Page->confirm_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->confirm_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_quantity->formatPattern()) ?>"<?= $Page->confirm_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_pending->Visible) { // confirm_pending ?>
    <div id="r_confirm_pending" class="row"<?= $Page->confirm_pending->rowAttributes() ?>>
        <label for="x_confirm_pending" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_pending"><?= $Page->confirm_pending->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_pending" id="z_confirm_pending" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_pending->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_confirm_pending" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_pending->getInputTextType() ?>" name="x_confirm_pending" id="x_confirm_pending" data-table="booking_ref" data-field="x_confirm_pending" value="<?= $Page->confirm_pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->confirm_pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_pending->formatPattern()) ?>"<?= $Page->confirm_pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_pending->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_date->Visible) { // booking_date ?>
    <div id="r_booking_date" class="row"<?= $Page->booking_date->rowAttributes() ?>>
        <label for="x_booking_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_booking_date"><?= $Page->booking_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_booking_date" id="z_booking_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->booking_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->booking_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_ref_booking_date" class="ew-search-field">
<input type="<?= $Page->booking_date->getInputTextType() ?>" name="x_booking_date" id="x_booking_date" data-table="booking_ref" data-field="x_booking_date" value="<?= $Page->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_date->formatPattern()) ?>"<?= $Page->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_date->getErrorMessage(false) ?></div>
<?php if (!$Page->booking_date->ReadOnly && !$Page->booking_date->Disabled && !isset($Page->booking_date->EditAttrs["readonly"]) && !isset($Page->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refsearch", "x_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_ref_booking_date" class="ew-search-field2 d-none">
<input type="<?= $Page->booking_date->getInputTextType() ?>" name="y_booking_date" id="y_booking_date" data-table="booking_ref" data-field="x_booking_date" value="<?= $Page->booking_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_date->formatPattern()) ?>"<?= $Page->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_date->getErrorMessage(false) ?></div>
<?php if (!$Page->booking_date->ReadOnly && !$Page->booking_date->Disabled && !isset($Page->booking_date->EditAttrs["readonly"]) && !isset($Page->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refsearch", "y_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_rate->Visible) { // booking_rate ?>
    <div id="r_booking_rate" class="row"<?= $Page->booking_rate->rowAttributes() ?>>
        <label for="x_booking_rate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_booking_rate"><?= $Page->booking_rate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_rate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_booking_rate" id="z_booking_rate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->booking_rate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->booking_rate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_ref_booking_rate" class="ew-search-field">
<input type="<?= $Page->booking_rate->getInputTextType() ?>" name="x_booking_rate" id="x_booking_rate" data-table="booking_ref" data-field="x_booking_rate" value="<?= $Page->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_rate->formatPattern()) ?>"<?= $Page->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_rate->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_ref_booking_rate" class="ew-search-field2 d-none">
<input type="<?= $Page->booking_rate->getInputTextType() ?>" name="y_booking_rate" id="y_booking_rate" data-table="booking_ref" data-field="x_booking_rate" value="<?= $Page->booking_rate->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_rate->formatPattern()) ?>"<?= $Page->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->booking_rate->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_currency->Visible) { // booking_currency ?>
    <div id="r_booking_currency" class="row"<?= $Page->booking_currency->rowAttributes() ?>>
        <label for="x_booking_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_booking_currency"><?= $Page->booking_currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_currency" id="z_booking_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_booking_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_currency"
        name="x_booking_currency"
        class="form-select ew-select<?= $Page->booking_currency->isInvalidClass() ?>"
        <?php if (!$Page->booking_currency->IsNativeSelect) { ?>
        data-select2-id="fbooking_refsearch_x_booking_currency"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_booking_currency"
        data-value-separator="<?= $Page->booking_currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_currency->getPlaceHolder()) ?>"
        <?= $Page->booking_currency->editAttributes() ?>>
        <?= $Page->booking_currency->selectOptionListHtml("x_booking_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_currency->getErrorMessage(false) ?></div>
<?= $Page->booking_currency->Lookup->getParamTag($Page, "p_x_booking_currency") ?>
<?php if (!$Page->booking_currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refsearch", function() {
    var options = { name: "x_booking_currency", selectId: "fbooking_refsearch_x_booking_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refsearch.lists.booking_currency?.lookupOptions.length) {
        options.data = { id: "x_booking_currency", form: "fbooking_refsearch" };
    } else {
        options.ajax = { id: "x_booking_currency", form: "fbooking_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.booking_currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="booking_ref" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_currency" id="z_currency" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_currency" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->currency->getInputTextType() ?>" name="x_currency" id="x_currency" data-table="booking_ref" data-field="x_currency" value="<?= $Page->currency->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency->formatPattern()) ?>"<?= $Page->currency->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_port_eta->Visible) { // confirm_port_eta ?>
    <div id="r_confirm_port_eta" class="row"<?= $Page->confirm_port_eta->rowAttributes() ?>>
        <label for="x_confirm_port_eta" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_port_eta"><?= $Page->confirm_port_eta->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_confirm_port_eta" id="z_confirm_port_eta" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_port_eta->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_confirm_port_eta" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_port_eta->getInputTextType() ?>" name="x_confirm_port_eta" id="x_confirm_port_eta" data-table="booking_ref" data-field="x_confirm_port_eta" value="<?= $Page->confirm_port_eta->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->confirm_port_eta->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_port_eta->formatPattern()) ?>"<?= $Page->confirm_port_eta->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_port_eta->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference" class="row"<?= $Page->reference->rowAttributes() ?>>
        <label for="x_reference" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_reference"><?= $Page->reference->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reference" id="z_reference" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_reference" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="booking_ref" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency_current_rate->Visible) { // currency_current_rate ?>
    <div id="r_currency_current_rate" class="row"<?= $Page->currency_current_rate->rowAttributes() ?>>
        <label for="x_currency_current_rate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_currency_current_rate"><?= $Page->currency_current_rate->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency_current_rate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_currency_current_rate" id="z_currency_current_rate" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->currency_current_rate->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->currency_current_rate->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_ref_currency_current_rate" class="ew-search-field">
<input type="<?= $Page->currency_current_rate->getInputTextType() ?>" name="x_currency_current_rate" id="x_currency_current_rate" data-table="booking_ref" data-field="x_currency_current_rate" value="<?= $Page->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_current_rate->formatPattern()) ?>"<?= $Page->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->currency_current_rate->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_ref_currency_current_rate" class="ew-search-field2 d-none">
<input type="<?= $Page->currency_current_rate->getInputTextType() ?>" name="y_currency_current_rate" id="y_currency_current_rate" data-table="booking_ref" data-field="x_currency_current_rate" value="<?= $Page->currency_current_rate->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_current_rate->formatPattern()) ?>"<?= $Page->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->currency_current_rate->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipment_date->Visible) { // shipment_date ?>
    <div id="r_shipment_date" class="row"<?= $Page->shipment_date->rowAttributes() ?>>
        <label for="x_shipment_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_shipment_date"><?= $Page->shipment_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipment_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_shipment_date" id="z_shipment_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->shipment_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->shipment_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_booking_ref_shipment_date" class="ew-search-field">
<input type="<?= $Page->shipment_date->getInputTextType() ?>" name="x_shipment_date" id="x_shipment_date" data-table="booking_ref" data-field="x_shipment_date" value="<?= $Page->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipment_date->formatPattern()) ?>"<?= $Page->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipment_date->getErrorMessage(false) ?></div>
<?php if (!$Page->shipment_date->ReadOnly && !$Page->shipment_date->Disabled && !isset($Page->shipment_date->EditAttrs["readonly"]) && !isset($Page->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refsearch", "x_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_booking_ref_shipment_date" class="ew-search-field2 d-none">
<input type="<?= $Page->shipment_date->getInputTextType() ?>" name="y_shipment_date" id="y_shipment_date" data-table="booking_ref" data-field="x_shipment_date" value="<?= $Page->shipment_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipment_date->formatPattern()) ?>"<?= $Page->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipment_date->getErrorMessage(false) ?></div>
<?php if (!$Page->shipment_date->ReadOnly && !$Page->shipment_date->Disabled && !isset($Page->shipment_date->EditAttrs["readonly"]) && !isset($Page->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refsearch", "y_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->our_port->Visible) { // our_port ?>
    <div id="r_our_port" class="row"<?= $Page->our_port->rowAttributes() ?>>
        <label for="x_our_port" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_our_port"><?= $Page->our_port->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_our_port" id="z_our_port" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->our_port->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_our_port" class="ew-search-field ew-search-field-single">
    <select
        id="x_our_port"
        name="x_our_port"
        class="form-select ew-select<?= $Page->our_port->isInvalidClass() ?>"
        <?php if (!$Page->our_port->IsNativeSelect) { ?>
        data-select2-id="fbooking_refsearch_x_our_port"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_our_port"
        data-value-separator="<?= $Page->our_port->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->our_port->getPlaceHolder()) ?>"
        <?= $Page->our_port->editAttributes() ?>>
        <?= $Page->our_port->selectOptionListHtml("x_our_port") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->our_port->getErrorMessage(false) ?></div>
<?= $Page->our_port->Lookup->getParamTag($Page, "p_x_our_port") ?>
<?php if (!$Page->our_port->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refsearch", function() {
    var options = { name: "x_our_port", selectId: "fbooking_refsearch_x_our_port" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refsearch.lists.our_port?.lookupOptions.length) {
        options.data = { id: "x_our_port", form: "fbooking_refsearch" };
    } else {
        options.ajax = { id: "x_our_port", form: "fbooking_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.our_port.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="booking_ref" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fbooking_refsearch_x_operator"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refsearch", function() {
    var options = { name: "x_operator", selectId: "fbooking_refsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fbooking_refsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fbooking_refsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="booking_ref" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="booking_ref" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->confirm_type->Visible) { // confirm_type ?>
    <div id="r_confirm_type" class="row"<?= $Page->confirm_type->rowAttributes() ?>>
        <label for="x_confirm_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_confirm_type"><?= $Page->confirm_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_confirm_type" id="z_confirm_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->confirm_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_confirm_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->confirm_type->getInputTextType() ?>" name="x_confirm_type" id="x_confirm_type" data-table="booking_ref" data-field="x_confirm_type" value="<?= $Page->confirm_type->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Page->confirm_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->confirm_type->formatPattern()) ?>"<?= $Page->confirm_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->confirm_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_booking_ref_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_booking_ref_company_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_company_id" class="ew-auto-suggest">
    <input type="<?= $Page->company_id->getInputTextType() ?>" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?= RemoveHtml($Page->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_ref" data-field="x_company_id" data-input="sv_x_company_id" data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fbooking_refsearch", function() {
    fbooking_refsearch.createAutoSuggest(Object.assign({"id":"x_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_ref.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fbooking_refsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fbooking_refsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fbooking_refsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
