<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("BookingRefGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fbooking_refgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { booking_ref: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fbooking_refgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["supplier_id", [fields.supplier_id.visible && fields.supplier_id.required ? ew.Validators.required(fields.supplier_id.caption) : null], fields.supplier_id.isInvalid],
            ["ref", [fields.ref.visible && fields.ref.required ? ew.Validators.required(fields.ref.caption) : null], fields.ref.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null, ew.Validators.integer], fields.rid.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["b_quantity", [fields.b_quantity.visible && fields.b_quantity.required ? ew.Validators.required(fields.b_quantity.caption) : null, ew.Validators.float], fields.b_quantity.isInvalid],
            ["confirm_pending", [fields.confirm_pending.visible && fields.confirm_pending.required ? ew.Validators.required(fields.confirm_pending.caption) : null, ew.Validators.float], fields.confirm_pending.isInvalid],
            ["booking_date", [fields.booking_date.visible && fields.booking_date.required ? ew.Validators.required(fields.booking_date.caption) : null, ew.Validators.datetime(fields.booking_date.clientFormatPattern)], fields.booking_date.isInvalid],
            ["booking_rate", [fields.booking_rate.visible && fields.booking_rate.required ? ew.Validators.required(fields.booking_rate.caption) : null, ew.Validators.float], fields.booking_rate.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["currency", [fields.currency.visible && fields.currency.required ? ew.Validators.required(fields.currency.caption) : null], fields.currency.isInvalid],
            ["confirm_port_eta", [fields.confirm_port_eta.visible && fields.confirm_port_eta.required ? ew.Validators.required(fields.confirm_port_eta.caption) : null], fields.confirm_port_eta.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["currency_current_rate", [fields.currency_current_rate.visible && fields.currency_current_rate.required ? ew.Validators.required(fields.currency_current_rate.caption) : null, ew.Validators.float], fields.currency_current_rate.isInvalid],
            ["shipment_date", [fields.shipment_date.visible && fields.shipment_date.required ? ew.Validators.required(fields.shipment_date.caption) : null, ew.Validators.datetime(fields.shipment_date.clientFormatPattern)], fields.shipment_date.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.integer], fields.packets.isInvalid],
            ["confirm_type", [fields.confirm_type.visible && fields.confirm_type.required ? ew.Validators.required(fields.confirm_type.caption) : null, ew.Validators.integer], fields.confirm_type.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["id",false],["supplier_id",false],["ref",false],["status",false],["rid",false],["quantity",false],["b_quantity",false],["confirm_pending",false],["booking_date",false],["booking_rate",false],["amount",false],["currency",false],["confirm_port_eta",false],["reference",false],["currency_current_rate",false],["shipment_date",false],["remarks",false],["packets",false],["confirm_type",false],["company_id",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier_id": <?= $Grid->supplier_id->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "rid": <?= $Grid->rid->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
            "company_id": <?= $Grid->company_id->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fbooking_refgrid" class="ew-form ew-list-form">
<div id="gmp_booking_ref" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_booking_refgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_booking_ref_id" class="booking_ref_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->supplier_id->Visible) { // supplier_id ?>
        <th data-name="supplier_id" class="<?= $Grid->supplier_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_booking_ref_supplier_id" class="booking_ref_supplier_id"><?= $Grid->renderFieldHeader($Grid->supplier_id) ?></div></th>
<?php } ?>
<?php if ($Grid->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Grid->ref->headerCellClass() ?>"><div id="elh_booking_ref_ref" class="booking_ref_ref"><?= $Grid->renderFieldHeader($Grid->ref) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_booking_ref_status" class="booking_ref_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Grid->rid->headerCellClass() ?>"><div id="elh_booking_ref_rid" class="booking_ref_rid"><?= $Grid->renderFieldHeader($Grid->rid) ?></div></th>
<?php } ?>
<?php if ($Grid->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Grid->quantity->headerCellClass() ?>"><div id="elh_booking_ref_quantity" class="booking_ref_quantity"><?= $Grid->renderFieldHeader($Grid->quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->b_quantity->Visible) { // b_quantity ?>
        <th data-name="b_quantity" class="<?= $Grid->b_quantity->headerCellClass() ?>"><div id="elh_booking_ref_b_quantity" class="booking_ref_b_quantity"><?= $Grid->renderFieldHeader($Grid->b_quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->confirm_pending->Visible) { // confirm_pending ?>
        <th data-name="confirm_pending" class="<?= $Grid->confirm_pending->headerCellClass() ?>"><div id="elh_booking_ref_confirm_pending" class="booking_ref_confirm_pending"><?= $Grid->renderFieldHeader($Grid->confirm_pending) ?></div></th>
<?php } ?>
<?php if ($Grid->booking_date->Visible) { // booking_date ?>
        <th data-name="booking_date" class="<?= $Grid->booking_date->headerCellClass() ?>"><div id="elh_booking_ref_booking_date" class="booking_ref_booking_date"><?= $Grid->renderFieldHeader($Grid->booking_date) ?></div></th>
<?php } ?>
<?php if ($Grid->booking_rate->Visible) { // booking_rate ?>
        <th data-name="booking_rate" class="<?= $Grid->booking_rate->headerCellClass() ?>"><div id="elh_booking_ref_booking_rate" class="booking_ref_booking_rate"><?= $Grid->renderFieldHeader($Grid->booking_rate) ?></div></th>
<?php } ?>
<?php if ($Grid->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Grid->amount->headerCellClass() ?>"><div id="elh_booking_ref_amount" class="booking_ref_amount"><?= $Grid->renderFieldHeader($Grid->amount) ?></div></th>
<?php } ?>
<?php if ($Grid->currency->Visible) { // currency ?>
        <th data-name="currency" class="<?= $Grid->currency->headerCellClass() ?>"><div id="elh_booking_ref_currency" class="booking_ref_currency"><?= $Grid->renderFieldHeader($Grid->currency) ?></div></th>
<?php } ?>
<?php if ($Grid->confirm_port_eta->Visible) { // confirm_port_eta ?>
        <th data-name="confirm_port_eta" class="<?= $Grid->confirm_port_eta->headerCellClass() ?>"><div id="elh_booking_ref_confirm_port_eta" class="booking_ref_confirm_port_eta"><?= $Grid->renderFieldHeader($Grid->confirm_port_eta) ?></div></th>
<?php } ?>
<?php if ($Grid->reference->Visible) { // reference ?>
        <th data-name="reference" class="<?= $Grid->reference->headerCellClass() ?>"><div id="elh_booking_ref_reference" class="booking_ref_reference"><?= $Grid->renderFieldHeader($Grid->reference) ?></div></th>
<?php } ?>
<?php if ($Grid->currency_current_rate->Visible) { // currency_current_rate ?>
        <th data-name="currency_current_rate" class="<?= $Grid->currency_current_rate->headerCellClass() ?>"><div id="elh_booking_ref_currency_current_rate" class="booking_ref_currency_current_rate"><?= $Grid->renderFieldHeader($Grid->currency_current_rate) ?></div></th>
<?php } ?>
<?php if ($Grid->shipment_date->Visible) { // shipment_date ?>
        <th data-name="shipment_date" class="<?= $Grid->shipment_date->headerCellClass() ?>"><div id="elh_booking_ref_shipment_date" class="booking_ref_shipment_date"><?= $Grid->renderFieldHeader($Grid->shipment_date) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_booking_ref_remarks" class="booking_ref_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_booking_ref_operator" class="booking_ref_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_booking_ref_datetime" class="booking_ref_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php if ($Grid->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Grid->packets->headerCellClass() ?>"><div id="elh_booking_ref_packets" class="booking_ref_packets"><?= $Grid->renderFieldHeader($Grid->packets) ?></div></th>
<?php } ?>
<?php if ($Grid->confirm_type->Visible) { // confirm_type ?>
        <th data-name="confirm_type" class="<?= $Grid->confirm_type->headerCellClass() ?>"><div id="elh_booking_ref_confirm_type" class="booking_ref_confirm_type"><?= $Grid->renderFieldHeader($Grid->confirm_type) ?></div></th>
<?php } ?>
<?php if ($Grid->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Grid->company_id->headerCellClass() ?>"><div id="elh_booking_ref_company_id" class="booking_ref_company_id"><?= $Grid->renderFieldHeader($Grid->company_id) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_id" class="el_booking_ref_id">
<input type="<?= $Grid->id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" data-table="booking_ref" data-field="x_id" value="<?= $Grid->id->EditValue ?>" placeholder="<?= HtmlEncode($Grid->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->id->formatPattern()) ?>"<?= $Grid->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->id->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_id" class="el_booking_ref_id">
<input type="<?= $Grid->id->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" data-table="booking_ref" data-field="x_id" value="<?= $Grid->id->EditValue ?>" placeholder="<?= HtmlEncode($Grid->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->id->formatPattern()) ?>"<?= $Grid->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->id->getErrorMessage() ?></div>
<input type="hidden" data-table="booking_ref" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue ?? $Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_id" class="el_booking_ref_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_id" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_id" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_id" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_id" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="booking_ref" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->supplier_id->Visible) { // supplier_id ?>
        <td data-name="supplier_id"<?= $Grid->supplier_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_supplier_id" class="el_booking_ref_supplier_id">
    <select
        id="x<?= $Grid->RowIndex ?>_supplier_id"
        name="x<?= $Grid->RowIndex ?>_supplier_id"
        class="form-select ew-select<?= $Grid->supplier_id->isInvalidClass() ?>"
        <?php if (!$Grid->supplier_id->IsNativeSelect) { ?>
        data-select2-id="fbooking_refgrid_x<?= $Grid->RowIndex ?>_supplier_id"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_supplier_id"
        data-value-separator="<?= $Grid->supplier_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->supplier_id->getPlaceHolder()) ?>"
        <?= $Grid->supplier_id->editAttributes() ?>>
        <?= $Grid->supplier_id->selectOptionListHtml("x{$Grid->RowIndex}_supplier_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->supplier_id->getErrorMessage() ?></div>
<?= $Grid->supplier_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_supplier_id") ?>
<?php if (!$Grid->supplier_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_supplier_id", selectId: "fbooking_refgrid_x<?= $Grid->RowIndex ?>_supplier_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refgrid.lists.supplier_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_supplier_id", form: "fbooking_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_supplier_id", form: "fbooking_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.supplier_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_supplier_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_supplier_id" id="o<?= $Grid->RowIndex ?>_supplier_id" value="<?= HtmlEncode($Grid->supplier_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_supplier_id" class="el_booking_ref_supplier_id">
    <select
        id="x<?= $Grid->RowIndex ?>_supplier_id"
        name="x<?= $Grid->RowIndex ?>_supplier_id"
        class="form-select ew-select<?= $Grid->supplier_id->isInvalidClass() ?>"
        <?php if (!$Grid->supplier_id->IsNativeSelect) { ?>
        data-select2-id="fbooking_refgrid_x<?= $Grid->RowIndex ?>_supplier_id"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_supplier_id"
        data-value-separator="<?= $Grid->supplier_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->supplier_id->getPlaceHolder()) ?>"
        <?= $Grid->supplier_id->editAttributes() ?>>
        <?= $Grid->supplier_id->selectOptionListHtml("x{$Grid->RowIndex}_supplier_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->supplier_id->getErrorMessage() ?></div>
<?= $Grid->supplier_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_supplier_id") ?>
<?php if (!$Grid->supplier_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_supplier_id", selectId: "fbooking_refgrid_x<?= $Grid->RowIndex ?>_supplier_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refgrid.lists.supplier_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_supplier_id", form: "fbooking_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_supplier_id", form: "fbooking_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.supplier_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_supplier_id" class="el_booking_ref_supplier_id">
<span<?= $Grid->supplier_id->viewAttributes() ?>>
<?= $Grid->supplier_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_supplier_id" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_supplier_id" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_supplier_id" value="<?= HtmlEncode($Grid->supplier_id->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_supplier_id" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_supplier_id" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_supplier_id" value="<?= HtmlEncode($Grid->supplier_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Grid->ref->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ref->getSessionValue() != "") { ?>
<span<?= $Grid->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ref->getDisplayValue($Grid->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ref" name="x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_ref" class="el_booking_ref_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="booking_ref" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="booking_ref" data-field="x_ref" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ref" id="o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ref->getSessionValue() != "") { ?>
<span<?= $Grid->ref->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->ref->getDisplayValue($Grid->ref->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ref" name="x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_ref" class="el_booking_ref_ref">
<input type="<?= $Grid->ref->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_ref" id="x<?= $Grid->RowIndex ?>_ref" data-table="booking_ref" data-field="x_ref" value="<?= $Grid->ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->ref->formatPattern()) ?>"<?= $Grid->ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->ref->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_ref" class="el_booking_ref_ref">
<span<?= $Grid->ref->viewAttributes() ?>>
<?= $Grid->ref->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_ref" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_ref" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_ref" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_ref" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_ref" value="<?= HtmlEncode($Grid->ref->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_status" class="el_booking_ref_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fbooking_refgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fbooking_refgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbooking_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbooking_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_status" class="el_booking_ref_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fbooking_refgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="booking_ref"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbooking_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fbooking_refgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbooking_refgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbooking_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fbooking_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking_ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_status" class="el_booking_ref_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_status" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_status" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_status" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_status" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Grid->rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_rid" class="el_booking_ref_rid">
<?php
if (IsRTL()) {
    $Grid->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_rid" class="ew-auto-suggest">
    <div class="input-group">
        <input type="<?= $Grid->rid->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_rid" id="sv_x<?= $Grid->RowIndex ?>_rid" value="<?= RemoveHtml($Grid->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rid->formatPattern()) ?>"<?= $Grid->rid->editAttributes() ?>>
        <?php if (AllowAdd(CurrentProjectID() . "ref") && !$Grid->rid->ReadOnly) { ?>
        <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_rid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->rid->caption() ?>" data-title="<?= $Grid->rid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_rid" data-url="<?= GetUrl("refaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
        <?php } ?>
    </div>
</span>
<selection-list hidden class="form-control" data-table="booking_ref" data-field="x_rid" data-input="sv_x<?= $Grid->RowIndex ?>_rid" data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_rid" id="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_refgrid", function() {
    fbooking_refgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_ref.fields.rid.autoSuggestOptions));
});
</script>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rid" id="o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_rid" class="el_booking_ref_rid">
<?php
if (IsRTL()) {
    $Grid->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_rid" class="ew-auto-suggest">
    <div class="input-group">
        <input type="<?= $Grid->rid->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_rid" id="sv_x<?= $Grid->RowIndex ?>_rid" value="<?= RemoveHtml($Grid->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rid->formatPattern()) ?>"<?= $Grid->rid->editAttributes() ?>>
        <?php if (AllowAdd(CurrentProjectID() . "ref") && !$Grid->rid->ReadOnly) { ?>
        <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_rid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->rid->caption() ?>" data-title="<?= $Grid->rid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_rid" data-url="<?= GetUrl("refaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
        <?php } ?>
    </div>
</span>
<selection-list hidden class="form-control" data-table="booking_ref" data-field="x_rid" data-input="sv_x<?= $Grid->RowIndex ?>_rid" data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_rid" id="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_refgrid", function() {
    fbooking_refgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_rid","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_ref.fields.rid.autoSuggestOptions));
});
</script>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_rid" class="el_booking_ref_rid">
<span<?= $Grid->rid->viewAttributes() ?>>
<?php if (!EmptyString($Grid->rid->getViewValue()) && $Grid->rid->linkAttributes() != "") { ?>
<a<?= $Grid->rid->linkAttributes() ?>><?= $Grid->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_rid" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_rid" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_rid" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_rid" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Grid->quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_quantity" class="el_booking_ref_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="booking_ref" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_quantity" id="o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_quantity" class="el_booking_ref_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="booking_ref" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_quantity" class="el_booking_ref_quantity">
<span<?= $Grid->quantity->viewAttributes() ?>>
<?= $Grid->quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_quantity" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_quantity" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_quantity" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_quantity" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->b_quantity->Visible) { // b_quantity ?>
        <td data-name="b_quantity"<?= $Grid->b_quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_b_quantity" class="el_booking_ref_b_quantity">
<input type="<?= $Grid->b_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_b_quantity" id="x<?= $Grid->RowIndex ?>_b_quantity" data-table="booking_ref" data-field="x_b_quantity" value="<?= $Grid->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->b_quantity->formatPattern()) ?>"<?= $Grid->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->b_quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_b_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_b_quantity" id="o<?= $Grid->RowIndex ?>_b_quantity" value="<?= HtmlEncode($Grid->b_quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_b_quantity" class="el_booking_ref_b_quantity">
<input type="<?= $Grid->b_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_b_quantity" id="x<?= $Grid->RowIndex ?>_b_quantity" data-table="booking_ref" data-field="x_b_quantity" value="<?= $Grid->b_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->b_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->b_quantity->formatPattern()) ?>"<?= $Grid->b_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->b_quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_b_quantity" class="el_booking_ref_b_quantity">
<span<?= $Grid->b_quantity->viewAttributes() ?>>
<?= $Grid->b_quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_b_quantity" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_b_quantity" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_b_quantity" value="<?= HtmlEncode($Grid->b_quantity->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_b_quantity" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_b_quantity" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_b_quantity" value="<?= HtmlEncode($Grid->b_quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->confirm_pending->Visible) { // confirm_pending ?>
        <td data-name="confirm_pending"<?= $Grid->confirm_pending->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_pending" class="el_booking_ref_confirm_pending">
<input type="<?= $Grid->confirm_pending->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_confirm_pending" id="x<?= $Grid->RowIndex ?>_confirm_pending" data-table="booking_ref" data-field="x_confirm_pending" value="<?= $Grid->confirm_pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->confirm_pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->confirm_pending->formatPattern()) ?>"<?= $Grid->confirm_pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->confirm_pending->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_confirm_pending" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_confirm_pending" id="o<?= $Grid->RowIndex ?>_confirm_pending" value="<?= HtmlEncode($Grid->confirm_pending->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_pending" class="el_booking_ref_confirm_pending">
<input type="<?= $Grid->confirm_pending->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_confirm_pending" id="x<?= $Grid->RowIndex ?>_confirm_pending" data-table="booking_ref" data-field="x_confirm_pending" value="<?= $Grid->confirm_pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->confirm_pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->confirm_pending->formatPattern()) ?>"<?= $Grid->confirm_pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->confirm_pending->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_pending" class="el_booking_ref_confirm_pending">
<span<?= $Grid->confirm_pending->viewAttributes() ?>>
<?= $Grid->confirm_pending->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_confirm_pending" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_confirm_pending" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_confirm_pending" value="<?= HtmlEncode($Grid->confirm_pending->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_confirm_pending" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_confirm_pending" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_confirm_pending" value="<?= HtmlEncode($Grid->confirm_pending->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->booking_date->Visible) { // booking_date ?>
        <td data-name="booking_date"<?= $Grid->booking_date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_booking_date" class="el_booking_ref_booking_date">
<input type="<?= $Grid->booking_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_date" id="x<?= $Grid->RowIndex ?>_booking_date" data-table="booking_ref" data-field="x_booking_date" value="<?= $Grid->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_date->formatPattern()) ?>"<?= $Grid->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_date->getErrorMessage() ?></div>
<?php if (!$Grid->booking_date->ReadOnly && !$Grid->booking_date->Disabled && !isset($Grid->booking_date->EditAttrs["readonly"]) && !isset($Grid->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refgrid", "x<?= $Grid->RowIndex ?>_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_booking_date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_booking_date" id="o<?= $Grid->RowIndex ?>_booking_date" value="<?= HtmlEncode($Grid->booking_date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_booking_date" class="el_booking_ref_booking_date">
<input type="<?= $Grid->booking_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_date" id="x<?= $Grid->RowIndex ?>_booking_date" data-table="booking_ref" data-field="x_booking_date" value="<?= $Grid->booking_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->booking_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_date->formatPattern()) ?>"<?= $Grid->booking_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_date->getErrorMessage() ?></div>
<?php if (!$Grid->booking_date->ReadOnly && !$Grid->booking_date->Disabled && !isset($Grid->booking_date->EditAttrs["readonly"]) && !isset($Grid->booking_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refgrid", "x<?= $Grid->RowIndex ?>_booking_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_booking_date" class="el_booking_ref_booking_date">
<span<?= $Grid->booking_date->viewAttributes() ?>>
<?php if (!EmptyString($Grid->booking_date->getViewValue()) && $Grid->booking_date->linkAttributes() != "") { ?>
<a<?= $Grid->booking_date->linkAttributes() ?>><?= $Grid->booking_date->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->booking_date->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_booking_date" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_booking_date" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_booking_date" value="<?= HtmlEncode($Grid->booking_date->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_booking_date" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_booking_date" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_booking_date" value="<?= HtmlEncode($Grid->booking_date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->booking_rate->Visible) { // booking_rate ?>
        <td data-name="booking_rate"<?= $Grid->booking_rate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_booking_rate" class="el_booking_ref_booking_rate">
<input type="<?= $Grid->booking_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_rate" id="x<?= $Grid->RowIndex ?>_booking_rate" data-table="booking_ref" data-field="x_booking_rate" value="<?= $Grid->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_rate->formatPattern()) ?>"<?= $Grid->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_rate->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_booking_rate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_booking_rate" id="o<?= $Grid->RowIndex ?>_booking_rate" value="<?= HtmlEncode($Grid->booking_rate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_booking_rate" class="el_booking_ref_booking_rate">
<input type="<?= $Grid->booking_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_booking_rate" id="x<?= $Grid->RowIndex ?>_booking_rate" data-table="booking_ref" data-field="x_booking_rate" value="<?= $Grid->booking_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->booking_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->booking_rate->formatPattern()) ?>"<?= $Grid->booking_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->booking_rate->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_booking_rate" class="el_booking_ref_booking_rate">
<span<?= $Grid->booking_rate->viewAttributes() ?>>
<?= $Grid->booking_rate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_booking_rate" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_booking_rate" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_booking_rate" value="<?= HtmlEncode($Grid->booking_rate->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_booking_rate" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_booking_rate" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_booking_rate" value="<?= HtmlEncode($Grid->booking_rate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Grid->amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_amount" class="el_booking_ref_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="booking_ref" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_amount" id="o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_amount" class="el_booking_ref_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="booking_ref" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_amount" class="el_booking_ref_amount">
<span<?= $Grid->amount->viewAttributes() ?>>
<?= $Grid->amount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_amount" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_amount" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_amount" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_amount" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency->Visible) { // currency ?>
        <td data-name="currency"<?= $Grid->currency->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_currency" class="el_booking_ref_currency">
<textarea data-table="booking_ref" data-field="x_currency" name="x<?= $Grid->RowIndex ?>_currency" id="x<?= $Grid->RowIndex ?>_currency" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"<?= $Grid->currency->editAttributes() ?>><?= $Grid->currency->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_currency" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency" id="o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_currency" class="el_booking_ref_currency">
<textarea data-table="booking_ref" data-field="x_currency" name="x<?= $Grid->RowIndex ?>_currency" id="x<?= $Grid->RowIndex ?>_currency" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->currency->getPlaceHolder()) ?>"<?= $Grid->currency->editAttributes() ?>><?= $Grid->currency->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->currency->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_currency" class="el_booking_ref_currency">
<span<?= $Grid->currency->viewAttributes() ?>>
<?= $Grid->currency->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_currency" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_currency" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_currency" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_currency" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_currency" value="<?= HtmlEncode($Grid->currency->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->confirm_port_eta->Visible) { // confirm_port_eta ?>
        <td data-name="confirm_port_eta"<?= $Grid->confirm_port_eta->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_port_eta" class="el_booking_ref_confirm_port_eta">
<textarea data-table="booking_ref" data-field="x_confirm_port_eta" name="x<?= $Grid->RowIndex ?>_confirm_port_eta" id="x<?= $Grid->RowIndex ?>_confirm_port_eta" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->confirm_port_eta->getPlaceHolder()) ?>"<?= $Grid->confirm_port_eta->editAttributes() ?>><?= $Grid->confirm_port_eta->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->confirm_port_eta->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_confirm_port_eta" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_confirm_port_eta" id="o<?= $Grid->RowIndex ?>_confirm_port_eta" value="<?= HtmlEncode($Grid->confirm_port_eta->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_port_eta" class="el_booking_ref_confirm_port_eta">
<textarea data-table="booking_ref" data-field="x_confirm_port_eta" name="x<?= $Grid->RowIndex ?>_confirm_port_eta" id="x<?= $Grid->RowIndex ?>_confirm_port_eta" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->confirm_port_eta->getPlaceHolder()) ?>"<?= $Grid->confirm_port_eta->editAttributes() ?>><?= $Grid->confirm_port_eta->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->confirm_port_eta->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_port_eta" class="el_booking_ref_confirm_port_eta">
<span<?= $Grid->confirm_port_eta->viewAttributes() ?>>
<?= $Grid->confirm_port_eta->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_confirm_port_eta" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_confirm_port_eta" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_confirm_port_eta" value="<?= HtmlEncode($Grid->confirm_port_eta->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_confirm_port_eta" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_confirm_port_eta" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_confirm_port_eta" value="<?= HtmlEncode($Grid->confirm_port_eta->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->reference->Visible) { // reference ?>
        <td data-name="reference"<?= $Grid->reference->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_reference" class="el_booking_ref_reference">
<textarea data-table="booking_ref" data-field="x_reference" name="x<?= $Grid->RowIndex ?>_reference" id="x<?= $Grid->RowIndex ?>_reference" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->reference->getPlaceHolder()) ?>"<?= $Grid->reference->editAttributes() ?>><?= $Grid->reference->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->reference->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_reference" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_reference" id="o<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_reference" class="el_booking_ref_reference">
<textarea data-table="booking_ref" data-field="x_reference" name="x<?= $Grid->RowIndex ?>_reference" id="x<?= $Grid->RowIndex ?>_reference" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->reference->getPlaceHolder()) ?>"<?= $Grid->reference->editAttributes() ?>><?= $Grid->reference->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->reference->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_reference" class="el_booking_ref_reference">
<span<?= $Grid->reference->viewAttributes() ?>>
<?= $Grid->reference->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_reference" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_reference" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_reference" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_reference" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_reference" value="<?= HtmlEncode($Grid->reference->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->currency_current_rate->Visible) { // currency_current_rate ?>
        <td data-name="currency_current_rate"<?= $Grid->currency_current_rate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_currency_current_rate" class="el_booking_ref_currency_current_rate">
<input type="<?= $Grid->currency_current_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_currency_current_rate" id="x<?= $Grid->RowIndex ?>_currency_current_rate" data-table="booking_ref" data-field="x_currency_current_rate" value="<?= $Grid->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->currency_current_rate->formatPattern()) ?>"<?= $Grid->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->currency_current_rate->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_currency_current_rate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_currency_current_rate" id="o<?= $Grid->RowIndex ?>_currency_current_rate" value="<?= HtmlEncode($Grid->currency_current_rate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_currency_current_rate" class="el_booking_ref_currency_current_rate">
<input type="<?= $Grid->currency_current_rate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_currency_current_rate" id="x<?= $Grid->RowIndex ?>_currency_current_rate" data-table="booking_ref" data-field="x_currency_current_rate" value="<?= $Grid->currency_current_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->currency_current_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->currency_current_rate->formatPattern()) ?>"<?= $Grid->currency_current_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->currency_current_rate->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_currency_current_rate" class="el_booking_ref_currency_current_rate">
<span<?= $Grid->currency_current_rate->viewAttributes() ?>>
<?= $Grid->currency_current_rate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_currency_current_rate" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_currency_current_rate" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_currency_current_rate" value="<?= HtmlEncode($Grid->currency_current_rate->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_currency_current_rate" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_currency_current_rate" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_currency_current_rate" value="<?= HtmlEncode($Grid->currency_current_rate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->shipment_date->Visible) { // shipment_date ?>
        <td data-name="shipment_date"<?= $Grid->shipment_date->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_shipment_date" class="el_booking_ref_shipment_date">
<input type="<?= $Grid->shipment_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_shipment_date" id="x<?= $Grid->RowIndex ?>_shipment_date" data-table="booking_ref" data-field="x_shipment_date" value="<?= $Grid->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->shipment_date->formatPattern()) ?>"<?= $Grid->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->shipment_date->getErrorMessage() ?></div>
<?php if (!$Grid->shipment_date->ReadOnly && !$Grid->shipment_date->Disabled && !isset($Grid->shipment_date->EditAttrs["readonly"]) && !isset($Grid->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refgrid", "x<?= $Grid->RowIndex ?>_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_shipment_date" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_shipment_date" id="o<?= $Grid->RowIndex ?>_shipment_date" value="<?= HtmlEncode($Grid->shipment_date->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_shipment_date" class="el_booking_ref_shipment_date">
<input type="<?= $Grid->shipment_date->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_shipment_date" id="x<?= $Grid->RowIndex ?>_shipment_date" data-table="booking_ref" data-field="x_shipment_date" value="<?= $Grid->shipment_date->EditValue ?>" placeholder="<?= HtmlEncode($Grid->shipment_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->shipment_date->formatPattern()) ?>"<?= $Grid->shipment_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->shipment_date->getErrorMessage() ?></div>
<?php if (!$Grid->shipment_date->ReadOnly && !$Grid->shipment_date->Disabled && !isset($Grid->shipment_date->EditAttrs["readonly"]) && !isset($Grid->shipment_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fbooking_refgrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fbooking_refgrid", "x<?= $Grid->RowIndex ?>_shipment_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_shipment_date" class="el_booking_ref_shipment_date">
<span<?= $Grid->shipment_date->viewAttributes() ?>>
<?php if (!EmptyString($Grid->shipment_date->getViewValue()) && $Grid->shipment_date->linkAttributes() != "") { ?>
<a<?= $Grid->shipment_date->linkAttributes() ?>><?= $Grid->shipment_date->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->shipment_date->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_shipment_date" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_shipment_date" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_shipment_date" value="<?= HtmlEncode($Grid->shipment_date->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_shipment_date" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_shipment_date" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_shipment_date" value="<?= HtmlEncode($Grid->shipment_date->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_remarks" class="el_booking_ref_remarks">
<textarea data-table="booking_ref" data-field="x_remarks" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>"<?= $Grid->remarks->editAttributes() ?>><?= $Grid->remarks->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_remarks" class="el_booking_ref_remarks">
<textarea data-table="booking_ref" data-field="x_remarks" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>"<?= $Grid->remarks->editAttributes() ?>><?= $Grid->remarks->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_remarks" class="el_booking_ref_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_remarks" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_remarks" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_remarks" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_remarks" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="booking_ref" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_operator" class="el_booking_ref_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_operator" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_operator" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_operator" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_operator" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="booking_ref" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_datetime" class="el_booking_ref_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_datetime" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_datetime" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_datetime" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_datetime" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Grid->packets->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_packets" class="el_booking_ref_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="booking_ref" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_packets" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packets" id="o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_packets" class="el_booking_ref_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="booking_ref" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_packets" class="el_booking_ref_packets">
<span<?= $Grid->packets->viewAttributes() ?>>
<?= $Grid->packets->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_packets" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_packets" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_packets" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_packets" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->confirm_type->Visible) { // confirm_type ?>
        <td data-name="confirm_type"<?= $Grid->confirm_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_type" class="el_booking_ref_confirm_type">
<input type="<?= $Grid->confirm_type->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_confirm_type" id="x<?= $Grid->RowIndex ?>_confirm_type" data-table="booking_ref" data-field="x_confirm_type" value="<?= $Grid->confirm_type->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Grid->confirm_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->confirm_type->formatPattern()) ?>"<?= $Grid->confirm_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->confirm_type->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_confirm_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_confirm_type" id="o<?= $Grid->RowIndex ?>_confirm_type" value="<?= HtmlEncode($Grid->confirm_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_type" class="el_booking_ref_confirm_type">
<input type="<?= $Grid->confirm_type->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_confirm_type" id="x<?= $Grid->RowIndex ?>_confirm_type" data-table="booking_ref" data-field="x_confirm_type" value="<?= $Grid->confirm_type->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Grid->confirm_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->confirm_type->formatPattern()) ?>"<?= $Grid->confirm_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->confirm_type->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_confirm_type" class="el_booking_ref_confirm_type">
<span<?= $Grid->confirm_type->viewAttributes() ?>>
<?= $Grid->confirm_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_confirm_type" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_confirm_type" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_confirm_type" value="<?= HtmlEncode($Grid->confirm_type->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_confirm_type" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_confirm_type" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_confirm_type" value="<?= HtmlEncode($Grid->confirm_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Grid->company_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_company_id" class="el_booking_ref_company_id">
<?php
if (IsRTL()) {
    $Grid->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_company_id" class="ew-auto-suggest">
    <input type="<?= $Grid->company_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_company_id" id="sv_x<?= $Grid->RowIndex ?>_company_id" value="<?= RemoveHtml($Grid->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->company_id->formatPattern()) ?>"<?= $Grid->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_ref" data-field="x_company_id" data-input="sv_x<?= $Grid->RowIndex ?>_company_id" data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_company_id" id="x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_refgrid", function() {
    fbooking_refgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_ref.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
</span>
<input type="hidden" data-table="booking_ref" data-field="x_company_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_company_id" id="o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_company_id" class="el_booking_ref_company_id">
<?php
if (IsRTL()) {
    $Grid->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_company_id" class="ew-auto-suggest">
    <input type="<?= $Grid->company_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_company_id" id="sv_x<?= $Grid->RowIndex ?>_company_id" value="<?= RemoveHtml($Grid->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->company_id->formatPattern()) ?>"<?= $Grid->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="booking_ref" data-field="x_company_id" data-input="sv_x<?= $Grid->RowIndex ?>_company_id" data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_company_id" id="x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fbooking_refgrid", function() {
    fbooking_refgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_company_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.booking_ref.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_booking_ref_company_id" class="el_booking_ref_company_id">
<span<?= $Grid->company_id->viewAttributes() ?>>
<?= $Grid->company_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="booking_ref" data-field="x_company_id" data-hidden="1" name="fbooking_refgrid$x<?= $Grid->RowIndex ?>_company_id" id="fbooking_refgrid$x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->FormValue) ?>">
<input type="hidden" data-table="booking_ref" data-field="x_company_id" data-hidden="1" data-old name="fbooking_refgrid$o<?= $Grid->RowIndex ?>_company_id" id="fbooking_refgrid$o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fbooking_refgrid","load"], () => fbooking_refgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Grid->id->footerCellClass() ?>"><span id="elf_booking_ref_id" class="booking_ref_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->supplier_id->Visible) { // supplier_id ?>
        <td data-name="supplier_id" class="<?= $Grid->supplier_id->footerCellClass() ?>"><span id="elf_booking_ref_supplier_id" class="booking_ref_supplier_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->ref->Visible) { // ref ?>
        <td data-name="ref" class="<?= $Grid->ref->footerCellClass() ?>"><span id="elf_booking_ref_ref" class="booking_ref_ref">
        </span></td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Grid->status->footerCellClass() ?>"><span id="elf_booking_ref_status" class="booking_ref_status">
        </span></td>
    <?php } ?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Grid->rid->footerCellClass() ?>"><span id="elf_booking_ref_rid" class="booking_ref_rid">
        </span></td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Grid->quantity->footerCellClass() ?>"><span id="elf_booking_ref_quantity" class="booking_ref_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->b_quantity->Visible) { // b_quantity ?>
        <td data-name="b_quantity" class="<?= $Grid->b_quantity->footerCellClass() ?>"><span id="elf_booking_ref_b_quantity" class="booking_ref_b_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->b_quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->confirm_pending->Visible) { // confirm_pending ?>
        <td data-name="confirm_pending" class="<?= $Grid->confirm_pending->footerCellClass() ?>"><span id="elf_booking_ref_confirm_pending" class="booking_ref_confirm_pending">
        </span></td>
    <?php } ?>
    <?php if ($Grid->booking_date->Visible) { // booking_date ?>
        <td data-name="booking_date" class="<?= $Grid->booking_date->footerCellClass() ?>"><span id="elf_booking_ref_booking_date" class="booking_ref_booking_date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->booking_rate->Visible) { // booking_rate ?>
        <td data-name="booking_rate" class="<?= $Grid->booking_rate->footerCellClass() ?>"><span id="elf_booking_ref_booking_rate" class="booking_ref_booking_rate">
        </span></td>
    <?php } ?>
    <?php if ($Grid->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Grid->amount->footerCellClass() ?>"><span id="elf_booking_ref_amount" class="booking_ref_amount">
        </span></td>
    <?php } ?>
    <?php if ($Grid->currency->Visible) { // currency ?>
        <td data-name="currency" class="<?= $Grid->currency->footerCellClass() ?>"><span id="elf_booking_ref_currency" class="booking_ref_currency">
        </span></td>
    <?php } ?>
    <?php if ($Grid->confirm_port_eta->Visible) { // confirm_port_eta ?>
        <td data-name="confirm_port_eta" class="<?= $Grid->confirm_port_eta->footerCellClass() ?>"><span id="elf_booking_ref_confirm_port_eta" class="booking_ref_confirm_port_eta">
        </span></td>
    <?php } ?>
    <?php if ($Grid->reference->Visible) { // reference ?>
        <td data-name="reference" class="<?= $Grid->reference->footerCellClass() ?>"><span id="elf_booking_ref_reference" class="booking_ref_reference">
        </span></td>
    <?php } ?>
    <?php if ($Grid->currency_current_rate->Visible) { // currency_current_rate ?>
        <td data-name="currency_current_rate" class="<?= $Grid->currency_current_rate->footerCellClass() ?>"><span id="elf_booking_ref_currency_current_rate" class="booking_ref_currency_current_rate">
        </span></td>
    <?php } ?>
    <?php if ($Grid->shipment_date->Visible) { // shipment_date ?>
        <td data-name="shipment_date" class="<?= $Grid->shipment_date->footerCellClass() ?>"><span id="elf_booking_ref_shipment_date" class="booking_ref_shipment_date">
        </span></td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Grid->remarks->footerCellClass() ?>"><span id="elf_booking_ref_remarks" class="booking_ref_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Grid->operator->footerCellClass() ?>"><span id="elf_booking_ref_operator" class="booking_ref_operator">
        </span></td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Grid->datetime->footerCellClass() ?>"><span id="elf_booking_ref_datetime" class="booking_ref_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets" class="<?= $Grid->packets->footerCellClass() ?>"><span id="elf_booking_ref_packets" class="booking_ref_packets">
        </span></td>
    <?php } ?>
    <?php if ($Grid->confirm_type->Visible) { // confirm_type ?>
        <td data-name="confirm_type" class="<?= $Grid->confirm_type->footerCellClass() ?>"><span id="elf_booking_ref_confirm_type" class="booking_ref_confirm_type">
        </span></td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Grid->company_id->footerCellClass() ?>"><span id="elf_booking_ref_company_id" class="booking_ref_company_id">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fbooking_refgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
