<?php

namespace PHPMaker2024\fibre;

// Page object
$BookingList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "booking_details") {
    if ($Page->MasterRecordExists) {
        include_once "views/BookingDetailsMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fbookingsrch" id="fbookingsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fbookingsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { booking: currentTable } });
var currentForm;
var fbookingsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fbookingsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["supplier", [], fields.supplier.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "agent": <?= $Page->agent->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->supplier->Visible) { // supplier ?>
<?php
if (!$Page->supplier->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_supplier" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->supplier->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_supplier" class="ew-search-caption ew-label"><?= $Page->supplier->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</div>
        </div>
        <div id="el_booking_supplier" class="ew-search-field">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fbookingsrch_x_supplier"
        <?php } ?>
        data-table="booking"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsrch", function() {
    var options = { name: "x_supplier", selectId: "fbookingsrch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsrch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fbookingsrch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fbookingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_booking_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fbookingsrch_x_status"
        <?php } ?>
        data-table="booking"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsrch", function() {
    var options = { name: "x_status", selectId: "fbookingsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fbookingsrch" };
    } else {
        options.ajax = { id: "x_status", form: "fbookingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
<?php
if (!$Page->product->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product" class="ew-search-caption ew-label"><?= $Page->product->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</div>
        </div>
        <div id="el_booking_product" class="ew-search-field">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fbookingsrch_x_product"
        <?php } ?>
        data-table="booking"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsrch", function() {
    var options = { name: "x_product", selectId: "fbookingsrch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsrch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fbookingsrch" };
    } else {
        options.ajax = { id: "x_product", form: "fbookingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_rid" class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</div>
        </div>
        <div id="el_booking_rid" class="ew-search-field">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fbookingsrch_x_rid"
        <?php } ?>
        data-table="booking"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fbookingsrch", function() {
    var options = { name: "x_rid", selectId: "fbookingsrch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fbookingsrch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fbookingsrch" };
    } else {
        options.ajax = { id: "x_rid", form: "fbookingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.booking.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->agent->Visible) { // agent ?>
<?php
if (!$Page->agent->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_agent" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->agent->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_agent"
            name="x_agent[]"
            class="form-control ew-select<?= $Page->agent->isInvalidClass() ?>"
            data-select2-id="fbookingsrch_x_agent"
            data-table="booking"
            data-field="x_agent"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->agent->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->agent->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->agent->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->agent->editAttributes() ?>>
            <?= $Page->agent->selectOptionListHtml("x_agent", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->agent->getErrorMessage(false) ?></div>
        <?= $Page->agent->Lookup->getParamTag($Page, "p_x_agent") ?>
        <script>
        loadjs.ready("fbookingsrch", function() {
            var options = {
                name: "x_agent",
                selectId: "fbookingsrch_x_agent",
                ajax: { id: "x_agent", form: "fbookingsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.booking.fields.agent.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fbookingsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fbookingsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fbookingsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fbookingsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fbookingsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fbookingsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fbookingsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="booking">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "booking_details" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="booking_details">
<input type="hidden" name="fk_ref" value="<?= HtmlEncode($Page->ref->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_booking" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_bookinglist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_booking_id" class="booking_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->booking_by->Visible) { // booking_by ?>
        <th data-name="booking_by" class="<?= $Page->booking_by->headerCellClass() ?>"><div id="elh_booking_booking_by" class="booking_booking_by"><?= $Page->renderFieldHeader($Page->booking_by) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_booking_company_id" class="booking_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
        <th data-name="supplier" class="<?= $Page->supplier->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_booking_supplier" class="booking_supplier"><?= $Page->renderFieldHeader($Page->supplier) ?></div></th>
<?php } ?>
<?php if ($Page->ref->Visible) { // ref ?>
        <th data-name="ref" class="<?= $Page->ref->headerCellClass() ?>"><div id="elh_booking_ref" class="booking_ref"><?= $Page->renderFieldHeader($Page->ref) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_booking_status" class="booking_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_booking_s_grp" class="booking_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_booking_product" class="booking_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_booking_rid" class="booking_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_booking_quantity" class="booking_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->b_quantity->Visible) { // b_quantity ?>
        <th data-name="b_quantity" class="<?= $Page->b_quantity->headerCellClass() ?>"><div id="elh_booking_b_quantity" class="booking_b_quantity"><?= $Page->renderFieldHeader($Page->b_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->confirm_quantity->Visible) { // confirm_quantity ?>
        <th data-name="confirm_quantity" class="<?= $Page->confirm_quantity->headerCellClass() ?>"><div id="elh_booking_confirm_quantity" class="booking_confirm_quantity"><?= $Page->renderFieldHeader($Page->confirm_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->booking_rate->Visible) { // booking_rate ?>
        <th data-name="booking_rate" class="<?= $Page->booking_rate->headerCellClass() ?>"><div id="elh_booking_booking_rate" class="booking_booking_rate"><?= $Page->renderFieldHeader($Page->booking_rate) ?></div></th>
<?php } ?>
<?php if ($Page->currency_current_rate->Visible) { // currency_current_rate ?>
        <th data-name="currency_current_rate" class="<?= $Page->currency_current_rate->headerCellClass() ?>"><div id="elh_booking_currency_current_rate" class="booking_currency_current_rate"><?= $Page->renderFieldHeader($Page->currency_current_rate) ?></div></th>
<?php } ?>
<?php if ($Page->booking_date->Visible) { // booking_date ?>
        <th data-name="booking_date" class="<?= $Page->booking_date->headerCellClass() ?>"><div id="elh_booking_booking_date" class="booking_booking_date"><?= $Page->renderFieldHeader($Page->booking_date) ?></div></th>
<?php } ?>
<?php if ($Page->shipment_date->Visible) { // shipment_date ?>
        <th data-name="shipment_date" class="<?= $Page->shipment_date->headerCellClass() ?>"><div id="elh_booking_shipment_date" class="booking_shipment_date"><?= $Page->renderFieldHeader($Page->shipment_date) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_booking_remarks" class="booking_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_booking_operator" class="booking_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_booking_datetime" class="booking_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_id" class="el_booking_id">
<span<?= $Page->id->viewAttributes() ?>>
<?php if (!EmptyString($Page->id->getViewValue()) && $Page->id->linkAttributes() != "") { ?>
<a<?= $Page->id->linkAttributes() ?>><?= $Page->id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->booking_by->Visible) { // booking_by ?>
        <td data-name="booking_by"<?= $Page->booking_by->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_booking_by" class="el_booking_booking_by">
<span<?= $Page->booking_by->viewAttributes() ?>>
<?= $Page->booking_by->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_company_id" class="el_booking_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->supplier->Visible) { // supplier ?>
        <td data-name="supplier"<?= $Page->supplier->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_supplier" class="el_booking_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?= $Page->supplier->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ref->Visible) { // ref ?>
        <td data-name="ref"<?= $Page->ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_ref" class="el_booking_ref">
<span<?= $Page->ref->viewAttributes() ?>>
<?= $Page->ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_status" class="el_booking_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_s_grp" class="el_booking_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_product" class="el_booking_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_rid" class="el_booking_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->getViewValue()) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><?= $Page->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_quantity" class="el_booking_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_quantity->Visible) { // b_quantity ?>
        <td data-name="b_quantity"<?= $Page->b_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_b_quantity" class="el_booking_b_quantity">
<span<?= $Page->b_quantity->viewAttributes() ?>>
<?= $Page->b_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->confirm_quantity->Visible) { // confirm_quantity ?>
        <td data-name="confirm_quantity"<?= $Page->confirm_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_confirm_quantity" class="el_booking_confirm_quantity">
<span<?= $Page->confirm_quantity->viewAttributes() ?>>
<?= $Page->confirm_quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->booking_rate->Visible) { // booking_rate ?>
        <td data-name="booking_rate"<?= $Page->booking_rate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_booking_rate" class="el_booking_booking_rate">
<span<?= $Page->booking_rate->viewAttributes() ?>>
<?= $Page->booking_rate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency_current_rate->Visible) { // currency_current_rate ?>
        <td data-name="currency_current_rate"<?= $Page->currency_current_rate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_currency_current_rate" class="el_booking_currency_current_rate">
<span<?= $Page->currency_current_rate->viewAttributes() ?>>
<?= $Page->currency_current_rate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->booking_date->Visible) { // booking_date ?>
        <td data-name="booking_date"<?= $Page->booking_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_booking_date" class="el_booking_booking_date">
<span<?= $Page->booking_date->viewAttributes() ?>>
<?= $Page->booking_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipment_date->Visible) { // shipment_date ?>
        <td data-name="shipment_date"<?= $Page->shipment_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_shipment_date" class="el_booking_shipment_date">
<span<?= $Page->shipment_date->viewAttributes() ?>>
<?= $Page->shipment_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_remarks" class="el_booking_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_operator" class="el_booking_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_booking_datetime" class="el_booking_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("booking");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
